/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.client.IHRBillListUIBiz;
import com.kingdee.eas.hr.qualifications.CerSchemeBillFactory;
import com.kingdee.eas.hr.qualifications.CerSchemeBillInfo;
import com.kingdee.eas.hr.qualifications.CerSchemeStateEnum;
import com.kingdee.eas.hr.qualifications.ICerSchemeBill;
import com.kingdee.eas.hr.qualifications.client.AbstractCerSchemeBillListUI;
import com.kingdee.eas.hr.qualifications.client.CerSchemeBillListUIBiz;
import com.kingdee.eas.hr.qualifications.client.CerSchemeBillPublishListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CerSchemeBillListUI
extends AbstractCerSchemeBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(CerSchemeBillListUI.class);
    private static final String STRRES = "com.kingdee.eas.hr.qualifications.QualificationsResource";

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CerSchemeBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected IObjectValue createNewData() {
        CerSchemeBillInfo objectValue = new CerSchemeBillInfo();
        return objectValue;
    }

    protected void setSelectedActionState() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows != null && selectRows.length > 0) {
            IRow row = null;
            row = this.tblMain.getRow(selectRows[0]);
            if (row != null) {
                super.setSelectedActionState();
            }
        }
    }

    protected IHRBillListUIBiz getBillBiz() {
        return new CerSchemeBillListUIBiz();
    }

    protected boolean isSupportDynQuery() {
        return false;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPublish.setEnabled(true);
        this.menuItemPublish.setEnabled(true);
        this.btnFinish.setEnabled(true);
        this.menuItemPublish.setEnabled(true);
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.menuItemPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.btnFinish.setIcon(EASResource.getIcon((String)"imgTbtn_allfinishinitialize"));
        this.menuItemFinish.setIcon(EASResource.getIcon((String)"imgTbtn_allfinishinitialize"));
        this.btnAudit.setText(EASResource.getString((String)STRRES, (String)"47_Audit"));
        this.btnAudit.setToolTipText(EASResource.getString((String)STRRES, (String)"47_Audit"));
        this.menuItemAudit.setText(EASResource.getString((String)STRRES, (String)"47_Audit"));
        this.menuItemAudit.setToolTipText(EASResource.getString((String)STRRES, (String)"47_Audit"));
        this.btnUnaudit.setText(EASResource.getString((String)STRRES, (String)"48_Unaudit"));
        this.btnUnaudit.setToolTipText(EASResource.getString((String)STRRES, (String)"48_Unaudit"));
        this.menuItemUnaudit.setText(EASResource.getString((String)STRRES, (String)"48_Unaudit"));
        this.menuItemUnaudit.setToolTipText(EASResource.getString((String)STRRES, (String)"48_Unaudit"));
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.isCanPublish()) {
            MsgBox.showInfo((String)EASResource.getString((String)STRRES, (String)"186_CanNotClose"));
            SysUtil.abort();
        }
        super.actionPublish_actionPerformed(e);
        this.getUIContext().put("ID", this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CerSchemeBillPublishListUI.class.getName(), this.getUIContext(), null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String finishMsg = EASResource.getString((String)STRRES, (String)"45_isFinish");
        if (this.confirmDialog(finishMsg)) {
            ObjectUuidPK pk;
            String schemeId = this.tblMain.getRow(rows[0]).getCell("id").getValue().toString();
            ICerSchemeBill iCerSchemeBill = CerSchemeBillFactory.getRemoteInstance();
            CerSchemeBillInfo schemeInfo = (CerSchemeBillInfo)iCerSchemeBill.getValue((IObjectPK)(pk = new ObjectUuidPK(BOSUuid.read((String)schemeId))));
            if (CerSchemeStateEnum.CLOSE.equals(schemeInfo.getBillState())) {
                return;
            }
            schemeInfo.setState(CerSchemeStateEnum.CLOSE);
            iCerSchemeBill.setFinish((IObjectPK)pk, schemeInfo);
            this.actionRefresh_actionPerformed(e);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent kdtselectevent) throws Exception {
        this.setButtonState();
        super.tblMain_tableSelectChanged(kdtselectevent);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            ((IHRBillBase)this.getBizInterface()).setAudited(BOSUuid.read((String)id));
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)STRRES, (String)"54_AuditSuccess"));
            this.refresh(e);
        }
    }

    public void actionUnaudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmUnaudit()) {
            ArrayList list = super.getSelectedIdValues();
            if (list.size() > 1) {
                MsgBox.showInfo((String)EASResource.getString((String)STRRES, (String)"56_OnlyCanSelectOne"));
                return;
            }
            String id = list.get(0).toString();
            HRBillBaseInfo baseInfo = new HRBillBaseInfo();
            baseInfo.setId(BOSUuid.read((String)id));
            baseInfo.put("key", (Object)EASResource.getString((String)STRRES, (String)"58_Audit"));
            if (id != null) {
                ((IHRBillBase)this.getBizInterface()).passUnaudit(baseInfo.getId());
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)STRRES, (String)"55_UnauditSuccess"));
                this.refresh(e);
            }
        }
    }

    protected boolean confirmUnaudit() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)STRRES, (String)"57_ConfirmUnaudit")));
    }

    private void setButtonState() {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rows != null && this.tblMain.getRowCount() > 0) {
            if (rows.length > 1) {
                this.btnPublish.setEnabled(false);
                this.menuItemPublish.setEnabled(false);
                this.btnFinish.setEnabled(false);
                this.menuItemFinish.setEnabled(false);
            } else {
                this.btnPublish.setEnabled(true);
                this.menuItemPublish.setEnabled(true);
                this.btnFinish.setEnabled(true);
                this.menuItemFinish.setEnabled(true);
                IRow row = this.tblMain.getRow(rows[0]);
                String stateItem = null;
                if (row.getCell("state").getValue() != null) {
                    stateItem = row.getCell("state").getValue().toString();
                    if (CerSchemeStateEnum.CLOSE.toString().equals(stateItem)) {
                        this.btnEdit.setEnabled(false);
                        this.btnAudit.setEnabled(false);
                        this.btnUnaudit.setEnabled(false);
                        this.btnRemove.setEnabled(false);
                        this.menuItemEdit.setEnabled(false);
                        this.menuItemAudit.setEnabled(false);
                        this.menuItemUnaudit.setEnabled(false);
                        this.menuItemRemove.setEnabled(false);
                    }
                    String approveType = row.getCell("approveType").getValue().toString();
                    if (ApproveTypeEnum.DIRECT.toString().equals(approveType) && CerSchemeStateEnum.PASS.toString().equals(stateItem)) {
                        this.btnUnaudit.setEnabled(true);
                        this.menuItemUnaudit.setEnabled(true);
                    } else {
                        this.btnUnaudit.setEnabled(false);
                        this.menuItemUnaudit.setEnabled(false);
                    }
                    if (CerSchemeStateEnum.PASS.toString().equals(stateItem)) {
                        this.btnFinish.setEnabled(true);
                        this.menuItemFinish.setEnabled(true);
                    } else {
                        this.btnFinish.setEnabled(false);
                        this.menuItemFinish.setEnabled(false);
                    }
                }
            }
        }
    }

    private boolean isCanPublish() {
        IRow row;
        int index = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (index > -1 && (row = this.tblMain.getRow(index)) != null && row.getCell("state").getValue() != null) {
            String stateItem = row.getCell("state").getValue().toString();
            if (CerSchemeStateEnum.PASS.toString().equals(stateItem)) {
                return true;
            }
        }
        return false;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount");
        int i = super.getBillCount();
        Object[] obj = new Object[]{this.tblMain.getRowCount(), i};
        String next = MessageFormat.format(msg, obj);
        this.setMessageBarText(next);
    }

    protected boolean isUseStandardPermission() {
        return true;
    }
}

