/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.qualifications.CerSchemeBillFactory;
import com.kingdee.eas.hr.qualifications.CerSchemeBillInfo;
import com.kingdee.eas.hr.qualifications.CerSchemeBillPublishCollection;
import com.kingdee.eas.hr.qualifications.CerSchemeBillPublishFactory;
import com.kingdee.eas.hr.qualifications.CerSchemeBillPublishInfo;
import com.kingdee.eas.hr.qualifications.CerSchemeBillTypeEntryCollection;
import com.kingdee.eas.hr.qualifications.CerSchemeBillTypeEntryInfo;
import com.kingdee.eas.hr.qualifications.CerSchemeMessageCollection;
import com.kingdee.eas.hr.qualifications.CerSchemeMessageFactory;
import com.kingdee.eas.hr.qualifications.CerSchemeMessageInfo;
import com.kingdee.eas.hr.qualifications.ICerSchemeBillPublish;
import com.kingdee.eas.hr.qualifications.ICerSchemeMessage;
import com.kingdee.eas.hr.qualifications.QualTypeInfo;
import com.kingdee.eas.hr.qualifications.client.AbstractCerSchemeBillPublishListUI;
import com.kingdee.eas.hr.qualifications.client.CerSchemeHelper;
import com.kingdee.eas.hr.qualifications.client.HRQualClientUtils;
import com.kingdee.eas.hr.qualifications.client.IProgTask;
import com.kingdee.eas.hr.qualifications.client.ProgressManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class CerSchemeBillPublishListUI
extends AbstractCerSchemeBillPublishListUI {
    private static final Logger logger = CoreUIObject.getLogger(CerSchemeBillPublishListUI.class);
    private final PersonInfo loginPerson = SysContext.getSysContext().getCurrentUserInfo().getPerson();
    private static final String STRRES = "com.kingdee.eas.hr.qualifications.QualificationsResource";
    private SelectorItemCollection selector = null;
    private CerSchemeBillInfo cerSchemeBillInfo = null;
    private CerSchemeMessageInfo messageInfo = null;
    private String cerSchemeBillId;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String addPerson = EASResource.getString((String)"com.kingdee.eas.hr.qualifications.QualificationsResource", (String)"40_AddPublishPerson");
    private static final String delPerson = EASResource.getString((String)"com.kingdee.eas.hr.qualifications.QualificationsResource", (String)"41_DelPublishPerson");

    public void onLoad() throws Exception {
        HRQualClientUtils.checkValidPerson((CoreUI)this);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.initWorkButton();
        this.initSchemeInfo();
        this.loadData();
    }

    protected void initWorkButton() {
        JButton btnAddPerson = this.contPerson.add((Action)((Object)this.actionAddPerson));
        JButton btnDelPerson = this.contPerson.add((Action)((Object)this.actionDelPerson));
        btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        btnDelPerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        btnAddPerson.setEnabled(true);
        btnDelPerson.setEnabled(true);
        this.btnPublish.setEnabled(true);
        btnAddPerson.setToolTipText(addPerson);
        btnDelPerson.setToolTipText(delPerson);
    }

    private void initSchemeInfo() throws Exception {
        String cerSchemeBillId = (String)this.getUIContext().get("ID");
        SelectorItemCollection sic = this.getSelector();
        this.cerSchemeBillInfo = CerSchemeBillFactory.getRemoteInstance().getCerSchemeBillInfo((IObjectPK)new ObjectUuidPK(cerSchemeBillId), sic);
        if (this.cerSchemeBillInfo != null) {
            this.prmtCerSchemeBill.setValue((Object)this.cerSchemeBillInfo);
        }
    }

    private SelectorItemCollection getSelector() {
        if (this.selector == null) {
            this.selector = new SelectorItemCollection();
            this.selector.add(new SelectorItemInfo("*"));
            this.selector.add(new SelectorItemInfo("adminOrg.id"));
            this.selector.add(new SelectorItemInfo("adminOrg.name"));
            this.selector.add(new SelectorItemInfo("adminOrg.number"));
            this.selector.add(new SelectorItemInfo("typeEntrys.*"));
            this.selector.add(new SelectorItemInfo("typeEntrys.qualType.*"));
            this.selector.add(new SelectorItemInfo("typeEntrys.qualType.name"));
        }
        return this.selector;
    }

    private void loadData() throws Exception {
        this.tblMain.removeRows();
        if (this.cerSchemeBillInfo == null) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)this.cerSchemeBillInfo.getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("sendPerson.id", (Object)this.loginPerson.getId().toString()));
        IRowSet rowSet = CerSchemeHelper.getRowSet("CerSchemeBillPublishQuery", fi);
        ArrayList list = new ArrayList();
        HashMap<String, String> map = null;
        while (rowSet.next()) {
            map = new HashMap<String, String>();
            map.put("id", rowSet.getString("id"));
            map.put("personId", rowSet.getString("person.id"));
            map.put("number", rowSet.getString("person.number"));
            map.put("name", rowSet.getString("person.name"));
            map.put("position", rowSet.getString("position.name"));
            map.put("adminOrg", rowSet.getString("adminOrg.name"));
            list.add(map);
        }
        this.fillTable(list);
        this.initMessage();
    }

    private void fillTable(List list) {
        CerSchemeBillPublishInfo cerSchemeBillPublishInfo = null;
        PersonInfo personInfo = null;
        Map map = null;
        IRow row = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            map = (Map)list.get(i);
            if (this.checkIfRefered((String)map.get("personId"))) continue;
            row = this.tblMain.addRow();
            row.getCell("id").setValue(map.get("id"));
            row.getCell("person.id").setValue(map.get("personId"));
            row.getCell("person.name").setValue(map.get("name"));
            row.getCell("person.number").setValue(map.get("number"));
            row.getCell("position.name").setValue(map.get("position"));
            row.getCell("adminOrg.name").setValue(map.get("adminOrg"));
            cerSchemeBillPublishInfo = new CerSchemeBillPublishInfo();
            personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)((String)map.get("personId"))));
            cerSchemeBillPublishInfo.setPerson(personInfo);
            cerSchemeBillPublishInfo.setScheme(this.cerSchemeBillInfo);
            cerSchemeBillPublishInfo.setSendPerson(this.loginPerson);
            row.setUserObject((Object)cerSchemeBillPublishInfo);
        }
    }

    private void initMessage() throws Exception {
        if (this.cerSchemeBillInfo == null) {
            this.txtTitle.setText(null);
            this.txtContent.setText(null);
            this.pkPublishDate.setValue(null);
            return;
        }
        this.messageInfo = this.getCerSchemeMessage();
        if (this.messageInfo == null) {
            this.messageInfo = this.createCerSchemeMessageInfo();
        }
        this.txtTitle.setText(this.messageInfo.getTitle());
        this.txtContent.setText(this.messageInfo.getContent());
        this.pkPublishDate.setValue((Object)this.messageInfo.getPublishDate());
        this.prmtSendPerson.setValue((Object)this.messageInfo.getSendPerson());
        this.prmtOrg.setValue((Object)this.messageInfo.getAdminOrg());
    }

    private CerSchemeMessageInfo getCerSchemeMessage() throws BOSException {
        CerSchemeMessageCollection collection = CerSchemeMessageFactory.getRemoteInstance().getCerSchemeMessageCollection(this.getCerSchemeMessageEntityView());
        CerSchemeMessageInfo info = null;
        if (collection != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    private EntityViewInfo getCerSchemeMessageEntityView() {
        if (this.cerSchemeBillId == null || this.cerSchemeBillId.length() <= 0) {
            this.cerSchemeBillId = this.getUIContext().get("ID").toString();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)this.cerSchemeBillId));
        filterInfo.getFilterItems().add(new FilterItemInfo("sendPerson.id", (Object)this.loginPerson.getId().toString()));
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("sendPerson.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("sendPerson.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("adminOrg.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("adminOrg.name"));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private CerSchemeMessageInfo createCerSchemeMessageInfo() {
        String title = EASResource.getString((String)STRRES, (String)"35_CerSchemeNotifyTitle");
        title = title.replaceAll("#0", this.cerSchemeBillInfo.getName());
        CerSchemeMessageInfo cerSchemeMessageInfo = new CerSchemeMessageInfo();
        cerSchemeMessageInfo.setTitle(title);
        String body = EASResource.getString((String)STRRES, (String)"44_SchemeBody");
        String newLine = System.getProperty("line.separator");
        body = body.replaceAll("#00", this.cerSchemeBillInfo.getName());
        body = body.replaceAll("#01", this.getQualTypeContent(this.cerSchemeBillInfo));
        body = body.replaceAll("#02", DateTimeUtils.format((Date)this.cerSchemeBillInfo.getSchemeStartDate(), (String)DATE_FORMAT) + " ---- " + DateTimeUtils.format((Date)this.cerSchemeBillInfo.getSchemeEndDate(), (String)DATE_FORMAT));
        body = body.replaceAll("@", newLine);
        cerSchemeMessageInfo.setContent(body);
        cerSchemeMessageInfo.setScheme(this.cerSchemeBillInfo);
        cerSchemeMessageInfo.setSendPerson(this.loginPerson);
        PersonPositionInfo PPinfo = null;
        try {
            PPinfo = HRQualClientUtils.getPersonPositionInfo(this.loginPerson.getId());
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResource.getString((String)STRRES, (String)"42_NotAdminOrg"));
        }
        if (PPinfo != null) {
            cerSchemeMessageInfo.setAdminOrg(PPinfo.getPersonDep());
        }
        return cerSchemeMessageInfo;
    }

    private String getQualTypeContent(CerSchemeBillInfo cerInfo) {
        StringBuffer result = new StringBuffer();
        CerSchemeBillTypeEntryCollection qualTypeCol = cerInfo.getTypeEntrys();
        if (qualTypeCol != null && qualTypeCol.size() > 0) {
            int size = qualTypeCol.size();
            for (int i = 0; i < size; ++i) {
                QualTypeInfo qualTypeInfo;
                CerSchemeBillTypeEntryInfo cerTypeInfo = qualTypeCol.get(i);
                if (cerTypeInfo == null || (qualTypeInfo = cerTypeInfo.getQualType()) == null) continue;
                result.append(qualTypeInfo.getName());
                if (i == size - 1) continue;
                result.append("\u3001");
            }
        }
        return result.toString();
    }

    private boolean checkIfRefered(String personId) {
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            String personIdInTable = (String)row.getCell("person.id").getValue();
            if (personIdInTable == null || !personIdInTable.equals(personId)) continue;
            return true;
        }
        return false;
    }

    private void verifyInput() {
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.prmtCerSchemeBill);
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.txtTitle);
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, STRRES, this.txtContent, "43_Content_Can_Not_Null");
    }

    private void bindFields() {
        this.messageInfo.setTitle(this.txtTitle.getText());
        this.messageInfo.setContent(this.txtContent.getText());
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)STRRES, (String)"37_NoPerson"));
            SysUtil.abort();
        }
        this.verifyInput();
        this.bindFields();
        if (this.confirmPublish()) {
            this.executePublish(this.getPublishInfoCollection());
        }
    }

    private void executePublish(final CerSchemeBillPublishCollection collection) {
        HRQualClientUtils.executeWithProcess((CoreUI)this, new IProgTask(){

            public void afterExec(Object result) throws Exception {
                CerSchemeBillPublishListUI.this.showSuccessMessage();
                CerSchemeBillPublishListUI.this.loadData();
            }

            public Object exec() throws Exception {
                CerSchemeBillPublishListUI.this.runPublish(collection);
                return "";
            }
        });
    }

    private void showSuccessMessage() {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)STRRES, (String)"39_PublishSuccess"));
    }

    private void runPublish(CerSchemeBillPublishCollection collection) throws Exception {
        this.messageInfo.setPublishDate(new Date());
        IObjectPK messagePK = CerSchemeBillFactory.getRemoteInstance().publish(this.messageInfo, collection);
        this.messageInfo.setId(BOSUuid.read((String)messagePK.toString()));
        ICerSchemeMessage iCerSchemeMessage = CerSchemeMessageFactory.getRemoteInstance();
        iCerSchemeMessage.setMassage(messagePK);
    }

    private CerSchemeBillPublishCollection getPublishInfoCollection() {
        CerSchemeBillPublishCollection collection = new CerSchemeBillPublishCollection();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            CerSchemeBillPublishInfo info = (CerSchemeBillPublishInfo)this.tblMain.getRow(i).getUserObject();
            String id = this.tblMain.getRow(i).getCell("id").getValue().toString();
            info.setId(BOSUuid.read((String)id));
            collection.add(info);
        }
        return collection;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        this.bindFields();
        IObjectPK pk = CerSchemeMessageFactory.getRemoteInstance().submit((CoreBaseInfo)this.messageInfo);
        this.messageInfo.setId(BOSUuid.read((String)pk.toString()));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)STRRES, (String)"36_Success"));
    }

    private boolean confirmPublish() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)STRRES, (String)"38_Confirm_Publish")));
    }

    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmt.showNoPositionPerson(true);
        pmt.setUserOrgRangeFilter(true);
        pmt.setIsSingleSelect(false);
        this.handlePromptBox((KDCommonPromptDialog)pmt);
    }

    private void handlePromptBox(KDCommonPromptDialog pmt) throws Exception {
        pmt.setModal(true);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            final Object[] obj = (Object[])pmt.getData();
            if (obj.length > 50) {
                ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

                    public void run() throws Exception {
                        CerSchemeBillPublishListUI.this.dealAddPerson(obj);
                    }
                };
                new ProgressManager((CoreUI)this).launchProcess(process, (CoreUIObject)this);
            } else {
                this.dealAddPerson(obj);
            }
        }
    }

    private void dealAddPerson(Object[] obj) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        PersonInfo personInfo = null;
        for (int i = 0; i < obj.length; ++i) {
            personInfo = (PersonInfo)obj[i];
            idSet.add(personInfo.getId().toString());
        }
        if (idSet.size() != 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            IRowSet rowSet = CerSchemeHelper.getRowSet("CerSchemePersonScopeQuery", fi);
            ArrayList list = new ArrayList();
            HashMap<String, String> map = null;
            while (rowSet.next()) {
                map = new HashMap<String, String>();
                map.put("personId", rowSet.getString("id"));
                map.put("number", rowSet.getString("number"));
                map.put("name", rowSet.getString("name"));
                map.put("position", rowSet.getString("position.name"));
                map.put("adminOrg", rowSet.getString("adminOrg.name"));
                list.add(map);
            }
            this.fillTable(list);
            this.submit();
        }
    }

    public void submit() throws Exception {
        ICerSchemeBillPublish iCerSchemeBillPublish = CerSchemeBillPublishFactory.getRemoteInstance();
        CerSchemeBillPublishCollection schemePublishCollection = new CerSchemeBillPublishCollection();
        CerSchemeBillPublishInfo schemePublishInfo = null;
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("id").getValue() != null) continue;
            schemePublishInfo = (CerSchemeBillPublishInfo)row.getUserObject();
            schemePublishCollection.add(schemePublishInfo);
        }
        if (schemePublishCollection.size() != 0) {
            Map idMap = iCerSchemeBillPublish.batchSubmit(schemePublishCollection);
            int size2 = this.tblMain.getRowCount();
            for (int i = 0; i < size2; ++i) {
                row = this.tblMain.getRow(i);
                if (row.getCell("id").getValue() != null) continue;
                row.getCell("id").setValue(idMap.get((String)row.getCell("person.id").getValue()));
            }
        }
    }

    public void actionDelPerson_actionPerformed(ActionEvent e) throws Exception {
        ICerSchemeBillPublish iSchemePublish = CerSchemeBillPublishFactory.getRemoteInstance();
        this.checkSelected();
        if (this.confirmRemove()) {
            IRow row = null;
            HashSet<String> idSet = new HashSet<String>();
            int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            if (rows.length > 0) {
                for (int i = rows.length - 1; i >= 0; --i) {
                    int rowIndex = rows[i];
                    row = this.tblMain.getRow(rowIndex);
                    String id = (String)row.getCell("id").getValue();
                    if (id != null) {
                        idSet.add(id);
                    }
                    this.tblMain.removeRow(rowIndex);
                }
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                if (idSet.size() > 0) {
                    iSchemePublish.delete(idSet);
                }
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent arg0) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareInit() {
        return super.isPrepareInit();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }
}

