/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.ICodingRule;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.qualifications.client.IProgTask;
import com.kingdee.eas.hr.qualifications.client.ProgDialog;
import com.kingdee.eas.hr.qualifications.client.QualGroupEmployeeF7PromptBox;
import com.kingdee.eas.hr.qualifications.client.TableActionHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class HRQualClientUtils {
    private static final String resClass = "com.kingdee.eas.hr.qualifications.QualificationsResource";

    public static ItemAction[] addButtonsToMutilTable(KDContainer container, KDTable table) {
        return HRQualClientUtils.addButtonsToMutilTable(container, table, null);
    }

    public static ItemAction[] addButtonsToMutilTable(KDContainer container, KDTable table, TableActionHandler handler) {
        HRQualClientUtils.setMutilTableFromBIM(container, table);
        class ActionRow
        extends ItemAction {
            private String name;
            private KDTable table;
            private TableActionHandler handler;

            ActionRow(KDTable table, String name, TableActionHandler handler) {
                this.table = table;
                this.name = name;
                this.handler = handler;
            }

            public void actionPerformed(ActionEvent e) {
                if ("ActionAddLine".equals(this.name)) {
                    if (this.handler != null) {
                        this.handler.AddLine(this.table);
                    } else {
                        HRQualClientUtils.addLine(this.table);
                    }
                } else if ("ActionInsertLine".equals(this.name)) {
                    if (this.handler != null) {
                        this.handler.InsertLine(this.table);
                    } else {
                        HRQualClientUtils.insertLine(this.table);
                    }
                } else if ("ActionRemoveLine".equals(this.name)) {
                    HRQualClientUtils.removeLine(this.table);
                }
            }
        }
        ActionRow actionAddLine = new ActionRow(table, "ActionAddLine", handler);
        ActionRow actionInsertLine = new ActionRow(table, "ActionInsertLine", handler);
        ActionRow actionRemoveLine = new ActionRow(table, "ActionRemoveLine", handler);
        HRQualClientUtils.initMutilTableFromBIM(container, (Action)((Object)actionAddLine), (Action)((Object)actionInsertLine), (Action)((Object)actionRemoveLine));
        ItemAction[] actions = new ItemAction[]{actionAddLine, actionInsertLine, actionRemoveLine};
        return actions;
    }

    private static void setMutilTableFromBIM(KDContainer container, KDTable table) {
        container.getContentPane().removeAll();
        container.getContentPane().add((Component)table);
    }

    public static void initMutilTableFromBIM(KDContainer container, Action actionAddLine, Action actionInsertLine, Action actionRemoveLine) {
        JButton btnAddLine = container.add(actionAddLine);
        btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnAddLine.setToolTipText(EASResource.getString((String)resClass, (String)"AddLine"));
        btnAddLine.setText(null);
        btnAddLine.setEnabled(true);
        JButton btnInsertLine = container.add(actionInsertLine);
        btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        btnInsertLine.setToolTipText(EASResource.getString((String)resClass, (String)"InsertLine"));
        btnInsertLine.setText(null);
        btnInsertLine.setEnabled(true);
        JButton btnRemoveLine = container.add(actionRemoveLine);
        btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnRemoveLine.setToolTipText(EASResource.getString((String)resClass, (String)"RemoveLine"));
        btnRemoveLine.setText(null);
        btnRemoveLine.setEnabled(true);
    }

    public static IRow addLine(KDTable table) {
        if (table == null) {
            return null;
        }
        return table.addRow();
    }

    public static IRow insertLine(KDTable table) {
        if (table == null) {
            return null;
        }
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = HRQualClientUtils.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        return row;
    }

    public static void removeRow(KDTable table, int rowIndex) {
        IObjectCollection collection;
        int index;
        Object detailData = table.getRow(rowIndex).getUserObject();
        table.removeRow(rowIndex);
        if (detailData != null && (index = HRQualClientUtils.getCollectionIndex(collection = (IObjectCollection)table.getUserObject(), (IObjectValue)detailData)) >= 0 && collection.size() > index) {
            collection.removeObject(index);
        }
    }

    public static void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || HRQualClientUtils.isTableColumnSelected(table)) {
            MsgBox.showInfo((String)EASResource.getString((String)resClass, (String)"118_SelectEntry"));
            return;
        }
        int top = table.getSelectManager().get().getTop();
        if (table.getRow(top) == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resClass, (String)"118_SelectEntry"));
            return;
        }
        IObjectValue detailData = (IObjectValue)table.getRow(top).getUserObject();
        table.removeRow(top);
        IObjectCollection collection = (IObjectCollection)table.getUserObject();
        if (collection != null && detailData != null) {
            collection.removeObject(top);
        }
    }

    public static int[] getSelectedColumns(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getLeft(); j <= block.getRight(); ++j) {
                set.add(j);
            }
        }
        int[] columns = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            columns[k++] = (Integer)iter.next();
        }
        return columns;
    }

    public static int[] getSelectedRows(KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                if (j < 0) continue;
                set.add(j);
            }
        }
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k++] = (Integer)iter.next();
        }
        return rows;
    }

    public static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public static int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    public static void verifyEntryEmpty(KDTable table) {
        if (table.getSelectManager().size() == 0 || HRQualClientUtils.isTableColumnSelected(table) || table.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)resClass, (String)"118_SelectEntry"));
            return;
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        HRQualClientUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDComboBox combo) {
        HRQualClientUtils.verifyEmpty(ui, null, combo, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizMultiLangBox txtName) {
        HRQualClientUtils.verifyEmpty(ui, null, txtName, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDDatePicker date) {
        HRQualClientUtils.verifyEmpty(ui, null, date, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextArea textAreacontent) {
        HRQualClientUtils.verifyEmpty(ui, null, textAreacontent, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        HRQualClientUtils.verifyEmpty(ui, null, bizBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextArea textArea, String msg) {
        if (!textArea.isEnabled()) {
            return;
        }
        String content = textArea.getText();
        if (content == null || content.toString().trim().equals("")) {
            textArea.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRQualClientUtils.getMessage((Component)textArea)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizMultiLangBox txtName, String msg) {
        Object txt = txtName.getSelectedItem();
        if (txt == null || txt.toString().trim().equals("")) {
            txtName.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRQualClientUtils.getMessage((Component)txtName)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        if (!txtNumber.isEnabled()) {
            return;
        }
        String txt = txtNumber.getText();
        if (txt == null || txt.trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRQualClientUtils.getMessage((Component)txtNumber)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDComboBox combo, String msg) {
        if (!combo.isEnabled()) {
            return;
        }
        int k = combo.getSelectedIndex();
        if (k < 0) {
            combo.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRQualClientUtils.getMessage((Component)combo)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDDatePicker date, String msg) {
        Object content = date.getValue();
        if (content == null) {
            date.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRQualClientUtils.getMessage((Component)date)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTimePicker time, String msg) {
        Object content = time.getValue();
        if (content == null) {
            time.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRQualClientUtils.getMessage((Component)time)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath != null && msg != null ? EASResource.getString((String)resourcePath, (String)msg) : HRQualClientUtils.getMessage((Component)bizBox)));
            SysUtil.abort();
        }
    }

    public static String getMessage(Component component) {
        String text = HRQualClientUtils.getBoundLabelText(component);
        return text + EASResource.getString((String)resClass, (String)"CanNotBeNull");
    }

    private static String getBoundLabelText(Component component) {
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        }
        return text;
    }

    public static String getDatePatternStr() {
        return "yyyy-MM-dd";
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("^[+\\-]?\\d+(.\\d+)?");
        return pattern.matcher(str).matches();
    }

    public static void checkFullWidthBlank(String number) {
        boolean checked = false;
        if (number != null && (checked = HRQualClientUtils.checkFull_width(number))) {
            MsgBox.showInfo((String)EASResource.getString((String)resClass, (String)"BillNumber_Not_Null"));
            SysUtil.abort();
        }
    }

    public static int getCurrentRowIndex(KDTable kdTable) {
        int rowIndex = -1;
        KDTSelectBlock selectBlock = kdTable.getSelectManager().get();
        if (selectBlock != null) {
            rowIndex = selectBlock.getTop();
        }
        return rowIndex;
    }

    public static PersonPositionInfo getPersonPositionInfo(BOSUuid personID) throws Exception {
        String oql = "select primaryPosition.id, primaryPosition.name, primaryPosition.number ,id,personDep.id,personDep.name,personDep.number where person.id = '" + personID + "'";
        PersonPositionCollection c = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(oql);
        if (c.size() > 0) {
            return c.get(0);
        }
        return null;
    }

    public static PersonInfo getPersonInfo(BOSUuid personID) throws Exception {
        String oql = "select id, name where id = '" + personID + "'";
        PersonCollection c = PersonFactory.getRemoteInstance().getPersonCollection(oql);
        if (c.size() > 0) {
            return c.get(0);
        }
        return null;
    }

    public static String getResource(String RES, String message) {
        return EASResource.getString((String)RES, (String)message);
    }

    public static String getResource(String RES, String message, Object[] params) {
        String str = HRQualClientUtils.getResource(RES, message);
        return MessageFormat.format(str, params);
    }

    public static final String QBchange(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] >= '\uff5e') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static boolean checkFull_width(String number) {
        boolean checked = false;
        byte[] bytes = number.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != -95) continue;
            bytes[i] = 32;
        }
        number = new String(bytes).trim();
        if (number.trim().equals("") || number == null) {
            checked = true;
        }
        return checked;
    }

    public static long getCompareDate(Date startDate, Date endDate) {
        long len = endDate.getTime() - startDate.getTime();
        long days = len / 86400000L;
        return days;
    }

    protected static boolean confirmAudit() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)resClass, (String)"Confirm_Audit")));
    }

    public static void checkValidPerson(CoreUI uiObject) {
        if (HRQualClientUtils.objectIsNull(SysContext.getSysContext().getCurrentUserInfo().getPerson())) {
            HRQualClientUtils.showErrorMessage(resClass, "34_userNoPerson", uiObject);
        }
    }

    public static boolean objectIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)obj.toString());
        }
        return false;
    }

    public static void showErrorMessage(String RES, String message, CoreUI uiObject) {
        MsgBox.showError((Component)uiObject, (String)HRQualClientUtils.getResource(RES, message));
        uiObject.setCursorOfDefault();
        SysUtil.abort();
    }

    public static void executeWithProcess(CoreUI uiObject, IProgTask prog) {
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)uiObject);
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    public static void viewPerson(String PersonID, String editUIModal, CoreUI ui) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"Owner", (Object)ui);
        uiContext.put((Object)"ID", (Object)PersonID);
        RealModeIDList idList = new RealModeIDList();
        idList.add(PersonID);
        uiContext.put((Object)"IDList", (Object)idList);
        uiContext.put((Object)"isPosition", (Object)true);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)editUIModal).create(EmployeeTreeEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public static QualGroupEmployeeF7PromptBox initPersonF7(FilterItemInfo filterItem) {
        QualGroupEmployeeF7PromptBox memberF7 = null;
        memberF7 = new QualGroupEmployeeF7PromptBox();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("QUERY_BASE", "com.kingdee.eas.hr.qualifications.app.QualGroupF7Query");
        map.put("QUERY_BY_HR", "com.kingdeQual.hr.qualifications.app.QualGroupF7ByHRQuery");
        map.put("QUERY_BY_ALL_ADMIN", "com.kingdee.eas.hr.qualifications.app.QualGroupF7ByAllAdminQuery");
        map.put("QUERY_BY_NEW", "com.kingdee.eas.hr.qualifications.app.QualGroupF7Query");
        map.put("QUERY_BY_OLD", "com.kingdee.eas.hr.qualifications.app.QualGroupF7OldQuery");
        map.put("QUERY_FOR_NO_POSITION_NEW", "com.kingdee.eas.hr.qualifications.app.QualGroupF7NoPosition2NewQuery");
        map.put("QUERY_FOR_NO_POSITION", "com.kingdee.eas.hr.qualifications.app.QualGroupF7NoPosition2Query");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(filterItem);
        map.put("QUAL_GROUP_FILTER", (String)filter);
        memberF7.setQualGroupProperties(map);
        memberF7.setIsSingleSelect(false);
        memberF7.setUserOrgRangeFilter(true);
        memberF7.setEnabledMultiSelection(true);
        memberF7.showNoPositionPerson(true);
        memberF7.setNopositionPersonFilter(filter);
        try {
            memberF7.setIsPluralityIsChooseContral(HRParamUtil.getParamOfHR(null, (String)"PLURALITY_IS_CHOOSE", null));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return memberF7;
    }

    public static boolean isExistCodingRule(String businessObject, String orgID, String key) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessObject", (Object)businessObject, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("org", (Object)orgID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)true, CompareType.EQUALS));
        if (key != null) {
            filter.getFilterItems().add(new FilterItemInfo(key, (Object)true, CompareType.EQUALS));
        }
        view.setFilter(filter);
        ICodingRule iCodingRule = CodingRuleFactory.getRemoteInstance();
        return iCodingRule.getCodingRuleCollection(view).size() > 0;
    }

    public static void addComboBoxEmptyItem(KDComboBox comboBox) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)comboBox.getModel();
        model.insertElementAt(null, 0);
    }

    public static HROrgUnitInfo getCurrentHROrgUnit() {
        HROrgUnitInfo info = SysContext.getSysContext().getCurrentHRUnit();
        return info;
    }

    public static FilterInfo getCurrentCUFilter() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    public static UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    public static CompanyOrgUnitInfo getCurrentCompany() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        return companyOrgUnitInfo;
    }

    public static FilterInfo getCurrentHRFilter(String hrOrgUnitId) {
        FilterInfo filter = new FilterInfo();
        if (HRQualClientUtils.getCurrentHROrgUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo(hrOrgUnitId, (Object)HRQualClientUtils.getCurrentHROrgUnit().getId().toString()));
        }
        return filter;
    }

    public static FilterInfo getHRFilter(String hrOrgUnitColumn, String hrOrgUnitId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(hrOrgUnitColumn, (Object)hrOrgUnitId));
        return filter;
    }

    public static EntityViewInfo getCurrentHREntityViewInfo(String hrOrgUnit) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(HRQualClientUtils.getCurrentHRFilter(hrOrgUnit));
        return viewInfo;
    }

    public static EntityViewInfo getHRAndAdminRangeEntityViewInfo(String hrOrgUnitId, String adminOrgUnitId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(HRQualClientUtils.getHRAndAdminRangeFilterInfo(hrOrgUnitId, adminOrgUnitId));
        return viewInfo;
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(String hrColumnName, String orgUnitColumnName) {
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        return HRQualClientUtils.getHRAndAdminRangeFilterInfo(hrColumnName, orgUnitColumnName, hrOrgUnitID);
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(String hrColumnName, String orgUnitColumnName, String hrOrgUnitId) {
        FilterInfo filter = HRQualClientUtils.getAdminRangeFilterInfo(orgUnitColumnName, hrOrgUnitId);
        FilterItemInfo item = new FilterItemInfo(hrColumnName, (Object)hrOrgUnitId);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static FilterInfo getRangeFilterInfo(String hrColumnName) {
        SysContext.getSysContext().getCurrentAdminUnit().getId().toString();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(hrColumnName, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(String orgUnitColumnName) {
        String hrOrgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        return HRQualClientUtils.getAdminRangeFilterInfo(orgUnitColumnName, hrOrgUnitId);
    }

    public static FilterInfo getAdminRangeFilterInfo(String orgUnitColumnName, String hrOrgUnitId) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String sql = HRQualClientUtils.getAdminRangeSQL(hrOrgUnitId, userID);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql, CompareType.INNER);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static FilterInfo getAdminRangeFilter(String orgUnitColumnName) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String sql = HRQualClientUtils.getAdminRangeSQL(userID);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql, CompareType.INNER);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static String getAdminRangeSQL(String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        return sql.toString();
    }

    public static String getAdminRangeSQL(String hrOrgUnitId, String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitId);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        return sql.toString();
    }

    public static FilterInfo getAdminRangeFilterInfo(String orgUnitColumnName) {
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        return HRQualClientUtils.getAdminRangeFilterInfo(orgUnitColumnName, hrOrgUnitID);
    }

    public static String getHRAndAdminRangePersonSQL(String hrOrgUnitID, String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT PERSON.FID FROM T_BD_PERSON AS PERSON");
        sql.append(" INNER JOIN T_HR_PERSONPOSITION AS PP ON PP.FPERSONID = PERSON.FID");
        sql.append(" INNER JOIN T_ORG_UNITRELATION AS REL ON REL.FFROMUNITID = PP.FPERSONDEP");
        sql.append(" INNER JOIN T_PM_ORGRANGE AS RANGE ON RANGE.FORGID = REL.FFROMUNITID");
        sql.append(" WHERE ");
        sql.append(" REL.FTOUNITID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" REL.FTYPERELATIONID = ");
        sql.append("'");
        sql.append("00000000-0000-0000-0000-0000000000100FE9F8B5");
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FUSERID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FTYPE = ");
        sql.append(20);
        return sql.toString();
    }

    public static FilterInfo getHRAndAdminRangePersonFilterInfo(String hrColumnName, String personColumnName) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        String sql = HRQualClientUtils.getHRAndAdminRangePersonSQL(hrOrgUnitID, userID);
        filterInfo.getFilterItems().add(new FilterItemInfo(personColumnName, (Object)sql, CompareType.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo(hrColumnName, (Object)hrOrgUnitID));
        return filterInfo;
    }

    public static String getHRAndAdminRangePersonSQL_All(String hrOrgUnitID, String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT PERSON.FID FROM T_BD_PERSON AS PERSON");
        sql.append(" INNER JOIN T_ORG_POSITIONMEMBER AS PM ON PM.FPERSONID = PERSON.FID");
        sql.append(" INNER JOIN T_ORG_POSITION AS Position ON PM.FPOSITIONID = Position.FID");
        sql.append(" INNER JOIN T_ORG_UNITRELATION AS REL ON REL.FFROMUNITID = Position.FAdminOrgUnitID");
        sql.append(" INNER JOIN T_PM_ORGRANGE AS RANGE ON RANGE.FORGID = REL.FFROMUNITID");
        sql.append(" WHERE ");
        sql.append(" REL.FTOUNITID in (");
        sql.append(hrOrgUnitID);
        sql.append(") ");
        sql.append(" AND ");
        sql.append(" REL.FTYPERELATIONID = ");
        sql.append("'");
        sql.append("00000000-0000-0000-0000-0000000000100FE9F8B5");
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FUSERID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FTYPE = ");
        sql.append(20);
        return sql.toString();
    }

    public static String getHRAndAdminRangePersonSQL() {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer hrOrgUnitID_buf = new StringBuffer();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        hrOrgUnitID_buf.append("'").append(hrOrgUnitID).append("'");
        String sql = HRQualClientUtils.getHRAndAdminRangePersonSQL_All(hrOrgUnitID_buf.toString(), userID);
        return sql;
    }

    public static FilterInfo getAllHRAndAdminRangeFilterInfo(String orgUnitColumnName) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        return HRQualClientUtils.getAllHRAndAdminRangeFilterInfo(orgUnitColumnName, userID);
    }

    public static FilterInfo getAllHRAndAdminRangeFilterInfo(String orgUnitColumnName, String userID) {
        String sql = HRQualClientUtils.getAllHRAndAdminRangeSQL(userID);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql, CompareType.INNER);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static String getAllHRAndAdminRangeSQL(String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID IN ( ");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(10);
        sql.append(" AND FOrgID in ( Select FId From T_ORG_HRO )");
        sql.append(")");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        return sql.toString();
    }

    public static HashSet getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        result = permission.getAuthorizedOrg(user, orgType, null, permItem);
        HashSet<String> hrIds = new HashSet<String>();
        if (result != null && result.size() > 0) {
            int size = result.size();
            for (int i = 0; i < size; ++i) {
                hrIds.add(result.get(i).getId().toString());
            }
        }
        return hrIds;
    }

    public static FilterInfo getAllHRAndAdminRangeFilterInfo(String orgUnitColumnName, OrgType orgType, String permItem) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        return HRQualClientUtils.getAllHRAndAdminRangeFilterInfo(orgUnitColumnName, userID, orgType, permItem);
    }

    public static FilterInfo getAllHRAndAdminRangeFilterInfo(String orgUnitColumnName, String userID, OrgType orgType, String permItem) {
        FilterInfo filter = new FilterInfo();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)userID));
        HashSet hrIds = null;
        try {
            hrIds = HRQualClientUtils.getAuthOrgByPermItem((IObjectPK)pk, orgType, permItem);
        }
        catch (EASBizException e) {
            MsgBox.showError((String)EASResource.getString((String)resClass, (String)"169_GetPermissionError"));
            SysUtil.abort();
        }
        catch (BOSException e) {
            MsgBox.showError((String)EASResource.getString((String)resClass, (String)"169_GetPermissionError"));
            SysUtil.abort();
        }
        if (hrIds == null || hrIds.size() <= 0) {
            return filter;
        }
        FilterItemInfo hrItem = new FilterItemInfo("FOrgID", (Object)hrIds, CompareType.INCLUDE);
        String sql = HRQualClientUtils.getAllHRAndAdminRangeSQLByPermItem(userID, hrItem.toString());
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql, CompareType.INNER);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static String getAllHRAndAdminRangeSQLByPermItem(String userID, String hrSql) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID IN ( ");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(10);
        sql.append(" AND FOrgID in ( Select FId From T_ORG_HRO )");
        sql.append(" AND ");
        sql.append(hrSql);
        sql.append(")");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        return sql.toString();
    }
}

