/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.qualifications.IQualTypeEntry;
import com.kingdee.eas.hr.qualifications.IdentifyMethodInfo;
import com.kingdee.eas.hr.qualifications.IdentifySchemeEnum;
import com.kingdee.eas.hr.qualifications.IdentifySchemeFactory;
import com.kingdee.eas.hr.qualifications.IdentifySchemeInfo;
import com.kingdee.eas.hr.qualifications.MethodEntryInfo;
import com.kingdee.eas.hr.qualifications.QualTypeEntryCollection;
import com.kingdee.eas.hr.qualifications.QualTypeEntryFactory;
import com.kingdee.eas.hr.qualifications.QualTypeEntryInfo;
import com.kingdee.eas.hr.qualifications.QualTypeInfo;
import com.kingdee.eas.hr.qualifications.QualificationsException;
import com.kingdee.eas.hr.qualifications.client.AbstractIdentifySchemeEditUI;
import com.kingdee.eas.hr.qualifications.client.HRQualClientUtils;
import com.kingdee.eas.hr.qualifications.client.QualTypePromptBox;
import com.kingdee.eas.hr.qualifications.client.TableActionHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class IdentifySchemeEditUI
extends AbstractIdentifySchemeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(IdentifySchemeEditUI.class);
    private static final String STRRES = "com.kingdee.eas.hr.qualifications.QualificationsResource";
    private ItemAction[] methodActions;
    private ItemAction[] typeActions;
    private QualTypePromptBox typeF7 = null;
    private int selQualTypeRow = 0;

    protected IObjectValue createNewData() {
        IdentifySchemeInfo info = new IdentifySchemeInfo();
        info.setCreateDate(new Date());
        info.setState(IdentifySchemeEnum.UNCANCELCANCEL);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return IdentifySchemeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
        this.btnFirst.setVisible(true);
        this.btnPre.setVisible(true);
        this.btnNext.setVisible(true);
        this.btnLast.setVisible(true);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.editData != null && "ADDNEW".equals(this.getOprtState())) {
            this.editData.setNumber(null);
            this.editData.setState(IdentifySchemeEnum.UNCANCELCANCEL);
        }
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        IdentifySchemeInfo editData = this.editData;
        super.removeByPK(pk);
        this.recycleNumberByOrg((IObjectValue)editData, "ControlUnit", editData.getString("number"));
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)number)) {
            try {
                String companyID = null;
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty(companyID) && iCodingRuleManager.isExist(editData, companyID) && iCodingRuleManager.isUseIntermitNumber(editData, companyID)) {
                    iCodingRuleManager.recycleNumber(editData, companyID, number);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void setAutoNumberByOrg(String orgType) {
        if (this.editData == null) {
            return;
        }
        if (this.editData.getNumber() == null) {
            try {
                String companyID = null;
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                    if (iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                        this.editData.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
                    }
                    this.txtNumber.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                this.oldData = this.editData;
                SysUtil.abort();
            }
        } else if (this.editData.getNumber().trim().length() > 0) {
            this.txtNumber.setText(this.editData.getNumber());
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"ControlUnit");
    }

    public void loadFields() {
        this.setAutoNumberByOrg("ControlUnit");
        this.kdtQualTypeEntry.checkParsed();
        this.kdtMethodEntry.checkParsed();
        super.loadFields();
        if (!"ADDNEW".equals(this.getOprtState())) {
            int n = this.kdtQualTypeEntry.getColumnCount();
            this.kdtQualTypeEntry.getSelectManager().select(0, 0, 0, n - 1);
        }
        if (this.editData.getState() != null && IdentifySchemeEnum.CANCELCANCEL.toString().equals(this.editData.getState().toString()) && "VIEW".equals(this.getOprtState())) {
            this.actionRemove.setEnabled(false);
            this.actionEdit.setEnabled(false);
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int methodRowSize;
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        if (HRQualClientUtils.checkFull_width(this.txtName.getText())) {
            this.txtName.requestFocus(true);
            MsgBox.showInfo((String)EASResource.getString((String)STRRES, (String)"28_Name_Not_Null"));
            SysUtil.abort();
        }
        if ((methodRowSize = this.kdtQualTypeEntry.getRowCount()) == 0) {
            MsgBox.showInfo((String)(EASResource.getString((String)STRRES, (String)"QualType") + EASResource.getString((String)STRRES, (String)"Entry") + EASResource.getString((String)STRRES, (String)"CanNotBeNull")));
            SysUtil.abort();
        } else {
            for (int i = 0; i < methodRowSize; ++i) {
                if (this.editData.getQualTypeEntry().get(i) == null || this.editData.getQualTypeEntry().get(i).getMethodEntry().size() != 0) continue;
                this.kdtQualTypeEntry.getSelectManager().select(i, 0, i, this.kdtQualTypeEntry.getColumnCount() - 1);
                MsgBox.showInfo((String)(EASResource.getString((String)STRRES, (String)"49_MethodEntryBlankOne") + (i + 1) + EASResource.getString((String)STRRES, (String)"50_MethodEntryBlankOne")));
                SysUtil.abort();
            }
        }
        this.checkQualTypeEntry(methodRowSize);
        this.checkMethodEntry(methodRowSize);
        this.checkQualTypeExistInOtherOne();
    }

    private void checkQualTypeExistInOtherOne() throws BOSException {
        String qualTypeId = null;
        EntityViewInfo view = new EntityViewInfo();
        if (this.kdtQualTypeEntry != null && this.kdtQualTypeEntry.getRowCount() > 0) {
            int size = this.kdtQualTypeEntry.getRowCount();
            for (int i = 0; i < size; ++i) {
                QualTypeEntryInfo qualTypeEntryInfo = (QualTypeEntryInfo)this.kdtQualTypeEntry.getRow(i).getUserObject();
                if (qualTypeEntryInfo != null && qualTypeEntryInfo.getQualType() != null) {
                    qualTypeId = qualTypeEntryInfo.getQualType().getId().toString();
                }
                if (qualTypeId == null) continue;
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("qualType", (Object)qualTypeId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("identifyScheme.state", (Object)1, CompareType.EQUALS));
                view.setFilter(filterInfo);
                IQualTypeEntry iQualTypeEntry = QualTypeEntryFactory.getRemoteInstance();
                QualTypeEntryCollection qualTypeEntryCol = iQualTypeEntry.getQualTypeEntryCollection(view);
                if (qualTypeEntryCol == null || qualTypeEntryCol.size() <= 0) continue;
                String qualTypeName = this.kdtQualTypeEntry.getRow(i).getCell("name").getValue().toString();
                String strInfo = EASResource.getString((String)STRRES, (String)"QualType") + " " + qualTypeName + " " + EASResource.getString((String)STRRES, (String)"52_QualTypeExist");
                MsgBox.showInfo((String)strInfo);
                SysUtil.abort();
            }
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("EDIT".equals(this.getOprtState())) {
            this.setButtonState(true);
        }
        if ("VIEW".equals(this.getOprtState())) {
            this.setButtonState(false);
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setButtonState(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.prmtMethod.setDisplayFormat("$name$");
        this.prmtMethod.setEditFormat("$number$");
        this.prmtMethod.setCommitFormat("$number$");
        this.prmtMethod.setEnabledMultiSelection(true);
    }

    private void checkQualTypeEntry(int methodRowSize) {
        for (int i = 0; i < methodRowSize - 1; ++i) {
            String methodId = null;
            if (this.editData.getQualTypeEntry().get(i) != null && this.editData.getQualTypeEntry().get(i).getQualType() != null) {
                methodId = this.editData.getQualTypeEntry().get(i).getQualType().getId().toString();
            }
            for (int j = i + 1; j < methodRowSize; ++j) {
                if (this.editData.getQualTypeEntry().get(j) == null || methodId == null) continue;
                String methodIdItem = null;
                if (this.editData.getQualTypeEntry().get(j) != null && this.editData.getQualTypeEntry().get(j).getQualType() != null) {
                    methodIdItem = this.editData.getQualTypeEntry().get(j).getQualType().getId().toString();
                }
                if (!methodId.equals(methodIdItem)) continue;
                String strItem = EASResource.getString((String)STRRES, (String)"QualType") + EASResource.getString((String)STRRES, (String)"Entry") + EASResource.getString((String)STRRES, (String)"Di") + (i + 1) + EASResource.getString((String)STRRES, (String)"Hang") + EASResource.getString((String)STRRES, (String)"Yu") + EASResource.getString((String)STRRES, (String)"Di") + (j + 1) + EASResource.getString((String)STRRES, (String)"Hang") + EASResource.getString((String)STRRES, (String)"repeat");
                MsgBox.showInfo((String)strItem);
                SysUtil.abort();
            }
        }
    }

    private void checkMethodEntry(int methodRowSize) {
        for (int k = 0; k < methodRowSize; ++k) {
            int qualTypeRowSize = -1;
            if (this.editData.getQualTypeEntry().get(k) == null) continue;
            qualTypeRowSize = this.editData.getQualTypeEntry().get(k).getMethodEntry().size();
            for (int i = 0; i < qualTypeRowSize - 1; ++i) {
                String qualTypeId = null;
                if (this.editData.getQualTypeEntry().get(k).getMethodEntry().get(i) != null && this.editData.getQualTypeEntry().get(k).getMethodEntry().get(i).getIdentifyMethod() != null) {
                    qualTypeId = this.editData.getQualTypeEntry().get(k).getMethodEntry().get(i).getIdentifyMethod().getId().toString();
                }
                for (int j = i + 1; j < qualTypeRowSize; ++j) {
                    String qualTypeItemId = null;
                    if (this.editData.getQualTypeEntry().get(k).getMethodEntry().get(j) != null) {
                        qualTypeItemId = this.editData.getQualTypeEntry().get(k).getMethodEntry().get(j).getIdentifyMethod().getId().toString();
                    }
                    if (qualTypeId == null || !qualTypeId.equals(qualTypeItemId)) continue;
                    this.kdtMethodEntry.getSelectManager().select(k, 0, k, 4);
                    String strItem = EASResource.getString((String)STRRES, (String)"49_MethodEntryBlankOne") + (k + 1) + EASResource.getString((String)STRRES, (String)"51_MethodRepeat") + (i + 1) + EASResource.getString((String)STRRES, (String)"HangYuDi") + (j + 1) + EASResource.getString((String)STRRES, (String)"Hang") + EASResource.getString((String)STRRES, (String)"repeat");
                    MsgBox.showInfo((String)strItem);
                    SysUtil.abort();
                }
            }
        }
    }

    private void setButtonState(boolean flag) {
        int i;
        if (this.methodActions != null) {
            for (i = 0; i < this.methodActions.length; ++i) {
                this.methodActions[i].setEnabled(flag);
            }
        }
        if (this.typeActions != null) {
            for (i = 0; i < this.typeActions.length; ++i) {
                this.typeActions[i].setEnabled(flag);
            }
        }
    }

    private void init() throws Exception {
        this.methodActions = HRQualClientUtils.addButtonsToMutilTable(this.contMethodEntry, this.kdtMethodEntry, new MethodEntryHandler());
        this.typeActions = HRQualClientUtils.addButtonsToMutilTable(this.contQualTypeEntry, this.kdtQualTypeEntry, new QualTypeEntryHandler());
        this.kdtMethodEntry.getStyleAttributes().setLocked(true);
        this.kdtQualTypeEntry.getStyleAttributes().setLocked(true);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (QualificationsException ev) {
            if ("998".equals(ev.getSubCode())) {
                this.txtNumber.requestFocus(true);
            }
            if ("999".equals(ev.getSubCode())) {
                this.txtName.requestFocus(true);
            }
            ExceptionHandler.handle((Throwable)((Object)ev));
        }
    }

    class QualTypeEntryHandler
    implements TableActionHandler {
        QualTypeEntryHandler() {
        }

        public IRow AddLine(KDTable table) {
            this.addLineByTypeF7(table, false);
            return null;
        }

        public IRow InsertLine(KDTable table) {
            this.addLineByTypeF7(table, true);
            return null;
        }

        private void showF7() {
            Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
            if (ownerWindow instanceof Frame) {
                IdentifySchemeEditUI.this.typeF7 = new QualTypePromptBox((Frame)ownerWindow);
            } else if (ownerWindow instanceof Dialog) {
                IdentifySchemeEditUI.this.typeF7 = new QualTypePromptBox((Dialog)ownerWindow);
            } else {
                IdentifySchemeEditUI.this.typeF7 = new QualTypePromptBox((Frame)null);
            }
            IdentifySchemeEditUI.this.typeF7.setModal(true);
            IdentifySchemeEditUI.this.typeF7.setIsSingleSelect(false);
            IdentifySchemeEditUI.this.typeF7.show();
        }

        private void addLineByTypeF7(KDTable entrys, boolean isInsert) {
            this.showF7();
            if (!IdentifySchemeEditUI.this.typeF7.isCanceled()) {
                ArrayList<QualTypeInfo> types = new ArrayList<QualTypeInfo>();
                if (IdentifySchemeEditUI.this.typeF7.getData() instanceof Object[]) {
                    Object[] obj = (Object[])IdentifySchemeEditUI.this.typeF7.getData();
                    if (obj == null || obj.length <= 0) {
                        return;
                    }
                    int size = obj.length;
                    for (int i = 0; i < size; ++i) {
                        types.add((QualTypeInfo)obj[i]);
                    }
                }
                if (IdentifySchemeEditUI.this.typeF7.getData() instanceof QualTypeInfo) {
                    types.add((QualTypeInfo)IdentifySchemeEditUI.this.typeF7.getData());
                }
                this.addLineByTypeList(entrys, types, isInsert);
            }
        }

        private void addLineByTypeList(KDTable entrys, List types, boolean isInsert) {
            Object methodId = null;
            if (types != null) {
                boolean isSelect = false;
                int top = 0;
                boolean isTableColumnSelected = false;
                if (isInsert && entrys.getSelectManager().size() > 0) {
                    isSelect = true;
                    top = entrys.getSelectManager().get().getTop();
                    isTableColumnSelected = this.isTableColumnSelected(entrys);
                }
                IRow row = null;
                int size = types.size();
                for (int i = 0; i < size; ++i) {
                    if (isInsert) {
                        if (isSelect && !isTableColumnSelected && top + i >= 0) {
                            row = entrys.addRow(top + i);
                        }
                    } else {
                        row = entrys.addRow();
                    }
                    this.addLineByType(entrys, row, (QualTypeInfo)types.get(i));
                }
            }
        }

        private boolean isTableColumnSelected(KDTable table) {
            KDTSelectBlock block;
            return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
        }

        private void addLineByType(KDTable entrys, IRow row, QualTypeInfo qTypeInfo) {
            if (entrys == null) {
                return;
            }
            if (row == null) {
                row = entrys.addRow();
            }
            IObjectValue detailData = this.createNewDetailData(qTypeInfo);
            IdentifySchemeEditUI.this.getUILifeCycleHandler().fireOnAddNewLine((Object)entrys, detailData);
            IdentifySchemeEditUI.this.dataBinder.loadLineFields(entrys, row, detailData);
            IdentifySchemeEditUI.this.getUILifeCycleHandler().fireOnAddNewLine(entrys, row.getRowIndex());
        }

        private IObjectValue createNewDetailData(QualTypeInfo qTypeInfo) {
            QualTypeEntryInfo qualTypeEntryInfo = new QualTypeEntryInfo();
            qualTypeEntryInfo.setQualType(qTypeInfo);
            IdentifySchemeEditUI.this.editData.getQualTypeEntry().add(qualTypeEntryInfo);
            return qualTypeEntryInfo;
        }
    }

    class MethodEntryHandler
    implements TableActionHandler {
        MethodEntryHandler() {
        }

        public IRow AddLine(KDTable table) {
            this.checkKdtQualTypeEntryIsSingle();
            this.addLineByMethodF7(table, false);
            return null;
        }

        public IRow InsertLine(KDTable table) {
            this.checkKdtQualTypeEntryIsSingle();
            this.addLineByMethodF7(table, true);
            return null;
        }

        private void showF7() {
            if (IdentifySchemeEditUI.this.prmtMethod.getSelector() == null) {
                IdentifySchemeEditUI.this.prmtMethod.setDataBySelector();
            } else {
                IdentifySchemeEditUI.this.prmtMethod.getSelector().show();
            }
        }

        private void addLineByMethodF7(KDTable entrys, boolean isInsert) {
            this.showF7();
            if (!IdentifySchemeEditUI.this.prmtMethod.getSelector().isCanceled()) {
                ArrayList<IdentifyMethodInfo> methods = new ArrayList<IdentifyMethodInfo>();
                if (IdentifySchemeEditUI.this.prmtMethod.getSelector().getData() instanceof Object[]) {
                    Object[] obj = (Object[])IdentifySchemeEditUI.this.prmtMethod.getSelector().getData();
                    if (obj == null || obj.length <= 0) {
                        return;
                    }
                    int size = obj.length;
                    for (int i = 0; i < size; ++i) {
                        methods.add((IdentifyMethodInfo)obj[i]);
                    }
                }
                if (IdentifySchemeEditUI.this.prmtMethod.getSelector().getData() instanceof IdentifyMethodInfo) {
                    methods.add((IdentifyMethodInfo)IdentifySchemeEditUI.this.prmtMethod.getSelector().getData());
                }
                this.addLineByMethodList(entrys, methods, isInsert);
            }
        }

        private void addLineByMethodList(KDTable entrys, List methods, boolean isInsert) {
            if (methods != null) {
                boolean isSelect = false;
                int top = 0;
                boolean isTableColumnSelected = false;
                if (isInsert && entrys.getSelectManager().size() > 0) {
                    isSelect = true;
                    top = entrys.getSelectManager().get().getTop();
                    isTableColumnSelected = this.isTableColumnSelected(entrys);
                }
                IRow row = null;
                int size = methods.size();
                for (int i = 0; i < size; ++i) {
                    if (isInsert) {
                        if (isSelect && !isTableColumnSelected && top + i >= 0) {
                            row = entrys.addRow(top + i);
                        }
                    } else {
                        row = entrys.addRow();
                    }
                    this.addLineByMethod(entrys, row, (IdentifyMethodInfo)methods.get(i));
                }
            }
        }

        private final boolean isTableColumnSelected(KDTable table) {
            KDTSelectBlock block;
            return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
        }

        private void addLineByMethod(KDTable entrys, IRow row, IdentifyMethodInfo iMethodInfo) {
            if (entrys == null) {
                return;
            }
            if (row == null) {
                row = entrys.addRow();
            }
            IObjectValue detailData = this.createNewDetailData(iMethodInfo);
            IdentifySchemeEditUI.this.getUILifeCycleHandler().fireOnAddNewLine((Object)entrys, detailData);
            IdentifySchemeEditUI.this.dataBinder.loadLineFields(entrys, row, detailData);
            IdentifySchemeEditUI.this.getUILifeCycleHandler().fireOnAddNewLine(entrys, row.getRowIndex());
        }

        private IObjectValue createNewDetailData(IdentifyMethodInfo iMethodInfo) {
            MethodEntryInfo methodEntryInfo = new MethodEntryInfo();
            methodEntryInfo.setIdentifyMethod(iMethodInfo);
            if (IdentifySchemeEditUI.this.editData.getQualTypeEntry().get(IdentifySchemeEditUI.this.selQualTypeRow) != null) {
                IdentifySchemeEditUI.this.editData.getQualTypeEntry().get(IdentifySchemeEditUI.this.selQualTypeRow).getMethodEntry().add(methodEntryInfo);
            }
            return methodEntryInfo;
        }

        private void checkKdtQualTypeEntryIsSingle() {
            int[] rowID = KDTableUtil.getSelectedRows((KDTable)IdentifySchemeEditUI.this.kdtQualTypeEntry);
            if (rowID != null && rowID.length == 1 && rowID[0] >= 0) {
                IdentifySchemeEditUI.this.selQualTypeRow = rowID[0];
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)IdentifySchemeEditUI.STRRES, (String)"Select_Single"));
                SysUtil.abort();
            }
        }
    }
}

