/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.qualifications.IQualStandardSystem;
import com.kingdee.eas.hr.qualifications.QualStandardSystemEntryCollection;
import com.kingdee.eas.hr.qualifications.QualStandardSystemEnum;
import com.kingdee.eas.hr.qualifications.QualStandardSystemFactory;
import com.kingdee.eas.hr.qualifications.QualStandardSystemInfo;
import com.kingdee.eas.hr.qualifications.QualStandardWeightCollection;
import com.kingdee.eas.hr.qualifications.QualStandardWeightEntryCollection;
import com.kingdee.eas.hr.qualifications.QualStandardWeightEntryFactory;
import com.kingdee.eas.hr.qualifications.QualStandardWeightEntryInfo;
import com.kingdee.eas.hr.qualifications.QualTypeSortFactory;
import com.kingdee.eas.hr.qualifications.ScoringRulesCollection;
import com.kingdee.eas.hr.qualifications.ScoringRulesFactory;
import com.kingdee.eas.hr.qualifications.ScoringRulesInfo;
import com.kingdee.eas.hr.qualifications.client.AbstractQualStandardSystemMainListUI;
import com.kingdee.eas.hr.qualifications.client.QualStandardSystemEditUI;
import com.kingdee.eas.hr.qualifications.client.QualStandardSystemPrintProvider;
import com.kingdee.eas.hr.qualifications.client.QualTypeSortEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class QualStandardSystemMainListUI
extends AbstractQualStandardSystemMainListUI {
    private static final Logger logger = CoreUIObject.getLogger(QualStandardSystemMainListUI.class);
    private static String res = "com.kingdee.eas.hr.qualifications.QualificationsResource";
    private static final String CONTROLTYPE_S1 = "S1";
    private static final String CONTROLTYPE_S2 = "S2";
    private static final String CONTROLTYPE_S3 = "S3";
    private static final String CONTROLTYPE_S4 = "S4";
    private static final String CONTROLTYPE_I = "I";
    private static final String ACTION_ADDNEW = "ACTION_ADDNEW";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_MODIFY = "ACTION_MODIFY";
    private static final String ACTION_MOVEDATA = "ACTION_MOVEDATA";
    private static final String ACTION_ADDNEW_TREE = "ACTION_ADDNEW_TREE";
    private static final String ACTION_DELETE_TREE = "ACTION_DELETE_TREE";
    private static final String ACTION_MODIFY_TREE = "ACTION_MODIFY_TREE";
    private static final String ACTION_MOVE_TREE = "ACTION_MOVE_TREE";

    protected String getGroupEditUIName() {
        return QualTypeSortEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "type.id";
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return new ObjectUuidPK(this.getSelectedNodeKeyValue());
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return QualTypeSortFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String ID = this.tblMain.getRow(rows[0]).getCell("id").getValue().toString();
        String levelID = this.tblMain.getRow(rows[0]).getCell("level.id").getValue().toString();
        String typeID = this.tblMain.getRow(rows[0]).getCell("type.id").getValue().toString();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)ID));
        QualStandardSystemInfo qssInfo = (QualStandardSystemInfo)((IQualStandardSystem)this.getBizInterface()).getValue((IObjectPK)pk);
        if (QualStandardSystemEnum.ENABLE.equals((Object)qssInfo.getState())) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"CAN_NOT_ENABLE"));
            SysUtil.abort();
        } else {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                if (!this.tblMain.getRow(i).getCell("level.id").getValue().toString().equals(levelID) || !this.tblMain.getRow(i).getCell("state").getValue().toString().equals(QualStandardSystemEnum.ENABLE.toString()) || !this.tblMain.getRow(i).getCell("type.id").getValue().toString().equals(typeID) || this.tblMain.getRow(i).getCell("id").getValue().toString().equals(ID)) continue;
                MsgBox.showInfo((String)(this.tblMain.getRow(i).getCell("type.name").getValue().toString() + EASResource.getString((String)res, (String)"QUAL") + this.tblMain.getRow(i).getCell("level.name").getValue().toString() + EASResource.getString((String)res, (String)"CAN_NOT_REPEATE_ENABLE")));
                SysUtil.abort();
            }
            qssInfo.setState(QualStandardSystemEnum.ENABLE);
            ((IQualStandardSystem)this.getBizInterface()).setCancelCancel((IObjectPK)pk, qssInfo);
            this.actionRefresh_actionPerformed(e);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.isEnableScoringRules();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            String ID = this.tblMain.getRow(rows[0]).getCell("id").getValue().toString();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)ID));
            QualStandardSystemInfo qssInfo = (QualStandardSystemInfo)((IQualStandardSystem)this.getBizInterface()).getValue((IObjectPK)pk);
            if (QualStandardSystemEnum.DISABLE.equals((Object)qssInfo.getState())) {
                MsgBox.showInfo((String)EASResource.getString((String)res, (String)"CAN_NOT_DISABLE"));
                SysUtil.abort();
            } else if (QualStandardSystemEnum.NO_ENABLE.equals((Object)qssInfo.getState())) {
                MsgBox.showInfo((String)EASResource.getString((String)res, (String)"NO_ENABLE"));
                SysUtil.abort();
            } else {
                qssInfo.setState(QualStandardSystemEnum.DISABLE);
                ((IQualStandardSystem)this.getBizInterface()).setCancel((IObjectPK)pk, qssInfo);
                this.actionRefresh_actionPerformed(e);
            }
        }
    }

    protected void initTree() throws Exception {
        super.initTree();
        if (((KDTreeNode)this.treeMain.getModel().getRoot()).getChildCount() != 0) {
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)((KDTreeNode)((KDTreeNode)this.treeMain.getModel().getRoot()).getChildAt(0)));
        }
    }

    protected String getRootName() {
        return EASResource.getString((String)res, (String)"QualType");
    }

    protected String getEditUIName() {
        return QualStandardSystemEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QualStandardSystemFactory.getRemoteInstance();
    }

    private void setmerge() {
        String[] mergeColumnKeys = this.getmerge();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    private String[] getmerge() {
        String[] columns = new String[]{"number", "type.name", "level.name", "versionNumber", "createTime", "creator.name", "state", "explan"};
        return columns;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setmerge();
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.tblMain.removeRows();
        this.chkIncludeChild.setVisible(false);
        this.btnGroupMoveTree.setVisible(false);
        this.btnMoveTree.setVisible(false);
        this.treeView.getControlPane().remove((Component)this.btnGroupMoveTree);
        this.treeView.getControlPane().remove((Component)this.btnMoveTree);
        this.pnlMain.setDividerLocation(240);
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.btnTPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemTPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode == null) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"SELECT_TREE_ROOT"));
            SysUtil.abort();
        }
        if (treeNode.isRoot()) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"CHOOSE_QUALTYPE_1"));
            SysUtil.abort();
        }
        if (treeNode.getChildCount() <= 0) {
            super.actionAddNew_actionPerformed(e);
            return;
        }
        MsgBox.showInfo((String)EASResource.getString((String)res, (String)"CAN_NOT_ADD_QUALSTANDARDSYSTEM"));
        SysUtil.abort();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getChildCount() > 0) {
            uiContext.put((Object)"isCannotCopyAddNew", (Object)"true");
        }
        super.prepareUIContext(uiContext, e);
    }

    public void removeSigle(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (this.tblMain.getRow(rows[0]).getCell("state").getValue().toString().equals(QualStandardSystemEnum.ENABLE.toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"CAN_NOT_DELETE"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int[] enable = new int[rows.length];
        if (rows.length == 1) {
            this.removeSigle(e);
        } else {
            int size = rows.length;
            boolean canDeleteAll = true;
            String deleteMsg = EASResource.getString((String)res, (String)"DELETE_MULTI_BEGIN") + rows.length + EASResource.getString((String)res, (String)"DELETE_NULTI_END");
            if (this.confirmDialog(deleteMsg)) {
                for (int i = 0; i < size; ++i) {
                    if (!this.tblMain.getRow(rows[i]).getCell("state").getValue().toString().equals(QualStandardSystemEnum.ENABLE.toString())) continue;
                    canDeleteAll = false;
                    enable[i] = 1;
                }
                for (int k = 0; k < size; ++k) {
                    if (enable[k] != 1) continue;
                    this.tblMain.removeRow(k);
                    --size;
                    --k;
                }
                this.checkPermission(ACTION_DELETE);
                super.Remove();
                this.refresh(e);
            }
            if (!canDeleteAll) {
                StringBuffer number = new StringBuffer();
                for (int j = 0; j < enable.length; ++j) {
                    if (enable[j] != 1) continue;
                    number.append(",").append(j + 1);
                }
                String temp = number.substring(1, number.length());
                String canNotDeleteMsg = EASResource.getString((String)res, (String)"Di");
                canNotDeleteMsg = canNotDeleteMsg.concat(temp);
                canNotDeleteMsg = canNotDeleteMsg.concat(EASResource.getString((String)res, (String)"Hang"));
                canNotDeleteMsg = canNotDeleteMsg.concat(EASResource.getString((String)res, (String)"IS_ENABLE"));
                String deleteError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteError");
                MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)canNotDeleteMsg, (int)8188);
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (this.tblMain.getRow(rows[0]).getCell("state").getValue().toString().equals(QualStandardSystemEnum.ENABLE.toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"CAN_NOT_EDIT"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionTPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTPrint_actionPerformed(e);
        ArrayList leaveBillIds = this.getEntryIds();
        QualStandardSystemPrintProvider qsProvider = new QualStandardSystemPrintProvider();
        qsProvider.executeActionPrint(leaveBillIds, (Component)((Object)this));
    }

    private ArrayList getEntryIds() {
        this.checkSelected();
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null || row.getCell("id") == null) continue;
            arrayList.add(row.getCell("id").getValue().toString());
        }
        return arrayList;
    }

    protected String getGroupEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        this.refreshList();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        String nexts = null;
        String msg = null;
        Object[] objs = null;
        msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_0");
        objs = new Object[]{this.tblMain.getRowCount3()};
        nexts = MessageFormat.format(msg, objs);
        this.setMessageBarText(nexts);
    }

    private void checkPermission(String action) throws Exception {
        if (this.getControlType().equalsIgnoreCase(CONTROLTYPE_S1)) {
            if (!this.getCurrentCUID().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                this.throwsExceptionForNoPermission(action);
            }
        } else if ((this.getControlType().equalsIgnoreCase(CONTROLTYPE_S3) || this.getControlType().equalsIgnoreCase(CONTROLTYPE_S4)) && !action.equals(ACTION_ADDNEW) && !this.getCurrentCUID().equals(this.getCUIDFromBizobject())) {
            this.throwsExceptionForNoPermission(action);
        }
    }

    private void throwsExceptionForNoPermission(String action) throws Exception {
        if (action.equals(ACTION_ADDNEW)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
        if (action.equals(ACTION_DELETE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        if (action.equals(ACTION_MODIFY)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
        if (action.equals(ACTION_MOVEDATA)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
        if (action.equals(ACTION_ADDNEW_TREE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADDTREE);
        }
        if (action.equals(ACTION_DELETE_TREE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_REMOVETREE);
        }
        if (action.equals(ACTION_MODIFY_TREE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_MODIFYTREE);
        }
        if (action.equals(ACTION_MOVE_TREE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_MOVETREE);
        }
    }

    private String getCUIDFromBizobject() throws Exception {
        this.checkSelected();
        return this.getICGF().getCUID(this.getSelectedKeyValue());
    }

    private ICUIDGetterFacade getICGF() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance();
    }

    protected void isEnableScoringRules() throws EASBizException, BOSException, Exception {
        this.checkSelected();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String ID = this.tblMain.getRow(rows[0]).getCell("id").getValue().toString();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)ID));
        QualStandardSystemInfo qssInfo = (QualStandardSystemInfo)((IQualStandardSystem)this.getBizInterface()).getValue((IObjectPK)pk);
        QualStandardSystemEntryCollection qssec = qssInfo.getEntry();
        String enable = "1";
        String sql = "select bill where state = '" + enable + "'";
        ScoringRulesCollection scoringRulesCollection = ScoringRulesFactory.getRemoteInstance().getScoringRulesCollection(sql);
        QualStandardWeightEntryCollection qswec = new QualStandardWeightEntryCollection();
        for (int sri = 0; sri < scoringRulesCollection.size(); ++sri) {
            int i;
            ScoringRulesInfo scoringRulesinfo = scoringRulesCollection.get(sri);
            QualStandardWeightCollection qualStandardWeightCollection = scoringRulesinfo.getQualStandardWeightEntry();
            if (qualStandardWeightCollection.size() > 0) {
                for (i = 0; i < qualStandardWeightCollection.size(); ++i) {
                    qswec.addCollection(qualStandardWeightCollection.get(i).getEntry());
                }
            }
            for (i = 0; i < qssec.size(); ++i) {
                for (int j = 0; j < qswec.size(); ++j) {
                    ObjectUuidPK qspk = new ObjectUuidPK(BOSUuid.read((String)qswec.get(j).getId().toString()));
                    QualStandardWeightEntryInfo qswqInfo = (QualStandardWeightEntryInfo)QualStandardWeightEntryFactory.getRemoteInstance().getValue((IObjectPK)qspk);
                    if (qswqInfo.getQualStandardSystemEntry() == null || !qssec.get(i).getId().toString().equals(qswqInfo.getQualStandardSystemEntry().getId().toString())) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)res, (String)"CAN_NOT_CANCEL_INUSE"));
                    SysUtil.abort();
                }
            }
        }
    }
}

