/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.qualifications.QualTypeFactory;
import com.kingdee.eas.hr.qualifications.QualTypeInfo;
import com.kingdee.eas.hr.qualifications.QualTypeSortInfo;
import com.kingdee.eas.hr.qualifications.QualificationsException;
import com.kingdee.eas.hr.qualifications.client.AbstractQualTypeEditUI;
import com.kingdee.eas.hr.qualifications.client.HRQualClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class QualTypeEditUI
extends AbstractQualTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(QualTypeEditUI.class);
    private static final String businessObject = "com.kingdee.eas.hr.qualifications.app.QualType";
    private String companyID = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuBar.setVisible(true);
        this.prmtLevel.setQueryInfo("com.kingdee.eas.hr.qualifications.app.QualLevelQuery");
        this.prmtLevel.setDisplayFormat("$name$");
        this.prmtLevel.setEditFormat("$number$");
        this.prmtLevel.setCommitFormat("$number$");
        super.initUIMenuBarLayout();
    }

    protected IObjectValue createNewData() {
        HROrgUnitInfo hroInfo = SysContext.getSysContext().getCurrentHRUnit();
        QualTypeInfo qualInfo = new QualTypeInfo();
        if ("ADDNEW".equals(this.getOprtState())) {
            qualInfo.setSort((QualTypeSortInfo)this.getUIContext().get("ParentNode"));
            qualInfo.setHrOrgUnit(hroInfo);
        }
        return qualInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QualTypeFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (!HRQualClientUtils.isExistCodingRule(businessObject, this.companyID, null)) {
            HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        }
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.prmtLevel);
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        QualTypeInfo editData = this.editData;
        super.removeByPK(pk);
        this.recycleNumberByOrg((IObjectValue)editData, "ControlUnit", editData.getString("number"));
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)number)) {
            try {
                String companyID = null;
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty(companyID) && iCodingRuleManager.isExist(editData, companyID) && iCodingRuleManager.isUseIntermitNumber(editData, companyID)) {
                    iCodingRuleManager.recycleNumber(editData, companyID, number);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void setAutoNumberByOrg(String orgType) {
        if (this.editData == null) {
            return;
        }
        if (this.editData.getNumber() == null) {
            try {
                String companyID = null;
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                    if (iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                        this.editData.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
                    }
                    this.txtNumber.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                this.oldData = this.editData;
                SysUtil.abort();
            }
        } else if (this.editData.getNumber().trim().length() > 0) {
            this.txtNumber.setText(this.editData.getNumber());
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"ControlUnit");
    }

    public void loadFields() {
        this.setAutoNumberByOrg("ControlUnit");
        this.dataBinder.loadFields();
    }

    public void setDataObject(IObjectValue dataObject) {
        if (this.editData != null && "ADDNEW".equals(this.getOprtState())) {
            this.editData.setNumber(null);
        }
        super.setDataObject(dataObject);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (QualificationsException ev) {
            if ("998".equals(ev.getSubCode())) {
                this.txtNumber.requestFocus(true);
            }
            if ("999".equals(ev.getSubCode())) {
                this.txtName.requestFocus(true);
            }
            if ("032".equals(ev.getSubCode())) {
                this.prmtLevel.requestFocus(true);
            }
            ExceptionHandler.handle((Throwable)((Object)ev));
        }
    }
}

