/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.qualifications.IQualType;
import com.kingdee.eas.hr.qualifications.QualStandardSystemEnum;
import com.kingdee.eas.hr.qualifications.QualTypeCollection;
import com.kingdee.eas.hr.qualifications.QualTypeFactory;
import com.kingdee.eas.hr.qualifications.QualTypeSortInfo;
import com.kingdee.eas.hr.qualifications.ScoringRulesFactory;
import com.kingdee.eas.hr.qualifications.ScoringRulesInfo;
import com.kingdee.eas.hr.qualifications.client.AbstractScoringRulesEditUI;
import com.kingdee.eas.hr.qualifications.client.HRQualClientUtils;
import com.kingdee.eas.hr.qualifications.client.IdentifyMethodWeightUI;
import com.kingdee.eas.hr.qualifications.client.QualStandardWeightUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ScoringRulesEditUI
extends AbstractScoringRulesEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ScoringRulesEditUI.class);
    KDFormattedTextField qualText;
    KDFormattedTextField identifyText;
    KDFormattedTextField weight;
    private static String res = "com.kingdee.eas.hr.qualifications.QualificationsResource";

    protected IObjectValue createNewData() {
        ScoringRulesInfo srInfo = new ScoringRulesInfo();
        if ("ADDNEW".equals(this.getOprtState())) {
            srInfo.setState(QualStandardSystemEnum.NO_ENABLE);
            QualTypeSortInfo info = new QualTypeSortInfo();
            info.setId(((QualTypeSortInfo)this.getUIContext().get("ParentNode")).getId());
            info.setName(((QualTypeSortInfo)this.getUIContext().get("ParentNode")).getName());
            srInfo.setType(info);
        }
        this.kdtEntry.removeRows();
        return srInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ScoringRulesFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.initTable();
        this.btnQualStandardWeight.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnIdentifyMethodWeight.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.menuItemCommQualStandard.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.menuItemIdentify.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        super.onLoad();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
    }

    private void initTable() {
        this.kdtEntry.checkParsed();
        this.qualText = new KDFormattedTextField();
        this.qualText.setDataType(1);
        this.qualText.setPrecision(2);
        this.qualText.setMaximumValue((Comparable)new BigDecimal(9.999999999E7));
        this.qualText.setMinimumValue((Comparable)new BigDecimal(0.0));
        this.qualText.setDataVerifierType(12);
        this.qualText.setSupportedEmpty(true);
        KDTDefaultCellEditor qualText_Editor = new KDTDefaultCellEditor((JTextField)this.qualText);
        this.identifyText = new KDFormattedTextField();
        this.identifyText.setDataType(1);
        this.identifyText.setPrecision(2);
        this.identifyText.setMaximumValue((Comparable)new BigDecimal(9.999999999E7));
        this.identifyText.setMinimumValue((Comparable)new BigDecimal(0.0));
        this.identifyText.setDataVerifierType(12);
        this.identifyText.setSupportedEmpty(true);
        KDTDefaultCellEditor identifyText_Editor = new KDTDefaultCellEditor((JTextField)this.identifyText);
        this.weight = new KDFormattedTextField();
        this.weight.setDataType(1);
        this.weight.setPrecision(2);
        this.weight.setMaximumValue((Comparable)new BigDecimal(9.999999999E7));
        this.weight.setMinimumValue((Comparable)new BigDecimal(0.0));
        this.weight.setDataVerifierType(12);
        KDTDefaultCellEditor weight_Editor = new KDTDefaultCellEditor((JTextField)this.weight);
        this.kdtEntry.getColumn("qualStandardWeight").setEditor((ICellEditor)qualText_Editor);
        this.kdtEntry.getColumn("identifyMethodWeight").setEditor((ICellEditor)identifyText_Editor);
        this.kdtEntry.getColumn("totalPercentage").setEditor((ICellEditor)weight_Editor);
    }

    public void loadFields() {
        this.kdtEntry.checkParsed();
        this.kdtEntry.removeRows();
        super.loadFields();
        this.setAutoNumberByOrg("ControlUnit");
        if (this.getOprtState().equals("ADDNEW")) {
            try {
                this.loadTableData();
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.txtType.setText(this.prmtType.getValue().toString());
    }

    private void loadTableData() throws BOSException {
        BOSUuid ID = ((QualTypeSortInfo)this.getUIContext().get("ParentNode")).getId();
        Date date = new Date();
        this.pkCreateTime.setValue((Object)date);
        this.pkCommencement.setValue((Object)date);
        IQualType iQualType = QualTypeFactory.getRemoteInstance();
        QualTypeCollection qtColl = null;
        qtColl = iQualType.getQualTypeCollection("select id,number,sort.id,level.id,level.name where sort.id='" + ID + "' ORDER BY level.number ASC");
        if (qtColl == null) {
            return;
        }
        for (int i = 0; i < qtColl.size(); ++i) {
            IRow row = null;
            row = this.kdtEntry.addRow();
            row.getCell("level").setValue((Object)qtColl.get(i).getLevel().getName());
            row.getCell("level.number").setValue((Object)qtColl.get(i).getLevel().getNumber());
        }
    }

    protected void kdtEntry_editStopped(KDTEditEvent e) throws Exception {
        super.kdtEntry_editStopped(e);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntry);
        for (int i = 0; i < rows.length; ++i) {
            float qual = 0.0f;
            float identify = 0.0f;
            if (this.kdtEntry.getRow(rows[i]).getCell("qualStandardWeight").getValue() != null && !this.kdtEntry.getRow(rows[i]).getCell("qualStandardWeight").getValue().equals("")) {
                qual = Float.parseFloat(this.kdtEntry.getRow(rows[i]).getCell("qualStandardWeight").getValue().toString());
            }
            if (this.kdtEntry.getRow(rows[i]).getCell("identifyMethodWeight").getValue() != null && !this.kdtEntry.getRow(rows[i]).getCell("identifyMethodWeight").getValue().equals("")) {
                identify = Float.parseFloat(this.kdtEntry.getRow(rows[i]).getCell("identifyMethodWeight").getValue().toString());
            }
            Float sum = new Float(qual + identify);
            NumberFormat formatter = NumberFormat.getNumberInstance();
            formatter.setMinimumFractionDigits(2);
            this.kdtEntry.getRow(rows[i]).getCell("totalPercentage").setValue((Object)formatter.format(sum));
        }
    }

    protected void kdtEntry_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void menuItemCommQualStandard_actionPerformed(ActionEvent e) throws Exception {
        this.btnQualStandardWeight_actionPerformed(e);
    }

    protected void btnQualStandardWeight_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"SAVE_FIRST"));
            SysUtil.abort();
        } else if (this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"SAVE_FIRST"));
            SysUtil.abort();
        }
        if (this.kdtEntry.getRowCount() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"CAN_NOT_SET_WEIGHT"));
            SysUtil.abort();
        }
        this.getUIContext().clear();
        this.getUIContext().put("ID", this.editData.getId().toString());
        this.getUIContext().put("TYPE.NAME", this.editData.getType().getName().toString());
        this.getUIContext().put("TYPE.ID", this.editData.getType().getId().toString());
        this.getUIContext().put("NUMBER", this.editData.getNumber());
        this.getUIContext().put("OprtState", this.getOprtState());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QualStandardWeightUI.class.getName(), this.getUIContext(), null, this.getOprtState());
        uiWindow.show();
        super.onLoad();
    }

    protected void menuItemIdentify_actionPerformed(ActionEvent e) throws Exception {
        this.btnIdentifyMethodWeight_actionPerformed(e);
    }

    protected void btnIdentifyMethodWeight_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"SAVE_FIRST"));
            SysUtil.abort();
        } else if (!this.editData.compareNewToOld()) {
            SysUtil.abort();
        }
        if (this.kdtEntry.getRowCount() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"CAN_NOT_SET_WEIGHT"));
            SysUtil.abort();
        }
        this.getUIContext().clear();
        this.getUIContext().put("ID", this.editData.getId().toString());
        this.getUIContext().put("TYPE.NAME", this.editData.getType().getName().toString());
        this.getUIContext().put("TYPE.ID", this.editData.getType().getId().toString());
        this.getUIContext().put("NUMBER", this.editData.getNumber());
        this.getUIContext().put("OprtState", this.getOprtState());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IdentifyMethodWeightUI.class.getName(), this.getUIContext(), null, this.getOprtState());
        uiWindow.show();
        super.onLoad();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        if (this.editData.getCommencement() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"DATE_CAN_NULL"));
            SysUtil.abort();
        }
        if (this.kdtEntry.getRowCount() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"QualStandardWeight_Can_Not_Null"));
            SysUtil.abort();
        }
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            if (this.kdtEntry.getRow(i).getCell("qualStandardWeight").getValue() == null) {
                MsgBox.showInfo((String)(EASResource.getString((String)res, (String)"Di") + (i + 1) + EASResource.getString((String)res, (String)"COMM_WEIGHT")));
                SysUtil.abort();
            }
            if (this.kdtEntry.getRow(i).getCell("identifyMethodWeight").getValue() == null) {
                MsgBox.showInfo((String)(EASResource.getString((String)res, (String)"Di") + (i + 1) + EASResource.getString((String)res, (String)"IDENTIFY_WEIGHT")));
                SysUtil.abort();
            }
            if (this.kdtEntry.getRow(i).getCell("totalPercentage").getValue().toString().equals("100.00")) continue;
            MsgBox.showInfo((String)(EASResource.getString((String)res, (String)"Di") + (i + 1) + EASResource.getString((String)res, (String)"Hang") + EASResource.getString((String)res, (String)"NOT_HUNDERS")));
            SysUtil.abort();
        }
        super.verifyInput(e);
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        ScoringRulesInfo editData = this.editData;
        super.removeByPK(pk);
        this.recycleNumberByOrg((IObjectValue)editData, "ControlUnit", editData.getString("number"));
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)number)) {
            try {
                String companyID = null;
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty(companyID) && iCodingRuleManager.isExist(editData, companyID) && iCodingRuleManager.isUseIntermitNumber(editData, companyID)) {
                    iCodingRuleManager.recycleNumber(editData, companyID, number);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void setAutoNumberByOrg(String orgType) {
        if (this.editData == null) {
            return;
        }
        if (this.editData.getNumber() == null) {
            try {
                String companyID = null;
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                    if (iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                        this.txtNumber.setText(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
                    }
                    this.txtNumber.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                this.oldData = this.editData;
                SysUtil.abort();
            }
        } else if (this.editData.getNumber().trim().length() > 0) {
            this.txtNumber.setText(this.editData.getNumber());
        }
    }
}

