/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.util.MailUtil;
import com.kingdee.eas.hr.qualifications.client.AbstractSendMailUI;
import com.kingdee.eas.hr.qualifications.client.HRQualClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class SendMailUI
extends AbstractSendMailUI {
    private static final Logger logger = CoreUIObject.getLogger(SendMailUI.class);
    private static final String RES = "com.kingdee.eas.hr.qualifications.QualificationsResource";

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
    }

    private void init() throws Exception {
        List selectAppIds = (List)this.getUIContext().get("selectAppIds");
        this.txtTo.setText(this.getMailStr(selectAppIds));
        this.txtTo.setEditable(false);
        this.txtSubject.setText(this.createDefaultMessage(selectAppIds, false));
    }

    private String getMailStr(List appList) throws BOSException, SQLException {
        StringBuffer mailStr = new StringBuffer();
        HashSet idSet = new HashSet();
        for (int i = 0; i < appList.size(); ++i) {
            idSet.add(appList.get(i));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IRowSet dataRows = this.query(view, "com.kingdee.eas.hr.qualifications.app", "PersonMailInCerAppQuery");
        String name = null;
        String email = null;
        if (dataRows != null) {
            while (dataRows.next()) {
                name = dataRows.getString("person.name");
                if (name != null && name.trim().length() > 0) {
                    mailStr.append(name);
                } else {
                    mailStr.append(" ");
                }
                mailStr.append("(");
                email = dataRows.getString("person.email");
                if (email != null && email.trim().length() > 0) {
                    mailStr.append(email);
                } else {
                    mailStr.append(" ");
                }
                mailStr.append(");");
            }
        }
        return mailStr.toString();
    }

    private IRowSet query(EntityViewInfo view, String queryPath, String queryName) throws BOSException {
        if (queryPath == null || queryPath.trim().equals("")) {
            return null;
        }
        if (queryName == null || queryName.trim().equals("")) {
            return null;
        }
        IRowSet dataRows = null;
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(queryPath, queryName));
        iqec.setObjectView(view);
        dataRows = iqec.executeQuery();
        return dataRows;
    }

    public void initWorkButton() {
        this.send.setIcon(EASResource.getIcon((String)"imgTbtn_deliverto"));
    }

    public void sendAction_actionPerformed(ActionEvent e) throws Exception {
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.txtTo);
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.txtSubject);
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, RES, this.mailContent, "mail_content_null");
        ArrayList<String> mailList = new ArrayList<String>();
        String mailStr = this.txtTo.getText();
        String[] arr = mailStr.split(";");
        StringBuffer to = new StringBuffer();
        String name = null;
        String mailAddr = null;
        for (int i = 0; i < arr.length; ++i) {
            String str = arr[i];
            int sIndex = str.indexOf("(");
            int eIndex = str.indexOf(")");
            if (sIndex >= 0 && eIndex >= 0) {
                name = str.substring(0, str.indexOf("("));
                mailAddr = str.substring(str.indexOf("(") + 1, str.indexOf(")"));
            }
            if (mailAddr == null || "".equals(mailAddr.trim())) {
                String s = EASResource.getString((String)RES, (String)"mailAddr_is_null");
                s = MessageFormat.format(s, name);
                MsgBox.showInfo((Component)((Object)this), (String)s);
                SysUtil.abort();
                continue;
            }
            mailList.add(mailAddr);
            if (to.length() > 0) {
                to.append(",");
            }
            to.append(mailAddr);
        }
        String content = this.mailContent.getStringValue();
        String subject = this.txtSubject.getStringValue();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        String from = userInfo.getPerson().getEmail();
        try {
            MailUtil mailUtil = MailUtil.getInstance();
            mailUtil.sendHtmlMail(from, to.toString(), subject, content);
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SENDMAIL_FAIL"), (Throwable)err);
            SysUtil.abort();
        }
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"SENDMAIL_SUCCESS"));
        super.actionExitCurrent_actionPerformed(null);
    }

    private String createDefaultMessage(List appList, boolean isAutoWrap) throws BOSException, SQLException {
        StringBuffer msg = new StringBuffer();
        HashSet idSet = new HashSet();
        for (int i = 0; i < appList.size(); ++i) {
            idSet.add(appList.get(i));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        String templeMsg = null;
        IRowSet dataRows = this.query(view, "com.kingdee.eas.hr.qualifications.app", "DefaultMailMsgInCerAppQuery");
        while (dataRows.next()) {
            templeMsg = EASResource.getString((String)RES, (String)"DEFAULT_MAIL_MSG");
            msg.append(MessageFormat.format(templeMsg, dataRows.getString("person.name"), dataRows.getString("sort.name"), dataRows.getString("level.name")));
            if (isAutoWrap) {
                msg.append("\n");
                continue;
            }
            msg.append(";");
        }
        return msg.toString();
    }
}

