/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.util.MailUtil;
import com.kingdee.eas.hr.qualifications.client.AbstractSendResultMailUI;
import com.kingdee.eas.hr.qualifications.client.HRQualClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SendResultMailUI
extends AbstractSendResultMailUI {
    private static final Logger logger = CoreUIObject.getLogger(SendResultMailUI.class);
    private static final String STRRES = "com.kingdee.eas.hr.qualifications.QualificationsResource";
    private HashSet personIdSet = null;

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
    }

    private void init() throws Exception {
        HashSet personIdSet = (HashSet)this.getUIContext().get("personId");
        this.txtTo.setText(this.getMailStr(personIdSet));
        this.txtTo.setEditable(false);
    }

    private String getMailStr(HashSet personIdSet) throws Exception {
        StringBuffer mailStr = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (personIdSet == null || personIdSet.size() <= 0) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)personIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IRowSet dataRows = this.query(view, "com.kingdee.eas.hr.qualifications.app", "SendResultPersonQuery");
        String name = null;
        String email = null;
        if (dataRows != null) {
            while (dataRows.next()) {
                name = dataRows.getString("name");
                if (name != null && name.trim().length() > 0) {
                    mailStr.append(name);
                } else {
                    mailStr.append(" ");
                }
                mailStr.append("(");
                email = dataRows.getString("email");
                if (email != null && email.trim().length() > 0) {
                    mailStr.append(email);
                } else {
                    mailStr.append(" ");
                }
                mailStr.append(");");
            }
        }
        return mailStr.toString();
    }

    private IRowSet query(EntityViewInfo view, String queryPath, String queryName) throws BOSException {
        if (queryPath == null || queryPath.trim().equals("")) {
            return null;
        }
        if (queryName == null || queryName.trim().equals("")) {
            return null;
        }
        IRowSet dataRows = null;
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(queryPath, queryName));
        iqec.setObjectView(view);
        dataRows = iqec.executeQuery();
        return dataRows;
    }

    public void sendAction_actionPerformed(ActionEvent e) throws Exception {
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.txtTo);
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, this.txtSubject);
        HRQualClientUtils.verifyEmpty((CoreUIObject)this, STRRES, this.mailContent, "mail_content_null");
        ArrayList<String> mailList = new ArrayList<String>();
        String mailStr = this.txtTo.getText();
        String[] arr = mailStr.split(";");
        StringBuffer sendTo = new StringBuffer();
        String name = null;
        String mailAddr = null;
        for (int i = 0; i < arr.length; ++i) {
            String str = arr[i];
            int sIndex = str.indexOf("(");
            int eIndex = str.indexOf(")");
            if (sIndex >= 0 && eIndex >= 0) {
                name = str.substring(0, str.indexOf("("));
                mailAddr = str.substring(str.indexOf("(") + 1, str.indexOf(")"));
            }
            if (mailAddr == null || "".equals(mailAddr.trim())) {
                String item = EASResource.getString((String)STRRES, (String)"mailAddr_is_null");
                item = MessageFormat.format(item, name);
                MsgBox.showInfo((Component)((Object)this), (String)item);
                SysUtil.abort();
                continue;
            }
            mailList.add(mailAddr);
            if (sendTo.length() > 0) {
                sendTo.append(",");
            }
            sendTo.append(mailAddr);
        }
        String content = this.mailContent.getStringValue();
        String subject = this.txtSubject.getStringValue();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        String from = userInfo.getPerson().getEmail();
        try {
            MailUtil mailUtil = MailUtil.getInstance();
            mailUtil.sendHtmlMail(from, sendTo.toString(), subject, content);
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)STRRES, (String)"SENDMAIL_FAIL"), (Throwable)err);
            SysUtil.abort();
        }
        MsgBox.showInfo((String)EASResource.getString((String)STRRES, (String)"SENDMAIL_SUCCESS"));
        super.sendAction_actionPerformed(e);
    }
}

