/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.IMailServerSet;
import com.kingdee.eas.hr.base.MailServerSetFactory;
import com.kingdee.eas.hr.base.MailServerSetInfo;
import com.kingdee.eas.hr.train.ByteArrayDataSource;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailForAttachUtil {
    private String from;
    private String to;
    private String cc;
    private String bcc;
    private String subject;
    private String body;
    private Context ctx = null;
    private static MailForAttachUtil mailUtil = null;

    private MailForAttachUtil() {
    }

    public static MailForAttachUtil getInstance(Context contex) {
        if (mailUtil == null) {
            mailUtil = new MailForAttachUtil();
        }
        MailForAttachUtil.mailUtil.ctx = contex;
        return mailUtil;
    }

    public static MailForAttachUtil getInstance() {
        if (mailUtil == null) {
            mailUtil = new MailForAttachUtil();
        }
        MailForAttachUtil.mailUtil.ctx = null;
        return mailUtil;
    }

    public MailServerSetInfo getMailServerInfo() throws BOSException, BaseException, EASBizException {
        IMailServerSet iMSS = null;
        String oql = null;
        if (this.ctx == null) {
            iMSS = MailServerSetFactory.getRemoteInstance();
            oql = "where CU='" + SysContext.getSysContext().getCurrentCtrlUnit().getId() + "'";
        } else {
            iMSS = MailServerSetFactory.getLocalInstance((Context)this.ctx);
            oql = "where CU='" + ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId() + "'";
        }
        if (!iMSS.exists(oql)) {
            throw new BaseException(BaseException.SMTP_NOT_SET);
        }
        return iMSS.getMailServerSetInfo(oql);
    }

    public void sendMail(MailServerSetInfo mssInfo, String from, String to, String cc, String bcc, String subject, String body) throws Exception {
        Properties props = System.getProperties();
        props.put("mail.smtp.host", mssInfo.getSmtpAddress());
        MyAuthenticator authen = null;
        String pass = null;
        if (mssInfo.isIsAuth()) {
            props.put("mail.smtp.auth", "true");
            pass = CryptoTean.decrypt((String)mssInfo.getBOSType().toString(), (String)mssInfo.getSmtpPass());
            authen = new MyAuthenticator(mssInfo.getSmtpUser(), pass);
        } else {
            props.put("mail.smtp.auth", "false");
        }
        Session mailSession = Session.getInstance((Properties)props, authen);
        MimeMessage mimeMsg = new MimeMessage(mailSession);
        mimeMsg.setFrom((Address)new InternetAddress(mssInfo.getAdminAddress()));
        if (!StringUtils.isEmpty((String)to)) {
            mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
        }
        if (cc != null) {
            mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
        }
        if (bcc != null) {
            mimeMsg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc));
        }
        mimeMsg.setSubject(subject, "GBK");
        mimeMsg.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(body, "text/html;charset=GBK")));
        if (mimeMsg.getAllRecipients() != null && mimeMsg.getAllRecipients().length > 0) {
            if (mssInfo.isIsAuth()) {
                Transport transport = mailSession.getTransport("smtp");
                transport.connect(mssInfo.getSmtpAddress(), mssInfo.getSmtpUser(), pass);
                transport.sendMessage((Message)mimeMsg, mimeMsg.getAllRecipients());
                transport.close();
            } else {
                Transport.send((Message)mimeMsg);
            }
        }
    }

    public void sendMail(MailServerSetInfo msInfo, String from, String to, String subject, String body) throws Exception {
        this.sendMail(msInfo, from, to, null, null, subject, body);
    }

    public void sendHtmlMail(String from, String to, String subject, String body) throws Exception {
        this.sendHtmlMail(from, to, null, null, subject, body);
    }

    public void sendHtmlMailForAct(String from, String to, String subject, String body, String bizID) throws Exception {
        this.sendHtmlMailForAct(from, to, null, null, subject, body, bizID);
    }

    public void sendHtmlMail(String from, String to, String cc, String subject, String body) throws Exception {
        this.sendHtmlMail(from, to, cc, null, subject, body);
    }

    public void sendHtmlMail(String from, String to, String cc, String bcc, String subject, String body) throws Exception {
        MailServerSetInfo msInfo = this.getMailServerInfo();
        this.sendMail(msInfo, from, to, cc, bcc, subject, body);
    }

    public void sendHtmlMailForAct(String from, String to, String cc, String bcc, String subject, String body, String bizID) throws Exception {
        int k;
        IMailServerSet iMSS = null;
        String oql = null;
        boolean flag = false;
        if (this.ctx == null) {
            iMSS = MailServerSetFactory.getRemoteInstance();
            oql = "where CU='" + SysContext.getSysContext().getCurrentCtrlUnit().getId() + "'";
        } else {
            iMSS = MailServerSetFactory.getLocalInstance((Context)this.ctx);
            oql = "where CU='" + ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId() + "'";
        }
        if (!iMSS.exists(oql)) {
            throw new BaseException(BaseException.SMTP_NOT_SET);
        }
        MailServerSetInfo mssInfo = iMSS.getMailServerSetInfo(oql);
        Properties props = System.getProperties();
        props.put("mail.smtp.host", mssInfo.getSmtpAddress());
        MyAuthenticator authen = null;
        String pass = null;
        if (mssInfo.isIsAuth()) {
            props.put("mail.smtp.auth", "true");
            pass = CryptoTean.decrypt((String)mssInfo.getBOSType().toString(), (String)mssInfo.getSmtpPass());
            authen = new MyAuthenticator(mssInfo.getSmtpUser(), pass);
        } else {
            props.put("mail.smtp.auth", "false");
        }
        Session mailSession = Session.getDefaultInstance((Properties)props, authen);
        MimeMessage mimeMsg = new MimeMessage(mailSession);
        mimeMsg.setFrom((Address)new InternetAddress(mssInfo.getAdminAddress()));
        if (to != null) {
            mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
        }
        if (cc != null) {
            mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
        }
        if (bcc != null) {
            mimeMsg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc));
        }
        mimeMsg.setSubject(subject, "GBK");
        File file = null;
        MimeBodyPart mbp2 = null;
        FileDataSource fds = null;
        FileOutputStream out = null;
        MimeBodyPart mbp1 = new MimeBodyPart();
        mbp1.setContent((Object)body, "text/html;charset=GBK");
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)mbp1);
        BoAttchAssoInfo boInfo = null;
        BoAttchAssoCollection coll = new BoAttchAssoCollection();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("BoID", (Object)bizID, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("attachment.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("attachment.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("attachment.simpleName"));
        coll = BoAttchAssoFactory.getLocalInstance((Context)this.ctx).getBoAttchAssoCollection(viewInfo);
        byte[] bt = null;
        for (k = 0; k < coll.size(); ++k) {
            boInfo = new BoAttchAssoInfo();
            boInfo = coll.get(k);
            if (boInfo.getAttachment().getId() == null) continue;
            bt = AttachmentFtpFacadeFactory.getLocalInstance((Context)this.ctx).downloadFile(boInfo.getAttachment().getId().toString(), 0L);
            file = new File(boInfo.getAttachment().getName() + "." + boInfo.getAttachment().getSimpleName());
            out = new FileOutputStream(file);
            out.write(bt);
            out.close();
            mbp2 = new MimeBodyPart();
            fds = new FileDataSource(file);
            mbp2.setDataHandler(new DataHandler((DataSource)fds));
            mbp2.setFileName(MimeUtility.encodeText((String)file.getName(), (String)"GBK", (String)"B"));
            mp.addBodyPart((BodyPart)mbp2);
        }
        mimeMsg.setContent((Multipart)mp);
        mimeMsg.setSentDate(new Date());
        if (mimeMsg.getAllRecipients() != null && mimeMsg.getAllRecipients().length > 0) {
            if (mssInfo.isIsAuth()) {
                Transport transport = mailSession.getTransport("smtp");
                transport.connect(mssInfo.getSmtpAddress(), mssInfo.getSmtpUser(), pass);
                transport.sendMessage((Message)mimeMsg, mimeMsg.getAllRecipients());
                transport.close();
            } else {
                Transport.send((Message)mimeMsg);
            }
        }
        for (k = 0; k < coll.size(); ++k) {
            boInfo = new BoAttchAssoInfo();
            boInfo = coll.get(k);
            if (boInfo.getAttachment().getId() == null) continue;
            bt = AttachmentFtpFacadeFactory.getLocalInstance((Context)this.ctx).downloadFile(boInfo.getAttachment().getId().toString(), 0L);
            file = new File(boInfo.getAttachment().getName() + "." + boInfo.getAttachment().getSimpleName());
            out = new FileOutputStream(file);
            out.write(bt);
            out.close();
            file.delete();
        }
    }

    class MyAuthenticator
    extends Authenticator {
        String user = null;
        String pass = null;

        public MyAuthenticator(String user, String pass) {
            this.user = user;
            this.pass = pass;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.pass);
        }
    }
}

