/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.util.UuidException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class TrainAssistant {
    private static final Logger logger = Logger.getLogger((String)TrainAssistant.class.getName());

    public static AdminOrgUnitInfo getUserOrgInfo(String personId, Context ctx) throws EASBizException, BOSException, UuidException {
        AdminOrgUnitInfo orgUnitInfo = null;
        if (!TrainCommonUtils.isEmpty(personId)) {
            IPerson personFactory = null;
            personFactory = ctx != null ? PersonFactory.getLocalInstance((Context)ctx) : PersonFactory.getRemoteInstance();
            orgUnitInfo = personFactory.getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
        }
        return orgUnitInfo;
    }

    public static String getCurrentPersonId(Context ctx) {
        Object object = null;
        try {
            Method method;
            if (ctx != null) {
                Class<?> contextUtilClass = Class.forName("com.kingdee.eas.util.app.ContextUtil");
                method = contextUtilClass.getMethod("getCurrentUserInfo", Context.class);
                object = method.invoke(null, ctx);
            } else {
                Class<?> sysContextClass = Class.forName("com.kingdee.eas.common.client.SysContext");
                method = sysContextClass.getMethod("getSysContext", null);
                object = method.invoke(null, null);
                method = sysContextClass.getMethod("getCurrentUserInfo", null);
                object = method.invoke(object, null);
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
        UserInfo userInfo = null;
        if (object instanceof UserInfo) {
            userInfo = (UserInfo)object;
        }
        String currentPersonId = null;
        if (userInfo != null && userInfo.getPerson() != null) {
            currentPersonId = userInfo.getPerson().getId().toString();
        }
        return currentPersonId;
    }

    public static IObjectValue getObjectValueInfo(IDataBase iDataBase, EntityViewInfo viewInfo) throws BOSException {
        CoreBaseCollection collection = iDataBase.getCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            return collection.getObject(0);
        }
        return null;
    }

    public static EntityViewInfo getEntityViewInfo(String columnName, Object value) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(columnName, value));
        view.setFilter(filter);
        return view;
    }

    public static FilterInfo buildHROFilter(HROrgUnitInfo hroInfo, String columnName) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        if (hroInfo == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select \"A\".FID").append(" from T_ORG_Admin \"A\" left join T_ORG_UnitRelation \"B\" ").append(" on \"A\".FID=\"B\".FFromUnitID ").append(" where \"A\".FIsSealUp = 0 and ((\"B\".FToUnitID = '" + hroInfo.getId().toString() + "' and FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5') ").append(" or \"A\".FID = '" + hroInfo.getId().toString() + "' )");
        filterInfo.getFilterItems().add(new FilterItemInfo(columnName, (Object)sql.toString(), CompareType.INNER));
        return filterInfo;
    }
}

