/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.Sout;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.client.AbstractAttachmentManageEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class AttachmentManageEditUI
extends AbstractAttachmentManageEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AttachmentManageEditUI.class);
    private String boID;

    public AttachmentManageEditUI() throws Exception {
        this.initCtrls();
    }

    private void initCtrls() {
        this.btnAddNew.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.kDCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String desc = EASResource.getString((String)"no");
                if (AttachmentManageEditUI.this.kDCheckBox1.isSelected()) {
                    desc = EASResource.getString((String)"yes");
                }
                AttachmentManageEditUI.this.tfTemp.setText(desc);
            }
        });
    }

    public void loadFields() {
        if (this.editData.getName().equals("")) {
            return;
        }
        super.loadFields();
    }

    protected IObjectValue createNewData() {
        AttachmentInfo ai = new AttachmentInfo();
        ai.setName("");
        return ai;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AttachmentFactory.getRemoteInstance();
    }

    private String getBoID() {
        if (this.boID == null) {
            this.boID = ((String)this.getUIContext().get("boID")).trim();
        }
        return this.boID;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.setUITitle(Resrcs.getString((String)"View"));
            this.btnSubmit.setVisible(false);
            this.btnPre.setVisible(true);
            this.btnNext.setVisible(true);
            this.btnFirst.setVisible(true);
            this.btnLast.setVisible(true);
        } else {
            this.setUITitle(Resrcs.getString((String)"Edit"));
            this.txtName.setEnabled(true);
            this.taDescription.setEnabled(true);
            this.kDCheckBox1.setEnabled(!this.editData.isIsShared());
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String theName = this.txtName.getText().trim();
        if (theName == null || theName.equals("")) {
            MsgBox.showInfo((String)Resrcs.getString((String)"FileNotSet"));
            return;
        }
        try {
            StringUtil4File.checkInvalidCharsInFileName((String)theName);
        }
        catch (AttachmentException ae) {
            ExceptionHandler.handle((Throwable)ae);
            return;
        }
        if (!theName.equals(this.editData.getName()) && ((IAttachment)this.getBizInterface()).isFileNameExisted(this.getBoID(), theName)) {
            Sout.show((String)this.editData.getName());
            MsgBox.showInfo((String)MessageFormat.format(Resrcs.getString((String)"FileNameExisted2"), theName));
            this.txtName.requestFocusInWindow();
            this.txtName.selectAll();
            return;
        }
        super.actionSubmit_actionPerformed(e);
    }
}

