/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.hr.train.client.AbstractAttachmentManageListUI;
import com.kingdee.eas.hr.train.client.AttachmentManageEditUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class AttachmentManageListUI
extends AbstractAttachmentManageListUI {
    private static final Logger logger = CoreUIObject.getLogger(AttachmentManageListUI.class);
    private String boID;
    private FileGetter fg;

    public AttachmentManageListUI() throws Exception {
        this.initCtrls();
    }

    private void initCtrls() {
        this.btnRefresh.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnViewContent.setEnabled(true);
        this.btnViewContent.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
        this.btnDownload.setIcon(EASResource.getIcon((String)"imgTbtn_dcdwj"));
        this.btnDownload.setEnabled(true);
    }

    protected String getEditUIName() {
        return AttachmentManageEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AttachmentFactory.getRemoteInstance();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"boID", (Object)this.getBoID());
        String code = this.getExtraCode();
        if (!code.equals("")) {
            uiContext.put((Object)"code", (Object)code);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("boAttchAsso.boID", (Object)this.getBoID(), CompareType.EQUALS));
        this.addExtraFilterItemCollection(fic);
        this.addExtraFilterItem(fic);
        return fi;
    }

    private String getExtraCode() {
        Object o = this.getUIContext().get("code");
        if (o == null) {
            return "";
        }
        String code = (String)o;
        return code;
    }

    private void addExtraFilterItem(FilterItemCollection fic) {
        String code = this.getExtraCode();
        if (!code.equals("")) {
            fic.add(new FilterItemInfo("number", (Object)code, CompareType.EQUALS));
        }
    }

    private void addExtraFilterItemCollection(FilterItemCollection fic) {
        Object o = this.getUIContext().get("extraFilterItemCollection");
        if (o == null) {
            return;
        }
        FilterItemCollection efic = (FilterItemCollection)o;
        int size = efic.size();
        for (int i = 0; i < size; ++i) {
            fic.add(efic.get(i));
        }
    }

    private String getBoID() {
        if (this.boID == null) {
            this.boID = (String)this.getUIContext().get("boID");
            if (this.boID != null) {
                this.boID = this.boID.trim();
            }
        }
        if (this.boID == null) {
            logger.info((Object)"......... boID is Empty,please put boID into UIContext");
            logger.info((Object)"......... boID is bussess Object id");
        }
        return this.boID;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            try {
                AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
                IIDList idList = attachmentClientManager.getIdInTable(this.tblMain, this.getKeyFieldName());
                attachmentClientManager.deleteAssoAttachment(this.boID, idList);
            }
            catch (ObjectNotFoundException onfe) {
                logger.error((Object)onfe.getMessage());
                this.refreshList();
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            this.refresh(e);
        }
    }

    private FileGetter getFileGetter() throws Exception {
        if (this.fg == null) {
            this.fg = new FileGetter((IAttachment)this.getBizInterface(), AttachmentFtpFacadeFactory.getRemoteInstance());
        }
        return this.fg;
    }

    public void actionDownload_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
        this.getFileGetter().downloadAttachment(attachmentClientManager.getIdInTable(this.tblMain, this.getKeyFieldName()), (Component)((Object)this));
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
        attachmentClientManager.showUploadFilesUI((Component)((Object)this), this.boID, this.getExtraCode());
        this.execQuery();
    }

    public void actionViewContent_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.getFileGetter().viewAttachment(this.getSelectedKeyValue());
    }
}

