/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.emp.PersonCertificationInfo;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordCollection;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.client.AbstractBatchAddCertificateUI;
import com.kingdee.eas.hr.train.client.LocateAssistant;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BatchAddCertificateUI
extends AbstractBatchAddCertificateUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchAddCertificateUI.class);
    private static String RES = "com.kingdee.eas.hr.train.client.TrainRecordResource";
    private String activityId = "";
    private String courseId = "";
    private boolean isCourseRecord = false;
    private EntityViewInfo eviForRecord = new EntityViewInfo();
    HashSet personIds = new HashSet();
    Set personIdsForQuery = new HashSet();
    Map oldData = new HashMap();
    private JButton btnSelectRecord;
    private JButton btnRemoveRecord;
    boolean flag = false;
    private static final int STR_TYPE = 0;
    private static final int INT_TYPE = 10;
    private static final int DATE_TYPE = 100;
    private LocateAssistant locateAssistant;
    private String userID = null;

    public void onLoad() throws Exception {
        super.onLoad();
        TrainActivityHelper.initTrainActivity_By_End_Star(this.prmtTrainActivity, TrainActivityHelper.getActSelectors());
        TrainActivityHelper.initTrainCourse(this.prmtTrainCourse, false, (IUIObject)this);
        this.prmtTrainActivity.setEditable(false);
        this.prmtTrainCourse.setEditable(false);
        this.tblMain.checkParsed();
        this.btnSave.setEnabled(true);
        KDTextField txtField = new KDTextField();
        txtField.setMaxLength(60);
        TrainUtils.setTableCellEditorByTextField(this.tblMain, txtField, "certificateName");
        TrainUtils.setTableCellEditorByTextField(this.tblMain, txtField, "certificateNumber");
        TrainUtils.setTableCellEditorByTextField(this.tblMain, txtField, "organization");
        KDFormattedTextField field = new KDFormattedTextField();
        field.setDataType(10);
        field.setMinimumValue((Comparable)new BigInteger("0"));
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)field);
        this.tblMain.getColumn("period").setEditor((ICellEditor)cellEditor);
        this.btnSelectRecord = this.contCertificate.add((Action)((Object)new ActionSelectRecord()));
        this.btnSelectRecord.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnSelectRecord.setToolTipText(EASResource.getString((String)RES, (String)"add_row"));
        this.btnRemoveRecord = this.contCertificate.add((Action)((Object)new ActionRemoveRecord()));
        this.btnRemoveRecord.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemoveRecord.setToolTipText(EASResource.getString((String)RES, (String)"delete_row"));
        KDDatePicker dp = new KDDatePicker();
        this.tblMain.getColumn("date").setEditor((ICellEditor)new KDTDefaultCellEditor(dp));
        SelectorItemCollection sicForRecord = this.eviForRecord.getSelector();
        sicForRecord.add(new SelectorItemInfo("*"));
        sicForRecord.add(new SelectorItemInfo("id"));
        sicForRecord.add(new SelectorItemInfo("TrainActivity.id"));
        sicForRecord.add(new SelectorItemInfo("TrainCourse.id"));
        sicForRecord.add(new SelectorItemInfo("actCertificate.*"));
        sicForRecord.add(new SelectorItemInfo("EmpCertificatio.*"));
        sicForRecord.add(new SelectorItemInfo("Employee.id"));
        sicForRecord.add(new SelectorItemInfo("Employee.name"));
        sicForRecord.add(new SelectorItemInfo("Employee.number"));
        this.tblMain.getColumn("personName").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("personName").getStyleAttributes().setBackground(new Color(217, 217, 214));
        this.tblMain.getColumn("personNumber").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("personNumber").getStyleAttributes().setBackground(new Color(217, 217, 214));
        TrainUtils.setKDTableSortable(this.tblMain);
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex("personName") + 1);
        this.userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnColumnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.btnSelectCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.actionLocate.setEnabled(true);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount > 0) {
            HashMap<String, PersonCertificationInfo> recordMap = new HashMap<String, PersonCertificationInfo>();
            this.oldData.clear();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblMain.getRow(i);
                Object value = row.getCell("recordId").getValue();
                if (value == null || value.toString().length() <= 0) continue;
                PersonCertificationInfo cInfo = new PersonCertificationInfo();
                value = row.getCell("certificateId").getValue();
                if (value != null && value.toString().length() > 0) {
                    cInfo.setId(BOSUuid.read((String)value.toString()));
                }
                if ((value = row.getCell("personId").getValue()) != null && value.toString().length() > 0) {
                    PersonInfo pInfo = new PersonInfo();
                    pInfo.setId(BOSUuid.read((String)value.toString()));
                    cInfo.setPerson(pInfo);
                }
                if ((value = row.getCell("certificateName").getValue()) != null && value.toString().length() > 0) {
                    cInfo.setCertificateName(value.toString());
                } else {
                    recordMap.clear();
                    MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"certificate_name_required"));
                    SysUtil.abort();
                }
                value = row.getCell("certificateNumber").getValue();
                if (value != null && value.toString().length() > 0) {
                    cInfo.setCertificateNumber(value.toString());
                } else {
                    recordMap.clear();
                    MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"certificate_number_required"));
                    SysUtil.abort();
                }
                value = row.getCell("organization").getValue();
                if (value != null && value.toString().length() > 0) {
                    cInfo.setOrgan(value.toString());
                }
                if ((value = row.getCell("period").getValue()) != null && value.toString().length() > 0) {
                    cInfo.setPeriodValidity(Integer.parseInt(value.toString()));
                } else {
                    cInfo.setPeriodValidity(0);
                }
                value = row.getCell("date").getValue();
                if (value != null) {
                    cInfo.setCertifyDate((Date)value);
                }
                recordMap.put(row.getCell("recordId").getValue().toString(), cInfo);
                this.oldData.put(row.getCell("recordId").getValue().toString(), cInfo);
            }
            if (recordMap.size() > 0) {
                TrainCourseRecordFactory.getRemoteInstance().submitCertificateBatch(this.activityId, this.courseId, recordMap);
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"save_success"));
            }
        }
    }

    public void actionColumnCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        int size = this.tblMain.getSelectManager().size();
        if (size > 0) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(0);
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.tblMain.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.tblMain.getCell(row, column).getValue();
            int length = this.tblMain.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (i == row) continue;
                this.tblMain.getCell(i, column).setValue(value);
            }
        }
    }

    public void actionSelectCopy_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.selectedCopy(this.tblMain);
    }

    protected void prmtTrainActivity_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtTrainActivity.getValue() != null) {
            TrainActivityHelper.initTrainCourseByActivity_END_AND_STAR(this.prmtTrainCourse, ((TrainActivityInfo)this.prmtTrainActivity.getValue()).getId().toString());
        } else {
            TrainActivityHelper.initTrainCourse(this.prmtTrainCourse, false, (IUIObject)this);
        }
        this.loadData();
        this.setAddAndEndPersonState();
    }

    protected void prmtTrainCourse_dataChanged(DataChangeEvent e) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (this.prmtTrainCourse.getValue() != null) {
            TrainCourseInfo trainCourseInfo = (TrainCourseInfo)this.prmtTrainCourse.getValue();
            String id = trainCourseInfo.getId().toString();
            this.prmtTrainActivity.setSelector(null);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("trainActState", (Object)50));
            fi.getFilterItems().add(new FilterItemInfo("trainActState", (Object)40));
            fi.setMaskString("(#0 or #1)");
            fi.getFilterItems().add(new FilterItemInfo("trainCourse.id", (Object)id));
            fi.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"HrOrgUnit.id", (String)"belongOrgUnit.id"), "AND");
            viewInfo.setFilter(fi);
            this.prmtTrainActivity.setEntityViewInfo(viewInfo);
        } else {
            FilterInfo fi = PFUtils.getHRAndAdminRangeFilterInfo((String)"HrOrgUnit.id", (String)"belongOrgUnit.id");
            fi.getFilterItems().add(new FilterItemInfo("trainActState", (Object)50));
            fi.getFilterItems().add(new FilterItemInfo("trainActState", (Object)40));
            fi.setMaskString("(#0 or #1)");
            viewInfo.setFilter(fi);
            this.prmtTrainActivity.setEntityViewInfo(viewInfo);
        }
        this.loadData();
        this.setAddAndEndPersonState();
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.actionSave.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                this.actionSave.actionPerformed(event);
                return !this.actionSave.isInvokeFailed();
            }
            return result == 1;
        }
        return true;
    }

    private boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            super.handleException((Exception)e);
        }
        if (this.tblMain.getRowCount() != this.oldData.size()) {
            return true;
        }
        int j = this.tblMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            IRow row = this.tblMain.getRow(i);
            String recordId = row.getCell("recordId").getValue().toString();
            if (this.oldData.containsKey(recordId)) {
                PersonCertificationInfo certificateInfo = (PersonCertificationInfo)this.oldData.get(recordId);
                if (certificateInfo == null) continue;
                if (!this.checkEquals(row.getCell("certificateId").getValue(), certificateInfo.getId(), 0)) {
                    return true;
                }
                if (!this.checkEquals(row.getCell("certificateName").getValue(), certificateInfo.getCertificateName(), 0)) {
                    return true;
                }
                if (!this.checkEquals(row.getCell("certificateNumber").getValue(), certificateInfo.getCertificateNumber(), 0)) {
                    return true;
                }
                if (!this.checkEquals(row.getCell("organization").getValue(), certificateInfo.getOrgan(), 0)) {
                    return true;
                }
                Object value = row.getCell("period").getValue();
                if (value == null ? certificateInfo.getPeriodValidity() != 0 : Integer.parseInt(value.toString()) != certificateInfo.getPeriodValidity()) {
                    return true;
                }
                if (this.checkEquals(row.getCell("date").getValue(), certificateInfo.getCertifyDate(), 100)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private final boolean checkEquals(Object newValue, Object oldValue, int type) {
        if (type == 0) {
            if (newValue == null) {
                newValue = "";
            }
            if (oldValue == null) {
                oldValue = "";
            }
            return (newValue = newValue.toString().trim()).equals(oldValue = oldValue.toString().trim());
        }
        if (type == 10) {
            if (newValue == null && oldValue == null) {
                return true;
            }
            if (newValue != null && oldValue == null) {
                return newValue.equals(0);
            }
            if (newValue == null && oldValue != null) {
                return oldValue.equals(0);
            }
            return newValue.equals(oldValue);
        }
        if (type == 100) {
            if (newValue == null && oldValue == null) {
                return true;
            }
            if (newValue != null && oldValue == null) {
                return false;
            }
            if (newValue == null && oldValue != null) {
                return false;
            }
            return newValue.equals(oldValue);
        }
        return true;
    }

    private void loadData() throws Exception {
        FilterInfo fi = new FilterInfo();
        if (this.prmtTrainActivity.getValue() != null) {
            this.activityId = ((TrainActivityInfo)this.prmtTrainActivity.getValue()).getId().toString();
        } else {
            this.activityId = "";
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"please_select_activity"));
            this.tblMain.removeRows();
            SysUtil.abort();
        }
        if (this.prmtTrainCourse.getValue() != null) {
            this.courseId = ((TrainCourseInfo)this.prmtTrainCourse.getValue()).getId().toString();
            this.isCourseRecord = true;
        } else {
            this.courseId = "";
            this.isCourseRecord = false;
        }
        if (this.activityId != null && this.activityId.length() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)this.activityId));
        }
        if (this.courseId != null && this.courseId.length() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)this.courseId));
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(TrainCommonUtils.getAdminRangeFilterItemInfo(this.userID, "recordExtends.OrgStudent.id"));
        if (FilterUtility.hasFilterItem((FilterInfo)fi)) {
            fi.mergeFilter(filterInfo, "AND");
        } else {
            fi = filterInfo;
        }
        this.eviForRecord.setFilter(fi);
        SelectorItemCollection sicForRecord = this.eviForRecord.getSelector();
        sicForRecord.add(new SelectorItemInfo("id"));
        sicForRecord.add(new SelectorItemInfo("TrainActivity.id"));
        sicForRecord.add(new SelectorItemInfo("TrainCourse.id"));
        sicForRecord.add(new SelectorItemInfo("EmpCertificatio.*"));
        sicForRecord.add(new SelectorItemInfo("EmpCertificatio.id"));
        sicForRecord.add(new SelectorItemInfo("EmpCertificatio.certificateNumber"));
        sicForRecord.add(new SelectorItemInfo("EmpCertificatio.certificateName"));
        sicForRecord.add(new SelectorItemInfo("EmpCertificatio.certifyDate"));
        sicForRecord.add(new SelectorItemInfo("EmpCertificatio.PeriodValidity"));
        sicForRecord.add(new SelectorItemInfo("EmpCertificatio.organ"));
        sicForRecord.add(new SelectorItemInfo("actCertificate.*"));
        sicForRecord.add(new SelectorItemInfo("actCertificate.id"));
        sicForRecord.add(new SelectorItemInfo("actCertificate.certificateNumber"));
        sicForRecord.add(new SelectorItemInfo("actCertificate.certificateName"));
        sicForRecord.add(new SelectorItemInfo("actCertificate.certifyDate"));
        sicForRecord.add(new SelectorItemInfo("actCertificate.PeriodValidity"));
        sicForRecord.add(new SelectorItemInfo("actCertificate.organ"));
        sicForRecord.add(new SelectorItemInfo("Employee.id"));
        sicForRecord.add(new SelectorItemInfo("Employee.name"));
        sicForRecord.add(new SelectorItemInfo("Employee.number"));
        sicForRecord.add(new SelectorItemInfo("recordExtends.isApproved"));
        sicForRecord.add(new SelectorItemInfo("recordExtends.actIsApproved"));
        TrainCourseRecordCollection coll = TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(this.eviForRecord);
        this.tblMain.removeRows();
        this.personIds.clear();
        this.personIdsForQuery.clear();
        this.oldData.clear();
        this.flag = false;
        this.putDataToTable(coll);
    }

    private void putDataToTable(TrainCourseRecordCollection coll) {
        if (coll == null || coll.size() <= 0) {
            return;
        }
        TrainCourseRecordCollection col_new = new TrainCourseRecordCollection();
        TrainCourseRecordInfo info_tmp = new TrainCourseRecordInfo();
        for (int i = 0; i < coll.size(); ++i) {
            info_tmp = coll.get(i);
            if (!this.isCourseRecord) {
                if (info_tmp.getRecordExtends().isActIsApproved()) continue;
                col_new.add(info_tmp);
                continue;
            }
            if (info_tmp.getRecordExtends().isIsApproved()) continue;
            col_new.add(info_tmp);
        }
        if (col_new == null || col_new.size() == 0) {
            return;
        }
        IRow row = null;
        int j = col_new.size();
        for (int i = 0; i < j; ++i) {
            TrainCourseRecordInfo info = col_new.get(i);
            PersonInfo pInfo = info.getEmployee();
            if (pInfo != null && this.personIds.contains(info.getEmployee().getId().toString())) continue;
            row = this.tblMain.addRow();
            row.getCell("personId").setValue((Object)info.getEmployee().getId());
            row.getCell("personName").setValue((Object)info.getEmployee().getName());
            row.getCell("personNumber").setValue((Object)info.getEmployee().getNumber());
            this.personIds.add(pInfo.getId().toString());
            this.personIdsForQuery.add(pInfo.getId().toString());
            PersonCertificationInfo certificateInfo = this.isCourseRecord ? info.getEmpCertificatio() : info.getActCertificate();
            row.getCell("recordId").setValue((Object)info.getId());
            if (certificateInfo == null) continue;
            row.getCell("certificateName").setValue((Object)certificateInfo.getCertificateName());
            row.getCell("certificateNumber").setValue((Object)certificateInfo.getCertificateNumber());
            row.getCell("organization").setValue((Object)certificateInfo.getOrgan());
            row.getCell("period").setValue((Object)String.valueOf(certificateInfo.getPeriodValidity()));
            row.getCell("date").setValue((Object)certificateInfo.getCertifyDate());
            row.getCell("certificateId").setValue((Object)certificateInfo.getId());
            if (this.flag) continue;
            this.oldData.put(info.getId().toString(), certificateInfo);
        }
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
        if (this.locateAssistant == null) {
            this.locateAssistant = new LocateAssistant((CoreUIObject)this, this.tblMain, this.getLocateNames());
        }
        this.locateAssistant.actionLocate();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"personNumber", "personName"};
        return locateNames;
    }

    private void clearTable() {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
    }

    private void setAddAndEndPersonState() {
        if (this.prmtTrainActivity.getValue() != null && this.prmtTrainCourse.getValue() == null) {
            TrainActivityInfo info = (TrainActivityInfo)this.prmtTrainActivity.getValue();
            if (!TrainActStateEnum.CLOSED.equals((Object)info.getTrainActState())) {
                this.btnSelectRecord.setEnabled(false);
                this.btnRemoveRecord.setEnabled(false);
                this.clearTable();
            }
        } else {
            this.btnSelectRecord.setEnabled(true);
            this.btnRemoveRecord.setEnabled(true);
        }
    }

    private class ActionRemoveRecord
    extends ItemAction {
        public ActionRemoveRecord() {
            this(null);
        }

        public ActionRemoveRecord(IUIObject uiObj) {
            super(uiObj);
            String _tempStr = "";
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift r"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            int[] row = KDTableUtil.getSelectedRows((KDTable)BatchAddCertificateUI.this.tblMain);
            for (int i = row.length - 1; i >= 0; --i) {
                IRow r = BatchAddCertificateUI.this.tblMain.getRow(row[i]);
                if (r == null) continue;
                if (r.getCell("personId").getValue() != null) {
                    BatchAddCertificateUI.this.personIds.remove(r.getCell("personId").getValue().toString());
                }
                BatchAddCertificateUI.this.tblMain.removeRow(row[i]);
            }
        }
    }

    private class ActionSelectRecord
    extends ItemAction {
        public ActionSelectRecord() {
            this(null);
        }

        public ActionSelectRecord(IUIObject uiObj) {
            super(uiObj);
            String _tempStr = "";
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift q"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            if (BatchAddCertificateUI.this.activityId == null || BatchAddCertificateUI.this.activityId.trim().length() <= 0) {
                MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"please_select_activity"));
                return;
            }
            KDCommonPromptDialog dlg = new KDCommonPromptDialog();
            MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.train.app", "PersonQuery");
            QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
            dlg.setQueryInfo(queryInfo);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi_person = new FilterInfo();
            fi_person.getFilterItems().add(new FilterItemInfo("id", (Object)BatchAddCertificateUI.this.personIdsForQuery, CompareType.INCLUDE));
            evi.setFilter(fi_person);
            dlg.setEntityViewInfo(evi);
            dlg.setEnabledMultiSelection(true);
            dlg.show();
            if (dlg.isCanceled()) {
                return;
            }
            Object[] obj = (Object[])dlg.getData();
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < obj.length; ++i) {
                String personId = ((PersonInfo)obj[i]).getId().toString();
                if (BatchAddCertificateUI.this.personIds.contains(personId)) continue;
                ids.add(personId);
            }
            if (ids.size() > 0) {
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("Employee.id", ids, CompareType.INCLUDE));
                if (BatchAddCertificateUI.this.activityId != null && BatchAddCertificateUI.this.activityId.length() > 0) {
                    fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)BatchAddCertificateUI.this.activityId));
                }
                if (BatchAddCertificateUI.this.courseId != null && BatchAddCertificateUI.this.courseId.length() > 0) {
                    fi.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)BatchAddCertificateUI.this.courseId));
                }
                BatchAddCertificateUI.this.eviForRecord.setFilter(fi);
                BatchAddCertificateUI.this.eviForRecord.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.id"));
                BatchAddCertificateUI.this.eviForRecord.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.name"));
                BatchAddCertificateUI.this.eviForRecord.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.id"));
                BatchAddCertificateUI.this.eviForRecord.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.name"));
                BatchAddCertificateUI.this.eviForRecord.getSelector().add(new SelectorItemInfo("recordExtends.isApproved"));
                BatchAddCertificateUI.this.eviForRecord.getSelector().add(new SelectorItemInfo("recordExtends.actIsApproved"));
                try {
                    TrainCourseRecordCollection coll = TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(BatchAddCertificateUI.this.eviForRecord);
                    BatchAddCertificateUI.this.flag = true;
                    BatchAddCertificateUI.this.putDataToTable(coll);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        }
    }
}

