/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.client.AbstractBatchAddCourseUI;
import com.kingdee.eas.hr.train.client.BatchAddInstructorUI;
import com.kingdee.eas.hr.train.client.ProgressManager;
import com.kingdee.eas.hr.train.client.TrainCoursePromptBox;
import com.kingdee.eas.hr.train.client.TrainInstructorPromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class BatchAddCourseUI
extends AbstractBatchAddCourseUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchAddInstructorUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainChanneResource";
    private static final String VERIFY_PATH = "com.kingdee.eas.hr.train.TrainVerifyResource";
    private TrainCoursePromptBox coursePromptBox;
    private List courses;
    private TrainInstructorInfo trainInstructorInfo;
    private boolean canceled = true;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() {
        this.prmtInstructor.setEditable(false);
        this.tblMain.getStyleAttributes().setLocked(true);
        TrainInstructorPromptBox promptBox = new TrainInstructorPromptBox((IUIObject)this);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isOuter"));
        sic.add(new SelectorItemInfo("Employee.name"));
        promptBox.setSelector(sic);
        this.prmtInstructor.setSelector((KDPromptSelector)promptBox);
        TrainUtils.setMutilTableFromBIM(this.contCourse, this.tblMain);
        JButton button = this.contCourse.add((Action)((Object)this.actionAddCourse));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        button.setToolTipText(EASResource.getString((String)RESOURCE, (String)"addCourse"));
        this.actionAddCourse.setEnabled(true);
        button = this.contCourse.add((Action)((Object)this.actionRemoveCourse));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        button.setToolTipText(EASResource.getString((String)RESOURCE, (String)"removeCourse"));
        this.actionRemoveCourse.setEnabled(true);
        this.coursePromptBox = new TrainCoursePromptBox((IUIObject)this);
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("CourseHour"));
        sic.add(new SelectorItemInfo("CourseHourUnit"));
        sic.add(new SelectorItemInfo("CourseJoinner"));
        sic.add(new SelectorItemInfo("CourseTarget"));
        sic.add(new SelectorItemInfo("courseCost"));
        sic.add(new SelectorItemInfo("CourseKind.name"));
        sic.add(new SelectorItemInfo("treeid.name"));
        this.coursePromptBox.setSelector(sic);
        this.coursePromptBox.setSingleSelect(false);
    }

    public void actionAddCourse_actionPerformed(ActionEvent e) throws Exception {
        this.coursePromptBox.show();
        if (!this.coursePromptBox.isCanceled() && this.coursePromptBox.getData() instanceof Object[]) {
            final Object[] objs = (Object[])this.coursePromptBox.getData();
            if (objs.length > 10) {
                ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

                    public void run() throws Exception {
                        BatchAddCourseUI.this.dealAddCourse(objs);
                    }
                };
                new ProgressManager(this).launchProcess(process, (CoreUIObject)this);
            } else {
                this.dealAddCourse(objs);
            }
        }
    }

    public void actionRemoveCourse_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.tblMain);
    }

    private void dealAddCourse(Object[] objs) {
        if (objs != null && objs.length > 0) {
            IRow row = null;
            TrainCourseInfo trainCourseInfo = null;
            int length = objs.length;
            for (int i = 0; i < length; ++i) {
                trainCourseInfo = (TrainCourseInfo)objs[i];
                if (TrainUtils.isRepeatRowInTable(this.tblMain, trainCourseInfo.getNumber(), "number")) continue;
                row = this.tblMain.addRow();
                this.setDataToRow(trainCourseInfo, row);
            }
        }
    }

    private void setDataToRow(Object object, IRow row) {
        TrainCourseInfo info = (TrainCourseInfo)object;
        row.getCell("courseObject").setValue((Object)info);
        row.getCell("number").setValue((Object)info.getNumber());
        row.getCell("name").setValue((Object)info.getName());
        row.getCell("cost").setValue((Object)info.getCourseCost());
        row.getCell("target").setValue((Object)info.getCourseTarget());
        if (info.getTreeid() != null) {
            row.getCell("type").setValue((Object)info.getTreeid().getName());
        }
        if (info.getCourseKind() != null) {
            row.getCell("kind").setValue((Object)info.getCourseKind().getName());
        }
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.storeValues();
        this.canceled = this.courses == null || this.courses.size() <= 0;
        this.getUIWindow().close();
    }

    private void storeValues() {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtInstructor);
        this.trainInstructorInfo = (TrainInstructorInfo)this.prmtInstructor.getValue();
        if (this.tblMain.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.contCourse.getTitle() + EASResource.getString((String)VERIFY_PATH, (String)"CanNotBeNull")));
            SysUtil.abort();
        }
        this.courses = new ArrayList();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.courses.add(this.tblMain.getRow(i).getCell("courseObject").getValue());
        }
    }

    protected void btnCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.canceled = true;
        this.getUIWindow().close();
    }

    public List getCourses() {
        return this.courses;
    }

    public TrainInstructorInfo getTrainInstructorInfo() {
        return this.trainInstructorInfo;
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

