/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.hr.train.ChannelCoursE1Collection;
import com.kingdee.eas.hr.train.ChannelCoursE1Factory;
import com.kingdee.eas.hr.train.ChannelCoursE1Info;
import com.kingdee.eas.hr.train.TrainChanneInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.TrainItemCourseInfo;
import com.kingdee.eas.hr.train.TrainItemInfo;
import com.kingdee.eas.hr.train.client.AbstractChannelCoursEditUI;
import com.kingdee.eas.hr.train.client.BatchAddCourseUI;
import com.kingdee.eas.hr.train.client.BatchAddInstructorUI;
import com.kingdee.eas.hr.train.client.LocateAssistant;
import com.kingdee.eas.hr.train.client.RowDataHandler;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCoursePromptBox;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainItemF7UI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TreeBasePromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class ChannelCoursEditUI
extends AbstractChannelCoursEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ChannelCoursEditUI.class);
    static String RES = "com.kingdee.eas.hr.train.client.TrainChanneResource";
    static String RES1 = "com.kingdee.eas.hr.train.client.TrainRecordResource";
    private String courseHaveBy = EASResource.getString((String)RES, (String)"COURSEHAVEBY");
    private String notDupSet = EASResource.getString((String)RES, (String)"NOTDUPSET");
    static String INSTRUCTOR = "Instructor";
    static String COURSE = "TrainCourse";
    private static final String TRAINITEM = "trainItem";
    protected static final TextRender render = new TextRender();
    private HashMap map;
    private LocateAssistant locateAssisant;
    private ChannelCoursE1Collection e1Collection;
    private Set delE1IDSet = new HashSet();
    private TrainChanneInfo trainChanneInfo;
    private Map e1HistoryMap = new HashMap();

    public void loadFields() {
        try {
            this.putDateToTable();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        IRow row = null;
        Object objHour = null;
        String courseHour = null;
        String courseHourUnit = null;
        int count = this.kdtE1.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.kdtE1.getRow(i);
            objHour = row.getCell("CourseHour").getValue();
            courseHour = objHour == null ? "" : String.valueOf(((BigDecimal)objHour).setScale(2, 4));
            String string = courseHourUnit = row.getCell("CourseHourUnit").getValue() == null ? "" : String.valueOf(row.getCell("CourseHourUnit").getValue());
            if (!StringUtils.isEmpty((String)courseHour)) {
                courseHour = courseHour + courseHourUnit;
            }
            row.getCell("HourAndHourUnit").setValue((Object)courseHour);
        }
        this.setActionState(!OprtState.VIEW.equals(this.getOprtState()));
    }

    private void putDateToTable() throws BOSException {
        this.e1HistoryMap.clear();
        this.kdtE1.removeRows();
        this.delE1IDSet.clear();
        ChannelCoursE1Collection e1Col = this.getE1Collection();
        if (e1Col != null && e1Col.size() > 0) {
            for (int i = 0; i < e1Col.size(); ++i) {
                ChannelCoursE1Info e1Info = e1Col.get(i);
                IRow row = this.kdtE1.addRow();
                if (e1Info.getTrainCourse() != null) {
                    row.getCell("TrainCourse").setValue((Object)e1Info.getTrainCourse());
                    row.getCell("TrainCourseNumb").setValue((Object)e1Info.getTrainCourse().getNumber());
                    row.getCell("CourseHour").setValue((Object)e1Info.getTrainCourse().getCourseHour());
                    row.getCell("CourseHourUnit").setValue((Object)e1Info.getTrainCourse().getCourseHourUnit());
                    row.getCell("CourseJoinner").setValue((Object)e1Info.getTrainCourse().getCourseJoinner());
                    row.getCell("Traincoursetarg").setValue((Object)e1Info.getTrainCourse().getCourseTarget());
                    row.getCell("e1.id").setValue((Object)e1Info.getId().toString());
                    if (e1Info.getTrainCourse().getTreeid() != null) {
                        row.getCell("TraincourseType").setValue((Object)e1Info.getTrainCourse().getTreeid().getName());
                    } else {
                        row.getCell("TraincourseType").setValue(null);
                    }
                    if (e1Info.getTrainCourse().getCourseKind() != null) {
                        row.getCell("TraincourseKind").setValue((Object)e1Info.getTrainCourse().getCourseKind().getName());
                    } else {
                        row.getCell("TraincourseKind").setValue(null);
                    }
                } else {
                    row.getCell("TrainCourse").setValue(null);
                    row.getCell("TrainCourseNumb").setValue(null);
                    row.getCell("CourseHour").setValue(null);
                    row.getCell("CourseHourUnit").setValue(null);
                    row.getCell("CourseJoinner").setValue(null);
                    row.getCell("Traincoursetarg").setValue(null);
                    row.getCell("TraincourseType").setValue(null);
                    row.getCell("TraincourseKind").setValue(null);
                }
                row.getCell(TRAINITEM).setValue((Object)e1Info.getTrainItem());
                row.getCell("Instructor").setValue((Object)e1Info.getInstructor());
                row.getCell("ChargeStand").setValue((Object)e1Info.getChargeStand());
                row.getCell("Remark").setValue((Object)e1Info.getRemark());
                this.e1HistoryMap.put(e1Info.getId().toString(), e1Info);
            }
        }
    }

    private ChannelCoursE1Collection getE1Collection() throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainChannel.id", (Object)this.trainChanneInfo.getId().toString()));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("ChargeStand"));
        evi.getSelector().add(new SelectorItemInfo("Remark"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.treeid.name"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.CourseTarget"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.CourseKind.name"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.CourseHour"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.CourseHourUnit"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.CourseJoinner"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.number"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.name"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.id"));
        evi.getSelector().add(new SelectorItemInfo("Instructor.name"));
        evi.getSelector().add(new SelectorItemInfo("Instructor.Employee.id"));
        evi.getSelector().add(new SelectorItemInfo("Instructor.Employee.name"));
        evi.getSelector().add(new SelectorItemInfo("Instructor.IsOuter"));
        evi.getSelector().add(new SelectorItemInfo("Instructor.id"));
        evi.getSelector().add(new SelectorItemInfo("trainItem.name"));
        evi.getSelector().add(new SelectorItemInfo("trainItem.number"));
        evi.getSelector().add(new SelectorItemInfo("trainItem.id"));
        evi.getSorter().add(new SorterItemInfo("TrainCourse.name"));
        evi.getSorter().add(new SorterItemInfo("Instructor.name"));
        return ChannelCoursE1Factory.getRemoteInstance().getChannelCoursE1Collection(evi);
    }

    private void setActionState(boolean enable) {
        this.actionAddInstructor.setEnabled(enable);
        this.actionAddCourse.setEnabled(enable);
        this.actionAddLine.setEnabled(enable);
        this.actionInsertLine.setEnabled(enable);
        this.actionRemoveLine.setEnabled(enable);
        this.actionSave.setEnabled(enable);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.actionLocate.setEnabled(true);
    }

    public void storeFields() {
        this.beforeStoreFields();
        this.getDateFromTable();
    }

    private void getDateFromTable() {
        if (this.kdtE1.getRowCount() > 0) {
            this.e1Collection = new ChannelCoursE1Collection();
            for (int i = 0; i < this.kdtE1.getRowCount(); ++i) {
                ChannelCoursE1Info e1Info = new ChannelCoursE1Info();
                IRow row = this.kdtE1.getRow(i);
                if (row.getCell("e1.id").getValue() != null) {
                    String e1ID = (String)row.getCell("e1.id").getValue();
                    e1Info.setId(BOSUuid.read((String)e1ID));
                } else {
                    e1Info.setId(null);
                }
                TrainCourseInfo courseInfo = (TrainCourseInfo)row.getCell("TrainCourse").getValue();
                e1Info.setTrainCourse(courseInfo);
                TrainItemInfo trainItemInfo = (TrainItemInfo)row.getCell(TRAINITEM).getValue();
                e1Info.setTrainItem(trainItemInfo);
                TrainInstructorInfo trainInstructorInfo = (TrainInstructorInfo)row.getCell("Instructor").getValue();
                e1Info.setInstructor(trainInstructorInfo);
                if (row.getCell("ChargeStand").getValue() != null) {
                    e1Info.setChargeStand((String)row.getCell("ChargeStand").getValue());
                } else {
                    e1Info.setChargeStand(null);
                }
                if (row.getCell("Remark").getValue() != null) {
                    e1Info.setRemark((String)row.getCell("Remark").getValue());
                } else {
                    e1Info.setRemark(null);
                }
                e1Info.setTrainChannel(this.trainChanneInfo);
                this.e1Collection.add(e1Info);
            }
        }
    }

    protected void beforeStoreFields() {
        if (this.kdtE1.getRowCount() == 0) {
            TrainClientUtil.showErrorMessage(RES, "channelcoursNotNull", this);
        }
        this.map = new HashMap();
        IRow row = null;
        KDTEditManager kdtManager = this.kdtE1.getEditManager();
        int n = this.kdtE1.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.kdtE1.getRow(i);
            if (TrainClientUtil.objectIsNull(row.getCell(COURSE).getValue())) {
                kdtManager.editCellAt(i, this.kdtE1.getColumnIndex(COURSE));
                TrainClientUtil.showErrorMessage(RES, "courseNotNull", this);
            } else if (TrainClientUtil.objectIsNull(row.getCell(INSTRUCTOR).getValue())) {
                kdtManager.editCellAt(i, this.kdtE1.getColumnIndex(INSTRUCTOR));
                TrainClientUtil.showErrorMessage(RES, "instructorNotNull", this);
            }
            String courseId = ((TrainCourseInfo)row.getCell(COURSE).getValue()).getId().toString();
            String instructorId = ((TrainInstructorInfo)row.getCell(INSTRUCTOR).getValue()).getId().toString();
            this.checkLineDup(row, courseId, instructorId);
        }
    }

    private void checkLineDup(IRow row, String course, String instructor) {
        if (this.map.containsKey(course)) {
            HashSet set = (HashSet)this.map.get(course);
            if (set.contains(instructor)) {
                KDTEditManager kdtManager = this.kdtE1.getEditManager();
                kdtManager.editCellAt(row.getRowIndex(), this.kdtE1.getColumnIndex(COURSE));
                MsgBox.showInfo((String)(row.getCell("TrainCourse").getValue().toString() + this.courseHaveBy + row.getCell("Instructor").getValue().toString() + this.notDupSet));
                SysUtil.abort();
            } else {
                set.add(instructor);
            }
        } else {
            HashSet<String> set = new HashSet<String>();
            set.add(instructor);
            this.map.put(course, set);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.trainChanneInfo = (TrainChanneInfo)this.getUIContext().get("trainChannel");
        this.kdtE1.checkParsed();
        TrainUtils.setTableNumberFormat(this.kdtE1, "CourseHour", 2);
        this.setTableColumnDisEnabled();
        this.initTrainItemF7();
        this.initInstructorF7();
        this.initTrainCourseF7();
        this.loadFields();
        this.initTableCellPaintFormat();
        TrainUtils.setTableCellEditorByTextField(this.kdtE1, "ChargeStand", 40);
        TrainUtils.setTableCellEditorByTextField(this.kdtE1, "Remark", 200);
        TrainUtils.setKDTableSortable(this.kdtE1);
        this.initKdtE1Buttons();
    }

    private void initKdtE1Buttons() {
        JButton button = this.contCourse.add((Action)((Object)this.actionAddInstructor));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        button.setToolTipText(EASResource.getString((String)RES, (String)"batchAddInstructor"));
        button.setText(null);
        button = this.contCourse.add((Action)((Object)this.actionAddCourse));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_addcourse"));
        button.setToolTipText(EASResource.getString((String)RES, (String)"batchAddCourse"));
        button.setText(null);
        TrainUtils.initMutilTableFromBIM(this.contCourse, (Action)((Object)this.actionAddLine), (Action)((Object)this.actionInsertLine), (Action)((Object)this.actionRemoveLine));
    }

    private void initTrainItemF7() {
        KDBizPromptBox prmtTrainItem = new KDBizPromptBox();
        prmtTrainItem.setVisible(true);
        prmtTrainItem.setDisplayFormat("$name$");
        prmtTrainItem.setEditFormat("$number$");
        prmtTrainItem.setCommitFormat("$number$");
        String uiName = TrainItemF7UI.class.getName();
        TreeBasePromptBox promptBox = new TreeBasePromptBox((IUIObject)this, uiName);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isEnable", (Object)1));
        promptBox.setFilterInfo(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("Course.course.*"));
        sic.add(new SelectorItemInfo("Course.course.treeid.name"));
        sic.add(new SelectorItemInfo("Course.course.CourseKind.name"));
        promptBox.setSelector(sic);
        promptBox.setSingleSelect(false);
        prmtTrainItem.setSelector((KDPromptSelector)promptBox);
        prmtTrainItem.setEnabledMultiSelection(true);
        prmtTrainItem.setEditable(false);
        KDTDefaultCellEditor kdtE1_TrainItem_CellEditor = new KDTDefaultCellEditor((IKDEditor)prmtTrainItem);
        this.kdtE1.getColumn(TRAINITEM).setEditor((ICellEditor)kdtE1_TrainItem_CellEditor);
        prmtTrainItem.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null) {
                    ChannelCoursEditUI.this.handleResult(e);
                    e.setResult(0);
                }
            }
        });
    }

    private void handleResult(PreChangeEvent e) {
        Object[] infos = (Object[])e.getData();
        if (infos != null && infos.length > 0) {
            Object[] objects = this.assembleChannelCourse(infos);
            RowDataHandler handler = new RowDataHandler(){

                public boolean setRowData(IRow row, Object object) {
                    boolean flag = false;
                    if (row != null && object != null) {
                        ChannelCoursE1Info channelCourse = (ChannelCoursE1Info)object;
                        row.getCell(ChannelCoursEditUI.TRAINITEM).setValue((Object)channelCourse.getTrainItem());
                        row.getCell(COURSE).setValue((Object)channelCourse.getTrainCourse());
                        row.getCell("TrainCourseNumb").setValue((Object)channelCourse.getTrainCourse().getNumber());
                        row.getCell("CourseHour").setValue((Object)channelCourse.getTrainCourse().getCourseHour());
                        row.getCell("CourseHourUnit").setValue((Object)channelCourse.getTrainCourse().getCourseHourUnit());
                        row.getCell("CourseJoinner").setValue((Object)channelCourse.getTrainCourse().getCourseJoinner());
                        row.getCell("Traincoursetarg").setValue((Object)channelCourse.getTrainCourse().getCourseTarget());
                        row.getCell("TraincourseType").setValue((Object)channelCourse.getTrainCourse().getTreeid());
                        row.getCell("TraincourseKind").setValue((Object)channelCourse.getTrainCourse().getCourseKind());
                        if (channelCourse.getTrainCourse().getCourseCost() != null) {
                            row.getCell("ChargeStand").setValue((Object)channelCourse.getTrainCourse().getCourseCost().setScale(TrainClientUtil.PRECISION, 4).toString());
                        } else {
                            row.getCell("ChargeStand").setValue(null);
                        }
                        ChannelCoursEditUI.this.setHourAndHourUnit(row.getRowIndex());
                        flag = true;
                    }
                    return flag;
                }
            };
            TrainUtils.batchAddRowWithData(this.kdtE1, objects, TRAINITEM, handler);
        }
    }

    private Object[] assembleChannelCourse(Object[] infos) {
        ArrayList<ChannelCoursE1Info> result = new ArrayList<ChannelCoursE1Info>();
        TrainItemInfo info = null;
        Iterator it = null;
        TrainItemCourseInfo itemCourse = null;
        ChannelCoursE1Info channelCourse = null;
        for (int i = 0; i < infos.length; ++i) {
            info = (TrainItemInfo)infos[i];
            it = info.getCourse().iterator();
            while (it.hasNext()) {
                itemCourse = (TrainItemCourseInfo)it.next();
                channelCourse = new ChannelCoursE1Info();
                channelCourse.setTrainItem(info);
                channelCourse.setTrainCourse(itemCourse.getCourse());
                result.add(channelCourse);
            }
        }
        return result.toArray();
    }

    private void initTableCellPaintFormat() {
        this.kdtE1.setUserCellDisplayParser(new IUserCellDisplayParser(){

            public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
                int hourAndHourUnitColumn = ChannelCoursEditUI.this.kdtE1.getColumnIndex("HourAndHourUnit");
                if (colIndex == hourAndHourUnitColumn - 1 && rowIndex >= 0) {
                    ChannelCoursEditUI.this.setHourAndHourUnit(rowIndex);
                }
                return value;
            }
        });
        this.kdtE1.getColumn(INSTRUCTOR).setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                try {
                    if (object == null) {
                        return;
                    }
                    TrainInstructorInfo info = (TrainInstructorInfo)object;
                    StringBuffer sb = new StringBuffer();
                    if (info.isIsOuter()) {
                        sb.append(info.getName());
                    } else if (info.getEmployee() != null && !StringUtils.isEmpty((String)info.getEmployee().getName())) {
                        sb.append(info.getEmployee().getName());
                    }
                    sb.append("_");
                    if (info.isIsOuter()) {
                        sb.append(TrainClientUtil.getResource(RES, "outerInstructor"));
                    } else {
                        sb.append(TrainClientUtil.getResource(RES, "innerInstructor"));
                    }
                    render.draw(graphics, clip, sb.toString(), cellStyle);
                }
                catch (Exception ex) {
                    ChannelCoursEditUI.this.handleException(ex);
                }
            }
        });
    }

    private void initTrainCourseF7() {
        KDBizPromptBox kdtE1_TrainCourse_PromptBox = new KDBizPromptBox();
        TrainCoursePromptBox f7 = new TrainCoursePromptBox((IUIObject)this);
        f7.setEnabled(true);
        kdtE1_TrainCourse_PromptBox.setEditable(false);
        kdtE1_TrainCourse_PromptBox.setEnabled(true);
        kdtE1_TrainCourse_PromptBox.setSelector((KDPromptSelector)f7);
        KDTDefaultCellEditor kdtE1_TrainCourse_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtE1_TrainCourse_PromptBox);
        this.kdtE1.getColumn(COURSE).setEditor((ICellEditor)kdtE1_TrainCourse_CellEditor);
    }

    private void initInstructorF7() {
        KDBizPromptBox instructorPromptBox = new KDBizPromptBox();
        TrainUtils.initTrainInstructor(instructorPromptBox, (IUIObject)this);
        instructorPromptBox.setDisplayFormat("$name$");
        instructorPromptBox.setEditFormat("$number$");
        instructorPromptBox.setCommitFormat("$number$");
        KDTDefaultCellEditor kdtE1_Instructor_CellEditor = new KDTDefaultCellEditor((IKDEditor)instructorPromptBox);
        this.kdtE1.getColumn(INSTRUCTOR).setEditor((ICellEditor)kdtE1_Instructor_CellEditor);
    }

    private void setTableColumnDisEnabled() {
        this.kdtE1.checkParsed();
        TrainClientUtil.setDisableColor(this.kdtE1);
        this.kdtE1.getColumn("TrainCourse").getStyleAttributes().setBackground(TrainClientUtil.requiredColor);
        this.kdtE1.getColumn("Instructor").getStyleAttributes().setBackground(TrainClientUtil.requiredColor);
    }

    private void setHourAndHourUnit(int rowIndex) {
        if (this.kdtE1.getRow(rowIndex).getCell("CourseHour").getValue() == null || this.kdtE1.getRow(rowIndex).getCell("CourseHourUnit").getValue() == null) {
            this.kdtE1.getRow(rowIndex).getCell("HourAndHourUnit").setValue(null);
            return;
        }
        String str = TrainClientUtil.formatBigDecimal((BigDecimal)this.kdtE1.getRow(rowIndex).getCell("CourseHour").getValue(), 2);
        str = str + this.kdtE1.getRow(rowIndex).getCell("CourseHourUnit").getValue().toString();
        this.kdtE1.getRow(rowIndex).getCell("HourAndHourUnit").setValue((Object)str);
    }

    private void updateState() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        if (this.locateAssisant == null) {
            this.locateAssisant = new LocateAssistant((CoreUIObject)this, this.kdtE1, this.getLocateNames());
        }
        this.locateAssisant.actionLocate();
    }

    protected String[] getLocateNames() {
        return new String[]{"TrainCourse", "TrainCourseNumb", "Instructor"};
    }

    public void actionAddCourse_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BatchAddCourseUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        window.show();
        BatchAddCourseUI batchAddCourseUI = (BatchAddCourseUI)window.getUIObject();
        if (!batchAddCourseUI.isCanceled()) {
            List courses = batchAddCourseUI.getCourses();
            TrainInstructorInfo trainInstructorInfo = batchAddCourseUI.getTrainInstructorInfo();
            if (trainInstructorInfo != null && courses.size() > 0) {
                TrainCourseInfo courseInfo2 = null;
                ArrayList<String> repeatCourses = null;
                for (TrainCourseInfo courseInfo2 : courses) {
                    if (this.setDataToRow(courseInfo2, trainInstructorInfo)) continue;
                    if (repeatCourses == null) {
                        repeatCourses = new ArrayList<String>();
                    }
                    repeatCourses.add(courseInfo2.getName());
                }
                if (repeatCourses != null) {
                    String str = EASResource.getString((String)RES, (String)"courseRepeat");
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(str, trainInstructorInfo.getName(), TrainCommonUtils.collectionToStrings(repeatCourses, "\u3001")));
                }
            }
        }
    }

    public void actionAddInstructor_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BatchAddInstructorUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        window.show();
        BatchAddInstructorUI batchAddInstructorUI = (BatchAddInstructorUI)window.getUIObject();
        if (!batchAddInstructorUI.isCanceled()) {
            List instructors = batchAddInstructorUI.getInstructors();
            TrainCourseInfo trainCourseInfo = batchAddInstructorUI.getTrainCourseInfo();
            if (trainCourseInfo != null && instructors.size() > 0) {
                TrainInstructorInfo instructorInfo2 = null;
                ArrayList<String> repeatInstructors = null;
                for (TrainInstructorInfo instructorInfo2 : instructors) {
                    if (this.setDataToRow(trainCourseInfo, instructorInfo2)) continue;
                    if (repeatInstructors == null) {
                        repeatInstructors = new ArrayList<String>();
                    }
                    repeatInstructors.add(instructorInfo2.getName());
                }
                if (repeatInstructors != null) {
                    String str = EASResource.getString((String)RES, (String)"instructorRepeat");
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(str, trainCourseInfo.getName(), TrainCommonUtils.collectionToStrings(repeatInstructors, "\u3001")));
                }
            }
        }
    }

    private boolean setDataToRow(TrainCourseInfo trainCourseInfo, TrainInstructorInfo instructorInfo) {
        if (this.checkDataRepeat(trainCourseInfo, instructorInfo)) {
            return false;
        }
        IRow row = this.kdtE1.addRow();
        row.getCell(COURSE).setValue((Object)trainCourseInfo);
        row.getCell("TrainCourseNumb").setValue((Object)trainCourseInfo.getNumber());
        row.getCell("CourseHour").setValue((Object)trainCourseInfo.getCourseHour());
        row.getCell("CourseHourUnit").setValue((Object)trainCourseInfo.getCourseHourUnit());
        row.getCell("CourseJoinner").setValue((Object)trainCourseInfo.getCourseJoinner());
        row.getCell("Traincoursetarg").setValue((Object)trainCourseInfo.getCourseTarget());
        row.getCell("TraincourseType").setValue((Object)trainCourseInfo.getTreeid());
        row.getCell("TraincourseKind").setValue((Object)trainCourseInfo.getCourseKind());
        if (trainCourseInfo.getCourseCost() != null) {
            row.getCell("ChargeStand").setValue((Object)trainCourseInfo.getCourseCost().setScale(TrainClientUtil.PRECISION, 4).toString());
        }
        row.getCell(INSTRUCTOR).setValue((Object)instructorInfo);
        return true;
    }

    private boolean checkDataRepeat(TrainCourseInfo trainCourseInfo, TrainInstructorInfo instructorInfo) {
        boolean result = false;
        IRow row = null;
        TrainCourseInfo rowCourseInfo = null;
        TrainInstructorInfo rowInstructorInfo = null;
        int count = this.kdtE1.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.kdtE1.getRow(i);
            rowCourseInfo = (TrainCourseInfo)row.getCell(COURSE).getValue();
            rowInstructorInfo = (TrainInstructorInfo)row.getCell(INSTRUCTOR).getValue();
            if (TrainCommonUtils.isEmpty((CoreBaseInfo)rowCourseInfo) || TrainCommonUtils.isEmpty((CoreBaseInfo)rowInstructorInfo) || !trainCourseInfo.getId().equals((Object)rowCourseInfo.getId()) || !instructorInfo.getId().equals((Object)rowInstructorInfo.getId())) continue;
            result = true;
            break;
        }
        return result;
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.addLine(this.kdtE1);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.insertLine(this.kdtE1);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.kdtE1);
        int[] index = TrainHelper.getSelectedRows(this.kdtE1);
        if (index.length == 0) {
            return;
        }
        Arrays.sort(index);
        for (int i = index.length - 1; i >= 0; --i) {
            IRow row = this.kdtE1.getRow(index[i]);
            if (row.getCell("e1.id").getValue() == null) continue;
            this.delE1IDSet.add(row.getCell("e1.id").getValue().toString());
        }
        TrainUtils.removeLine(this.kdtE1);
    }

    protected void kdtE1_editStopped(KDTEditEvent e) throws Exception {
        if (e.getRowIndex() >= 0 && "TrainCourse".equalsIgnoreCase(this.kdtE1.getColumn(e.getColIndex()).getKey())) {
            this.kdtE1.getCell(e.getRowIndex(), "CourseHour").setValue(UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtE1.getCell(e.getRowIndex(), "TrainCourse").getValue()), (String)"CourseHour"));
            this.kdtE1.getCell(e.getRowIndex(), "CourseHourUnit").setValue(UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtE1.getCell(e.getRowIndex(), "TrainCourse").getValue()), (String)"CourseHourUnit"));
            this.kdtE1.getCell(e.getRowIndex(), "CourseJoinner").setValue(UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtE1.getCell(e.getRowIndex(), "TrainCourse").getValue()), (String)"CourseJoinner"));
            BigDecimal chargeStand = (BigDecimal)UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtE1.getCell(e.getRowIndex(), "TrainCourse").getValue()), (String)"courseCost");
            this.kdtE1.getCell(e.getRowIndex(), "ChargeStand").setValue(chargeStand != null ? chargeStand.setScale(TrainClientUtil.PRECISION, 4).toString() : null);
            this.setHourAndHourUnit(e.getRowIndex());
            this.kdtE1.getCell(e.getRowIndex(), "TrainCourseNumb").setValue(UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtE1.getCell(e.getRowIndex(), "TrainCourse").getValue()), (String)"number"));
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        String notDelMessage = ChannelCoursE1Factory.getRemoteInstance().batchForE1(this.e1Collection, this.delE1IDSet);
        if (notDelMessage != null) {
            MsgBox.showInfo((String)notDelMessage);
        } else {
            TrainClientUtil.showMessage(RES1, "batchSaveSuccess", this);
        }
        this.putDateToTable();
    }

    protected boolean checkBeforeWindowClosing() {
        this.checkModify(null);
        return super.checkBeforeWindowClosing();
    }

    private void checkModify(PreChangeEvent event) {
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.operateYes();
            } else if (result == 2) {
                if (event != null) {
                    event.setResult(0);
                } else {
                    SysUtil.abort();
                }
            }
        }
    }

    private void operateYes() {
        ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
        this.actionSave.actionPerformed(event);
        if (this.actionSave.isInvokeFailed()) {
            SysUtil.abort();
        }
    }

    private boolean isModify() {
        this.getDateFromTable();
        if (!this.delE1IDSet.isEmpty()) {
            return true;
        }
        if (this.e1HistoryMap.size() != this.kdtE1.getRowCount()) {
            return true;
        }
        if (this.e1HistoryMap.size() == 0 && this.kdtE1.getRowCount() == 0) {
            return false;
        }
        if (this.e1HistoryMap.size() != 0 && this.kdtE1.getRowCount() == 0) {
            return true;
        }
        if (this.e1Collection.size() > 0) {
            for (int i = 0; i < this.e1Collection.size(); ++i) {
                ChannelCoursE1Info e1Info = this.e1Collection.get(i);
                if (this.e1HistoryMap.containsKey(e1Info.getId().toString())) {
                    if (ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)e1Info, (AbstractObjectValue)((AbstractObjectValue)this.e1HistoryMap.get(e1Info.getId().toString())))) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }
}

