/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.ChannelCoursFactory;
import com.kingdee.eas.hr.train.ChannelCoursInfo;
import com.kingdee.eas.hr.train.client.AbstractChannelCoursListUI;
import com.kingdee.eas.hr.train.client.ChannelCoursEditUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ChannelCoursListUI
extends AbstractChannelCoursListUI {
    private static final Logger logger = CoreUIObject.getLogger(ChannelCoursListUI.class);
    private static final String resourcePath = "com.kingdee.eas.hr.train.client.TrainSysResource";
    FilterInfo filterInfo = null;
    String[] visible;
    String[] disVisible;
    String flag;

    protected String getEditUIName() {
        return ChannelCoursEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ChannelCoursFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        ChannelCoursInfo objectValue = new ChannelCoursInfo();
        return objectValue;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        if (this.filterInfo != null && this.filterInfo.getFilterItems().size() > 0) {
            FilterInfo filterForQuery = this.filterInfo;
            try {
                filterForQuery.mergeFilter(TrainUtils.getCUFilterForQuery(), "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            return filterForQuery;
        }
        return TrainUtils.getCurrentCUFilter();
    }

    public void onLoad() throws Exception {
        this.fetchUIContext();
        super.onLoad();
        this.initTableCellPaintFormat();
        this.initTable();
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                boolean isOuter;
                String trainChannelSupplierType = rowSet.getString("trainChanneCategory.name");
                String trainChannelName = rowSet.getString("Trainchannel.name");
                String courseHour = null;
                if (trainChannelSupplierType != null && trainChannelName != null) {
                    rowSet.updateString("channelCourse", trainChannelSupplierType + " - " + trainChannelName);
                }
                if (isOuter = rowSet.getBoolean("Instructor.IsOuter")) {
                    rowSet.updateString("instructorType", EASResource.getString((String)resourcePath, (String)"OuterInstructor"));
                } else {
                    rowSet.updateString("instructorType", EASResource.getString((String)resourcePath, (String)"InnerInstructor"));
                }
                courseHour = rowSet.getBigDecimal("TrainCourse.CourseHour") != null ? TrainClientUtil.formatBigDecimal(rowSet.getBigDecimal("TrainCourse.CourseHour"), 2) : "0.00";
                String courseUnit = rowSet.getString("TrainCourse.CourseHourUnit");
                rowSet.updateString("courseAndUnit", courseHour + courseUnit);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    private void initTable() {
        if ("course".equals(this.flag)) {
            this.tblMain.getColumn("E1_TrainCourse").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("trainCourseNumber").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("courseTarget").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("courseType").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("courseKind").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("HourAndHourUnit").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("CourseJoinner").getStyleAttributes().setHided(true);
        } else if ("instructor".equals(this.flag)) {
            this.tblMain.getColumn("E1_Instructor").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("channelCourse").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("instructorType").getStyleAttributes().setHided(true);
        }
    }

    private void initTableCellPaintFormat() {
        this.tblMain.setUserCellDisplayParser(new IUserCellDisplayParser(){

            public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
                int hourAndHourUnitColumn = ChannelCoursListUI.this.tblMain.getColumnIndex("HourAndHourUnit");
                if (colIndex == hourAndHourUnitColumn - 2 && rowIndex >= 0) {
                    ChannelCoursListUI.this.setHourAndHourUnit(rowIndex);
                }
                return value;
            }
        });
    }

    private void setHourAndHourUnit(int rowIndex) {
        if (this.tblMain.getRow(rowIndex).getCell("CourseHour").getValue() == null || this.tblMain.getRow(rowIndex).getCell("CourseHourUnit").getValue() == null) {
            return;
        }
        String str = TrainClientUtil.formatBigDecimal((BigDecimal)this.tblMain.getRow(rowIndex).getCell("CourseHour").getValue(), 2);
        if (str == null) {
            str = "0";
        }
        str = str + this.tblMain.getRow(rowIndex).getCell("CourseHourUnit").getValue().toString();
        this.tblMain.getRow(rowIndex).getCell("HourAndHourUnit").setValue((Object)str);
    }

    private void fetchUIContext() {
        this.filterInfo = (FilterInfo)this.getUIContext().get("filter");
        this.visible = (String[])this.getUIContext().get("visible");
        this.disVisible = (String[])this.getUIContext().get("disVisible");
        this.flag = this.getUIContext().get("flag").toString();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }
}

