/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.train.EquipmentByTrainActCollection;
import com.kingdee.eas.hr.train.EquipmentByTrainActFactory;
import com.kingdee.eas.hr.train.EquipmentByTrainActInfo;
import com.kingdee.eas.hr.train.IEquipmentByTrainAct;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainEquipmentInfo;
import com.kingdee.eas.hr.train.client.AbstractEquipmentForActUI;
import com.kingdee.eas.hr.train.client.TrainEquipmentMultiPromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class EquipmentForActUI
extends AbstractEquipmentForActUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentForActUI.class);
    private String trainActivityId;
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainHolidayResource";
    private static final String TRAINRESOURCE = "com.kingdee.eas.hr.train.TrainResource";
    private static final String deleteEquipmentTrainAct = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"deleteEquipmentTrainAct");
    private static final String equipmentCountMustUpZero = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"EQUIPMENTCOUNTMUSTUPZERO");
    public static final Color KDTABLE_TOTAL_BG_COLOR = new Color(217, 217, 214);
    private Map historys = new HashMap();
    private int countEquipmentByTrainAct = 0;

    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        TrainEquipmentMultiPromptBox trainEquipment = new TrainEquipmentMultiPromptBox((IUIObject)this);
        trainEquipment.show();
        if (!trainEquipment.isCanceled() && trainEquipment.getData() instanceof Object[]) {
            Object[] obj = (Object[])trainEquipment.getData();
            TrainEquipmentInfo equipmentInfo = null;
            EquipmentByTrainActCollection equipmentByTrainActCollection = new EquipmentByTrainActCollection();
            EquipmentByTrainActInfo equipmentByTrainActInfo = null;
            TrainActivityInfo activityInfo = new TrainActivityInfo();
            activityInfo.setId(BOSUuid.read((String)this.trainActivityId));
            for (int i = 0; i < obj.length; ++i) {
                equipmentByTrainActInfo = new EquipmentByTrainActInfo();
                equipmentInfo = (TrainEquipmentInfo)obj[i];
                equipmentByTrainActInfo.setTrainEquipment(equipmentInfo);
                equipmentByTrainActInfo.setTrainActivity(activityInfo);
                if (equipmentInfo.getCount() != null) {
                    equipmentByTrainActInfo.setCount(equipmentInfo.getCount().intValue());
                }
                equipmentByTrainActCollection.add(equipmentByTrainActInfo);
            }
            this.fillTable(equipmentByTrainActCollection);
        }
        this.setComponentsState();
    }

    private boolean checkIfRefered(String equipmentId) {
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            String equipmentIdInTable = (String)row.getCell("equipmentId").getValue();
            if (equipmentIdInTable == null || !equipmentIdInTable.equals(equipmentId)) continue;
            return true;
        }
        return false;
    }

    private void fillTable(EquipmentByTrainActCollection equipmentByTrainActCollection) throws Exception {
        this.tblMain.setEditable(true);
        EquipmentByTrainActInfo equipmentByTrainActInfo = null;
        TrainEquipmentInfo trainEquipment = null;
        IRow row = null;
        this.countEquipmentByTrainAct = equipmentByTrainActCollection.size();
        int size = equipmentByTrainActCollection.size();
        for (int i = 0; i < size; ++i) {
            equipmentByTrainActInfo = equipmentByTrainActCollection.get(i);
            trainEquipment = equipmentByTrainActInfo.getTrainEquipment();
            if (this.checkIfRefered(trainEquipment.getId().toString())) continue;
            row = this.tblMain.addRow();
            row.setUserObject((Object)equipmentByTrainActInfo);
            if (equipmentByTrainActInfo.getId() != null) {
                row.getCell("actID").setValue((Object)equipmentByTrainActInfo.getId().toString());
            }
            row.getCell("equipmentId").setValue((Object)trainEquipment.getId().toString());
            row.getCell("number").setValue((Object)trainEquipment.getNumber());
            row.getCell("name").setValue((Object)trainEquipment.getName());
            row.getCell("unit").setValue((Object)trainEquipment.getUnit());
            row.getCell("count").setValue((Object)equipmentByTrainActInfo.getCount());
            row.getCell("trainChannel").setValue(trainEquipment.getTrainChannel() == null ? null : trainEquipment.getTrainChannel().getName());
            row.getCell("introduce").setValue((Object)trainEquipment.getIntroduce());
            row.getCell("keepAdd").setValue((Object)trainEquipment.getKeepAddress());
            row.getCell("keeper").setValue((Object)trainEquipment.getKeeper());
            row.getCell("trainEquipmentCate").setValue((Object)trainEquipment.getTreeid().getName());
            this.historys.put(trainEquipment.getId().toString(), equipmentByTrainActInfo.getCount());
        }
    }

    private boolean confirmRemoveEnable() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)deleteEquipmentTrainAct));
    }

    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        if (this.confirmRemoveEnable()) {
            List selectRowList = TrainUtils.getSelectedRows(this.tblMain);
            Arrays.sort(selectRowList.toArray());
            IRow row = null;
            HashSet<String> idSet = new HashSet<String>();
            for (int i = selectRowList.size() - 1; i >= 0; --i) {
                int rowIndex = (Integer)selectRowList.get(i);
                row = this.tblMain.getRow(rowIndex);
                if (row.getCell("actID").getValue() == null) {
                    this.tblMain.removeRow(rowIndex);
                    continue;
                }
                String id = (String)row.getCell("actID").getValue();
                if (id != null) {
                    idSet.add(id);
                }
                this.tblMain.removeRow(rowIndex);
                this.historys.remove((String)row.getCell("equipmentId").getValue());
            }
            if (idSet.size() > 0) {
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                IEquipmentByTrainAct equipmentByTrainAct = EquipmentByTrainActFactory.getRemoteInstance();
                equipmentByTrainAct.delete(fi);
            }
        }
        this.setComponentsState();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.checkModify();
        this.showData();
    }

    protected void tblMain_editStopping(KDTEditEvent e) throws Exception {
        IRow row;
        if (e.getColIndex() == this.tblMain.getColumnIndex("count") && (row = this.tblMain.getRow(e.getRowIndex())).getCell("count").getValue() != null) {
            String count = row.getCell("count").getValue().toString();
            if (count == null) {
                e.setValue(null);
            } else if (count.indexOf("-") >= 0) {
                e.setValue((Object)"0");
            }
        }
    }

    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        IRow row;
        if (e.getColIndex() == this.tblMain.getColumnIndex("count") && (row = this.tblMain.getRow(e.getRowIndex())).getCell("count").getValue() != null) {
            String count = row.getCell("count").getValue().toString();
            if (count == null) {
                e.setValue(null);
            } else if (count.indexOf("-") >= 0) {
                e.setValue((Object)"0");
            }
        }
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        IRow row;
        if (e.getColIndex() == this.tblMain.getColumnIndex("count") && (row = this.tblMain.getRow(e.getRowIndex())).getCell("count").getValue() != null) {
            String count = row.getCell("count").getValue().toString();
            if (count == null) {
                e.setValue(null);
            } else if (count.indexOf("-") >= 0) {
                e.setValue((Object)"0");
                row.getCell("count").setValue((Object)"0");
                MsgBox.showConfirm2((String)equipmentCountMustUpZero);
            }
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        IEquipmentByTrainAct equipmentByTrainAct = EquipmentByTrainActFactory.getRemoteInstance();
        EquipmentByTrainActCollection equipmentByTrainActCollection = null;
        EquipmentByTrainActInfo equipmentByTrainActInfo = null;
        IRow row = null;
        TrainActivityInfo activityInfo = new TrainActivityInfo();
        activityInfo.setId(BOSUuid.read((String)this.trainActivityId));
        TrainEquipmentInfo trainEquipmentInfo = null;
        equipmentByTrainActCollection = new EquipmentByTrainActCollection();
        for (int t = 0; t < this.tblMain.getRowCount(); ++t) {
            equipmentByTrainActInfo = new EquipmentByTrainActInfo();
            trainEquipmentInfo = new TrainEquipmentInfo();
            row = this.tblMain.getRow(t);
            if (row.getCell("actID").getValue() != null) {
                equipmentByTrainActInfo.setId(BOSUuid.read((String)row.getCell("actID").getValue().toString()));
            }
            trainEquipmentInfo.setId(BOSUuid.read((String)row.getCell("equipmentId").getValue().toString()));
            equipmentByTrainActInfo.setTrainActivity(activityInfo);
            equipmentByTrainActInfo.setTrainEquipment(trainEquipmentInfo);
            if (row.getCell("count").getValue() != null) {
                if (row.getCell("count").getValue().toString().equals("0")) {
                    equipmentByTrainActInfo.setCount(Integer.parseInt("0"));
                } else {
                    equipmentByTrainActInfo.setCount(new BigDecimal(row.getCell("count").getValue().toString()).setScale(2).intValue());
                }
            } else {
                row.getCell("count").setValue((Object)"0");
                equipmentByTrainActInfo.setCount(Integer.parseInt("0"));
            }
            equipmentByTrainActCollection.add(equipmentByTrainActInfo);
        }
        equipmentByTrainAct.addBatch(equipmentByTrainActCollection);
        String message = EASResource.getString((String)TRAINRESOURCE, (String)"Success");
        MsgBox.showInfo((Component)((Object)this), (String)(this.getUITitle() + " " + message));
        this.tblMain.removeRows();
        this.showData();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAdd.setEnabled(true);
        this.btnDel.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.btnSave.setEnabled(true);
        this.tblMain.checkParsed();
        KDFormattedTextField txtPeriods = new KDFormattedTextField();
        this.tblMain.getColumn("count").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtPeriods));
        this.tblMain.getSelectManager().setSelectMode(10);
        this.trainActivityId = (String)this.getUIContext().get("ID");
        this.fillTable();
        this.initWorkButton();
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("trainChannel").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("unit").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("introduce").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("keepAdd").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("keeper").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("trainEquipmentCate").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("name").getStyleAttributes().setBackground(KDTABLE_TOTAL_BG_COLOR);
        this.tblMain.getColumn("number").getStyleAttributes().setBackground(KDTABLE_TOTAL_BG_COLOR);
        this.tblMain.getColumn("unit").getStyleAttributes().setBackground(KDTABLE_TOTAL_BG_COLOR);
        this.tblMain.getColumn("trainChannel").getStyleAttributes().setBackground(KDTABLE_TOTAL_BG_COLOR);
        this.tblMain.getColumn("introduce").getStyleAttributes().setBackground(KDTABLE_TOTAL_BG_COLOR);
        this.tblMain.getColumn("keepAdd").getStyleAttributes().setBackground(KDTABLE_TOTAL_BG_COLOR);
        this.tblMain.getColumn("keeper").getStyleAttributes().setBackground(KDTABLE_TOTAL_BG_COLOR);
        this.tblMain.getColumn("trainEquipmentCate").getStyleAttributes().setBackground(KDTABLE_TOTAL_BG_COLOR);
        this.setComponentsState();
    }

    private void setComponentsState() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAdd.setEnabled(false);
            this.btnDel.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.tblMain.getStyleAttributes().setLocked(true);
        } else {
            this.btnAdd.setEnabled(true);
            this.btnDel.setEnabled(true);
            this.btnSave.setEnabled(this.tblMain.getRowCount() > 0);
            this.tblMain.getStyleAttributes().setLocked(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    private void fillTable() throws BOSException, SQLException {
        for (int k = this.tblMain.getRowCount(); k >= 0; --k) {
            this.tblMain.removeRow(k);
        }
        this.historys.clear();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)((String)this.getUIContext().get("ID"))));
        viewInfo.setFilter(filter);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "EquipmentByTrainActQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery();
        rowSet.beforeFirst();
        this.countEquipmentByTrainAct = rowSet.size();
        while (rowSet.next()) {
            IRow row = this.tblMain.addRow();
            ICell cell = row.getCell(0);
            cell.setValue((Object)rowSet.getString("id"));
            cell = row.getCell(1);
            cell.setValue((Object)rowSet.getString("TrainEquipment.id"));
            cell = row.getCell(2);
            cell.setValue((Object)rowSet.getString("TrainEquipment.number"));
            cell = row.getCell(3);
            cell.setValue((Object)rowSet.getString("TrainEquipment.name"));
            if (rowSet.getString("count") != null) {
                cell = row.getCell(4);
                cell.setValue((Object)rowSet.getString("count"));
                this.historys.put(rowSet.getString("TrainEquipment.id"), rowSet.getString("count"));
            } else {
                this.historys.put(rowSet.getString("TrainEquipment.id"), "0");
            }
            if (rowSet.getString("TrainEquipment.Unit") != null) {
                cell = row.getCell(5);
                cell.setValue((Object)rowSet.getString("TrainEquipment.Unit"));
            }
            if (rowSet.getString("trainChannel.name") != null) {
                cell = row.getCell(6);
                cell.setValue((Object)rowSet.getString("trainChannel.name"));
            }
            if (rowSet.getString("TrainEquipment.Introduce") != null) {
                cell = row.getCell(7);
                cell.setValue((Object)rowSet.getString("TrainEquipment.Introduce"));
            }
            if (rowSet.getString("TrainEquipment.KeepAddress") != null) {
                cell = row.getCell(8);
                cell.setValue((Object)rowSet.getString("TrainEquipment.KeepAddress"));
            }
            if (rowSet.getString("TrainEquipment.Keeper") != null) {
                cell = row.getCell(9);
                cell.setValue((Object)rowSet.getString("TrainEquipment.Keeper"));
            }
            if (rowSet.getString("tree.name") == null) continue;
            cell = row.getCell(10);
            cell.setValue((Object)rowSet.getString("tree.name"));
        }
        rowSet.beforeFirst();
        this.setComponentsState();
    }

    protected boolean checkBeforeWindowClosing() {
        this.checkModify();
        return super.checkBeforeWindowClosing();
    }

    private void checkModify() {
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.operateYes();
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    private void operateYes() {
        ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
        this.ActionSave.actionPerformed(event);
        if (this.ActionSave.isInvokeFailed()) {
            SysUtil.abort();
        }
    }

    private boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        if (this.countEquipmentByTrainAct != this.tblMain.getRowCount()) {
            return true;
        }
        IRow row = null;
        String equipmentId = null;
        String count = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            equipmentId = row.getCell("equipmentId").getValue().toString();
            count = row.getCell("count").getValue() != null ? row.getCell("count").getValue().toString() : "0";
            if (count.equals(this.historys.get(equipmentId).toString())) continue;
            return true;
        }
        return false;
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("trainActivityId", this.getUIContext().get("ID"));
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public boolean isPrepareInit() {
        return true;
    }

    private void showData() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((String)this.getUIContext().get("ID"))));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainActivity.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainActivity.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainEquipment.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainEquipment.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainEquipment.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainEquipment.Unit"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainEquipment.Keeper"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainEquipment.Count"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainEquipment.KeepAddress"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainEquipment.Introduce"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainEquipment.description"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainEquipment.treeid.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainEquipment.treeid.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainEquipment.trainChannel.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("count"));
        IEquipmentByTrainAct iEquipmentByTrainAct = EquipmentByTrainActFactory.getRemoteInstance();
        EquipmentByTrainActCollection coll = iEquipmentByTrainAct.getEquipmentByTrainActCollection(viewInfo);
        this.fillTable(coll);
    }
}

