/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.train.PersonCheckUpFactory;
import com.kingdee.eas.hr.train.PersonCheckUpInfo;
import com.kingdee.eas.hr.train.client.AbstractPersonCheckUpListUI;
import com.kingdee.eas.hr.train.client.PersonCheckUpEditUI;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class PersonCheckUpListUI
extends AbstractPersonCheckUpListUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonCheckUpListUI.class);
    private EmployeeTreeEditUI treeEditUI = null;

    public PersonCheckUpListUI() throws Exception {
        this.tblMain.checkParsed();
    }

    public void onLoad() throws Exception {
        this.treeEditUI = (EmployeeTreeEditUI)this.getUIContext().get("GroupListEditUI");
        super.onLoad();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.treeEditUI.curEmpID, CompareType.EQUALS));
        return filter;
    }

    public void refreshList() throws Exception {
        this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        super.refreshList();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"PersonID", (Object)this.treeEditUI.curEmpID);
        uiContext.put((Object)"currentHRO", (Object)this.treeEditUI.getMainBizOrgInfo());
    }

    protected String getEditUIName() {
        return PersonCheckUpEditUI.class.getName();
    }

    protected IObjectValue createNewData() {
        PersonCheckUpInfo objectValue = new PersonCheckUpInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PersonCheckUpFactory.getRemoteInstance();
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2 && this.getUIContext().get("NO_PERMISSION") != null) {
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            this.actionView_actionPerformed(evt);
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(EmployeeClientUtils.getCurrentHRO((EmployeeTreeEditUI)this.treeEditUI).getId());
    }
}

