/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.train.QuertionInquiryTreeFactory;
import com.kingdee.eas.hr.train.QuertionInquiryTreeInfo;
import com.kingdee.eas.hr.train.QuestionInquiryFactory;
import com.kingdee.eas.hr.train.QuestionInquiryFormFactory;
import com.kingdee.eas.hr.train.QuestionInquiryFormInfo;
import com.kingdee.eas.hr.train.QuestionSmodeEnum;
import com.kingdee.eas.hr.train.client.AbstractQuestionInquiryListUI;
import com.kingdee.eas.hr.train.client.QuestionInquiryEditUI;
import com.kingdee.eas.hr.train.client.QuestionInquiryFormNotUI;
import com.kingdee.eas.hr.train.client.QuestionInquiryFormUI;
import com.kingdee.eas.hr.train.client.QuestionInquiryTreeEditUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class QuestionInquiryListUI
extends AbstractQuestionInquiryListUI {
    private static final Logger logger = CoreUIObject.getLogger(QuestionInquiryListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainResource";

    public void onLoad() throws Exception {
        this.menuItemGroupAddNew.setAccelerator(KeyStroke.getKeyStroke("ctrl alt N"));
        super.onLoad();
        this.btnBrowse.setIcon(EASResource.getIcon((String)"imgTbtn_seechecklist"));
    }

    public void storeFields() {
        super.storeFields();
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return EASResource.getString((String)RESOURCE, (String)"QuestionInquiryTreeType");
    }

    protected String getGroupEditUIName() {
        return QuestionInquiryTreeEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected FilterInfo getDefaultFilterForTree() {
        return TrainUtils.getCurrentHRFilter("HROrgUnit.id");
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return QuertionInquiryTreeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return QuestionInquiryEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QuestionInquiryFactory.getRemoteInstance();
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.hasItems()) {
            TrainClientUtil.showErrorMessage(RESOURCE, "HasQuestionInquiry", (CoreUI)this);
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    private boolean hasItems() throws EASBizException, BOSException {
        boolean result = false;
        KDTreeNode node = (KDTreeNode)this.treeMain.getSelectionPath().getLastPathComponent();
        if (node != null && node.getUserObject() instanceof QuertionInquiryTreeInfo) {
            QuertionInquiryTreeInfo itemTree = (QuertionInquiryTreeInfo)node.getUserObject();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)itemTree.getId().toString()));
            if (QuestionInquiryFactory.getRemoteInstance().exists(filterInfo)) {
                result = true;
            }
        }
        return result;
    }

    public void actionBrowse_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String questionInquiryId = this.getSelectedKeyValue();
        if (questionInquiryId != null) {
            QuestionInquiryFormInfo info = QuestionInquiryFormFactory.getRemoteInstance().getQuestionInquForm(questionInquiryId);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"InitDataObject", (Object)info);
            uiContext.put((Object)"flag", (Object)"flag");
            IUIWindow questionInquiryFormUI = null;
            questionInquiryFormUI = QuestionSmodeEnum.UNITE.equals((Object)this.getSelectedState()) ? uiFactory.create(QuestionInquiryFormUI.class.getName(), (Map)uiContext) : uiFactory.create(QuestionInquiryFormNotUI.class.getName(), (Map)uiContext);
            questionInquiryFormUI.show();
        }
    }

    private QuestionSmodeEnum getSelectedState() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("unite");
            Object keyValue = cell.getValue();
            if (keyValue == null) {
                return null;
            }
            BizEnumValueInfo enumInfo = (BizEnumValueInfo)keyValue;
            return QuestionSmodeEnum.getEnum(enumInfo.getInt());
        }
        return null;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"IsReference_QuestionInquiry"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    private boolean isRefered() throws Exception {
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return false;
        }
        return QuestionInquiryFactory.getRemoteInstance().isReferen(id);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterItemCollection filterItemCollection = viewInfo.getFilter().getFilterItems();
        FilterItemInfo filterItemInfo = null;
        Object compareValue = null;
        int size = filterItemCollection.size();
        for (int i = 0; i < size; ++i) {
            filterItemInfo = filterItemCollection.get(i);
            compareValue = filterItemInfo.getCompareValue();
            if (compareValue == null || compareValue.toString().indexOf("NONE") == -1) continue;
            filterItemInfo.setCompareValue(null);
        }
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        return exec;
    }
}

