/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.train.RequirementFacadeFactory;
import com.kingdee.eas.hr.train.RequirementIssueEntryFactory;
import com.kingdee.eas.hr.train.RequirementResponseFactory;
import com.kingdee.eas.hr.train.RequirementResponseInfo;
import com.kingdee.eas.hr.train.client.AbstractReqResponseDetailUI;
import com.kingdee.eas.hr.train.client.RequirementClientUtil;
import com.kingdee.eas.hr.train.client.RequirementResponsePublisherUI;
import com.kingdee.eas.hr.train.client.RequirementResponseSummaryFilterUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReqResponseDetailUI
extends AbstractReqResponseDetailUI {
    private boolean isMultiPublish = false;
    private String requirementId;
    private Set responserIds;
    private FilterInfo mainFilterInfo = null;
    private String COLUMN_ORG_NAME = "orgName";
    private String COLUMN_POSITION_NAME = "positionName";
    private String COLUMN_RESPONSER_NAME = "responserName";
    private int ORGNAME_COLUMNINDEX = 0;
    private int POSITIONNAME_COLUMNINDEX = 1;
    private int RESPONSERNAME_COLUMNINDEX = 2;
    private static final String RESOURCE = "com.kingdee.eas.hr.train.RequirementResource";
    private String orgNameAlias = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"ORGNAME");
    private String positionNameAlias = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"POSITIONNAME");
    private String responserNameAlias = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"RESPONSERNAME");
    private String HIGH_COUNT = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"HIGH_COUNT");
    private String MIDDLE_COUNT = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"MIDDLE_COUNT");
    private String LOW_COUNT = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"LOW_COUNT");
    private int startColumn;
    private int endColumn;
    private int COLUMN_WIDTH = 0;
    private int HEADROW_COUNT = 0;
    private int addColumnCount = 0;
    private Styles.HorizontalAlignment alignment = null;
    private CommonQueryDialog dialog = null;
    private static final Logger logger = CoreUIObject.getLogger(ReqResponseDetailUI.class);

    public void onLoad() throws Exception {
        this.setIsNeedDefaultFilter(false);
        this.requirementId = (String)this.getUIContext().get("requirement");
        this.responserIds = (Set)this.getUIContext().get("responserIds");
        this.isMultiPublish = this.isMultiPublish();
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.mainFilterInfo = this.getDefaultFilterForQuery();
        if (this.isMultiPublish) {
            this.HEADROW_COUNT = 4;
            this.COLUMN_WIDTH = 30;
            this.alignment = Styles.HorizontalAlignment.RIGHT;
            this.addColumnCount = 3;
        } else {
            this.HEADROW_COUNT = 3;
            this.COLUMN_WIDTH = 100;
            this.alignment = Styles.HorizontalAlignment.CENTER;
            this.addColumnCount = 1;
        }
        this.fillTable();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewResponse.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.actionViewResponse.setEnabled(true);
    }

    private boolean isMultiPublish() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)this.requirementId));
        if (this.responserIds != null) {
            HashSet<String> secResponserIds = new HashSet<String>();
            for (String responserId : this.responserIds) {
                if (responserId.equals(TrainUtils.getCurrentPersonId())) continue;
                secResponserIds.add(responserId);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.publisher.id", secResponserIds, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(20)));
        try {
            return RequirementIssueEntryFactory.getRemoteInstance().exists(filterInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return false;
    }

    private void fillTable() throws Exception {
        this.tblMain.removeHeadRows();
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        IRowSet rowSet = RequirementFacadeFactory.getRemoteInstance().getResponseDetail(this.mainFilterInfo);
        this.initTableHead();
        while (rowSet.next()) {
            int rowIndex = this.getRowIndex(rowSet);
            int columnIndex = this.getColumnIndex(rowSet);
            this.fillRowData(rowSet, rowIndex, columnIndex);
        }
        this.mergeTableHead();
        this.mergeTable();
        this.tblMain.getGroupManager().group();
    }

    private void initTableHead() {
        IRow headRow = null;
        IColumn column = this.tblMain.addColumn();
        column.setKey(this.COLUMN_ORG_NAME);
        column = this.tblMain.addColumn();
        column.setKey(this.COLUMN_POSITION_NAME);
        column = this.tblMain.addColumn();
        column.setKey(this.COLUMN_RESPONSER_NAME);
        for (int i = 0; i < this.HEADROW_COUNT; ++i) {
            headRow = this.tblMain.addHeadRow();
            headRow.getCell(this.ORGNAME_COLUMNINDEX).setValue((Object)this.orgNameAlias);
            headRow.getCell(this.POSITIONNAME_COLUMNINDEX).setValue((Object)this.positionNameAlias);
            headRow.getCell(this.RESPONSERNAME_COLUMNINDEX).setValue((Object)this.responserNameAlias);
        }
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        mm.mergeBlock(0, this.ORGNAME_COLUMNINDEX, this.HEADROW_COUNT - 1, this.ORGNAME_COLUMNINDEX);
        mm.mergeBlock(0, this.POSITIONNAME_COLUMNINDEX, this.HEADROW_COUNT - 1, this.POSITIONNAME_COLUMNINDEX);
        mm.mergeBlock(0, this.RESPONSERNAME_COLUMNINDEX, this.HEADROW_COUNT - 1, this.RESPONSERNAME_COLUMNINDEX);
    }

    private int getRowIndex(IRowSet rowSet) throws SQLException {
        String responserId = rowSet.getString("responserId");
        IRow row = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            if (!responserId.equals(row.getUserObject())) continue;
            return i;
        }
        row = this.tblMain.addRow();
        row.setUserObject((Object)responserId);
        row.getCell(this.ORGNAME_COLUMNINDEX).setValue((Object)rowSet.getString("adminOrgUnitName"));
        row.getCell(this.POSITIONNAME_COLUMNINDEX).setValue((Object)rowSet.getString("positionName"));
        row.getCell(this.RESPONSERNAME_COLUMNINDEX).setValue((Object)rowSet.getString("responserName"));
        return this.tblMain.getRowCount() - 1;
    }

    private int getColumnIndex(IRowSet rowSet) throws SQLException {
        String type = RequirementClientUtil.transformType(rowSet.getString("type"));
        String contentType = rowSet.getString("contentType");
        String contentName = rowSet.getString("contentName");
        this.startColumn = this.RESPONSERNAME_COLUMNINDEX + 1;
        this.endColumn = this.tblMain.getColumnCount();
        boolean flag = this.assertColumnPosition(type, this.tblMain.getHeadRow(0));
        if (!flag) {
            flag = this.assertColumnPosition(contentType, this.tblMain.getHeadRow(1));
        }
        if (!flag) {
            this.assertColumnPosition(contentName, this.tblMain.getHeadRow(2));
        }
        for (int i = this.startColumn; i < this.endColumn; ++i) {
            this.tblMain.getHeadRow(0).getCell(i).setValue((Object)type);
            this.tblMain.getHeadRow(1).getCell(i).setValue((Object)contentType);
            this.tblMain.getHeadRow(2).getCell(i).setValue((Object)contentName);
        }
        if (this.isMultiPublish) {
            int index = 0;
            for (int i = this.startColumn; i < this.endColumn; ++i) {
                if (index == 0) {
                    this.tblMain.getHeadRow(3).getCell(i).setValue((Object)this.HIGH_COUNT);
                } else if (index == 1) {
                    this.tblMain.getHeadRow(3).getCell(i).setValue((Object)this.MIDDLE_COUNT);
                } else if (index == 2) {
                    this.tblMain.getHeadRow(3).getCell(i).setValue((Object)this.LOW_COUNT);
                }
                ++index;
            }
        }
        return this.startColumn;
    }

    private boolean assertColumnPosition(String title, IRow headRow) {
        boolean flag = false;
        if (!this.existTableHead(title, headRow)) {
            this.startColumn = this.endColumn;
            this.endColumn += this.addColumnCount;
            IColumn column = null;
            for (int i = this.startColumn; i < this.endColumn; ++i) {
                column = this.tblMain.addColumn(i);
                column.setWidth(this.COLUMN_WIDTH);
                column.getStyleAttributes().setHorizontalAlign(this.alignment);
            }
            flag = true;
        }
        return flag;
    }

    private boolean existTableHead(String title, IRow headRow) {
        String value = null;
        boolean find = false;
        for (int i = this.startColumn; i < this.endColumn; ++i) {
            value = (String)headRow.getCell(i).getValue();
            if (value.equals(title)) {
                if (find) continue;
                this.startColumn = i;
                find = true;
                continue;
            }
            if (!find) continue;
            this.endColumn = i;
            break;
        }
        return find;
    }

    private void fillRowData(IRowSet rowSet, int rowIndex, int columnIndex) throws SQLException {
        IRow row = this.tblMain.getRow(rowIndex);
        if (this.isMultiPublish) {
            Integer count = rowSet.getInt("highCount") > 0 ? new Integer(rowSet.getInt("highCount")) : null;
            row.getCell(columnIndex++).setValue((Object)count);
            count = rowSet.getInt("middleCount") > 0 ? new Integer(rowSet.getInt("middleCount")) : null;
            row.getCell(columnIndex++).setValue((Object)count);
            count = rowSet.getInt("lowCount") > 0 ? new Integer(rowSet.getInt("lowCount")) : null;
            row.getCell(columnIndex).setValue((Object)count);
        } else {
            String value = null;
            value = rowSet.getInt("highCount") > 0 ? this.HIGH_COUNT : (rowSet.getInt("middleCount") > 0 ? this.MIDDLE_COUNT : this.LOW_COUNT);
            row.getCell(columnIndex).setValue((Object)value);
        }
    }

    private void mergeTableHead() {
        IRow headRow = null;
        IRow preHeadRow = null;
        String preValue = null;
        String curValue = null;
        String preTopValue = null;
        String curTopValue = null;
        int start = 0;
        int count = this.tblMain.getColumnCount();
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        for (int i = 0; i < this.HEADROW_COUNT - 1; ++i) {
            headRow = this.tblMain.getHeadRow(i);
            if (i > 0) {
                preHeadRow = this.tblMain.getHeadRow(i - 1);
            }
            preValue = null;
            for (int j = this.RESPONSERNAME_COLUMNINDEX + 1; j < count; ++j) {
                curValue = (String)headRow.getCell(j).getValue();
                if (preHeadRow != null) {
                    curTopValue = (String)preHeadRow.getCell(j).getValue();
                }
                if (preValue == null) {
                    preValue = curValue;
                    preTopValue = curTopValue;
                    start = j;
                }
                if (preValue.equals(curValue) && (preTopValue == null || preTopValue.equals(curTopValue))) continue;
                mm.mergeBlock(i, start, i, j - 1);
                preValue = curValue;
                preTopValue = curTopValue;
                start = j;
            }
            mm.mergeBlock(i, start, i, count - 1);
        }
    }

    protected void mergeTable() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn(this.COLUMN_ORG_NAME).setGroup(true);
        this.tblMain.getColumn(this.COLUMN_POSITION_NAME).setGroup(true);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirementId", (Object)this.requirementId));
        filterInfo.getFilterItems().add(new FilterItemInfo("responserId", (Object)this.responserIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(20)));
        return filterInfo;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog == null) {
            this.dialog = this.initCommonQueryDialog();
            this.dialog.setMaxReturnCountVisible(true);
        }
        if (this.dialog.show()) {
            this.tHelper.setDialog(this.dialog);
            this.mainFilterInfo = this.getEntityViewInfo(this.dialog.getEntityViewInfoResult()).getFilter();
            this.fillTable();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        try {
            this.getUIContext().put("responserIds", this.responserIds);
            RequirementResponseSummaryFilterUI filterUI = new RequirementResponseSummaryFilterUI(this.getUIContext());
            dialog.addUserPanel((KDPanel)filterUI);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "ResponseSuggestCourseQuery"));
        dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        return dialog;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillTable();
    }

    protected String getSelectedKeyValue() {
        IRow row;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int rowIndex = -1;
        if (selectRows.length > 0) {
            rowIndex = selectRows[0];
        }
        if ((row = this.tblMain.getRow(rowIndex)) != null) {
            String responserId = (String)row.getUserObject();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            try {
                RequirementResponseInfo responseInfo = RequirementResponseFactory.getRemoteInstance().getRequirementResponseInfo(this.requirementId, responserId, sic);
                if (responseInfo != null) {
                    return responseInfo.getId().toString();
                }
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    public void actionViewResponse_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RequirementResponseFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return RequirementResponsePublisherUI.class.getName();
    }

    protected String[] getLocateNames() {
        return new String[]{this.COLUMN_ORG_NAME, this.COLUMN_POSITION_NAME, this.COLUMN_RESPONSER_NAME};
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }
}

