/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.CodingRuleHelper;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.RequirementAssistant;
import com.kingdee.eas.hr.train.RequirementCourseTypeEnum;
import com.kingdee.eas.hr.train.RequirementEntryCollection;
import com.kingdee.eas.hr.train.RequirementEntryInfo;
import com.kingdee.eas.hr.train.RequirementFactory;
import com.kingdee.eas.hr.train.RequirementInfo;
import com.kingdee.eas.hr.train.RequirementIssueInfo;
import com.kingdee.eas.hr.train.RequirementStateEnum;
import com.kingdee.eas.hr.train.RequirementTypeEnum;
import com.kingdee.eas.hr.train.TrainAssistant;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainItemInfo;
import com.kingdee.eas.hr.train.TrainingMethodFactory;
import com.kingdee.eas.hr.train.client.AbstractRequirementEditUI;
import com.kingdee.eas.hr.train.client.RequirementClientUtil;
import com.kingdee.eas.hr.train.client.RequirementIssueUI;
import com.kingdee.eas.hr.train.client.RequirementResponseProcessUI;
import com.kingdee.eas.hr.train.client.RequirementResponseSummaryUI;
import com.kingdee.eas.hr.train.client.RowDataHandler;
import com.kingdee.eas.hr.train.client.TableActionHandler;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseTreePromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.swing.ComboBoxModel;
import org.apache.log4j.Logger;

public class RequirementEditUI
extends AbstractRequirementEditUI {
    public static final Logger logger = Logger.getLogger((String)RequirementEditUI.class.getName());
    protected static final String RESOURCE = "com.kingdee.eas.hr.train.RequirementResource";
    private static final int OBJECT_MAXLENGTH = 100;
    private ItemAction[] outerItemActions;
    private ItemAction[] innerItemActions;
    private boolean isCreatorOrSameOrg = false;
    private String currentPersonId;
    private String userOrgUnitId;
    private boolean isCourseType = true;

    public void onLoad() throws Exception {
        this.currentPersonId = (String)this.getUIContext().get("currentPersonId");
        this.userOrgUnitId = (String)this.getUIContext().get("userOrgUnitId");
        this.isCourseType = RequirementTypeEnum.COURSE_TYPE.equals(this.getUIContext().get("requirementType"));
        this.init();
        super.onLoad();
        this.tHelper.getDisabledTables().add(this.kdtInnerContent);
        this.tHelper.getDisabledTables().add(this.kdtOuterContent);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnProcess.setIcon(EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.btnGather.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.menuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemProcess.setIcon(EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.menuItemGather.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
    }

    protected void init() throws Exception {
        TrainUtils.initOrgUnit(this.prmtadminOrgUnit, false, (IUIObject)this);
        this.initInnerContentF7("trainCourse", RequirementClientUtil.getCoursePromptBox((IUIObject)this, true));
        this.initInnerContentF7("trainItem", RequirementClientUtil.getTrainItemPromptBox((IUIObject)this, true));
        this.initKdtInnerContent();
        this.initKdtOuterContent();
    }

    private void setColumnHide() {
        boolean flag = RequirementTypeEnum.COURSE_TYPE.equals((Object)this.editData.getType());
        this.kdtInnerContent.getColumn("trainCourse").getStyleAttributes().setHided(!flag);
        this.kdtInnerContent.getColumn("courseType").getStyleAttributes().setHided(!flag);
        this.kdtInnerContent.getColumn("trainItem").getStyleAttributes().setHided(flag);
        this.kdtInnerContent.getColumn("itemType").getStyleAttributes().setHided(flag);
    }

    protected void initInnerContentF7(String columnName, KDBizPromptBox promptBox) {
        this.kdtInnerContent.getColumn(columnName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
        promptBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null) {
                    RequirementEditUI.this.handleCourseResult(e);
                    e.setResult(0);
                } else {
                    RequirementEditUI.this.clearRow();
                }
            }
        });
    }

    protected KDBizPromptBox getInnerContentF7() {
        return null;
    }

    private void handleCourseResult(PreChangeEvent e) {
        RowDataHandler handler = new RowDataHandler(){

            public boolean setRowData(IRow row, Object object) {
                boolean result = false;
                if (row != null && object != null) {
                    RequirementEditUI.this.setInnerRowInfo(row, object);
                    result = true;
                }
                return result;
            }
        };
        TrainUtils.batchAddRowWithData(this.kdtInnerContent, (Object[])e.getData(), this.getInnerContentColumn(), handler);
    }

    protected void setInnerRowInfo(IRow row, Object object) {
        if (this.isCourseType) {
            TrainCourseInfo courseInfo = (TrainCourseInfo)object;
            row.getCell("trainCourse").setValue((Object)courseInfo);
            row.getCell("courseType").setValue((Object)courseInfo.getTreeid());
            String objectStr = courseInfo.getCourseJoinner();
            if (objectStr != null && objectStr.length() > 100) {
                objectStr = objectStr.substring(0, 100);
            }
            row.getCell("object").setValue((Object)objectStr);
            row.getCell("cost").setValue((Object)courseInfo.getCourseCost());
            this.setRowCourseHour(row, courseInfo.getCourseHour(), courseInfo.getCourseHourUnit());
        } else {
            TrainItemInfo trainItemInfo = (TrainItemInfo)object;
            row.getCell("trainItem").setValue((Object)trainItemInfo);
            row.getCell("itemType").setValue((Object)trainItemInfo.getTreeid());
            String objectStr = trainItemInfo.getTrainObject();
            if (objectStr != null && objectStr.length() > 100) {
                objectStr = objectStr.substring(0, 100);
            }
            row.getCell("object").setValue((Object)objectStr);
            row.getCell("trainMethod").setValue((Object)trainItemInfo.getTrainMethod());
            this.setRowCourseHour(row, trainItemInfo.getCourseHour(), trainItemInfo.getCourseHourUnit());
        }
        row.getCell("type").setValue((Object)RequirementCourseTypeEnum.MUST);
    }

    private void initKdtInnerContent() throws Exception {
        this.initKdtContent(this.kdtInnerContent);
        TableActionHandler handler = new TableActionHandler(){

            public IRow afterAddLine(IRow row) {
                row.getCell("type").setValue((Object)RequirementCourseTypeEnum.MUST);
                return row;
            }

            public IRow afterInsertLine(IRow row) {
                return this.afterAddLine(row);
            }
        };
        TrainUtils.setMutilTableFromBIM(this.contInnerContent, this.kdtInnerContent);
        this.innerItemActions = TrainUtils.addButtonsToMutilTable(this.contInnerContent, this.kdtInnerContent, handler);
    }

    private void initKdtContent(KDTable table) throws Exception {
        KDComboBox cboTrainMethod = new KDComboBox();
        cboTrainMethod.setModel((ComboBoxModel)TrainUtils.getComboModel(TrainingMethodFactory.getRemoteInstance(), TrainUtils.getCurrentHRFilter("hrOrgUnit.id")));
        TrainUtils.setTableCellEditorByComboBox(table, cboTrainMethod, "trainMethod");
        KDFormattedTextField txtCost = null;
        if (table.getColumn("cost").getEditor() != null) {
            txtCost = (KDFormattedTextField)table.getColumn("cost").getEditor().getComponent();
            txtCost.setPrecision(TrainClientUtil.PRECISION);
        } else {
            txtCost = TrainUtils.setTableCellEditorByFormattedTextField(table, "cost", TrainClientUtil.PRECISION);
        }
        TrainUtils.setPositiveNumberValue(txtCost);
        TrainUtils.setTableCellEditorByTextField(table, "object", 100);
        TrainUtils.setTableCellEditorByTextField(table, "remark", 200);
        TrainClientUtil.setDisableColor(table);
    }

    protected void clearRow() {
        int curIndex = TrainUtils.getCurrentRowIndex(this.kdtInnerContent);
        IRow row = this.kdtInnerContent.getRow(curIndex);
        row.getCell("courseType").setValue(null);
        row.getCell("courseHour").setValue(null);
        row.getCell("object").setValue(null);
        row.getCell("cost").setValue(null);
    }

    private void initKdtOuterContent() throws Exception {
        this.initKdtContent(this.kdtOuterContent);
        TableActionHandler handler = new TableActionHandler(){

            public IRow afterAddLine(IRow row) {
                row.getCell("type").setValue((Object)RequirementCourseTypeEnum.MUST);
                return row;
            }

            public IRow afterInsertLine(IRow row) {
                return this.afterAddLine(row);
            }
        };
        this.outerItemActions = TrainUtils.addButtonsToMutilTable(this.contOuterContent, this.kdtOuterContent, handler);
        TrainUtils.setTableCellEditorByComboBox(this.kdtOuterContent, "type", "com.kingdee.eas.hr.train.RequirementCourseTypeEnum");
        TrainUtils.setTableCellEditorByTextField(this.kdtOuterContent, "trainSubject", 100);
        TrainUtils.setTableCellEditorByF7Selector(this.kdtOuterContent, (KDPromptSelector)new TrainCourseTreePromptBox((IUIObject)this), "courseType");
        TrainUtils.setTableCellEditorByDatePicker(this.kdtOuterContent, "startDate");
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("Entry.courseType.id"));
        sic.add(new SelectorItemInfo("Entry.courseType.name"));
        sic.add(new SelectorItemInfo("creator.person.id"));
        sic.add(new SelectorItemInfo("creator.person.name"));
        return sic;
    }

    protected void kdtInnerCourse_editStarting(KDTEditEvent e) throws Exception {
        TrainUtils.setComboBoxSelected(e);
    }

    protected void kdtOuterCourse_editStarting(KDTEditEvent e) throws Exception {
        TrainUtils.setComboBoxSelected(e);
    }

    public void loadFields() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.isCreatorOrSameOrg = true;
        } else {
            String id = this.editData.getId().toString();
            String createPersonId = this.editData.getCreator().getPerson().getId().toString();
            String adminOrgUnitId = this.editData.getAdminOrgUnit().getId().toString();
            this.isCreatorOrSameOrg = RequirementClientUtil.isCreatorOrSameOrg(id, createPersonId, adminOrgUnitId, this.currentPersonId, this.userOrgUnitId);
        }
        this.editData.copyNewToOld();
        RequirementEntryCollection outerCourses = RequirementClientUtil.getOuterCourses(this.editData);
        super.loadFields();
        this.isCourseType = RequirementTypeEnum.COURSE_TYPE.equals((Object)this.editData.getType());
        this.setUITitle(this.getUITitleString());
        RequirementClientUtil.loadOuterCourseFields(this.kdtOuterContent, outerCourses);
        this.setRowCourseHour();
        this.setCompomentState();
        this.setColumnHide();
    }

    protected void initOldData(IObjectValue dataObject) {
        this.editData.setAvailable(false);
        super.initOldData(dataObject);
        this.editData.setAvailable(true);
    }

    private void setCompomentState() {
        boolean flag = OprtState.ADDNEW.equals(this.getOprtState());
        this.actionPublish.setEnabled(!flag);
        flag = this.editData.getState() != null && !RequirementStateEnum.UN_PUBLISH.equals((Object)this.editData.getState());
        this.actionProcess.setEnabled(flag);
        this.actionGather.setEnabled(flag);
        flag = this.currentPersonId.equals(this.editData.getCreator().getPerson().getId().toString()) && RequirementStateEnum.PUBLISHED.equals((Object)this.editData.getState());
        this.actionClose.setEnabled(flag);
        flag = this.isCreatorOrSameOrg && OprtState.VIEW.equals(this.getOprtState()) && RequirementStateEnum.UN_PUBLISH.equals((Object)this.editData.getState());
        this.actionEdit.setEnabled(flag);
        flag = OprtState.VIEW.equals(this.getOprtState());
        this.lockComponents(flag);
    }

    protected void setRowCourseHour() {
        RequirementEntryCollection collection = this.editData.getEntry();
        for (int i = 0; i < this.kdtInnerContent.getRowCount(); ++i) {
            IRow row = this.kdtInnerContent.getRow(i);
            Object id = row.getCell("id").getValue();
            if (id == null) continue;
            this.setRowCourseHour(row, collection.get(id));
        }
    }

    protected void setRowCourseHour(IRow row, RequirementEntryInfo entryInfo) {
        if (this.isCourseType) {
            if (entryInfo != null && entryInfo.getCourse() != null) {
                this.setRowCourseHour(row, entryInfo.getCourse().getCourseHour(), entryInfo.getCourse().getCourseHourUnit());
            }
        } else if (entryInfo != null && entryInfo.getTrainItem() != null) {
            this.setRowCourseHour(row, entryInfo.getTrainItem().getCourseHour(), entryInfo.getTrainItem().getCourseHourUnit());
        }
    }

    protected void setRowCourseHour(IRow row, BigDecimal courseHour, CourseHourUnitEnum courseHourUnit) {
        if (courseHour != null && courseHourUnit != null) {
            String str = courseHour.setScale(TrainClientUtil.PRECISION) + courseHourUnit.getAlias();
            row.getCell("courseHour").setValue((Object)str);
        } else {
            row.getCell("courseHour").setValue(null);
        }
    }

    private void lockComponents(boolean flag) {
        int i;
        this.kdtInnerContent.getStyleAttributes().setLocked(flag);
        for (i = 0; i < this.innerItemActions.length; ++i) {
            this.innerItemActions[i].setEnabled(!flag);
        }
        this.kdtOuterContent.getStyleAttributes().setLocked(flag);
        for (i = 0; i < this.outerItemActions.length; ++i) {
            this.outerItemActions[i].setEnabled(!flag);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.lockComponents(false);
        CodingRuleHelper.setAutoNumber(this, (CoreBaseInfo)this.editData, this.txtNumber, "EDIT");
    }

    public void storeFields() {
        super.storeFields();
        RequirementClientUtil.storeOuterCourse(this.editData, this.kdtOuterContent);
        this.editData.setStartDate(DateTimeUtils.truncateDate((Date)this.editData.getStartDate()));
        this.editData.setEndDate(DateTimeUtils.truncateDate((Date)this.editData.getEndDate()));
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtadminOrgUnit);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkendDate);
        TrainVerifyUtils.verifyDateBigOrSmallOrEqual((CoreUIObject)this, this.pkstartDate, this.pkendDate, null);
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtInnerContent, this.getInnerContentColumn());
        TrainVerifyUtils.verifyRepeatRow((CoreUIObject)this, this.kdtInnerContent, this.getInnerContentColumn(), null);
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtOuterContent, "trainSubject");
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtOuterContent, "courseType");
        TrainVerifyUtils.verifyRepeatRow((CoreUIObject)this, this.kdtOuterContent, "trainSubject", null);
        IRow row = null;
        DataBaseInfo dataBaseInfo = null;
        for (int i = 0; i < this.kdtInnerContent.getRowCount(); ++i) {
            row = this.kdtInnerContent.getRow(i);
            dataBaseInfo = (DataBaseInfo)row.getCell(this.getInnerContentColumn()).getValue();
            if (!TrainUtils.isRepeatRowInTable(this.kdtOuterContent, dataBaseInfo.getName(), "trainSubject")) continue;
            this.kdtInnerContent.getEditManager().editCellAt(i, this.kdtInnerContent.getColumnIndex(this.getInnerContentColumn()));
            MsgBox.showWarning((Component)((Object)this), (String)TrainClientUtil.getResource(RESOURCE, "COURSE_REPEATED", new Object[]{this.contInnerContent.getTitle(), this.contOuterContent.getTitle()}));
            SysUtil.abort();
        }
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        String requirementIssueId = RequirementAssistant.getIssueId(this.editData.getId().toString(), this.isCreatorOrSameOrg, null);
        String state = null;
        if (requirementIssueId == null) {
            if (OprtState.VIEW.equals(this.getOprtState())) {
                TrainClientUtil.showMessageAndAbort(RESOURCE, "UN_PUBLISH", (CoreUI)this);
            } else {
                state = OprtState.ADDNEW;
                uiContext.put((Object)"parent", (Object)this.editData);
            }
        } else {
            uiContext.put((Object)"ID", (Object)requirementIssueId);
            state = this.getOprtState();
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RequirementIssueUI.class.getName(), (Map)uiContext, null, state);
        uiWindow.show();
        RequirementIssueUI issueUI = (RequirementIssueUI)uiWindow.getUIObject();
        if (issueUI.isModifiedData()) {
            this.reloadData();
        }
    }

    private void reloadData() throws Exception {
        CacheServiceFactory.getInstance().discardType(this.editData.getBOSType());
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId().toString())));
        this.loadFields();
        this.setSaved(true);
    }

    public void actionProcess_actionPerformed(ActionEvent e) throws Exception {
        this.showResultWindow(RequirementResponseProcessUI.class.getName(), OprtState.VIEW);
    }

    public void actionGather_actionPerformed(ActionEvent e) throws Exception {
        this.showResultWindow(RequirementResponseSummaryUI.class.getName(), OprtState.EDIT);
    }

    private void showResultWindow(String uiClassName, String state) throws BOSException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"requirement", (Object)this.editData.getId().toString());
        uiContext.put((Object)"requirementName", (Object)this.editData.getName());
        uiContext.put((Object)"requirementType", (Object)this.editData.getType());
        String publisherId = null;
        if (this.isCreatorOrSameOrg) {
            RequirementIssueInfo issueInfo = RequirementAssistant.getRootIssueInfo(this.editData.getId().toString(), null);
            publisherId = issueInfo.getPublisher().getId().toString();
        } else {
            publisherId = TrainUtils.getCurrentPersonId();
        }
        uiContext.put((Object)"publisherId", (Object)publisherId);
        uiContext.put((Object)"requirementState", (Object)this.editData.getState());
        uiContext.put((Object)"isCreatorOrSameOrg", (Object)this.isCreatorOrSameOrg);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClassName, (Map)uiContext, null, state);
        uiWindow.show();
    }

    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        if (!TrainClientUtil.showConfirmMessge(RESOURCE, "CONFIRM_CLOSEREQUIRE", (CoreUI)this)) {
            return;
        }
        RequirementFactory.getRemoteInstance().close((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
        this.reloadData();
        this.showSuccessMessage(EASResource.getString((String)RESOURCE, (String)"CLOSE_SUCCESS"));
    }

    protected void showSuccessMessage(String message) {
        this.setMessageText(this.getClassAlise() + " " + message);
        String strState = OprtState.EDIT.equals(this.getOprtState()) ? "Msg_Edit" : "Msg_View";
        this.setNextMessageText(this.getClassAlise() + " " + EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + strState)));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    protected String getEditUIName() {
        return RequirementEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RequirementFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        RequirementInfo objectValue = new RequirementInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        try {
            objectValue.setAdminOrgUnit(TrainAssistant.getUserOrgInfo(this.currentPersonId, null));
        }
        catch (Exception e) {
            logger.info((Object)e.getCause());
        }
        objectValue.setHrOrgUnit(TrainUtils.getCurrentHROrgUnit());
        objectValue.setStartDate(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setState(RequirementStateEnum.UN_PUBLISH);
        if (this.isCourseType) {
            objectValue.setType(RequirementTypeEnum.COURSE_TYPE);
        } else {
            objectValue.setType(RequirementTypeEnum.ITEM_TYPE);
        }
        return objectValue;
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK pk = super.runSubmit();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        return pk;
    }

    protected void setAutoNumberByOrg(String orgType) {
        CodingRuleHelper.setAutoNumber(this, (CoreBaseInfo)this.editData, this.txtNumber, this.getOprtState());
    }

    protected String getInnerContentColumn() {
        return this.isCourseType ? "trainCourse" : "trainItem";
    }

    protected String getUITitleString() {
        String resourceKey = this.isCourseType ? "REQUIREMENT_COURSE" : "REQUIREMENT_TRAINITEM";
        return EASResource.getString((String)RESOURCE, (String)resourceKey);
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("currentPersonId", (Object)((String)this.getUIContext().get("currentPersonId")));
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public RequestContext prepareActionGather(IItemAction itemAction) throws Exception {
        return this.prepareRequirementId(super.prepareActionGather(itemAction));
    }

    public RequestContext prepareActionProcess(IItemAction itemAction) throws Exception {
        return this.prepareRequirementId(super.prepareActionProcess(itemAction));
    }

    private RequestContext prepareRequirementId(RequestContext request) {
        if (this.isCreatorOrSameOrg) {
            request.put("requirementId", (Object)this.editData.getId().toString());
        }
        return request;
    }

    public RequestContext prepareActionPublish(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionPublish(itemAction);
        request.put("requirementId", (Object)this.editData.getId().toString());
        request.put("isCreatorOrSameOrg", (Object)this.isCreatorOrSameOrg);
        return request;
    }

    public RequestContext prepareActionAddNew(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAddNew(itemAction);
        request.put("currentPersonId", (Object)this.currentPersonId);
        return request;
    }

    public boolean isPrepareActionPublish() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionProcess() {
        return true;
    }
}

