/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.train.RequirementInfo;
import com.kingdee.eas.hr.train.RequirementIssueException;
import com.kingdee.eas.hr.train.RequirementIssueFactory;
import com.kingdee.eas.hr.train.RequirementIssueInfo;
import com.kingdee.eas.hr.train.RequirementStateEnum;
import com.kingdee.eas.hr.train.client.AbstractRequirementIssueUI;
import com.kingdee.eas.hr.train.client.ProgressManager;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;

public class RequirementIssueUI
extends AbstractRequirementIssueUI {
    private static final String ACT_RESOURCE = "com.kingdee.eas.hr.train.TrainActivityResource";
    private static final int MAX_PERSON_COUNT = 80;
    private boolean modifiedData = false;

    public RequirementIssueUI() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        TrainUtils.initPerson(this.prmtPublisher, false, (IUIObject)this);
        this.kdtEntry.getStyleAttributes().setLocked(true);
        this.kdtEntry.checkParsed();
        this.kdtEntry.getSelectManager().setSelectMode(10);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        JButton btnAddPerson = this.contEntry.add((Action)((Object)this.actionAddPerson));
        JButton btnDeletePerson = this.contEntry.add((Action)((Object)this.actionDeletePerson));
        btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        btnAddPerson.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"ADD_PERSON"));
        btnDeletePerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        btnDeletePerson.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"DELETE_PERSON"));
    }

    public void loadFields() {
        super.loadFields();
        this.loadKdtEntryData();
        boolean enabled = !OprtState.VIEW.equals(this.getOprtState());
        this.actionSubmit.setEnabled(enabled);
        this.actionPublish.setEnabled(enabled);
        this.actionAddPerson.setEnabled(enabled);
        this.actionDeletePerson.setEnabled(enabled);
        this.pkCloseDate.setEnabled(enabled);
        TrainClientUtil.setComponentEnable((IKDTextComponent)this.prmtPublisher, enabled && this.editData.isIsRoot());
    }

    private void loadKdtEntryData() {
        if (this.kdtEntry.getRowCount() == 0) {
            return;
        }
        HashSet<String> personIds = new HashSet<String>();
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            PersonInfo info = (PersonInfo)this.kdtEntry.getRow(i).getCell("person").getValue();
            personIds.add(info.getId().toString());
        }
        try {
            IRowSet rowSet = this.getPersonInfos(personIds);
            Map persons = this.assembleMap(rowSet);
            for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
                IRow row = this.kdtEntry.getRow(i);
                PersonInfo info = (PersonInfo)row.getCell("person").getValue();
                String personId = info.getId().toString();
                Map person = (Map)persons.get(personId);
                if (person == null) continue;
                row.getCell("grade").setValue(person.get("grade"));
                row.getCell("position").setValue(person.get("position"));
                row.getCell("orgUnit").setValue(person.get("orgUnitName"));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private Map assembleMap(IRowSet rowSet) throws SQLException {
        HashMap persons = new HashMap();
        while (rowSet.next()) {
            HashMap<String, String> person = new HashMap<String, String>();
            person.put("grade", rowSet.getString("jobGrade.name"));
            person.put("position", rowSet.getString("Position.name"));
            person.put("orgUnitName", rowSet.getString("AdminOrgUnit.displayName"));
            persons.put(rowSet.getString("id"), person);
        }
        return persons;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("requirement.id"));
        sic.add(new SelectorItemInfo("requirement.name"));
        sic.add(new SelectorItemInfo("requirement.state"));
        sic.add(new SelectorItemInfo("isRoot"));
        sic.add(new SelectorItemInfo("entry.state"));
        return sic;
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(null);
        this.storeFields();
        if (this.editData.getEntry().size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ACT_RESOURCE, (String)"NoPerson"));
            SysUtil.abort();
        }
        IObjectPK pk = RequirementIssueFactory.getRemoteInstance().publish((IObjectValue)this.editData);
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId().toString())));
        this.loadFields();
        this.modifiedData = true;
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ACT_RESOURCE, (String)"PublishSuccess"));
    }

    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmt.setIsSingleSelect(false);
        pmt.setUserOrgRangeFilter(true);
        pmt.setModal(true);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            Object[] obj = (Object[])pmt.getData();
            if (obj == null || obj.length == 0) {
                return;
            }
            final HashSet<String> personIds = new HashSet<String>();
            for (int i = 0; i < obj.length; ++i) {
                personIds.add(((PersonInfo)obj[i]).getId().toString());
            }
            if (obj.length > 80) {
                ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

                    public void run() throws Exception {
                        RequirementIssueUI.this.dealAddPerson(personIds);
                    }
                };
                new ProgressManager((CoreUI)this).launchProcess(process, (CoreUIObject)this);
            } else {
                this.dealAddPerson(personIds);
            }
        }
    }

    private void dealAddPerson(Set personIds) throws Exception {
        if (personIds == null || personIds.size() == 0) {
            return;
        }
        IRowSet rowSet = this.getPersonInfos(personIds);
        while (rowSet.next()) {
            String personId = rowSet.getString("id");
            PersonInfo info = new PersonInfo();
            info.setId(BOSUuid.read((String)personId));
            if (TrainUtils.isRepeatRowInTable(this.kdtEntry, info, "person")) continue;
            IRow row = this.kdtEntry.addRow();
            row.getCell("person").setValue((Object)info);
            row.getCell("personName").setValue((Object)rowSet.getString("name"));
            row.getCell("personNumber").setValue((Object)rowSet.getString("number"));
            row.getCell("grade").setValue((Object)rowSet.getString("jobGrade.name"));
            row.getCell("position").setValue((Object)rowSet.getString("Position.name"));
            row.getCell("orgUnit").setValue((Object)rowSet.getString("AdminOrgUnit.displayName"));
        }
    }

    private IRowSet getPersonInfos(Set personIds) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)personIds, CompareType.INCLUDE));
        IRowSet rowSet = TrainActivityHelper.getRowSet("RequirementPersonQuery", filterInfo);
        return rowSet;
    }

    public void actionDeletePerson_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.kdtEntry);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtPublisher);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkCloseDate);
    }

    protected IObjectValue createNewData() {
        RequirementIssueInfo issueInfo = new RequirementIssueInfo();
        issueInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        issueInfo.setRequirement((RequirementInfo)this.getUIContext().get("parent"));
        issueInfo.setPublisher(SysContext.getSysContext().getCurrentUserInfo().getPerson());
        if (RequirementStateEnum.UN_PUBLISH.equals((Object)issueInfo.getRequirement().getState())) {
            issueInfo.setIsRoot(true);
        } else {
            issueInfo.setIsRoot(false);
        }
        return issueInfo;
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPK = super.runSubmit();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
        this.modifiedData = true;
        return objectPK;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RequirementIssueFactory.getRemoteInstance();
    }

    protected boolean isModifiedData() {
        return this.modifiedData;
    }

    public void handUIException(Throwable e) {
        if (e instanceof RequirementIssueException && e.getMessage().length() > 200) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"HANDLE_FAIL"), (String)e.getMessage(), (int)0);
        } else {
            super.handUIException(e);
        }
    }

    public RequestContext prepareActionPublish(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionPublish(itemAction);
        if (request == null) {
            request = new RequestContext();
        }
        this.beforeStoreFields(null);
        this.storeFields();
        if (this.editData.getEntry().size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ACT_RESOURCE, (String)"NoPerson"));
            SysUtil.abort();
        }
        request.setValue((CoreBaseInfo)this.editData);
        request.put("selector", (Object)this.getSelectors());
        return request;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionPublish() {
        return false;
    }
}

