/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.RequirementInfo;
import com.kingdee.eas.hr.train.RequirementStateEnum;
import com.kingdee.eas.hr.train.RequirementTypeEnum;
import com.kingdee.eas.hr.train.TrainAssistant;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.client.AbstractRequirementQueryPanelUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.hr.train.client.RequirementClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import javax.swing.event.ChangeEvent;

public class RequirementQueryPanelUI
extends AbstractRequirementQueryPanelUI {
    private static final String RESOURCE = "com.kingdee.eas.hr.train.RequirementResource";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String STATE = "state";
    private static final String TYPE = "type";
    private static final String ADMINORG_UNITID = "adminOrgUnit.id";

    public RequirementQueryPanelUI() throws Exception {
        this.clear();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String currentPersonId = TrainUtils.getCurrentPersonId();
        AdminOrgUnitInfo orgUnitInfo = TrainAssistant.getUserOrgInfo(currentPersonId, null);
        String userOrgUnitId = null;
        if (orgUnitInfo != null) {
            userOrgUnitId = orgUnitInfo.getId().toString();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(RequirementClientUtil.getRequirementFilterInfo(currentPersonId, userOrgUnitId));
        this.prmtRequirement.setEntityViewInfo(viewInfo);
        TrainUtils.initOrgUnit(this.prmtAdminOrgUnit, false, (IUIObject)this);
        this.prmtAdminOrgUnit.setEditable(false);
        TrainUtils.addComboBoxEmptyItem(this.cboState);
        TrainUtils.addComboBoxEmptyItem(this.cboType);
    }

    public FilterInfo getFilterInfo() {
        RequirementStateEnum state;
        OrgUnitInfo orgUnitInfo;
        String requirementName;
        RequirementInfo requirementInfo;
        FilterInfo filterInfo = new FilterInfo();
        RequirementTypeEnum type = (RequirementTypeEnum)((Object)this.cboType.getSelectedItem());
        if (type != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo(TYPE, (Object)type.getValue()));
        }
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)(requirementInfo = (RequirementInfo)this.prmtRequirement.getValue()))) {
            filterInfo.getFilterItems().add(new FilterItemInfo(ID, (Object)requirementInfo.getId().toString()));
        }
        if (!TrainCommonUtils.isEmpty(requirementName = this.txtName.getText())) {
            requirementName = "%" + requirementName + "%";
            filterInfo.getFilterItems().add(new FilterItemInfo(NAME, (Object)requirementName, CompareType.LIKE));
        }
        if ((orgUnitInfo = (OrgUnitInfo)this.prmtAdminOrgUnit.getValue()) != null && orgUnitInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo(ADMINORG_UNITID, (Object)orgUnitInfo.getId().toString()));
        }
        if ((state = (RequirementStateEnum)((Object)this.cboState.getSelectedItem())) != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo(STATE, (Object)state.getValue()));
        }
        if (this.pkStartDate.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.pkStartDate.getValue())), CompareType.GREATER_EQUALS));
        }
        if (this.pkEndDate.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.pkEndDate.getValue())), CompareType.LESS_EQUALS));
        }
        return filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CustomerQueryUtil.storeToCustomerParams(cp, this.cboType);
        CustomerQueryUtil.storeToCustomerParams(cp, this.chkLike);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtRequirement);
        CustomerQueryUtil.storeToCustomerParams(cp, this.txtName);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtAdminOrgUnit);
        CustomerQueryUtil.storeToCustomerParams(cp, this.cboState);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkStartDate);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkEndDate);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        CustomerQueryUtil.loadFromCustomerParams(cp, this.cboType);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.chkLike);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtRequirement, RequirementInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.txtName);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtAdminOrgUnit, AdminOrgUnitInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.cboState);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkStartDate);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkEndDate);
    }

    protected void chkLike_stateChanged(ChangeEvent e) throws Exception {
        boolean flag = this.chkLike.isSelected();
        this.contRequirementName.setVisible(flag);
        this.contRequirement.setVisible(!flag);
        if (flag) {
            this.prmtRequirement.setValue(null);
        } else {
            this.txtName.setText(null);
        }
    }

    public boolean verify() {
        if (this.pkEndDate.getValue() != null && this.pkStartDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"startDateCannotEmpty"));
            return false;
        }
        if (this.pkStartDate.getValue() != null && this.pkEndDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"endDateCannotEmpty"));
            return false;
        }
        TrainVerifyUtils.verifyDateBigOrSmallOrEqual((CoreUIObject)this, this.pkStartDate, this.pkEndDate, EASResource.getString((String)RESOURCE, (String)"endDateBeforStartDate"));
        return super.verify();
    }

    public void clear() {
        this.chkLike.setSelected(false);
        this.txtName.setText(null);
        this.prmtRequirement.setValue(null);
        this.prmtAdminOrgUnit.setValue(null);
        this.pkStartDate.setValue(null);
        this.pkEndDate.setValue(null);
        this.cboType.setSelectedIndex(-1);
        this.cboState.setSelectedIndex(-1);
    }
}

