/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.hr.train.RequirementEntryCollection;
import com.kingdee.eas.hr.train.RequirementEntryInfo;
import com.kingdee.eas.hr.train.RequirementFactory;
import com.kingdee.eas.hr.train.RequirementInfo;
import com.kingdee.eas.hr.train.RequirementTypeEnum;
import com.kingdee.eas.hr.train.ResponseSuggestCourseCollection;
import com.kingdee.eas.hr.train.ResponseSuggestCourseFactory;
import com.kingdee.eas.hr.train.ResponseSuggestCourseInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.client.AbstractRequirementResponseCourseF7UI;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class RequirementResponseCourseF7UI
extends AbstractRequirementResponseCourseF7UI {
    private static final Logger logger = CoreUIObject.getLogger(RequirementResponseCourseF7UI.class);
    private String requirementId;
    private Set responserIds;
    private RequirementTypeEnum requirementType;
    private boolean canceled = true;
    private Collection selectedCollection = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.requirementId = (String)this.getUIContext().get("requirement");
        this.responserIds = (Set)this.getUIContext().get("responserIds");
        this.requirementType = (RequirementTypeEnum)((Object)this.getUIContext().get("requirementType"));
        this.initAppointedCourseTable();
        this.initSuggestCourseTable();
        this.initSelectedCourseTable();
        this.setTableTitle();
    }

    private void initAppointedCourseTable() throws Exception {
        this.setTableProperty(this.kdtAppointedCourse);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("Entry.*"));
        sic.add(new SelectorItemInfo("Entry.course.name"));
        sic.add(new SelectorItemInfo("Entry.course.treeid.name"));
        sic.add(new SelectorItemInfo("Entry.trainItem.name"));
        sic.add(new SelectorItemInfo("Entry.trainItem.treeid.name"));
        sic.add(new SelectorItemInfo("Entry.courseType.name"));
        RequirementInfo requirementInfo = RequirementFactory.getRemoteInstance().getRequirementInfo((IObjectPK)new ObjectUuidPK(this.requirementId), sic);
        RequirementEntryCollection entrys = requirementInfo.getEntry();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            this.setRowAppointedCourseInfo(entrys.get(i));
        }
    }

    private void setTableProperty(KDTable table) {
        table.checkParsed();
        TrainUtils.setKDTableSortable(table);
        table.getStyleAttributes().setLocked(true);
        table.getSelectManager().setSelectMode(10);
    }

    private void setRowAppointedCourseInfo(RequirementEntryInfo entryInfo) {
        IRow row = this.kdtAppointedCourse.addRow();
        String contentName = null;
        TreeBaseInfo typeInfo = null;
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)entryInfo.getCourse())) {
            contentName = entryInfo.getCourse().getName();
            typeInfo = entryInfo.getCourse().getTreeid();
        } else if (!TrainCommonUtils.isEmpty((CoreBaseInfo)entryInfo.getTrainItem())) {
            contentName = entryInfo.getTrainItem().getName();
            typeInfo = entryInfo.getTrainItem().getTreeid();
        } else if (!TrainCommonUtils.isEmpty(entryInfo.getTrainSubject())) {
            contentName = entryInfo.getTrainSubject();
            typeInfo = entryInfo.getCourseType();
        }
        row.getCell("name").setValue((Object)contentName);
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)typeInfo)) {
            row.getCell("type").setValue((Object)typeInfo.getName());
        }
        row.getCell("require").setValue((Object)entryInfo.getType());
        row.getCell("trainObject").setValue((Object)entryInfo.getObject());
        row.getCell("remark").setValue((Object)entryInfo.getRemark());
        row.getCell("startDate").setValue((Object)entryInfo.getStartDate());
        row.getCell("cost").setValue((Object)entryInfo.getCost());
        row.getCell("flag").setValue((Object)"appointed");
    }

    private void initSuggestCourseTable() throws BOSException {
        this.setTableProperty(this.kdtSuggestCourse);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("courseType.name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.requirement.id", (Object)this.requirementId));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.responser.id", (Object)this.responserIds, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        ResponseSuggestCourseCollection collection = ResponseSuggestCourseFactory.getRemoteInstance().getResponseSuggestCourseCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            HashSet courses = new HashSet();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                this.setRowSuggestCourseInfo(collection.get(i), courses);
            }
        }
    }

    private void setRowSuggestCourseInfo(ResponseSuggestCourseInfo info, Set courses) {
        String key = info.getTrainSubject() + info.getCourseType().getName();
        if (!courses.contains(key)) {
            courses.add(key);
            IRow row = this.kdtSuggestCourse.addRow();
            row.getCell("name").setValue((Object)info.getTrainSubject());
            if (!TrainCommonUtils.isEmpty((CoreBaseInfo)info.getCourseType())) {
                row.getCell("type").setValue((Object)info.getCourseType().getName());
            }
            row.getCell("require").setValue((Object)info.getType());
            row.getCell("trainObject").setValue((Object)info.getObject());
            row.getCell("remark").setValue((Object)info.getRemark());
            row.getCell("startDate").setValue((Object)info.getStartDate());
            row.getCell("cost").setValue((Object)info.getCost());
            row.getCell("flag").setValue((Object)"suggest");
        }
    }

    private void initSelectedCourseTable() {
        this.setTableProperty(this.kdtSelectedCourse);
        TrainUtils.setMutilTableFromBIM(this.contSelectedCourse, this.kdtSelectedCourse);
        JButton button = this.contSelectedCourse.add((Action)((Object)this.actionRemoveLine));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        button.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource.RemoveLine"));
        this.actionRemoveLine.setEnabled(true);
    }

    private void setTableTitle() {
        String courseStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"TRAINCOURSE");
        String nameStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"NAME");
        String typeStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"TYPE");
        String appointedNameTitle = null;
        String appointedTypeTitle = null;
        String selectedNameTitle = null;
        String selectedTypeTitle = null;
        if (RequirementTypeEnum.COURSE_TYPE.equals((Object)this.requirementType)) {
            appointedNameTitle = courseStr + nameStr;
            appointedTypeTitle = courseStr + typeStr;
            selectedNameTitle = appointedNameTitle;
            selectedTypeTitle = appointedTypeTitle;
        } else if (RequirementTypeEnum.ITEM_TYPE.equals((Object)this.requirementType)) {
            String itemStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"TRAINITEM");
            appointedNameTitle = itemStr + nameStr;
            appointedTypeTitle = itemStr + typeStr;
            selectedNameTitle = itemStr + "/" + courseStr + nameStr;
            selectedTypeTitle = itemStr + "/" + courseStr + typeStr;
        }
        IRow row = this.kdtAppointedCourse.getHeadRow(0);
        row.getCell(this.kdtAppointedCourse.getColumnIndex("name")).setValue((Object)appointedNameTitle);
        row.getCell(this.kdtAppointedCourse.getColumnIndex("type")).setValue((Object)appointedTypeTitle);
        row = this.kdtSelectedCourse.getHeadRow(0);
        row.getCell(this.kdtSelectedCourse.getColumnIndex("name")).setValue((Object)selectedNameTitle);
        row.getCell(this.kdtSelectedCourse.getColumnIndex("type")).setValue((Object)selectedTypeTitle);
    }

    protected void kdtAppointedCourse_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.insertRow(this.kdtAppointedCourse);
        }
    }

    private void insertRow(KDTable table) {
        int[] ids = TrainHelper.getSelectedRows(table);
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            IRow fromRow = table.getRow(ids[i]);
            this.insertRowFromTopTable(fromRow);
        }
    }

    private void insertRowFromTopTable(IRow row) {
        String typeName;
        String name = row.getCell("name").getValue().toString();
        if (!this.isExistSameRowInTable(name, typeName = (String)row.getCell("type").getValue())) {
            this.kdtSelectedCourse.addRow(this.kdtSelectedCourse.getRowCount(), row);
        }
    }

    private boolean isExistSameRowInTable(String courseName, String typeName) {
        IRow row = null;
        int size = this.kdtSelectedCourse.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtSelectedCourse.getRow(i);
            if (!courseName.equals(row.getCell("name").getValue())) continue;
            if (typeName != null && typeName.equals(row.getCell("type").getValue())) {
                return true;
            }
            if (typeName != row.getCell("type").getValue()) continue;
            return true;
        }
        return false;
    }

    protected void kdtSuggestCourse_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.insertRow(this.kdtSuggestCourse);
        }
    }

    protected void kdtSelectedCourse_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionRemoveLine_actionPerformed(null);
        }
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.kdtSelectedCourse);
    }

    protected void btnSelect_actionPerformed(ActionEvent e) throws Exception {
        this.setSelectedCourse();
        if (this.selectedCollection == null || this.selectedCollection.size() <= 0) {
            this.canceled = true;
            return;
        }
        this.canceled = false;
        this.getUIWindow().close();
    }

    private void setSelectedCourse() {
        int size = this.kdtSelectedCourse.getRowCount();
        if (size <= 0) {
            return;
        }
        if (this.selectedCollection == null) {
            this.selectedCollection = new ArrayList();
        }
        IRow row = null;
        TrainCourseInfo courseInfo = null;
        for (int i = 0; i < size; ++i) {
            row = this.kdtSelectedCourse.getRow(i);
            courseInfo = new TrainCourseInfo();
            courseInfo.setId(BOSUuid.create((BOSObjectType)courseInfo.getBOSType()));
            courseInfo.setName((String)row.getCell("name").getValue());
            this.selectedCollection.add(courseInfo);
        }
    }

    protected void btnCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.canceled = true;
        this.getUIWindow().close();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Collection getSelectedCollection() {
        return this.selectedCollection;
    }
}

