/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.train.RequirementResponseFactory;
import com.kingdee.eas.hr.train.RequirementTypeEnum;
import com.kingdee.eas.hr.train.client.AbstractRequirementResponseDetailUI;
import com.kingdee.eas.hr.train.client.RequirementClientUtil;
import com.kingdee.eas.hr.train.client.RequirementResponsePublisherUI;
import com.kingdee.eas.hr.train.client.RequirementResponseSummaryFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Set;
import org.apache.log4j.Logger;

public class RequirementResponseDetailUI
extends AbstractRequirementResponseDetailUI {
    private static final Logger logger = CoreUIObject.getLogger(RequirementResponseDetailUI.class);

    public void onLoad() throws Exception {
        this.setIsNeedDefaultFilter(false);
        super.onLoad();
        this.setTableTitle();
        this.tblMain.getGroupManager().setGroup(true);
    }

    private void setTableTitle() {
        String courseStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"TRAINCOURSE");
        String itemStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"TRAINITEM");
        String nameStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"NAME");
        String nameTitle = null;
        RequirementTypeEnum requirementType = (RequirementTypeEnum)((Object)this.getUIContext().get("requirementType"));
        if (RequirementTypeEnum.COURSE_TYPE.equals((Object)requirementType)) {
            nameTitle = courseStr + nameStr;
        } else if (RequirementTypeEnum.ITEM_TYPE.equals((Object)requirementType)) {
            nameTitle = itemStr + nameStr;
        }
        IRow row = this.tblMain.getHeadRow(0);
        row.getCell(this.tblMain.getColumnIndex("contentName")).setValue((Object)nameTitle);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewResponse.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.actionViewResponse.setEnabled(true);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            RequirementResponseSummaryFilterUI filterUI = new RequirementResponseSummaryFilterUI(this.getUIContext());
            dialog.addUserPanel((KDPanel)filterUI);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return dialog;
    }

    public void actionViewResponse_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            String type = null;
            while (rowSet.next()) {
                type = RequirementClientUtil.transformType(rowSet.getString("type"));
                rowSet.updateString("type", type);
            }
            rowSet.beforeFirst();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
        super.onGetRowSet(rowSet);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        String requirementId = (String)this.getUIContext().get("requirement");
        Set responserIds = (Set)this.getUIContext().get("responserIds");
        Set orgIds = (Set)this.getUIContext().get("orgIds");
        Set contentTypes = (Set)this.getUIContext().get("contentTypes");
        Set contentNames = (Set)this.getUIContext().get("contentNames");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirementId", (Object)requirementId));
        filterInfo.getFilterItems().add(new FilterItemInfo("responserId", (Object)responserIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnitId", (Object)orgIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("contentType", (Object)contentTypes, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("contentName", (Object)contentNames, CompareType.INCLUDE));
        return filterInfo;
    }

    protected String[] getLocateNames() {
        return new String[]{"responseOrg", "responser", "type", "contentName"};
    }

    protected String getEditUIName() {
        return RequirementResponsePublisherUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RequirementResponseFactory.getRemoteInstance();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }
}

