/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.RequirementAssistant;
import com.kingdee.eas.hr.train.RequirementResponseEnum;
import com.kingdee.eas.hr.train.RequirementResponseFactory;
import com.kingdee.eas.hr.train.RequirementTypeEnum;
import com.kingdee.eas.hr.train.ResponseAppointedCourseCollection;
import com.kingdee.eas.hr.train.ResponseAppointedCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseTreeInfo;
import com.kingdee.eas.hr.train.TrainItemInfo;
import com.kingdee.eas.hr.train.TrainItemTreeInfo;
import com.kingdee.eas.hr.train.client.AbstractRequirementResponseEditUI;
import com.kingdee.eas.hr.train.client.RequirementClientUtil;
import com.kingdee.eas.hr.train.client.TableActionHandler;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseEditUI;
import com.kingdee.eas.hr.train.client.TrainCourseTreePromptBox;
import com.kingdee.eas.hr.train.client.TrainItemEditUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class RequirementResponseEditUI
extends AbstractRequirementResponseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RequirementResponseEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.TrainResource";
    protected SelectorItemCollection responseSelector;
    private boolean requireSubmitPrompt = true;
    private ItemAction[] itemActions = null;

    public RequirementResponseEditUI() throws Exception {
        this.setSelector();
    }

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
        this.handleRequirementType();
    }

    protected void init() throws Exception {
        TrainUtils.initOrgUnit(this.prmtAdminOrgUnit, false, (IUIObject)this);
        this.kdtAppointedCourse.checkParsed();
        this.kdtSuggestCourse.checkParsed();
        TrainClientUtil.setDisableColor(this.kdtAppointedCourse);
        this.itemActions = TrainUtils.addButtonsToMutilTable(this.contSuggestCourse, this.kdtSuggestCourse, new SuggestTableActionHandler());
        TrainUtils.setTableCellEditorByComboBox(this.kdtSuggestCourse, "type", "com.kingdee.eas.hr.train.RequirementCourseTypeEnum");
        TrainUtils.setTableCellEditorByTextField(this.kdtSuggestCourse, "trainSubject", 100);
        TrainUtils.setTableCellEditorByF7Selector(this.kdtSuggestCourse, (KDPromptSelector)new TrainCourseTreePromptBox((IUIObject)this), "courseType");
        TrainUtils.setTableCellEditorByDatePicker(this.kdtSuggestCourse, "startDate");
        KDFormattedTextField txtCost = TrainUtils.setTableCellEditorByFormattedTextField(this.kdtSuggestCourse, "cost", TrainClientUtil.PRECISION);
        TrainUtils.setPositiveNumberValue(txtCost);
        TrainUtils.setTableCellEditorByTextField(this.kdtSuggestCourse, "object", 100);
        TrainUtils.setTableCellEditorByTextField(this.kdtSuggestCourse, "remark", 200);
        TrainUtils.setTableCellEditorByTextField(this.kdtAppointedCourse, "suggest", 100);
        this.initRequirementGrade(this.kdtAppointedCourse);
        this.initRequirementGrade(this.kdtSuggestCourse);
    }

    private void setSelector() {
        this.responseSelector = super.getSelectors();
        this.responseSelector.add(new SelectorItemInfo("state"));
        this.responseSelector.add(new SelectorItemInfo("requirement.type"));
        this.responseSelector.add(new SelectorItemInfo("calculateTime"));
        this.responseSelector.add(new SelectorItemInfo("appointedCourse.requirementEntry.course.treeid.name"));
        this.responseSelector.add(new SelectorItemInfo("appointedCourse.requirementEntry.courseType.name"));
        this.responseSelector.add(new SelectorItemInfo("appointedCourse.requirementEntry.trainItem.treeid.name"));
        this.responseSelector.add(new SelectorItemInfo("appointedCourse.requirementEntry.trainItem.name"));
    }

    protected void initRequirementGrade(KDTable table) throws Exception {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnViewCourse.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnViewTrainItem.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemViewCourse.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.menuItemViewTrainItem.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.menuItemSave.setVisible(true);
    }

    private void handleRequirementType() {
        boolean isCourseType = RequirementTypeEnum.COURSE_TYPE.equals((Object)this.editData.getRequirement().getType());
        String nameStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"NAME");
        String typeStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"TYPE");
        String appointedNameTitle = null;
        String appointedTypeTitle = null;
        if (isCourseType) {
            String courseStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"TRAINCOURSE");
            appointedNameTitle = courseStr + nameStr;
            appointedTypeTitle = courseStr + typeStr;
        } else if (RequirementTypeEnum.ITEM_TYPE.equals((Object)this.editData.getRequirement().getType())) {
            String itemStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"TRAINITEM");
            appointedNameTitle = itemStr + nameStr;
            appointedTypeTitle = itemStr + typeStr;
        }
        IRow row = this.kdtAppointedCourse.getHeadRow(0);
        row.getCell(this.kdtAppointedCourse.getColumnIndex("contentName")).setValue((Object)appointedNameTitle);
        row.getCell(this.kdtAppointedCourse.getColumnIndex("contentType")).setValue((Object)appointedTypeTitle);
        this.btnViewCourse.setVisible(isCourseType);
        this.menuItemViewCourse.setVisible(isCourseType);
        this.btnViewTrainItem.setVisible(!isCourseType);
        this.menuItemViewTrainItem.setVisible(!isCourseType);
    }

    protected void setAppointedContentInfo() {
        ResponseAppointedCourseCollection collection = this.editData.getAppointedCourse();
        for (int i = 0; i < this.kdtAppointedCourse.getRowCount(); ++i) {
            IRow row = this.kdtAppointedCourse.getRow(i);
            ResponseAppointedCourseInfo entryInfo = (ResponseAppointedCourseInfo)RequirementClientUtil.getObjectValue((IObjectCollection)collection, row);
            if (entryInfo == null) continue;
            if (entryInfo.getRequirementEntry().getCourse() != null) {
                this.setRowCourseInfo(row, entryInfo.getRequirementEntry().getCourse());
                continue;
            }
            if (entryInfo.getRequirementEntry().getTrainItem() == null) continue;
            this.setRowTrainItemInfo(row, entryInfo.getRequirementEntry().getTrainItem());
        }
    }

    private void setRowCourseInfo(IRow row, TrainCourseInfo courseInfo) {
        String courseHour = null;
        if (courseInfo.getCourseHour() != null && courseInfo.getCourseHourUnit() != null) {
            courseHour = courseInfo.getCourseHour().setScale(TrainClientUtil.PRECISION) + courseInfo.getCourseHourUnit().getAlias();
        }
        row.getCell("courseHour").setValue(courseHour);
        TrainCourseTreeInfo courseType = null;
        if (courseInfo.getTreeid() != null) {
            courseType = courseInfo.getTreeid();
        }
        row.getCell("contentType").setValue((Object)courseType);
        row.getCell("contentName").setValue((Object)courseInfo.getName());
    }

    private void setRowTrainItemInfo(IRow row, TrainItemInfo trainItemInfo) {
        String courseHour = null;
        if (trainItemInfo.getCourseHour() != null && trainItemInfo.getCourseHourUnit() != null) {
            courseHour = trainItemInfo.getCourseHour().setScale(TrainClientUtil.PRECISION) + trainItemInfo.getCourseHourUnit().getAlias();
        }
        row.getCell("courseHour").setValue(courseHour);
        TrainItemTreeInfo itemType = null;
        if (trainItemInfo.getTreeid() != null) {
            itemType = trainItemInfo.getTreeid();
        }
        row.getCell("contentType").setValue((Object)itemType);
        row.getCell("contentName").setValue((Object)trainItemInfo.getName());
    }

    protected void setCompomentsState(boolean flag) {
        this.kdtAppointedCourse.getStyleAttributes().setLocked(!flag);
        this.kdtSuggestCourse.getStyleAttributes().setLocked(!flag);
        for (int i = 0; i < this.itemActions.length; ++i) {
            this.itemActions[i].setEnabled(flag);
        }
        if (RequirementResponseEnum.RESPONSED.equals((Object)this.editData.getState())) {
            this.actionSave.setEnabled(false);
        }
    }

    public IObjectPK runSubmit() throws Exception {
        if (this.requireSubmitPrompt && !TrainClientUtil.showConfirmMessge(RESOURCE, "CONFIRM_SUBMIT", (CoreUI)this)) {
            SysUtil.abort();
        }
        this.setRequireSubmitPrompt(true);
        return super.runSubmit();
    }

    public void actionViewCourse_actionPerformed(ActionEvent e) throws Exception {
        String courseStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"TRAINCOURSE");
        String message = TrainClientUtil.getResource("com.kingdee.eas.hr.train.RequirementResource", "OUTER_COURSE", new Object[]{courseStr, courseStr});
        TrainClientUtil.viewEditUI((CoreUI)this, TrainCourseEditUI.class.getName(), this.kdtAppointedCourse, "trainCourse", message);
    }

    public void actionViewTrainItem_actionPerformed(ActionEvent e) throws Exception {
        String trainItemStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"TRAINITEM");
        String message = TrainClientUtil.getResource("com.kingdee.eas.hr.train.RequirementResource", "OUTER_COURSE", new Object[]{trainItemStr, trainItemStr});
        TrainClientUtil.viewEditUI((CoreUI)this, TrainItemEditUI.class.getName(), this.kdtAppointedCourse, "trainItem", message);
    }

    protected void kdtAppointedCourse_editStarting(KDTEditEvent e) throws Exception {
        TrainUtils.setComboBoxSelected(e);
    }

    protected void kdtSuggestCourse_editStarting(KDTEditEvent e) throws Exception {
        TrainUtils.setComboBoxSelected(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.kdtSuggestCourse);
    }

    protected String getEditUIName() {
        return RequirementResponseEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RequirementResponseFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        String requirementId = (String)this.getUIContext().get("requirement");
        try {
            return RequirementAssistant.createRequirementResponseInfo(requirementId, SysContext.getSysContext().getCurrentUserInfo());
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtAdminOrgUnit);
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtSuggestCourse, "trainSubject");
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtSuggestCourse, "courseType");
        TrainVerifyUtils.verifyRepeatRow((CoreUIObject)this, this.kdtSuggestCourse, "trainSubject", null);
        IRow row = null;
        String courseName = null;
        for (int i = 0; i < this.kdtSuggestCourse.getRowCount(); ++i) {
            row = this.kdtSuggestCourse.getRow(i);
            courseName = (String)row.getCell("trainSubject").getValue();
            if (!TrainUtils.isRepeatRowInTable(this.kdtAppointedCourse, courseName, "contentName")) continue;
            this.kdtSuggestCourse.getEditManager().editCellAt(i, this.kdtSuggestCourse.getColumnIndex("trainSubject"));
            MsgBox.showWarning((Component)((Object)this), (String)TrainClientUtil.getResource("com.kingdee.eas.hr.train.RequirementResource", "COURSE_REPEATED", new Object[]{this.contAppointedCourse.getTitle(), this.contSuggestCourse.getTitle()}));
            SysUtil.abort();
        }
        this.verifyRequireLevel(this.kdtAppointedCourse, this.contAppointedCourse.getTitle());
        this.verifyRequireLevel(this.kdtSuggestCourse, this.contSuggestCourse.getTitle());
    }

    private void verifyRequireLevel(KDTable table, String tableTitle) {
        IRow row = null;
        boolean exist = false;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            exist = false;
            for (int j = 0; j < RequirementClientUtil.columns.length && !(exist = this.requireLevelHasValue(row.getCell(RequirementClientUtil.columns[j]).getValue())); ++j) {
            }
            if (exist) continue;
            int columnIndex = table.getColumnIndex(RequirementClientUtil.columns[1]);
            table.getEditManager().editCellAt(i, columnIndex);
            this.showRequireLevelWarning(tableTitle);
        }
    }

    protected boolean requireLevelHasValue(Object value) {
        return false;
    }

    protected void showRequireLevelWarning(String tableTitle) {
    }

    protected void showSaveSuccess() {
        this.showSuccessMessage(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
    }

    protected void showSubmitSuccess() {
        this.showSuccessMessage(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Submit_OK"));
    }

    protected void showSuccessMessage(String str) {
        this.setMessageText(str);
        this.setNextMessageText(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    public void setRequireSubmitPrompt(boolean require) {
        this.requireSubmitPrompt = require;
    }

    protected IRow setSuggestRowInfo(IRow row) {
        return row;
    }

    class SuggestTableActionHandler
    implements TableActionHandler {
        SuggestTableActionHandler() {
        }

        public IRow afterAddLine(IRow row) {
            return RequirementResponseEditUI.this.setSuggestRowInfo(row);
        }

        public IRow afterInsertLine(IRow row) {
            return this.afterAddLine(row);
        }
    }
}

