/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.client.PersonMultiPromptBox;
import com.kingdee.eas.hr.train.RequirementInfo;
import com.kingdee.eas.hr.train.RequirementResponseEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.client.AbstractRequirementResponseProcessFilterUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class RequirementResponseProcessFilterUI
extends AbstractRequirementResponseProcessFilterUI {
    private static final String ID = "person.id";
    private static final String STATE = "response.state";
    private static final String ADMINORG_UNITID = "adminOrgUnit.id";
    private static final String RESPONSEDATE = "response.responseDate";

    public RequirementResponseProcessFilterUI() throws Exception {
        this.clear();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        PersonMultiPromptBox personBox = new PersonMultiPromptBox();
        personBox.setIsDisplayHrOrgUnit(true);
        personBox.setIsSingleSelect(true);
        this.prmtRequirement.setSelector((KDPromptSelector)personBox);
        TrainUtils.initOrgUnit(this.prmtAdminOrgUnit, false, (IUIObject)this);
        this.prmtAdminOrgUnit.setEditable(false);
        TrainUtils.addComboBoxEmptyItem(this.cboState);
    }

    public FilterInfo getFilterInfo() {
        RequirementResponseEnum state;
        OrgUnitInfo orgUnitInfo;
        FilterInfo filterInfo = new FilterInfo();
        PersonInfo requirementInfo = (PersonInfo)this.prmtRequirement.getValue();
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)requirementInfo)) {
            filterInfo.getFilterItems().add(new FilterItemInfo(ID, (Object)requirementInfo.getId().toString()));
        }
        if ((orgUnitInfo = (OrgUnitInfo)this.prmtAdminOrgUnit.getValue()) != null && orgUnitInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo(ADMINORG_UNITID, (Object)orgUnitInfo.getId().toString()));
        }
        if ((state = (RequirementResponseEnum)((Object)this.cboState.getSelectedItem())) != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo(STATE, (Object)state.getValue()));
        }
        if (this.pkSubmintDate.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo(RESPONSEDATE, (Object)DateTimeUtils.truncateDate((Date)((Date)this.pkSubmintDate.getValue())), CompareType.GREATER_EQUALS));
        }
        return filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtRequirement);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtAdminOrgUnit);
        CustomerQueryUtil.storeToCustomerParams(cp, this.cboState);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkSubmintDate);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtRequirement, RequirementInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtAdminOrgUnit, AdminOrgUnitInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.cboState);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkSubmintDate);
    }

    public void clear() {
        this.prmtRequirement.setValue(null);
        this.prmtAdminOrgUnit.setValue(null);
        this.pkSubmintDate.setValue(null);
        this.cboState.setSelectedIndex(-1);
    }
}

