/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.train.RequirementFacadeFactory;
import com.kingdee.eas.hr.train.RequirementResponseEnum;
import com.kingdee.eas.hr.train.RequirementResponseFactory;
import com.kingdee.eas.hr.train.RequirementStateEnum;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.client.AbstractRequirementResponseProcessUI;
import com.kingdee.eas.hr.train.client.RequirementResponseProcessFilterUI;
import com.kingdee.eas.hr.train.client.RequirementSendMailUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RequirementResponseProcessUI
extends AbstractRequirementResponseProcessUI {
    private static final Logger logger = CoreUIObject.getLogger(RequirementResponseProcessUI.class);
    private String resClass = "com.kingdee.eas.hr.train.TrainHolidayResource.";
    private String requirementID;
    private String responserID;
    private Set receivers = null;
    private static String requirementName = null;

    public void onLoad() throws Exception {
        this.requirementID = this.getUIContext().get("requirement").toString();
        this.responserID = this.getUIContext().get("publisherId").toString();
        this.receivers = RequirementFacadeFactory.getRemoteInstance().getRequirementReceivers(this.requirementID, this.responserID);
        super.onLoad();
        RequirementStateEnum state = (RequirementStateEnum)((Object)this.getUIContext().get("requirementState"));
        this.sendMail.setEnabled(!RequirementStateEnum.CLOSED.equals((Object)state));
        requirementName = this.getUIContext().get("requirementName").toString();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.sendMail.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.btnSendMessage.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("publisher.id", (Object)this.responserID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)this.requirementID, CompareType.EQUALS));
        if (this.receivers != null && this.receivers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.receivers, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)"F117", CompareType.EQUALS));
        }
        return filter;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dlg = super.initCommonQueryDialog();
        dlg.setShowFilter(false);
        try {
            dlg.addUserPanel((KDPanel)new RequirementResponseProcessFilterUI());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return dlg;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RequirementResponseFactory.getRemoteInstance();
    }

    public void actionSendMail_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String fromPersonID = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
        PersonInfo pInfo = null;
        HashSet<String> emails = new HashSet<String>();
        StringBuffer acceptPersonNames = new StringBuffer();
        String accept = "";
        List selectedRows = TrainUtils.getSelectedRows(this.tblMain);
        IRow row = null;
        Iterator it = selectedRows.iterator();
        HashSet<String> personIds = new HashSet<String>();
        while (it.hasNext()) {
            int index = (Integer)it.next();
            row = this.tblMain.getRow(index);
            if (row.getCell("person.id") == null || row.getCell("person.id").getValue() == null) continue;
            personIds.add(row.getCell("person.id").getValue().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", personIds, CompareType.INCLUDE));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("email"));
        PersonCollection pColl = PersonFactory.getRemoteInstance().getPersonCollection(evi);
        StringBuffer nullEmailPersons = new StringBuffer();
        int j = pColl.size();
        for (int i = 0; i < j; ++i) {
            pInfo = pColl.get(i);
            if (!StringUtils.isEmpty((String)pInfo.getEmail()) && pInfo.getEmail().indexOf("@") > 0) {
                emails.add(pInfo.getEmail());
                acceptPersonNames.append(pInfo.getName());
                acceptPersonNames.append(";");
                continue;
            }
            nullEmailPersons.append(pInfo.getNumber()).append("      ").append(pInfo.getName()).append("\n");
        }
        if (nullEmailPersons != null && nullEmailPersons.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainResource", (String)"person_email_null"), (String)nullEmailPersons.toString(), (int)2);
        }
        if (emails.size() < 1) {
            return;
        }
        accept = acceptPersonNames.toString();
        accept = accept.substring(0, accept.lastIndexOf(";"));
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiContext.put((Object)"accept", (Object)accept);
        uiContext.put((Object)"email", emails);
        uiContext.put((Object)"person", (Object)fromPersonID);
        uiContext.put((Object)"requirementName", (Object)requirementName);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RequirementSendMailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List selectedRows = TrainUtils.getSelectedRows(this.tblMain);
        IRow row = null;
        Iterator it = selectedRows.iterator();
        ArrayList<String> personIds = new ArrayList<String>();
        while (it.hasNext()) {
            int index = (Integer)it.next();
            row = this.tblMain.getRow(index);
            if (!RequirementResponseEnum.UN_RESPONSE.getAlias().equals(row.getCell("response.state").getValue().toString()) || row.getCell("person.id") == null || row.getCell("person.id").getValue() == null) continue;
            personIds.add(row.getCell("person.id").getValue().toString());
        }
        if (personIds.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "noMessage")));
            return;
        }
        String fromPerson = SysContext.getSysContext().getCurrentUserInfo().getName();
        String Message2 = EASResource.getString((String)(this.resClass + "FINISHEDQUICKLY")) + " " + requirementName + " " + EASResource.getString((String)(this.resClass + "messageinfoo"));
        HashMap<String, String> messagMap = new HashMap<String, String>();
        messagMap.put("title", EASResource.getString((String)(this.resClass + "needMessage")) + Message2);
        messagMap.put("sender", fromPerson);
        messagMap.put("body", Message2);
        TrainActivityFacadeFactory.getRemoteInstance().sendMessage(personIds, messagMap);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "sendMessage")));
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        this.requirementID = this.getUIContext().get("requirement").toString();
        this.responserID = this.getUIContext().get("publisherId").toString();
        request.put("requirement", (Object)this.requirementID);
        request.put("responserId", (Object)this.responserID);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public boolean isPrepareInit() {
        return true;
    }
}

