/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.train.RequirementFactory;
import com.kingdee.eas.hr.train.RequirementInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.client.AbstractRequirementResponseSummaryFilterUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.hr.train.client.RequirementResponseCoursePromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RequirementResponseSummaryFilterUI
extends AbstractRequirementResponseSummaryFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RequirementResponseSummaryFilterUI.class);
    private Map context;

    public RequirementResponseSummaryFilterUI() throws Exception {
    }

    public RequirementResponseSummaryFilterUI(Map context) throws Exception {
        this.context = context;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        TrainUtils.initOrgUnit(this.prmtAdminOrg, true, (IUIObject)this);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        String requirementId = (String)this.context.get("requirement");
        RequirementInfo requirementInfo = RequirementFactory.getRemoteInstance().getRequirementInfo((IObjectPK)new ObjectUuidPK(requirementId), sic);
        this.txtRequirement.setText(requirementInfo.getName());
        RequirementResponseCoursePromptBox promptBox = new RequirementResponseCoursePromptBox((IUIObject)this, this.context);
        this.prmtCourse.setSelector((KDPromptSelector)promptBox);
        this.prmtCourse.setEnabledMultiSelection(true);
    }

    public FilterInfo getFilterInfo() {
        Object[] courses;
        FilterInfo filterInfo = new FilterInfo();
        Set adminOrgUnitIds = TrainCommonUtils.assembleSetByArray((Object[])this.prmtAdminOrg.getValue());
        if (adminOrgUnitIds != null && adminOrgUnitIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnitId", (Object)adminOrgUnitIds, CompareType.INCLUDE));
        }
        if ((courses = (Object[])this.prmtCourse.getValue()) != null && courses.length > 0) {
            HashSet<String> courseNames = new HashSet<String>();
            TrainCourseInfo trainCourseInfo = null;
            for (int i = 0; i < courses.length; ++i) {
                trainCourseInfo = (TrainCourseInfo)courses[i];
                courseNames.add(trainCourseInfo.getName());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("contentName", courseNames, CompareType.INCLUDE));
        }
        return filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtAdminOrg);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtCourse);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtAdminOrg, AdminOrgUnitInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtCourse, TrainCourseInfo.class.getName());
    }

    public void clear() {
        super.clear();
        this.prmtAdminOrg.setValue(null);
        this.prmtCourse.setValue(null);
    }

    public boolean verify() {
        return true;
    }
}

