/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.RequirementFacadeFactory;
import com.kingdee.eas.hr.train.RequirementTypeEnum;
import com.kingdee.eas.hr.train.ResponseAppointedCourseCollection;
import com.kingdee.eas.hr.train.ResponseAppointedCourseFactory;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.client.AbstractResponseSuggestSummaryUI;
import com.kingdee.eas.hr.train.client.ResponseSuggestSummaryFilterUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Set;
import org.apache.log4j.Logger;

public class ResponseSuggestSummaryUI
extends AbstractResponseSuggestSummaryUI {
    private static final Logger logger = CoreUIObject.getLogger(ResponseSuggestSummaryUI.class);
    private String requirementId = null;
    private Set allResponserIds = null;

    public void onLoad() throws Exception {
        this.requirementId = (String)this.getUIContext().get("requirement");
        String publisherId = (String)this.getUIContext().get("publisherId");
        this.allResponserIds = RequirementFacadeFactory.getRemoteInstance().getRequirementAllResponsers(this.requirementId, publisherId);
        this.checkHasSuggest(this.requirementId, this.allResponserIds);
        super.onLoad();
        this.setTableTitle();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                IRow row = null;
                for (int i = ResponseSuggestSummaryUI.this.tblMain.getRowCount() - 1; i >= 0; --i) {
                    row = ResponseSuggestSummaryUI.this.tblMain.getRow(i);
                    if (!TrainCommonUtils.isEmpty((String)row.getCell("suggest").getValue())) continue;
                    ResponseSuggestSummaryUI.this.tblMain.removeRow(i);
                }
                ResponseSuggestSummaryUI.this.tblMain.getGroupManager().group();
            }
        });
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getGroupManager().group();
    }

    private void checkHasSuggest(String requirementId, Set responseIds) throws BOSException {
        boolean noSuggest = true;
        if (responseIds != null && responseIds.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("suggest"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.requirement.id", (Object)requirementId));
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.responser.id", (Object)responseIds, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.state", (Object)20));
            filterInfo.getFilterItems().add(new FilterItemInfo("suggest", null, CompareType.NOTEQUALS));
            viewInfo.setFilter(filterInfo);
            ResponseAppointedCourseCollection collection = ResponseAppointedCourseFactory.getRemoteInstance().getResponseAppointedCourseCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    if (TrainCommonUtils.isEmpty(collection.get(i).getSuggest())) continue;
                    noSuggest = false;
                    break;
                }
            }
        }
        if (noSuggest) {
            TrainClientUtil.showErrorMessage("com.kingdee.eas.hr.train.RequirementResource", "NO_RESPONSESUGGEST_DATA", (CoreUI)this);
        }
    }

    private void setTableTitle() {
        String nameStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"NAME");
        String nameTitle = null;
        RequirementTypeEnum requirementType = (RequirementTypeEnum)((Object)this.getUIContext().get("requirementType"));
        if (RequirementTypeEnum.COURSE_TYPE.equals((Object)requirementType)) {
            String courseStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"TRAINCOURSE");
            nameTitle = courseStr + nameStr;
        } else if (RequirementTypeEnum.ITEM_TYPE.equals((Object)requirementType)) {
            String itemStr = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"TRAINITEM");
            nameTitle = itemStr + nameStr;
        }
        IRow row = this.tblMain.getHeadRow(0);
        row.getCell(this.tblMain.getColumnIndex("contentName")).setValue((Object)nameTitle);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirementId", (Object)this.requirementId));
        filterInfo.getFilterItems().add(new FilterItemInfo("responserId", (Object)this.allResponserIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("responseState", (Object)20));
        filterInfo.getFilterItems().add(new FilterItemInfo("suggest", null, CompareType.NOTEMPTY));
        return filterInfo;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            dialog.addUserPanel((KDPanel)new ResponseSuggestSummaryFilterUI(this.getUIContext()));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return dialog;
    }

    protected String getKeyFieldName() {
        return "appointedCourse.id";
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

