/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.base.uiframe.client.UINewSession;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.SurveyResponseFactory;
import com.kingdee.eas.hr.train.SurveyResponseInfo;
import com.kingdee.eas.hr.train.TrainSurveyStateEnum;
import com.kingdee.eas.hr.train.client.AbstractSurveyResponseListUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class SurveyResponseListUI
extends AbstractSurveyResponseListUI {
    private static final Logger logger = CoreUIObject.getLogger(SurveyResponseListUI.class);

    public void onLoad() throws Exception {
        TrainClientUtil.checkValidPerson((CoreUI)this);
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnResponse.setIcon(EASResource.getIcon((String)"imgTbtn_readin"));
        this.actionResponse.setEnabled(true);
    }

    public void actionResponse_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int index = TrainUtils.getCurrentRowIndex(this.tblMain);
        IRow row = this.tblMain.getRow(index);
        String state = row.getCell("state").getValue().toString();
        if (TrainSurveyStateEnum.CLOSE.getAlias().equals(state)) {
            this.actionView_actionPerformed(e);
        } else {
            String id = this.getSelectedKeyValue();
            if (StringUtils.isEmpty((String)id)) {
                this.actionAddNew_actionPerformed(e);
            } else {
                this.actionEdit_actionPerformed(e);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        String curPersonId = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)curPersonId));
        return filterInfo;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedKeyValue();
        if (StringUtils.isEmpty((String)id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.TRAINAutoGenerateResource", (String)"0_SurveyResponseListUI"));
            return;
        }
        super.actionView_actionPerformed(e);
    }

    protected String getKeyFieldName() {
        return "surveyResponse.id";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SurveyResponseFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        SurveyResponseInfo objectValue = new SurveyResponseInfo();
        return objectValue;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        int index = TrainUtils.getCurrentRowIndex(this.tblMain);
        uiContext.put((Object)"trainSurveyId", this.tblMain.getRow(index).getCell("id").getValue());
    }

    protected String getEditUIModal() {
        IUIWindow win = this.getUIWindow();
        if (win instanceof UINewFrame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        if (win instanceof UIDialog) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        if (win instanceof UINewSession) {
            return "com.kingdee.eas.base.uiframe.client.UINewSessionFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }
}

