/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.IJob;
import com.kingdee.eas.basedata.org.JobCollection;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.JobPromptBox;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.TechnicalPostCollection;
import com.kingdee.eas.hr.base.TechnicalPostFactory;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.client.TechnicalPostPromptBox;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.client.JobGradePromptBox;
import com.kingdee.eas.hr.train.SysCateFactory;
import com.kingdee.eas.hr.train.SysCateInfo;
import com.kingdee.eas.hr.train.SysCateJobEntryInfo;
import com.kingdee.eas.hr.train.SysCateJobGradeEntryInfo;
import com.kingdee.eas.hr.train.SysCatePostionEntryInfo;
import com.kingdee.eas.hr.train.SysCateTechPostEntryInfo;
import com.kingdee.eas.hr.train.TrainException;
import com.kingdee.eas.hr.train.TrainFacadeFactory;
import com.kingdee.eas.hr.train.client.AbstractSysCateConfigEditUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class SysCateConfigEditUI
extends AbstractSysCateConfigEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SysCateConfigEditUI.class);
    private Icon newLineIcon = EASResource.getIcon((String)"imgTbtn_addline");
    private Icon removeLineIcon = EASResource.getIcon((String)"imgTbtn_deleteline");
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private static final String title = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"trainSysRefConfig");

    public void onLoad() throws Exception {
        this.kdtJobEntry.checkParsed();
        this.kdtPostionEntry.checkParsed();
        this.kdtTechPostEntry.checkParsed();
        this.kdtJobGradeEntry.checkParsed();
        super.onLoad();
        this.disableTable(this.kdtJobEntry);
        this.disableTable(this.kdtPostionEntry);
        this.disableTable(this.kdtTechPostEntry);
        this.disableTable(this.kdtJobGradeEntry);
        if (this.editData.getParent() != null && this.editData.getParent().getName() != null) {
            this.txtName.setSelectedItem((Object)(this.editData.getParent().getName() + " - " + this.editData.getName()));
        } else {
            this.txtName.setSelectedItem((Object)this.editData.getName());
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    protected void lockUIForViewStatus() {
        this.chkShowDisplayName.setEnabled(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        boolean enabled = OprtState.EDIT.equals(this.getOprtState());
        JButton btnAddJob = this.contJob.add((Action)((Object)this.actionAddLineForJob));
        btnAddJob.setIcon(this.newLineIcon);
        btnAddJob.setToolTipText(EASResource.getString((String)RES, (String)"addJob"));
        btnAddJob.setEnabled(enabled);
        JButton btnRemoveJob = this.contJob.add((Action)((Object)this.actionRemoveLineForJob));
        btnRemoveJob.setIcon(this.removeLineIcon);
        btnRemoveJob.setToolTipText(EASResource.getString((String)RES, (String)"removeJob"));
        btnRemoveJob.setEnabled(enabled);
        JButton btnAddPosition = this.contPosition.add((Action)((Object)this.actionAddLineForPosition));
        btnAddPosition.setIcon(this.newLineIcon);
        btnAddPosition.setToolTipText(EASResource.getString((String)RES, (String)"addPosition"));
        btnAddPosition.setEnabled(enabled);
        JButton btnRemovePosition = this.contPosition.add((Action)((Object)this.actionRemoveLineForPosition));
        btnRemovePosition.setIcon(this.removeLineIcon);
        btnRemovePosition.setToolTipText(EASResource.getString((String)RES, (String)"removePosition"));
        btnRemovePosition.setEnabled(enabled);
        JButton btnAddTechPost = this.contTechPost.add((Action)((Object)this.actionAddLineForTechPost));
        btnAddTechPost.setIcon(this.newLineIcon);
        btnAddTechPost.setToolTipText(EASResource.getString((String)RES, (String)"addTechPost"));
        btnAddTechPost.setEnabled(enabled);
        JButton btnRemoveTechPost = this.contTechPost.add((Action)((Object)this.actionRemoveLineForTechPost));
        btnRemoveTechPost.setIcon(this.removeLineIcon);
        btnRemoveTechPost.setToolTipText(EASResource.getString((String)RES, (String)"removeTechPost"));
        btnRemoveTechPost.setEnabled(enabled);
        JButton btnAddJobGrade = this.contJobGrade.add((Action)((Object)this.actionAddLineForJobGrade));
        btnAddJobGrade.setIcon(this.newLineIcon);
        btnAddJobGrade.setToolTipText(EASResource.getString((String)RES, (String)"addJobGrade"));
        btnAddJobGrade.setEnabled(enabled);
        JButton btnRemoveJobGrade = this.contJobGrade.add((Action)((Object)this.actionRemoveLineForJobGrade));
        btnRemoveJobGrade.setIcon(this.removeLineIcon);
        btnRemoveJobGrade.setToolTipText(EASResource.getString((String)RES, (String)"removeJobGrade"));
        btnRemoveJobGrade.setEnabled(enabled);
    }

    protected IObjectValue createNewData() {
        SysCateInfo ret = new SysCateInfo();
        return ret;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SysCateFactory.getRemoteInstance();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    private void addLine(KDTable table, IObjectValue obj) {
        IRow row = table.addRow();
        this.loadLineFields(table, row, obj);
    }

    public void actionAddLineForJob_actionPerformed(ActionEvent e) throws Exception {
        JobPromptBox prmtJobBox = new JobPromptBox((IUIObject)this);
        prmtJobBox.setIsSingleSelect(false);
        prmtJobBox.show();
        if (prmtJobBox.isCanceled()) {
            return;
        }
        Object[] values = (Object[])prmtJobBox.getData();
        HashSet jobSet = this.getEntryTableID(this.kdtJobEntry, "jobID");
        JobInfo job = null;
        SysCateJobEntryInfo ret = null;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < values.length; ++i) {
            job = (JobInfo)values[i];
            set.add(job.getId().toString());
        }
        EntityViewInfo jobViewInfo = new EntityViewInfo();
        FilterInfo jobFilter = new FilterInfo();
        jobFilter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        jobViewInfo.setFilter(jobFilter);
        SelectorItemCollection jobSelector = jobViewInfo.getSelector();
        jobSelector.add(new SelectorItemInfo("id"));
        jobSelector.add(new SelectorItemInfo("name"));
        jobSelector.add(new SelectorItemInfo("number"));
        jobSelector.add(new SelectorItemInfo("jobCategory.name"));
        jobSelector.add(new SelectorItemInfo("jobCategory.id"));
        IJob iJob = JobFactory.getRemoteInstance();
        JobCollection jobColl = iJob.getJobCollection(jobViewInfo);
        int n = jobColl.size();
        for (int i = 0; i < n; ++i) {
            job = jobColl.get(i);
            if (job.getId() == null || jobSet.contains(job.getId().toString())) continue;
            ret = new SysCateJobEntryInfo();
            ret.setJob(job);
            this.addLine(this.kdtJobEntry, (IObjectValue)ret);
        }
    }

    public void actionShowDisplayName_actionPerformed(ActionEvent e) throws Exception {
        this.showDisplayName();
    }

    protected void showDisplayName() {
        this.showDisplayName("orgUnit", "orgDisplayName");
    }

    protected void showDisplayName(String col, String displayCol) {
        boolean isShowDisplay = this.chkShowDisplayName.isSelected();
        if (!this.kdtPostionEntry.getColumn(col).getStyleAttributes().isHided() || !this.kdtPostionEntry.getColumn(displayCol).getStyleAttributes().isHided()) {
            this.kdtPostionEntry.getColumn(col).getStyleAttributes().setHided(isShowDisplay);
            this.kdtPostionEntry.getColumn(displayCol).getStyleAttributes().setHided(!isShowDisplay);
        }
    }

    public void actionRemoveLineForJob_actionPerformed(ActionEvent e) throws Exception {
        this.removeLinesData(this.kdtJobEntry);
    }

    public void actionAddLineForPosition_actionPerformed(ActionEvent e) throws Exception {
        Frame frame = (Frame)this.getUIContext().get("OwnerWindow");
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("MULTI_SELECT", Boolean.TRUE);
        PositionPromptBox2 prmptPosition = new PositionPromptBox2(frame, hashMap);
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        Set hroSet = new HashSet();
        try {
            hroSet = TrainFacadeFactory.getRemoteInstance().getPersonHRRange(userID);
        }
        catch (EASBizException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        prmptPosition.setHROFilter(hroSet);
        prmptPosition.setModal(true);
        prmptPosition.show();
        if (prmptPosition.isCanceled()) {
            return;
        }
        Object[] posCol = (Object[])prmptPosition.getData();
        HashSet posSet = this.getEntryTableID(this.kdtPostionEntry, "position.id");
        PositionInfo position = null;
        SysCatePostionEntryInfo ret = null;
        HashSet<String> set = new HashSet<String>();
        int size = posCol.length;
        for (int i = 0; i < size; ++i) {
            position = (PositionInfo)posCol[i];
            if (posSet.contains(position.getId().toString())) continue;
            set.add(position.getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.displayName"));
        PositionCollection coll = PositionFactory.getRemoteInstance().getPositionCollection(viewInfo);
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            ret = new SysCatePostionEntryInfo();
            ret.setPosition(coll.get(i));
            this.addLine(this.kdtPostionEntry, (IObjectValue)ret);
        }
    }

    public void actionAddLineForTechPost_actionPerformed(ActionEvent e) throws Exception {
        TechnicalPostPromptBox prmptTechPost = new TechnicalPostPromptBox((IUIObject)this);
        prmptTechPost.setIsSingleSelect(false);
        prmptTechPost.show();
        if (prmptTechPost.isCanceled()) {
            return;
        }
        Object[] values = (Object[])prmptTechPost.getData();
        HashSet techPostSet = this.getEntryTableID(this.kdtTechPostEntry, "tehcPost.id");
        TechnicalPostInfo techPost = null;
        SysCateTechPostEntryInfo ret = null;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < values.length; ++i) {
            techPost = (TechnicalPostInfo)values[i];
            set.add(techPost.getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("category.id"));
        sic.add(new SelectorItemInfo("category.name"));
        sic.add(new SelectorItemInfo("level.id"));
        sic.add(new SelectorItemInfo("level.name"));
        TechnicalPostCollection coll = TechnicalPostFactory.getRemoteInstance().getTechnicalPostCollection(viewInfo);
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            ret = new SysCateTechPostEntryInfo();
            ret.setTechPost(coll.get(i));
            if (coll.get(i).getId() == null || techPostSet.contains(coll.get(i).getId().toString())) continue;
            this.addLine(this.kdtTechPostEntry, (IObjectValue)ret);
        }
    }

    public void actionRemoveLineForPosition_actionPerformed(ActionEvent e) throws Exception {
        this.removeLinesData(this.kdtPostionEntry);
    }

    public void actionRemoveLineForTechPost_actionPerformed(ActionEvent e) throws Exception {
        this.removeLinesData(this.kdtTechPostEntry);
    }

    public void removeLinesData(KDTable table) {
        TrainUtils.removeLine(table);
    }

    private void disableTable(KDTable table) {
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            table.getColumn(i).getStyleAttributes().setLocked(true);
        }
    }

    public void actionAddLineForJobGrade_actionPerformed(ActionEvent e) throws Exception {
        JobGradePromptBox box = new JobGradePromptBox((IUIObject)this);
        box.setIsSingleSelect(false);
        box.show();
        if (!box.isCanceled()) {
            Object[] datas = (Object[])box.getData();
            HashSet jobGradeIds = this.getEntryTableID(this.kdtJobGradeEntry, "jobGrade.id");
            if (datas != null && datas.length > 0) {
                SysCateJobGradeEntryInfo ret = null;
                JobGradeInfo jobGradeInfo = null;
                for (int i = 0; i < datas.length; ++i) {
                    jobGradeInfo = (JobGradeInfo)datas[i];
                    if (jobGradeInfo == null || jobGradeIds.contains(jobGradeInfo.getId().toString())) continue;
                    ret = new SysCateJobGradeEntryInfo();
                    ret.setJobGrade(jobGradeInfo);
                    this.addLine(this.kdtJobGradeEntry, (IObjectValue)ret);
                }
            }
        }
    }

    public void actionRemoveLineForJobGrade_actionPerformed(ActionEvent e) throws Exception {
        this.removeLinesData(this.kdtJobGradeEntry);
    }

    private HashSet getEntryTableID(KDTable entryTable, String entryTableID) {
        HashSet<String> set = new HashSet<String>();
        Object value = null;
        int index = entryTable.getColumnIndex(entryTableID);
        int n = entryTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            value = entryTable.getRow(i).getCell(index).getValue();
            if (value == null) continue;
            set.add(value.toString());
        }
        return set;
    }

    protected void showSaveSuccess() {
        this.setMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_TemporarilySave_OK"));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    protected void showSubmitSuccess() {
        this.setMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setNextMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AddNew"));
        } else if ("EDIT".equals(this.getOprtState())) {
            this.setNextMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        }
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    protected void showAddNew() {
        this.setMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AddNew"));
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    protected void showEdit() {
        this.setMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    protected void showView() {
        this.setMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_View"));
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (TrainUtils.isExistDupRowInTable(this.kdtJobEntry, "jobID")) {
            throw new TrainException(TrainException.SYSCATE_JOB_CANNOTDUP);
        }
        if (TrainUtils.isExistDupRowInTable(this.kdtPostionEntry, "position.id")) {
            throw new TrainException(TrainException.SYSCATE_POSITION_CANNOTDUP);
        }
        if (TrainUtils.isExistDupRowInTable(this.kdtTechPostEntry, "tehcPost.id")) {
            throw new TrainException(TrainException.SYSCATE_TECHPOST_CANNOTDUP);
        }
        if (TrainUtils.isExistDupRowInTable(this.kdtJobGradeEntry, "jobGrade.id")) {
            throw new TrainException(TrainException.SYSCATE_JOBGRADE_CANNOTDUP);
        }
    }

    public boolean isPrepareInit() {
        return true;
    }
}

