/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainActCourseStateEnum;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCourseSummaryCollection;
import com.kingdee.eas.hr.train.TrainCourseSummaryFactory;
import com.kingdee.eas.hr.train.TrainCourseSummaryInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainActCourseListUI;
import com.kingdee.eas.hr.train.client.TrainActCourseEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityCourseSelectUI;
import com.kingdee.eas.hr.train.client.TrainActivityEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseCostListUI;
import com.kingdee.eas.hr.train.client.TrainStudentCourseListUI;
import com.kingdee.eas.hr.train.client.TrainStudentListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TrainActCourseListUI
extends AbstractTrainActCourseListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActCourseListUI.class);
    private String trainActivityID;
    private ListEditUI listEditUI;
    private String trainStudentClassName;
    private String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";
    private boolean endState = false;

    public void onLoad() throws Exception {
        if (this.getUIContext().get("CURRENT.VO") != null) {
            this.getUIContext().remove("CURRENT.VO");
        }
        if (this.getUIContext().get("IDList") != null) {
            this.getUIContext().remove("IDList");
        }
        this.trainActivityID = (String)this.getUIContext().get("ID");
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(10);
        TrainUtils.setTableNumberFormat(this.tblMain, "totalCost", 2);
        TrainUtils.setTableNumberFormat(this.tblMain, "passStand", 2);
        this.setUIStatus();
        this.setDataObject(this.getEntityViewInfo());
        this.listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAddNew.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                TrainActCourseListUI.this.setActionStatus();
            }
        });
    }

    private void setActionStatus() {
        if (this.tblMain.getRowCount() <= 0) {
            this.actionStudentAssign.setEnabled(false);
            this.actionCourseBudget.setEnabled(false);
        } else {
            this.actionStudentAssign.setEnabled(true);
            this.actionCourseBudget.setEnabled(true);
        }
    }

    private void setUIStatus() throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("needDivide"));
        sic.add(new SelectorItemInfo("planActivity.id"));
        sic.add(new SelectorItemInfo("trainActState"));
        TrainActivityInfo activityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(this.trainActivityID), sic);
        if (activityInfo.getTrainActState().getValue() == 40) {
            this.endState = true;
        }
        this.btnEnd.setEnabled(this.endState);
        if (this.trainStudentClassName == null) {
            this.trainStudentClassName = !activityInfo.isNeedDivide() ? TrainStudentCourseListUI.class.getName() : TrainStudentListUI.class.getName();
        }
        if (activityInfo.getPlanActivity() == null) {
            this.actionReferPlanCourse.setEnabled(false);
        } else {
            this.actionReferPlanCourse.setEnabled(true);
        }
    }

    public void setTrainStudentClassName(String trainStudentClassName) {
        this.trainStudentClassName = trainStudentClassName;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnReferPlanCourse.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnCourseBudget.setIcon(EASResource.getIcon((String)"imgTbtn_budgetadjust"));
        this.btnStudentAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnEnd.setIcon(EASResource.getIcon((String)"imgTbtn_allfinishinitialize"));
    }

    public void onShow() throws Exception {
        super.onShow();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAddNew.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                rowSet.updateString("studentAmount", this.getStudentCount(rowSet.getString("id")));
                rowSet.updateString("trainDateTime", TrainActivityHelper.getStartDate2EndDateString(rowSet.getDate("startDate"), rowSet.getDate("endDate")));
                BigDecimal courseHour = null;
                if (rowSet.getBigDecimal("CourseHour") != null && rowSet.getString("CourseHourUnit") != null) {
                    courseHour = rowSet.getBigDecimal("CourseHour", 2);
                    rowSet.updateString("LessonHour", courseHour + rowSet.getString("CourseHourUnit"));
                }
                String trainChannel = rowSet.getString("trainChannel.name");
                String trainChannelType = rowSet.getString("trainChanneCategory.name");
                if (trainChannel == null || trainChannelType == null) continue;
                rowSet.updateString("channelCourse.name", trainChannel + "_" + trainChannelType);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    private IObjectValue getEntityViewInfo() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)this.trainActivityID));
        evi.setFilter(fi);
        return evi;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"TrainActivityID", (Object)this.trainActivityID);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refreshData(e);
        }
    }

    protected String getEditUIName() {
        return TrainActCourseEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainActCourseFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainActCourseInfo objectValue = new TrainActCourseInfo();
        return objectValue;
    }

    public void actionStudentAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionStudentAssign_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"TrainActivityID", (Object)this.trainActivityID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.trainStudentClassName, (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        this.listEditUI.uiMap.remove("com.kingdee.eas.hr.train.client.TrainActStudentListUI");
        this.refreshData(e);
    }

    public void actionCourseBudget_actionPerformed(ActionEvent e) throws Exception {
        super.actionCourseBudget_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"TrainActivityID", (Object)this.trainActivityID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TrainCourseCostListUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        this.refreshData(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        if (!this.confirmRemove()) {
            return;
        }
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet();
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            idSet.add(it.next());
        }
        this.prepareCheckRemove(idSet).callHandler();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(fInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("TrainActCourse.TrainCourse.name"));
        TrainCourseSummaryCollection trainCourseSummaryColl = TrainCourseSummaryFactory.getRemoteInstance().getTrainCourseSummaryCollection(viewInfo);
        TrainCourseSummaryInfo trainCourseSummaryInfo = null;
        StringBuffer courseNames = new StringBuffer();
        if (trainCourseSummaryColl != null && trainCourseSummaryColl.size() > 0) {
            int size = trainCourseSummaryColl.size();
            for (int i = 0; i < size; ++i) {
                trainCourseSummaryInfo = trainCourseSummaryColl.get(i);
                courseNames.append(trainCourseSummaryInfo.getTrainActCourse().getTrainCourse().getName());
                if (i == size - 1) continue;
                courseNames.append(",");
            }
        }
        String message = EASResource.getString((String)this.resourcePath, (String)"ConfirmDelTrainActCourse");
        message = message.replaceAll("#0", courseNames.toString());
        if (!courseNames.toString().trim().equals("")) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)message))) {
                this.prepareRealRemove(idSet).callHandler();
                TrainActCourseFactory.getRemoteInstance().delete(idSet, this.trainActivityID);
                this.refresh(e);
            }
        } else {
            TrainActCourseFactory.getRemoteInstance().delete(idSet, this.trainActivityID);
            this.refresh(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionReferPlanCourse_actionPerformed(ActionEvent e) throws Exception {
        super.actionReferPlanCourse_actionPerformed(e);
        UIContext context = new UIContext((Object)this);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("needDivide"));
        sic.add(new SelectorItemInfo("planActivity.id"));
        TrainActivityInfo activityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(this.trainActivityID), sic);
        context.put((Object)"TrainActivityID", (Object)this.trainActivityID);
        context.put((Object)"ID", (Object)activityInfo.getPlanActivity().getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TrainActivityCourseSelectUI.class.getName(), (Map)context, null, OprtState.VIEW);
        uiWindow.show();
        TrainActivityCourseSelectUI uiObj = (TrainActivityCourseSelectUI)uiWindow.getUIObject();
        HashSet courseIdSet = uiObj.getSelectedCourse();
        if (courseIdSet == null || courseIdSet.size() == 0) {
            return;
        }
        TrainActivityFacadeFactory.getRemoteInstance().referPlanCourse(courseIdSet, this.trainActivityID);
        this.refresh(null);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.setActivityBudgetCost();
        this.setActionStatus();
    }

    private void refreshData(ActionEvent e) throws Exception {
        this.prepareRefresh(null).callHandler();
        this.refresh(e);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)this.trainActivityID));
        return fi;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        queryExecutor.option().isAutoIgnoreZero = false;
        return queryExecutor;
    }

    private void setActivityBudgetCost() throws EASBizException, BOSException {
        TrainActivityInfo trainActivityInfo;
        TrainActivityEditUI trainActivityEditUI = (TrainActivityEditUI)((Object)this.listEditUI.uiMap.get(TrainActivityEditUI.class.getName()));
        if (trainActivityEditUI != null && (trainActivityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(this.trainActivityID))) != null) {
            trainActivityEditUI.txtBudgetCost.setValue((Object)trainActivityInfo.getBudgetCost());
        }
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        handler.setRequestContext((Serializable)this.prepareParameters(null));
        return handler;
    }

    public IUIActionPostman prepareRefresh(RequestContext request) {
        IUIActionPostman handler = super.prepareRefresh(request);
        handler.setRequestContext((Serializable)this.prepareParameters(null));
        return handler;
    }

    public RequestContext prepareActionRefresh(IItemAction itemAction) throws Exception {
        return this.prepareParameters(super.prepareActionRefresh(itemAction));
    }

    private RequestContext prepareParameters(RequestContext request) {
        if (request == null) {
            request = new RequestContext();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("needDivide"));
        sic.add(new SelectorItemInfo("planActivity.id"));
        request.put("infoSelector", (Object)sic);
        String actId = (String)this.getUIContext().get("ID");
        request.put("trainActivityId", (Object)actId);
        return request;
    }

    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        IUIActionPostman handler = super.prepareQuery(e);
        handler.setRequestContext((Serializable)this.prepareParameters(null));
        return handler;
    }

    private IUIActionPostman prepareCheckRemove(Set idSet) {
        IUIActionPostman handler = this.prepareRealRemove(idSet);
        RequestContext request = new RequestContext();
        request.setMethodName("handleCheckRemove");
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    private IUIActionPostman prepareRealRemove(Set idSet) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = this.prepareQueryContext(null);
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("handleRealRemove");
        this.prepareParameters(request);
        request.put("trainActCourseIds", (Object)idSet);
        request.put("trainActivityId", (Object)this.trainActivityID);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public void actionEnd_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
        String id = this.getSelectedKeyValue();
        this.verifyActivityFinishCondition(id);
        TrainActivityFacadeFactory.getRemoteInstance().finishTrainActCourse(id);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"FinishSuccess"));
        BizEnumValueInfo valueInfo = new BizEnumValueInfo();
        valueInfo.setValue((Object)TrainActCourseStateEnum.END);
        this.tblMain.getRow(selectedRow).getCell("state").setValue((Object)valueInfo);
        this.refreshTable(selectedRow);
        this.setWorkButtonStatus(TrainActCourseStateEnum.END);
    }

    private void refreshTable(int selectedRow) {
        this.tblMain.refresh();
        this.tblMain.getSelectManager().select(selectedRow, 0);
    }

    private void setWorkButtonStatus(TrainActCourseStateEnum approved) {
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            if (TrainActCourseStateEnum.END.equals((Object)approved)) {
                this.btnEdit.setEnabled(false);
                this.btnStudentAssign.setEnabled(false);
                this.btnRemove.setEnabled(false);
            } else {
                this.btnEdit.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.btnStudentAssign.setEnabled(true);
            }
        }
        if (this.endState) {
            if (TrainActCourseStateEnum.END.equals((Object)approved)) {
                this.btnEnd.setEnabled(false);
            } else {
                this.btnEnd.setEnabled(true);
            }
        }
    }

    private void verifyActivityFinishCondition(String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("EndDate"));
        TrainActCourseInfo info = TrainActCourseFactory.getRemoteInstance().getTrainActCourseInfo((IObjectPK)new ObjectUuidPK(id), sic);
        Date currentDate = new Date();
        if (info.getEndDate() != null && currentDate.before(info.getEndDate()) && !TrainClientUtil.showConfirmMessge(this.resourcePath, "Finish_Confirm_Message", (CoreUI)this)) {
            SysUtil.abort();
        }
    }

    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.tblMain_activeCellChanged(e);
        this.tblMain.checkParsed();
        if (this.tblMain.getSelectManager().get() == null) {
            return;
        }
        int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
        if (selectedRow < 0) {
            return;
        }
        BizEnumValueInfo state = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("state").getValue();
        if (state != null) {
            this.setWorkButtonStatus(TrainActCourseStateEnum.getEnum(state.getInt()));
        } else {
            if (!OprtState.VIEW.equals(this.getOprtState())) {
                this.btnEdit.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.btnStudentAssign.setEnabled(true);
            }
            if (this.endState) {
                this.btnEnd.setEnabled(true);
            }
        }
    }

    private String getStudentCount(String trainActCourseID) {
        String sql = "select count(fpersonid) as a from (SELECT DISTINCT fpersonid FROM T_HR_TrainStudentCourse where FTrainActCourseID='" + trainActCourseID + "') as tmpTable";
        String count = "";
        try {
            IRowSet rows = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
            if (rows != null && rows.next()) {
                count = rows.getString(1);
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        return count;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionStudentAssign() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }
}

