/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainActCourseWorkloadQueryPanelUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.hr.train.client.TrainCourseForReportPromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TrainActCourseWorkloadQueryPanelUI
extends AbstractTrainActCourseWorkloadQueryPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActCourseWorkloadQueryPanelUI.class);
    private static String RES = "com.kingdee.eas.hr.train.client.TrainReportResource";

    public FilterInfo getFilterInfo() {
        int i;
        HashSet<String> idSet;
        Object[] objs;
        FilterInfo filter = new FilterInfo();
        if (this.prmtOrgUnit.getData() != null && (objs = (Object[])this.prmtOrgUnit.getData()).length != 0 && objs[0] != null) {
            idSet = new HashSet<String>();
            for (i = 0; i < objs.length; ++i) {
                idSet.add(((AdminOrgUnitInfo)objs[i]).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("lastAdminOrgUnitID", idSet, CompareType.INCLUDE));
        }
        if (this.prmtPerson.getValue() != null && (objs = (Object[])this.prmtPerson.getData()).length != 0 && objs[0] != null) {
            idSet = new HashSet();
            for (i = 0; i < objs.length; ++i) {
                idSet.add(((PersonInfo)objs[i]).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("lastPersonId", idSet, CompareType.INCLUDE));
        }
        if (this.prmtTrainAct.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((TrainActivityInfo)this.prmtTrainAct.getValue()).getId().toString()));
        }
        if (this.prmtTrainCourse.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("trainCourse.id", (Object)((TrainCourseInfo)this.prmtTrainCourse.getValue()).getId().toString()));
        }
        FilterItemInfo filterItemInfo = null;
        Date beginDate = (Date)this.dateStart.getValue();
        beginDate.setHours(0);
        beginDate.setMinutes(0);
        beginDate.setSeconds(0);
        filterItemInfo = new FilterItemInfo("endDate", (Object)beginDate, CompareType.GREATER_EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        Date endDate = (Date)this.dateEnd.getValue();
        endDate.setHours(23);
        endDate.setMinutes(59);
        endDate.setSeconds(59);
        filterItemInfo = new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        return filter;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7();
    }

    public void clear() {
        super.clear();
        this.clearPanel();
    }

    public void initF7() throws Exception {
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmt.setIsSingleSelect(false);
        pmt.setModal(true);
        this.prmtPerson.setSelector((KDPromptSelector)pmt);
        this.prmtPerson.setEnabledMultiSelection(true);
        this.prmtPerson.setEditable(false);
        TrainUtils.initOrgUnit(this.prmtOrgUnit, true, (IUIObject)this);
        this.initTrainActF7();
        this.initTrainCourseF7();
        Date date = new Date();
        this.dateStart.setValue((Object)this.getTheDate(date));
        this.dateEnd.setValue((Object)date);
    }

    private void initTrainActF7() throws BOSException {
        this.prmtTrainAct.setQueryInfo("com.kingdee.eas.hr.train.app.TrainActivityQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = PFUtils.getHRAndAdminRangeFilterInfo((String)"HrOrgUnit.id", (String)"belongOrgUnit.id");
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)50));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)40));
        if (this.prmtTrainCourse.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trainCourse.id", (Object)((TrainCourseInfo)this.prmtTrainCourse.getValue()).getId().toString()));
            filterInfo.setMaskString("#0 and (#1 or #2) and #3");
        } else {
            filterInfo.setMaskString("#0 and (#1 or #2)");
        }
        viewInfo.setFilter(filterInfo);
        this.prmtTrainAct.setEntityViewInfo(viewInfo);
    }

    private void initTrainCourseF7() {
        if (this.prmtTrainAct.getValue() != null) {
            this.prmtTrainCourse.setSelector(null);
            this.prmtTrainCourse.setQueryInfo("com.kingdee.eas.hr.train.app.TrainActCourseWorkloadTrainCourseQuery");
            EntityViewInfo courseViewInfo = new EntityViewInfo();
            FilterInfo courseFilterInfo = new FilterInfo();
            courseFilterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((TrainActivityInfo)this.prmtTrainAct.getValue()).getId().toString()));
            courseFilterInfo.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
            courseViewInfo.setFilter(courseFilterInfo);
            this.prmtTrainCourse.setEntityViewInfo(courseViewInfo);
        } else {
            TrainCourseForReportPromptBox pmt = new TrainCourseForReportPromptBox((IUIObject)this);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
            pmt.setFilterInfo(fi);
            pmt.setSelector(this.getCourseSelectors());
            this.prmtTrainCourse.setSelector((KDPromptSelector)pmt);
            this.prmtTrainCourse.setEditable(false);
        }
    }

    private SelectorItemCollection getCourseSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("treeid.name"));
        sic.add(new SelectorItemInfo("CourseKind.name"));
        sic.add(new SelectorItemInfo("CourseTarget"));
        return sic;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CustomerQueryUtil.storeToCustomerParams(cp, this.dateStart);
        CustomerQueryUtil.storeToCustomerParams(cp, this.dateEnd);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtOrgUnit);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtPerson);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtTrainAct);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtTrainCourse);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        CustomerQueryUtil.loadFromCustomerParams(cp, this.dateStart);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.dateEnd);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtOrgUnit, AdminOrgUnitInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtPerson, PersonInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtTrainAct, TrainActivityInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtTrainCourse, TrainCourseInfo.class.getName());
    }

    public void clearPanel() {
        this.dateStart.setValue(null);
        this.dateEnd.setValue(null);
        this.prmtPerson.setValue(null);
        this.prmtOrgUnit.setValue(null);
        this.prmtTrainAct.setValue(null);
        this.prmtTrainCourse.setValue(null);
        this.prmtPerson.setEnabled(true);
        this.prmtOrgUnit.setEnabled(true);
        this.prmtTrainAct.setEnabled(true);
        this.prmtTrainCourse.setEnabled(true);
    }

    public boolean verify() {
        Date beginDate = (Date)this.dateStart.getValue();
        Date endDate = (Date)this.dateEnd.getValue();
        if (beginDate == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"beginDateCanNotNull"));
            this.dateStart.requestFocus();
            SysUtil.abort();
        }
        if (endDate == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"endDateCanNotNull"));
            this.dateEnd.requestFocus();
            SysUtil.abort();
        }
        if (DateTimeUtils.dayAfter((Date)beginDate, (Date)endDate)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"DATESCOPEERROR"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public Date getTheDate(Date date) {
        Date theDate = null;
        theDate = new Date(date.getYear(), date.getMonth(), 1);
        return theDate;
    }

    protected void prmtTrainAct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtTrainAct_dataChanged(e);
        this.initTrainCourseF7();
    }

    protected void prmtTrainCourse_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtTrainCourse_dataChanged(e);
        this.initTrainActF7();
    }
}

