/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.TrainActDeptStudentFactory;
import com.kingdee.eas.hr.train.TrainActDeptStudentInfo;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainConstants;
import com.kingdee.eas.hr.train.client.AbstractTrainActDeptStudentEditUI;
import com.kingdee.eas.hr.train.client.RowDataHandler;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class TrainActDeptStudentEditUI
extends AbstractTrainActDeptStudentEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActDeptStudentEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.TrainActivityResource";
    private ItemAction[] actions = null;

    public void onLoad() throws Exception {
        this.initKdtEntrys();
        super.onLoad();
        TrainUtils.selectFirstRow(this.kdtEntrys);
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
    }

    private void initKdtEntrys() throws Exception {
        this.kdtEntrys.checkParsed();
        this.actions = TrainUtils.addButtonsToMutilTable(this.conEntrys, this.kdtEntrys);
        this.initAdminOrgUnit();
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(0);
        formattedTextField.setHorizontalAlignment(4);
        this.kdtEntrys.getColumn("studentNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        this.kdtEntrys.getColumn("adminOrgUnitNumber").getStyleAttributes().setBackground(TrainConstants.disableColor);
        TrainUtils.setTableCellEditorByTextField(this.kdtEntrys, "remark");
        TrainClientUtil.setFormattedTextFieldMaxMinValue(formattedTextField);
    }

    private void initAdminOrgUnit() throws Exception {
        KDBizPromptBox prmtAdminOrgUnit = new KDBizPromptBox();
        prmtAdminOrgUnit.setEditFormat("$number$");
        prmtAdminOrgUnit.setCommitFormat("$number$");
        prmtAdminOrgUnit.setDisplayFormat("$name$");
        prmtAdminOrgUnit.setEnabledMultiSelection(true);
        prmtAdminOrgUnit.setEditable(true);
        TrainUtils.initOrgUnit(prmtAdminOrgUnit, true, (IUIObject)this);
        prmtAdminOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null && e.getData() instanceof Object[]) {
                    TrainActDeptStudentEditUI.this.handleResult(e);
                    e.setResult(0);
                }
            }
        });
        this.kdtEntrys.getColumn("adminOrgUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAdminOrgUnit));
    }

    private void handleResult(PreChangeEvent e) {
        RowDataHandler handler = new RowDataHandler(){

            public boolean setRowData(IRow row, Object object) {
                AdminOrgUnitInfo info;
                boolean result = false;
                if (row != null && object != null && !TrainUtils.isRepeatRowInTable(TrainActDeptStudentEditUI.this.kdtEntrys, info = (AdminOrgUnitInfo)object, "adminOrgUnit")) {
                    row.getCell("adminOrgUnit").setValue((Object)info);
                    row.getCell("adminOrgUnitNumber").setValue((Object)info.getNumber());
                    result = true;
                }
                return result;
            }
        };
        TrainUtils.batchAddRowWithData(this.kdtEntrys, (Object[])e.getData(), "adminOrgUnit", handler);
    }

    public void loadFields() {
        super.loadFields();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setActionState(false);
        } else {
            this.setActionState(true);
        }
    }

    private void setActionState(boolean flag) {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].setEnabled(flag);
        }
        this.kdtEntrys.getStyleAttributes().setLocked(!flag);
    }

    protected IObjectValue createNewData() {
        TrainActDeptStudentInfo objectValue = new TrainActDeptStudentInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setTrainActivity((TrainActivityInfo)this.getUIContext().get("TrainActDeptStudent"));
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainActDeptStudentFactory.getRemoteInstance();
    }

    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtEntrys.getColumnIndex("adminOrgUnit")) {
            int rowIndex = e.getRowIndex();
            IRow row = this.kdtEntrys.getRow(rowIndex);
            AdminOrgUnitInfo orgUnitInfo = (AdminOrgUnitInfo)row.getCell(colIndex).getValue();
            if (orgUnitInfo != null) {
                row.getCell("adminOrgUnitNumber").setValue((Object)orgUnitInfo.getNumber());
            } else {
                row.getCell("adminOrgUnitNumber").setValue(null);
            }
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        String title = this.conEntrys.getTitle();
        TrainVerifyUtils.verifyEntrys((CoreUIObject)this, this.kdtEntrys, title);
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtEntrys, "adminOrgUnit");
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtEntrys, "studentNumber");
        TrainVerifyUtils.verifyNumberPositive((CoreUIObject)this, this.kdtEntrys, "studentNumber");
        TrainVerifyUtils.verifyRepeatRow((CoreUIObject)this, this.kdtEntrys, "adminOrgUnit", title);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        BigDecimal maxStudentCount;
        super.verifyInput(e);
        if (this.kdtEntrys.getRowCount() <= 0) {
            return;
        }
        int studentCount = 0;
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            int count = (Integer)this.kdtEntrys.getRow(i).getCell("studentNumber").getValue();
            studentCount += count;
        }
        BigDecimal minStudentCount = this.editData.getTrainActivity().getMinStudentCount();
        if (minStudentCount != null && studentCount < minStudentCount.intValue() && !TrainClientUtil.showConfirmMessge((CoreUI)this, RESOURCE, "DeptStudent_Less", new Object[]{String.valueOf(minStudentCount)})) {
            SysUtil.abort();
        }
        if ((maxStudentCount = this.editData.getTrainActivity().getMaxStudentCount()) != null && studentCount > maxStudentCount.intValue() && !TrainClientUtil.showConfirmMessge((CoreUI)this, RESOURCE, "DeptStudent_Than", new Object[]{String.valueOf(maxStudentCount)})) {
            SysUtil.abort();
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("trainActivity.id"));
        sic.add(new SelectorItemInfo("trainActivity.minStudentCount"));
        sic.add(new SelectorItemInfo("trainActivity.maxStudentCount"));
        return sic;
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK pk = super.runSubmit();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
        return pk;
    }

    public boolean isPrepareInit() {
        return true;
    }
}

