/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityEnum;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainResourceException;
import com.kingdee.eas.hr.train.client.AbstractTrainActManagerUI;
import com.kingdee.eas.hr.train.client.TrainActParticipantScopeListUI;
import com.kingdee.eas.hr.train.client.TrainActivityEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import org.apache.log4j.Logger;

public class TrainActManagerUI
extends AbstractTrainActManagerUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActManagerUI.class);
    private String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";
    private boolean isPublished;
    private boolean isAudited;
    private boolean isCanceled = true;

    public boolean isAudited() {
        return this.isAudited;
    }

    public void setAudited(boolean isAudited) {
        this.isAudited = isAudited;
    }

    public void setPublished(boolean isPublished) {
        this.isPublished = isPublished;
    }

    public boolean isPublished() {
        return this.isPublished;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public void onLoad() throws Exception {
        this.getUIContext().put("IDList", new RealModeIDList());
        this.btnAddNew.setEnabled(false);
        this.btnAddNew.setVisible(false);
        super.onLoad();
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.getUIContext().put("OwnerWindow", this);
    }

    protected IObjectValue createNewData() {
        TrainActivityInfo objectValue = new TrainActivityInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainActivityFactory.getRemoteInstance();
    }

    protected List getUIList() {
        return TrainActivityEnum.getEnumList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkBeforeWindowClosing() {
        int result;
        TrainActStateEnum status;
        Boolean isModify = (Boolean)this.getUIContext().get("IsModifyTrainActivity");
        if (isModify != null && isModify.booleanValue() && (status = (TrainActStateEnum)((Object)this.getUIContext().get("TrainActivityStatus"))).equals((Object)TrainActStateEnum.APPROVED)) {
            result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmAuditTrainActivity"));
            if (result == 0) {
                try {
                    TrainActivityFacadeFactory.getRemoteInstance().reAudit((String)this.getUIContext().get("ID"), TrainAuditStateEnum.UNSUBMIT, TrainActStateEnum.NOT_EFFECTIVE);
                    return true;
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                return true;
            }
            if (result != 1 || this.isPublished) return result == 1 && this.isPublished;
            int result2 = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmPublishTrainActivity"));
            if (result2 != 0) return result2 == 1;
            try {
                this.getUIContext().put("Send", "Yes");
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainActParticipantScopeListUI.class.getName(), this.getUIContext(), null, OprtState.ADDNEW);
                uiWindow.show();
            }
            catch (UIException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        Boolean isFromPlanActivity = (Boolean)this.getUIContext().get("isCanceled");
        if (!this.isCanceled() || isFromPlanActivity == null) return true;
        result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
        if (result == 0) {
            TrainActivityEditUI trainActivityEditUI = (TrainActivityEditUI)((Object)this.uiMap.get("com.kingdee.eas.hr.train.client.TrainActivityEditUI"));
            try {
                trainActivityEditUI.submit();
                this.setCanceled(false);
                return true;
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            return true;
        }
        if (result != 1) return false;
        String trainActivityId = (String)this.getUIContext().get("ID");
        try {
            TrainActivityFactory.getRemoteInstance().deleteForPlanActivity(trainActivityId);
            this.setCanceled(true);
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return true;
    }

    protected void processRecordMove2() throws Exception {
        if (this.uiObj instanceof EditUI) {
            ((EditUI)this.uiObj).loadFields();
        } else if (this.uiObj instanceof ListUI) {
            ((ListUI)this.uiObj).refreshList();
        }
    }

    protected void listMain_valueChanged(ListSelectionEvent e) throws Exception {
        TrainActivityEditUI activityEditUI;
        boolean flag = false;
        if (this.uiObj instanceof EditUI && this.uiObj instanceof TrainActivityEditUI && (activityEditUI = (TrainActivityEditUI)this.uiObj).isModify()) {
            int result = MsgBox.showConfirm3((String)EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"97_EvaluFormSolutionEditUI"));
            if (result == 0) {
                this.setMainStatusBar(null);
                try {
                    activityEditUI.submit();
                    flag = true;
                }
                catch (TrainResourceException e1) {
                    MsgBox.showInfo((String)e1.getMessage());
                    activityEditUI.onLoad();
                    this.listMain.setSelectedIndex(0);
                }
            } else if (result == 2) {
                activityEditUI.onLoad();
                this.listMain.setSelectedIndex(0);
            } else if (result == 1) {
                activityEditUI.onLoad();
                flag = true;
            }
        }
        if (flag) {
            this.listMain.setValueIsAdjusting(false);
        }
        super.listMain_valueChanged(e);
    }

    public boolean isRefreshParent() {
        return true;
    }

    public void showStateMessage() {
        this.showSubmitSuccess();
    }

    protected void showSubmitSuccess() {
        this.setMessageText(EASResource.getString((String)this.resourcePath, (String)"ActivityBaseInfo_SubmitSuccess"));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }
}

