/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainStudentCourseFactory;
import com.kingdee.eas.hr.train.TrainStudentCourseInfo;
import com.kingdee.eas.hr.train.TrainStudentFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainActStudentListUI;
import com.kingdee.eas.hr.train.client.TrainStudentCourseEditUI;
import com.kingdee.eas.hr.train.client.TrainStudentCourseListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainActStudentListUI
extends AbstractTrainActStudentListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActStudentListUI.class);
    private String trainActivityID;
    boolean isNeedDivide = false;
    private CommonQueryDialog commonQueryDialog = null;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.trainActivityID = (String)this.getUIContext().get("ID");
        this.initWorkButton();
        this.tblMain.getSelectManager().setSelectMode(10);
        TrainUtils.setKDTableSortable(this.tblMain);
        TrainActivityInfo info = this.getTrainActivityInfo();
        if (info.isNeedDivide()) {
            this.setMainQueryPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainStudentQuery"));
            this.putBindContents("mainQuery", new String[]{"", "Person.id", "Type", "Person.number", "Person.name", "Person.gender", "AdminOrgUnit.name", "PosiStudent.name", "job.name", "technicalPost.name", "personDegree.specialty", "degree.name", "personCM.mobile", "Person.email", "Person.cell", "Person.officePhone", "HighDegree.highestDiploma", "HighDegree.specialty"});
            this.btnStudentAssign.setVisible(false);
            this.setTypeColumnHided(false);
            this.isNeedDivide = true;
        } else {
            this.setMainQueryPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActStudentQuery"));
            this.putBindContents("mainQuery", new String[]{"", "Person.id", "Type", "Person.number", "Person.name", "Person.gender", "orgUnit.name", "position.name", "job.name", "technicalPost.name", "personDegree.specialty", "degree.name", "personCM.mobile", "Person.email", "Person.cell", "Person.officePhone", "HighDegree.highestDiploma", "HighDegree.specialty"});
            this.btnStudentAssign.setVisible(true);
            this.setTypeColumnHided(true);
        }
        this.setDataObject((IObjectValue)this.getEntityViewInfo());
        this.execQuery();
    }

    private EntityViewInfo getEntityViewInfo() {
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        }
        return this.mainQuery;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)this.trainActivityID));
        return fi;
    }

    protected void execQuery() {
        try {
            IRowSet rowSet = this.getQueryExecutor(this.mainQueryPK, this.mainQuery).executeQuery();
            this.onGetRowSet(rowSet);
            this.tblMain.removeRows(false);
            if (this.isNeedDivide) {
                this.fillTable_NeedDivide(rowSet);
            } else {
                this.fillTable(rowSet);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnStudentAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (rowSet.getString("personCM.mobile") != null) continue;
                rowSet.updateString("personCM.mobile", rowSet.getString("personCM.officePhone"));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
    }

    private void fillTable_NeedDivide(IRowSet rowSet) throws Exception {
        while (rowSet.next()) {
            IRow rowInTable = this.getExistRowInTable(rowSet.getString("Person.id"));
            if (rowInTable != null) {
                if (!rowSet.getBoolean("personTP.isHighTechnical")) continue;
                rowInTable.getCell("technicalPost").setValue((Object)rowSet.getString("technicalPost.name"));
                continue;
            }
            IRow row = this.tblMain.addRow();
            row.getCell("type").setValue((Object)rowSet.getString("Type"));
            row.getCell("personId").setValue((Object)rowSet.getString("Person.id"));
            row.getCell("number").setValue((Object)rowSet.getString("Person.number"));
            row.getCell("name").setValue((Object)rowSet.getString("Person.name"));
            row.getCell("gender").setValue((Object)rowSet.getString("Person.gender"));
            row.getCell("orgUnit").setValue((Object)rowSet.getString("AdminOrgUnit.name"));
            row.getCell("position").setValue((Object)rowSet.getString("PosiStudent.name"));
            row.getCell("job").setValue((Object)rowSet.getString("job.name"));
            row.getCell("technicalPost").setValue((Object)rowSet.getString("technicalPost.name"));
            row.getCell("specialty").setValue((Object)rowSet.getString("HighDegree.specialty"));
            row.getCell("linkMethod").setValue((Object)rowSet.getString("personCM.mobile"));
            row.getCell("officPhone").setValue((Object)rowSet.getString("Person.officePhone"));
            row.getCell("email").setValue((Object)rowSet.getString("Person.email"));
            row.getCell("mobilePhone").setValue((Object)rowSet.getString("Person.cell"));
            row.getCell("degree").setValue((Object)rowSet.getString("HighDegree.highestDiploma"));
            row.getCell("jobGrade").setValue((Object)rowSet.getString("jobGrade.name"));
        }
    }

    private void fillTable(IRowSet rowSet) throws Exception {
        while (rowSet.next()) {
            IRow rowInTable = this.getExistRowInTable(rowSet.getString("Person.id"));
            if (rowInTable != null) {
                if (!rowSet.getBoolean("personTP.isHighTechnical")) continue;
                rowInTable.getCell("technicalPost").setValue((Object)rowSet.getString("technicalPost.name"));
                continue;
            }
            IRow row = this.tblMain.addRow();
            row.getCell("type").setValue((Object)rowSet.getString("Type"));
            row.getCell("personId").setValue((Object)rowSet.getString("Person.id"));
            row.getCell("number").setValue((Object)rowSet.getString("Person.number"));
            row.getCell("name").setValue((Object)rowSet.getString("Person.name"));
            row.getCell("gender").setValue((Object)rowSet.getString("Person.gender"));
            row.getCell("orgUnit").setValue((Object)rowSet.getString("orgUnit.name"));
            row.getCell("position").setValue((Object)rowSet.getString("position.name"));
            row.getCell("job").setValue((Object)rowSet.getString("job.name"));
            row.getCell("technicalPost").setValue((Object)rowSet.getString("technicalPost.name"));
            row.getCell("specialty").setValue((Object)rowSet.getString("HighDegree.specialty"));
            row.getCell("linkMethod").setValue((Object)rowSet.getString("personCM.mobile"));
            row.getCell("officPhone").setValue((Object)rowSet.getString("Person.officePhone"));
            row.getCell("email").setValue((Object)rowSet.getString("Person.email"));
            row.getCell("mobilePhone").setValue((Object)rowSet.getString("Person.cell"));
            row.getCell("degree").setValue((Object)rowSet.getString("HighDegree.highestDiploma"));
            row.getCell("jobGrade").setValue((Object)rowSet.getString("jobGrade.name"));
        }
    }

    private IRow getExistRowInTable(String personId) {
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            String personIdInTable = (String)row.getCell("personId").getValue();
            if (personIdInTable == null || !personIdInTable.equals(personId)) continue;
            return row;
        }
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return TrainStudentCourseEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainStudentCourseFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainStudentCourseInfo objectValue = new TrainStudentCourseInfo();
        return objectValue;
    }

    public void actionStudentAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionStudentAssign_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"TrainActivityID", (Object)this.trainActivityID);
        uiContext.put((Object)"IsView", (Object)Boolean.TRUE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TrainStudentCourseListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.getUIObject().getUIToolBar().setVisible(true);
        uiWindow.show();
    }

    private TrainActivityInfo getTrainActivityInfo() throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("needDivide"));
        TrainActivityInfo activityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(this.trainActivityID), sic);
        return activityInfo;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public void setTypeColumnHided(boolean isHide) {
        this.tblMain.getColumn("type").getStyleAttributes().setHided(isHide);
    }

    public void setMainQueryPK(IMetaDataPK mainQueryPK) {
        this.mainQueryPK = mainQueryPK;
    }

    public void putBindContents(String objectName, String[] fields) {
        this.tblMain.putBindContents(objectName, fields);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = TrainActStudentListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = this.initCommonQueryDialog();
        }
        if (this.commonQueryDialog.show()) {
            this.MaxReturnRowCount = iQuery.getMaxNumView(this.getMetaDataPK().getFullName(), queryName);
            this.mainQuery.getSorter().clear();
            this.mainQuery = this.getEntityViewInfo(this.commonQueryDialog.getEntityViewInfoResult());
            if (this.mainQuery.getSorter() != null && this.mainQuery.getSorter().size() > 0) {
                this.setIsIgnoreOrder(true);
            } else {
                this.setIsIgnoreOrder(false);
            }
            this.refreshList();
        } else {
            SysUtil.abort();
        }
    }

    protected IIDList getSelectedKeyValues() {
        return null;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        if (!this.confirmRemove()) {
            return;
        }
        List rowIndexList = TrainUtils.getSelectedRows(this.tblMain);
        HashSet<String> idSet = new HashSet<String>();
        int rowIndex = 0;
        int count = rowIndexList.size();
        for (int i = 0; i < count; ++i) {
            rowIndex = Integer.valueOf(rowIndexList.get(i).toString());
            idSet.add(this.tblMain.getRow(rowIndex).getCell("personId").getValue().toString());
        }
        TrainStudentFactory.getRemoteInstance().delete(this.trainActivityID, idSet);
        this.refresh(null);
    }
}

