/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.train.ITrainActivityReportFacade;
import com.kingdee.eas.hr.train.TrainActivityReportFacadeFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainActStudentReportUI;
import com.kingdee.eas.hr.train.client.TrainActStudentReportFilterUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainTreeTable;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class TrainActStudentReportUI
extends AbstractTrainActStudentReportUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActStudentReportUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainReportResource";
    private Map adminOrgUnits = new HashMap();
    private Map summaryMap = new HashMap();
    private HRCellTreeRenderer render = new HRCellTreeRenderer();
    private int rootLevel;
    private String rootLongNumber;
    private boolean isFirstDefaultQuery = true;
    private CommonQueryDialog queryDlg = null;
    private Date startDate;
    private Date endDate;
    private AdminOrgUnitInfo adminOrgUnitInfo;
    private boolean includeCourse = false;
    private Set trainActivityIds;
    private Set trainCourseIds;

    public void onLoad() throws Exception {
        this.setIsNeedDefaultFilter(false);
        super.onLoad();
        this.tblMain.checkParsed();
        TrainTreeTable.setHRTreeTable(this.tblMain, "orgName");
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.buildAdminOrgUnitMap();
        this.actionQuery_actionPerformed(null);
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    private void buildAdminOrgUnitMap() throws EASBizException, BOSException {
        AdminOrgUnitCollection collection = HROrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollectionWithOrgRangeFilter(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                this.adminOrgUnits.put(collection.get(i).getLongNumber(), collection.get(i));
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setColumnHide();
    }

    private void executeQuery() throws BOSException, EASBizException {
        ITrainActivityReportFacade facade = TrainActivityReportFacadeFactory.getRemoteInstance();
        Collection result = facade.getDeptActStudentCountInfos(this.startDate, this.endDate, (IObjectValue)this.adminOrgUnitInfo, this.trainActivityIds, this.includeCourse, this.trainCourseIds);
        this.fillTable(result);
        this.setStatusBarText();
        this.handleRowData();
        TrainTreeTable.hideLevelRow(this.tblMain, 1, "orgName");
    }

    private void handleRowData() {
        HashMap<String, HRCellUserObject> map = new HashMap<String, HRCellUserObject>();
        IRow row = null;
        HRCellUserObject cellObj = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            cellObj = (HRCellUserObject)row.getCell("orgName").getValue();
            map.put(cellObj.getLongNumber(), cellObj);
        }
        HRCellUserObject parentCellObj = null;
        String parentLongNumber = null;
        int size2 = this.tblMain.getRowCount();
        for (int i = 0; i < size2; ++i) {
            row = this.tblMain.getRow(i);
            cellObj = (HRCellUserObject)row.getCell("orgName").getValue();
            if (cellObj.getLongNumber().equals(this.rootLongNumber)) continue;
            parentLongNumber = this.getParentNumber(cellObj.getLongNumber());
            if (map.keySet().contains(parentLongNumber)) continue;
            parentLongNumber = this.getParentNumber(cellObj.getLongNumber(), map.keySet());
            parentCellObj = (HRCellUserObject)map.get(parentLongNumber);
            int oldLevel = cellObj.getLevel();
            cellObj.setLevel(parentCellObj.getLevel() + 1);
            this.handleSubRows(i + 1, oldLevel - cellObj.getLevel(), cellObj.getLongNumber());
        }
    }

    private void handleSubRows(int startIndex, int gap, String parentLongNumber) {
        IRow row = null;
        HRCellUserObject cellObj = null;
        int size = this.tblMain.getRowCount();
        for (int i = startIndex; i < size && (cellObj = (HRCellUserObject)(row = this.tblMain.getRow(i)).getCell("orgName").getValue()).getLongNumber().indexOf(parentLongNumber) != -1; ++i) {
            cellObj.setLevel(cellObj.getLevel() - gap);
        }
    }

    private void setStatusBarText() {
        String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_0");
        Object[] objs = new Object[]{this.tblMain.getRowCount()};
        this.setMessageBarText(MessageFormat.format(msg, objs));
    }

    private void fillTable(Collection col) {
        this.tblMain.removeRows();
        this.summaryMap.clear();
        this.render = new HRCellTreeRenderer();
        if (col != null && col.size() > 0) {
            Map map2 = null;
            IRow row = null;
            for (Map map2 : col) {
                if (!this.adminOrgUnits.keySet().contains(map2.get("orgLongNumber"))) continue;
                row = this.tblMain.addRow();
                this.setRowCellInfo(map2, row);
                this.storeRowInfoToSummary(row);
            }
            this.insertSummaryData();
            this.countRate();
            this.mergeTable();
        }
        this.setColumnHide();
    }

    private void countRate() {
        IRow row = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            double rate = 0.0;
            row = this.tblMain.getRow(i);
            double mustNumber = ((Integer)row.getCell("mustNumber").getValue()).doubleValue();
            if (mustNumber != 0.0) {
                double factNumber = ((Integer)row.getCell("factNumber").getValue()).doubleValue();
                rate = factNumber / mustNumber;
            }
            row.getCell("rate").setValue((Object)String.valueOf(rate));
        }
    }

    private void insertSummaryData() {
        HashSet existLongNumbers = new HashSet();
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            int insertCount = this.confirmParentAdminOrg(existLongNumbers, row, i);
            HRCellUserObject cellObj = (HRCellUserObject)row.getCell("orgName").getValue();
            String longNumber = cellObj.getLongNumber();
            if (!this.hasChildren(i += insertCount) || this.summaryMap.get(longNumber) == null) continue;
            insertCount = this.insertParentAdmin(longNumber, i);
            i += insertCount;
            i = this.moveNode(i);
        }
    }

    private int moveNode(int index) {
        String longNumber = null;
        IRow row = null;
        HRCellUserObject cellObj = null;
        int count = this.tblMain.getRowCount();
        while (index < count) {
            row = this.tblMain.getRow(index);
            cellObj = (HRCellUserObject)row.getCell("orgName").getValue();
            if (longNumber == null) {
                longNumber = cellObj.getLongNumber();
            }
            if (!longNumber.equals(cellObj.getLongNumber())) break;
            cellObj.setName(cellObj.getName() + EASResource.getString((String)RESOURCE, (String)"baseDept"));
            cellObj.setLevel(cellObj.getLevel() + 1);
            cellObj.setLongNumber(cellObj.getLongNumber() + "!-1");
            cellObj.setIsLeaf(true);
            cellObj.setExpanded(false);
            ++index;
        }
        return --index;
    }

    private boolean hasChildren(int index) {
        boolean result = false;
        IRow row = this.tblMain.getRow(index);
        HRCellUserObject cellObj = (HRCellUserObject)row.getCell("orgName").getValue();
        int count = this.tblMain.getRowCount();
        while (index++ < count) {
            IRow curRow = this.tblMain.getRow(index);
            if (curRow == null) continue;
            HRCellUserObject curCellObj = (HRCellUserObject)curRow.getCell("orgName").getValue();
            if (cellObj.getLongNumber().equals(curCellObj.getLongNumber())) continue;
            if (curCellObj.getLongNumber().indexOf(cellObj.getLongNumber()) < 0) break;
            result = true;
            break;
        }
        return result;
    }

    private void storeRowInfoToSummary(IRow row) {
        HRCellUserObject cellObj = (HRCellUserObject)row.getCell("orgName").getValue();
        String longNumber = cellObj.getLongNumber();
        String parentNumber = null;
        parentNumber = cellObj.isLeaf() ? this.getParentNumber(longNumber, this.adminOrgUnits.keySet()) : longNumber;
        while (parentNumber.indexOf(this.rootLongNumber) != -1) {
            this.countNumber(parentNumber, row);
            parentNumber = this.getParentNumber(parentNumber, this.adminOrgUnits.keySet());
        }
    }

    private String getParentNumber(String longNumber, Collection longNumbers) {
        int index = longNumber.lastIndexOf("!");
        if (index != -1) {
            if (!longNumbers.contains(longNumber = longNumber.substring(0, index))) {
                return this.getParentNumber(longNumber, longNumbers);
            }
            return longNumber;
        }
        return "";
    }

    private String getParentNumber(String longNumber) {
        int index = longNumber.lastIndexOf("!");
        if (index != -1) {
            return longNumber.substring(0, index);
        }
        return "";
    }

    private void countNumber(String longNumber, IRow row) {
        TreeMap values = (TreeMap)this.summaryMap.get(longNumber);
        if (values == null) {
            values = new TreeMap();
        }
        String actId = row.getCell("actId").getValue().toString();
        String courseId = row.getCell("courseId").getValue() == null ? null : row.getCell("courseId").getValue().toString();
        HashMap<String, Object> value = (HashMap<String, Object>)values.get(actId + courseId);
        if (value == null) {
            value = new HashMap<String, Object>();
        }
        int deptNumber = (Integer)row.getCell("deptNumber").getValue();
        int signupNumber = (Integer)row.getCell("signupNumber").getValue();
        int mustNumber = (Integer)row.getCell("mustNumber").getValue();
        int factNumber = (Integer)row.getCell("factNumber").getValue();
        int totalDeptNumber = value.get("deptNumber") == null ? 0 : (Integer)value.get("deptNumber");
        int totalSignupNumber = value.get("signupNumber") == null ? 0 : (Integer)value.get("signupNumber");
        int totalMustNumber = value.get("mustNumber") == null ? 0 : (Integer)value.get("mustNumber");
        int totalFactNumber = value.get("factNumber") == null ? 0 : (Integer)value.get("factNumber");
        value.put("deptNumber", totalDeptNumber + deptNumber);
        value.put("signupNumber", totalSignupNumber + signupNumber);
        value.put("mustNumber", totalMustNumber + mustNumber);
        value.put("factNumber", totalFactNumber + factNumber);
        value.put("actName", row.getCell("actName").getValue());
        value.put("courseName", row.getCell("courseName").getValue());
        value.put("actId", actId);
        value.put("courseId", courseId);
        values.put(actId + courseId, value);
        this.summaryMap.put(longNumber, values);
    }

    private int insertParentAdmin(String parentLongNumber, int index) {
        if (this.summaryMap.get(parentLongNumber) == null) {
            return 0;
        }
        Map values = (Map)this.summaryMap.get(parentLongNumber);
        Iterator it = values.entrySet().iterator();
        Map value = null;
        int insertCount = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            value = (Map)values.get(key);
            AdminOrgUnitInfo orgInfo = (AdminOrgUnitInfo)this.adminOrgUnits.get(parentLongNumber);
            if (orgInfo == null) continue;
            value.put("orgId", orgInfo.getId().toString());
            value.put("orgName", orgInfo.getName());
            value.put("orgLongNumber", orgInfo.getLongNumber());
            value.put("orgIsLeaf", orgInfo.isIsLeaf());
            value.put("orgLevel", orgInfo.getLevel());
            this.setRowCellInfo(value, this.tblMain.addRow(index));
            ++insertCount;
        }
        this.summaryMap.remove(parentLongNumber);
        return insertCount;
    }

    private void mergeTable() {
        int curIndex;
        int orgColumnIndex = this.tblMain.getColumnIndex("orgName");
        int actColumnIndex = this.tblMain.getColumnIndex("actName");
        int preOrgIndex = 0;
        int preActIndex = 0;
        String preOrgName = null;
        String preActName = null;
        for (curIndex = 0; curIndex < this.tblMain.getRowCount(); ++curIndex) {
            IRow row = this.tblMain.getRow(curIndex);
            if (row == null) continue;
            HRCellUserObject cellObj = (HRCellUserObject)row.getCell("orgName").getValue();
            String orgName = cellObj.getName();
            if (preOrgName == null) {
                preOrgName = cellObj.getName();
            }
            if (preActName == null) {
                preOrgName = (String)row.getCell("actName").getValue();
            }
            KDTMergeManager mergeManager = this.tblMain.getMergeManager();
            if (!preOrgName.equals(orgName)) {
                mergeManager.mergeBlock(preOrgIndex, orgColumnIndex, curIndex - 1, orgColumnIndex);
                preOrgIndex = curIndex;
                preOrgName = orgName;
                mergeManager.mergeBlock(preActIndex, actColumnIndex, curIndex - 1, actColumnIndex);
                preActIndex = curIndex;
                preActName = (String)row.getCell("actName").getValue();
                continue;
            }
            if (preActName.equals(row.getCell("actName").getValue())) continue;
            mergeManager.mergeBlock(preActIndex, actColumnIndex, curIndex - 1, actColumnIndex);
            preActIndex = curIndex;
            preActName = (String)row.getCell("actName").getValue();
        }
        this.tblMain.getMergeManager().mergeBlock(preOrgIndex, orgColumnIndex, curIndex - 1, orgColumnIndex);
        this.tblMain.getMergeManager().mergeBlock(preActIndex, actColumnIndex, curIndex - 1, actColumnIndex);
    }

    private void setColumnHide() {
        this.tblMain.getColumn("courseName").getStyleAttributes().setHided(!this.includeCourse);
    }

    private int confirmParentAdminOrg(Set existLongNumbers, IRow row, int index) {
        String longNumber;
        String parentNumber;
        int insertCount = 0;
        HRCellUserObject cellObj = (HRCellUserObject)row.getCell("orgName").getValue();
        int level = cellObj.getLevel();
        if (level > 0 && !existLongNumbers.contains(parentNumber = this.getParentNumber(longNumber = cellObj.getLongNumber())) && this.adminOrgUnits.keySet().contains(parentNumber)) {
            insertCount = this.insertParentAdmin(parentNumber, index);
            existLongNumbers.add(parentNumber);
            insertCount += this.confirmParentAdminOrg(existLongNumbers, this.tblMain.getRow(index), index);
        }
        existLongNumbers.add(cellObj.getLongNumber());
        return insertCount;
    }

    private void setRowCellInfo(Map map, IRow row) {
        HRCellUserObject cellObj = new HRCellUserObject();
        cellObj.setCompanyId((String)map.get("orgId"));
        cellObj.setName((String)map.get("orgName"));
        cellObj.setLongNumber((String)map.get("orgLongNumber"));
        cellObj.setIsLeaf(((Boolean)map.get("orgIsLeaf")).booleanValue());
        cellObj.setLevel((Integer)map.get("orgLevel") - this.rootLevel);
        cellObj.setExpanded(!cellObj.isLeaf());
        row.getCell("orgName").setValue((Object)cellObj);
        row.getCell("orgName").setRenderer((IBasicRender)this.render);
        row.getCell("actName").setValue(map.get("actName"));
        row.getCell("actId").setValue(map.get("actId"));
        row.getCell("courseName").setValue(map.get("courseName"));
        row.getCell("courseId").setValue(map.get("courseId"));
        row.getCell("deptNumber").setValue(map.get("deptNumber"));
        row.getCell("signupNumber").setValue(map.get("signupNumber"));
        row.getCell("mustNumber").setValue(map.get("mustNumber"));
        row.getCell("factNumber").setValue(map.get("factNumber"));
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.showFilterDialog(e);
        this.isFirstDefaultQuery = false;
        this.setTxtTitle();
    }

    private void showFilterDialog(ActionEvent e) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = this.mainQueryPK.getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            EntityViewInfo defaultView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            if (defaultView == null || !FilterUtility.hasFilterItem((FilterInfo)defaultView.getFilter())) {
                this.shwQueryDialog();
            } else {
                this.parseFilter(defaultView.getFilter());
                this.executeQuery();
                if (this.getPreference() == null) {
                    this.doDefaultSolution(iQuery, queryName);
                    this.applyPreference();
                }
            }
        } else {
            this.shwQueryDialog();
        }
    }

    private void shwQueryDialog() throws BOSException, Exception {
        if (this.queryDlg == null) {
            this.queryDlg = this.initCommonQueryDialog();
        }
        if (this.queryDlg.show()) {
            this.doQuery(this.queryDlg);
            EntityViewInfo viewInfo = this.queryDlg.getEntityViewInfoResult();
            this.prepareQuery(viewInfo.getFilter()).callHandler();
            this.parseFilter(viewInfo.getFilter());
            this.executeQuery();
        } else {
            SysUtil.abort();
        }
    }

    private void parseFilter(FilterInfo filterInfo) throws EASBizException, BOSException {
        this.resetCondition();
        FilterItemCollection filters = filterInfo.getFilterItems();
        for (int i = 0; i < filters.size(); ++i) {
            FilterItemInfo filterItemInfo = filters.get(i);
            String propertyName = filterItemInfo.getPropertyName();
            if ("actStartDate".equals(propertyName)) {
                this.startDate = (Date)filterItemInfo.getCompareValue();
                continue;
            }
            if ("actEndDate".equals(propertyName)) {
                this.endDate = (Date)filterItemInfo.getCompareValue();
                continue;
            }
            if ("adminOrgUnitId".equals(propertyName)) {
                String adminOrgUnitId = (String)filterItemInfo.getCompareValue();
                this.adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitId));
                this.rootLevel = this.adminOrgUnitInfo.getLevel();
                this.rootLongNumber = this.adminOrgUnitInfo.getLongNumber();
                continue;
            }
            if ("trainActivity".equals(propertyName)) {
                this.trainActivityIds = (Set)filterItemInfo.getCompareValue();
                continue;
            }
            if ("includeCourse".equals(propertyName) && filterItemInfo.getCompareValue() != null) {
                Comparable<Boolean> value;
                if (filterItemInfo.getCompareValue() instanceof Boolean) {
                    value = (Boolean)filterItemInfo.getCompareValue();
                    this.includeCourse = (Boolean)value;
                    continue;
                }
                if (!(filterItemInfo.getCompareValue() instanceof Integer)) continue;
                value = (Integer)filterItemInfo.getCompareValue();
                this.includeCourse = (Integer)value == 1;
                continue;
            }
            if (!"trainCourse".equals(propertyName)) continue;
            this.trainCourseIds = (Set)filterItemInfo.getCompareValue();
        }
    }

    private void resetCondition() {
        this.startDate = null;
        this.endDate = null;
        this.adminOrgUnitInfo = null;
        this.trainActivityIds = null;
        this.trainCourseIds = null;
        this.includeCourse = false;
    }

    private void setTxtTitle() {
        StringBuffer sb = new StringBuffer();
        sb.append(DateTimeUtils.format((Date)this.startDate, (String)"yyyy.MM.dd"));
        sb.append(" -- ");
        sb.append(DateTimeUtils.format((Date)this.endDate, (String)"yyyy.MM.dd"));
        this.txtTitle.setText(sb.toString());
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dlg = super.initCommonQueryDialog();
        dlg.setShowFilter(false);
        dlg.setShowSorter(false);
        dlg.setMaxReturnCountVisible(false);
        dlg.setUiObject(null);
        try {
            dlg.addUserPanel((KDPanel)new TrainActStudentReportFilterUI());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return dlg;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.executeQuery();
    }

    protected String getKeyFieldName() {
        return "actName";
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    public IUIActionPostman prepareInit() {
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), this, this.mainQueryPK);
    }

    protected IUIActionPostman prepareQuery(FilterInfo filterInfo) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = new RequestContext();
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("handleQuery");
        request.put("filter", (Object)filterInfo);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

