/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.ChargeItemInfo;
import com.kingdee.eas.hr.train.TrainActCostSummaryInfo;
import com.kingdee.eas.hr.train.TrainActivityCostCollection;
import com.kingdee.eas.hr.train.TrainActivityCostFactory;
import com.kingdee.eas.hr.train.TrainSummaryFactory;
import com.kingdee.eas.hr.train.TrainSummaryInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainActivityCostSummaryUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class TrainActivityCostSummaryUI
extends AbstractTrainActivityCostSummaryUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActivityCostSummaryUI.class);
    private Icon newLineIcon = EASResource.getIcon((String)"imgTbtn_addline");
    private Icon removeLineIcon = EASResource.getIcon((String)"imgTbtn_deleteline");
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private static final String costTitle = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"totalCost");
    private static final String costUnit = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"costUnit");
    private static final String title = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"trainPlanItemCost");
    private static final String total = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"total");
    private static final String dollar = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"dollar");
    private static final Color YELLOW = new Color(16579551);
    private BigDecimal totalCost = new BigDecimal("0.00");
    private BigDecimal costTotal = new BigDecimal("0.00");
    private boolean isFirst = true;
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainHolidayResource";
    private static final String totalCostMention = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"SummaryTotalCostItem");

    public void onLoad() throws Exception {
        this.kdtTrainActCostSummary.checkParsed();
        if (this.getUIContext().get("costTotal") != null) {
            this.costTotal = new BigDecimal(this.getUIContext().get("costTotal").toString());
        }
        this.setCostTypeEditor();
        this.setCostEditor();
        super.onLoad();
        this.kdtTrainActCostSummary.getColumn("chargeItem").getStyleAttributes().setBackground(YELLOW);
        this.kdtTrainActCostSummary.getColumn("totalCost").getStyleAttributes().setBackground(YELLOW);
        TrainUtils.setTableCellEditorByTextField(this.kdtTrainActCostSummary, "chargeStand", 40);
        TrainUtils.setTableCellEditorByTextField(this.kdtTrainActCostSummary, "remark", 80);
        TrainUtils.setTableCellEditorByFormattedTextField(this.kdtTrainActCostSummary, "count", 0);
    }

    protected void kdtTrainActCostSummary_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtTrainActCostSummary.getColumnIndex("totalCost")) {
            this.cacuTotalCostEdit();
        }
        IRow row = this.kdtTrainActCostSummary.getRow(e.getRowIndex());
        if (colIndex == this.kdtTrainActCostSummary.getColumn("chargeItem").getColumnIndex() && e.getValue() != null && this.isExistChargeItemInTable((ChargeItemInfo)e.getValue(), row)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.TrainActivityResource", (String)"ExistItem"));
            row.getCell("chargeItem").setValue(null);
            row.getCell("chargeStand").setValue(null);
            row.getCell("count").setValue(null);
            row.getCell("totalCost").setValue(null);
            row.getCell("remark").setValue(null);
            SysUtil.abort();
        }
    }

    private boolean isExistChargeItemInTable(ChargeItemInfo info, IRow editRow) {
        if (info == null) {
            return false;
        }
        IRow row = null;
        int count = this.kdtTrainActCostSummary.getRowCount() - 1;
        for (int i = 0; i < count; ++i) {
            row = this.kdtTrainActCostSummary.getRow(i);
            if (row.getRowIndex() == editRow.getRowIndex() || row.getCell("chargeItem").getValue() == null || !((ChargeItemInfo)row.getCell("chargeItem").getValue()).getId().toString().equals(info.getId().toString())) continue;
            return true;
        }
        return false;
    }

    private void setTitle() {
        StringBuffer sb = new StringBuffer();
        sb.append(costTitle);
        sb.append(this.costTotal.toString());
        sb.append(costUnit);
        this.contMain.setTitle(total + sb.toString() + dollar);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        int option = this.checkReback();
        if (option == 0 || option == 1) {
            super.actionSubmit_actionPerformed(e);
        }
    }

    private int checkReback() {
        BigDecimal newValue = this.countvalue(this.editData);
        BigDecimal originValue = this.fetchTrainActivityCostFromUIContext();
        return this.operateReback(newValue, originValue);
    }

    private int operateReback(BigDecimal newValue, BigDecimal originValue) {
        boolean flag = false;
        if (originValue == null) {
            flag = true;
        } else {
            if (originValue.compareTo(newValue) == 0) {
                return 0;
            }
            flag = true;
        }
        if (flag) {
            int showConfirm2 = MsgBox.showConfirm2((Component)((Object)this), (String)totalCostMention);
            if (showConfirm2 == 0) {
                this.getUIContext().put("needReback", Boolean.TRUE);
                this.getUIContext().put("newValue", newValue);
            }
            return showConfirm2;
        }
        return 0;
    }

    private BigDecimal fetchTrainActivityCostFromUIContext() {
        return (BigDecimal)this.getUIContext().get("originValue");
    }

    private BigDecimal countvalue(TrainSummaryInfo editData) {
        BigDecimal value = new BigDecimal("0.0");
        int n = editData.getTrainActCostSummary().size();
        for (int i = 0; i < n; ++i) {
            if (TrainClientUtil.objectIsNull(editData.getTrainActCostSummary().get(i).getTotalCost())) continue;
            value = value.add(editData.getTrainActCostSummary().get(i).getTotalCost());
        }
        return value;
    }

    private void cacuTotalCostEdit() {
        this.totalCost = new BigDecimal("0.00");
        BigDecimal cost = null;
        int n = this.kdtTrainActCostSummary.getRowCount();
        for (int i = 0; i < n; ++i) {
            int col = this.kdtTrainActCostSummary.getColumnIndex("totalCost");
            cost = (BigDecimal)this.kdtTrainActCostSummary.getRow(i).getCell(col).getValue();
            if (cost == null) continue;
            this.totalCost = this.totalCost.add(cost);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(TrainUtils.formatBigDecimal(this.totalCost, 2));
        this.contMain.setTitle(total + sb.toString() + dollar);
    }

    protected boolean confirmRemoveEnable() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)totalCostMention));
    }

    private void cacuTotalCost() {
        this.totalCost = new BigDecimal("0.00");
        BigDecimal cost = null;
        int n = this.kdtTrainActCostSummary.getRowCount();
        for (int i = 0; i < n; ++i) {
            int col = this.kdtTrainActCostSummary.getColumnIndex("totalCost");
            cost = (BigDecimal)this.kdtTrainActCostSummary.getRow(i).getCell(col).getValue();
            if (cost == null) continue;
            this.totalCost = this.totalCost.add(cost);
        }
        if (this.totalCost.compareTo(this.costTotal) == 1 || this.totalCost.compareTo(this.costTotal) == -1) {
            // empty if block
        }
        StringBuffer sb = new StringBuffer();
        sb.append(TrainUtils.formatBigDecimal(this.totalCost, 2));
        this.contMain.setTitle(total + sb.toString() + dollar);
        this.isFirst = false;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setTitle();
        if (this.isFirst) {
            this.cacuTotalCostEdit();
            this.isFirst = false;
        }
    }

    private void setCostTypeEditor() throws Exception {
        EntityViewInfo evi = TrainUtils.getCurrentHREntityViewInfo();
        TrainUtils.setTableCellEditorByF7Query(this.kdtTrainActCostSummary, "com.kingdee.eas.hr.train.app.ChargeItemQuery", "chargeItem", evi);
    }

    private void setCostEditor() {
        KDFormattedTextField txtCost = new KDFormattedTextField();
        txtCost.setHorizontalAlignment(2);
        txtCost.setDataType(1);
        txtCost.setPrecision(2);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(txtCost);
        this.kdtTrainActCostSummary.getColumn("totalCost").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtCost));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.oprtState)) {
            this.actionInputCost.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        } else {
            this.actionInputCost.setEnabled(true);
        }
        JButton btnAddLine = this.contMain.add((Action)((Object)this.actionAddLine));
        btnAddLine.setIcon(this.newLineIcon);
        btnAddLine.setToolTipText(EASResource.getString((String)RES, (String)"add"));
        JButton btnRemoveLine = this.contMain.add((Action)((Object)this.actionRemoveLine));
        btnRemoveLine.setIcon(this.removeLineIcon);
        btnRemoveLine.setToolTipText(EASResource.getString((String)RES, (String)"remove"));
    }

    private void addLine(KDTable table, IObjectValue obj) {
        IRow row = table.addRow();
        this.loadLineFields(table, row, obj);
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        TrainActCostSummaryInfo info = new TrainActCostSummaryInfo();
        this.addLine(this.kdtTrainActCostSummary, (IObjectValue)info);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.kdtTrainActCostSummary);
    }

    protected IObjectValue createNewData() {
        TrainSummaryInfo ret = new TrainSummaryInfo();
        return ret;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainSummaryFactory.getRemoteInstance();
    }

    protected void showSubmitSuccess() {
        this.setMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setNextMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AddNew"));
        } else if ("EDIT".equals(this.getOprtState())) {
            this.setNextMessageText(title + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        }
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    public TrainSummaryInfo getEditDataInfo() {
        return this.editData;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        int chargeItemIndex = this.kdtTrainActCostSummary.getColumnIndex("chargeItem");
        int totalCostIndex = this.kdtTrainActCostSummary.getColumnIndex("totalCost");
        IRow row = null;
        KDTEditManager km = this.kdtTrainActCostSummary.getEditManager();
        int n = this.kdtTrainActCostSummary.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.kdtTrainActCostSummary.getRow(i);
            if (row.getCell(chargeItemIndex).getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullChargeItem"));
                km.editCellAt(row.getRowIndex(), chargeItemIndex);
                SysUtil.abort();
            }
            if (row.getCell(totalCostIndex).getValue() != null) continue;
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullTotalCost"));
            km.editCellAt(row.getRowIndex(), totalCostIndex);
            SysUtil.abort();
        }
    }

    public BigDecimal getTotalCost() {
        return this.totalCost;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("Cost"));
        return sic;
    }

    private TrainActivityCostCollection getTrainActivityCostCollection(String trainActCostID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActivityID", (Object)trainActCostID, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("chargeItemID.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("chargeItemID.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("chargeStand"));
        viewInfo.getSelector().add(new SelectorItemInfo("count"));
        viewInfo.getSelector().add(new SelectorItemInfo("totalCost"));
        viewInfo.getSelector().add(new SelectorItemInfo("remark"));
        return TrainActivityCostFactory.getRemoteInstance().getTrainActivityCostCollection(viewInfo);
    }

    private void importChargeItem() {
        String trainactCostID = (String)this.getUIContext().get("trainActivity");
        if (!TrainClientUtil.objectIsNull(trainactCostID)) {
            try {
                TrainActivityCostCollection traincoCollection = this.getTrainActivityCostCollection(trainactCostID);
                if (traincoCollection != null) {
                    int n = traincoCollection.size();
                    for (int i = 0; i < n; ++i) {
                        IRow row = this.kdtTrainActCostSummary.addRow();
                        row.getCell("chargeItem").setValue((Object)traincoCollection.get(i).getChargeItemID());
                        row.getCell("chargeStand").setValue((Object)traincoCollection.get(i).getChargeStand());
                        row.getCell("count").setValue((Object)traincoCollection.get(i).getCount());
                        row.getCell("totalCost").setValue((Object)traincoCollection.get(i).getTotalCost());
                        row.getCell("remark").setValue((Object)traincoCollection.get(i).getRemark());
                    }
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    public void actionInputCost_actionPerformed(ActionEvent e) throws Exception {
        this.importChargeItem();
    }

    public IObjectPK runSubmit() throws Exception {
        this.cacuTotalCost();
        if (this.totalCost != null && this.totalCost.compareTo(new BigDecimal("0.00")) > 0) {
            this.editData.getTrainActivity().setBudgetCost(this.totalCost);
        }
        return super.runSubmit();
    }
}

