/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.emp.client.PersonMultiPromptBox;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.AssessMethodCollection;
import com.kingdee.eas.hr.train.AssessMethodFactory;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.IAssessMethod;
import com.kingdee.eas.hr.train.ITrainActCourse;
import com.kingdee.eas.hr.train.ITrainPlanCategory;
import com.kingdee.eas.hr.train.ITrainingCategory;
import com.kingdee.eas.hr.train.ITrainingMethod;
import com.kingdee.eas.hr.train.TrainActCourseCollection;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainActParticipantScopeCollection;
import com.kingdee.eas.hr.train.TrainActParticipantScopeFactory;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordCollection;
import com.kingdee.eas.hr.train.TrainCourseRecordExtendsInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.TrainPlanCategoryCollection;
import com.kingdee.eas.hr.train.TrainPlanCategoryEnum;
import com.kingdee.eas.hr.train.TrainPlanCategoryFactory;
import com.kingdee.eas.hr.train.TrainRecordIsPassedEnum;
import com.kingdee.eas.hr.train.TrainTypeEnum;
import com.kingdee.eas.hr.train.TrainUtilEnum;
import com.kingdee.eas.hr.train.TrainingCategoryCollection;
import com.kingdee.eas.hr.train.TrainingCategoryFactory;
import com.kingdee.eas.hr.train.TrainingMethodCollection;
import com.kingdee.eas.hr.train.TrainingMethodFactory;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseForReportPromptBox;
import com.kingdee.eas.hr.train.client.TrainItemF7UI;
import com.kingdee.eas.hr.train.client.TrainItemTreePromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TreeBasePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class TrainActivityHelper {
    private static String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";
    public static final String TAID = "TrainActivityID";
    public static final String TOTAL = "Total";
    public static final Color KDTABLE_TOTAL_BG_COLOR = new Color(0xF6F6B6);
    public static final Color DISABLE_COLOR = new Color(217, 217, 214);
    public static final Color ABLE_COLOR = new Color(255, 255, 255);
    public static final int COST_PRECISION = 2;
    public static final int ZERO_PRECISION = 0;
    public static final String TACID = "TrainActCourseID";
    public static final String IS_CREATED_BY_PLAN_ACTIVITY = "IsCreatedByPlanActivity";
    public static final int COURSE_HOUR_SCALE = 2;
    public static final String IS_MODIFY_TRAINACTIVITY = "IsModifyTrainActivity";
    public static final String TRAINACTIVITY_STATUS = "TrainActivityStatus";
    public static final String IS_PUBLISHED = "IsPublished";
    public static final String IS_VIEW = "IsView";
    public static final String TCID = "TrainCourseID";
    public static final String TMID = "TrainMaterialID";
    public static final String TIID = "TrainInstructorID";

    public static IRowSet getRowSet(String queryName, FilterInfo fi) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", queryName);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    public static IRowSet getRowSet(String queryName, EntityViewInfo viewInfo) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", queryName);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    public static int getRowCount(String queryName, EntityViewInfo viewInfo) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", queryName);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(viewInfo);
        return exec.getRowCount();
    }

    public static void initTrainCategory(KDComboBox comboTrainingCategory) throws Exception {
        ITrainingCategory trainCategory = TrainingCategoryFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterItemInfo);
        TrainingCategoryCollection coll = trainCategory.getTrainingCategoryCollection(evi);
        comboTrainingCategory.removeAllItems();
        comboTrainingCategory.addItems(coll.toArray());
    }

    public static void initTrainPlanCategory(KDComboBox comboTrainPlanCategory) throws Exception {
        ITrainPlanCategory trainPlanCategory = TrainPlanCategoryFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = TrainClientUtil.getCurrentHROFilter();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("property"));
        evi.getSelector().add(new SelectorItemInfo("category"));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterItemInfo);
        TrainPlanCategoryCollection coll = trainPlanCategory.getTrainPlanCategoryCollection(evi);
        comboTrainPlanCategory.removeAllItems();
        comboTrainPlanCategory.addItems(coll.toArray());
    }

    public static void initTrainingMethod(KDComboBox comboTrainingMethod) throws Exception {
        ITrainingMethod trainingMethod = TrainingMethodFactory.getRemoteInstance();
        EntityViewInfo evi = TrainUtils.getCurrentHREntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterItemInfo);
        TrainingMethodCollection coll = trainingMethod.getTrainingMethodCollection(evi);
        comboTrainingMethod.removeAllItems();
        comboTrainingMethod.addItems(coll.toArray());
    }

    public static void initAssessMethod(KDComboBox comboAssessMethod) throws Exception {
        IAssessMethod assessMethod = AssessMethodFactory.getRemoteInstance();
        EntityViewInfo evi = TrainUtils.getCurrentHREntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterItemInfo);
        AssessMethodCollection coll = assessMethod.getAssessMethodCollection(evi);
        comboAssessMethod.removeAllItems();
        comboAssessMethod.addItems(coll.toArray());
        comboAssessMethod.setSelectedIndex(-1);
    }

    public static void initTrainActCourse(String trainActivityId, KDComboBox comboTrainActCourse) throws Exception {
        TrainActivityHelper.initTrainActCourse(trainActivityId, comboTrainActCourse, false);
    }

    public static void initTrainActCourse(String trainActivityId, KDComboBox comboTrainActCourse, boolean isNeedAll) throws Exception {
        TrainActCourseCollection coll = TrainActivityHelper.getTrainActCourse(trainActivityId);
        comboTrainActCourse.removeAllItems();
        if (isNeedAll) {
            comboTrainActCourse.addItem((Object)TrainUtilEnum.ALL);
        }
        comboTrainActCourse.addItems(coll.toArray());
    }

    public static TrainActCourseCollection getTrainActCourse(String trainActivityId) throws BOSException {
        ITrainActCourse trainActCourse = TrainActCourseFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.id"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.name"));
        TrainActCourseCollection coll = trainActCourse.getTrainActCourseCollection(evi);
        return coll;
    }

    public static TrainActCourseInfo getTrainActCourse(String trainActivityId, String trainCourseId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (trainActivityId != null) {
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        }
        if (trainCourseId != null) {
            fi.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)trainCourseId));
        }
        if (!FilterUtility.hasFilterItem((FilterInfo)fi)) {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)"-1"));
        }
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("StartDate"));
        evi.getSelector().add(new SelectorItemInfo("EndDate"));
        evi.getSelector().add(new SelectorItemInfo("TotalCost"));
        ITrainActCourse trainActCourse = TrainActCourseFactory.getRemoteInstance();
        TrainActCourseCollection coll = trainActCourse.getTrainActCourseCollection(evi);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public static PersonInfo getResponser(AdminOrgUnitInfo orgUnitInfo) throws Exception {
        PersonInfo personInfo = null;
        if (orgUnitInfo == null || orgUnitInfo.getResponPosition() == null || orgUnitInfo.getResponPosition().getId() == null) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("position.adminOrgUnit.id", (Object)orgUnitInfo.getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("position.id", (Object)orgUnitInfo.getResponPosition().getId().toString()));
        evi.setFilter(fi);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("isPrimary");
        sorterItem.setSortType(SortType.DESCEND);
        sorter.add(sorterItem);
        evi.setSorter(sorter);
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        evi.getSelector().add(new SelectorItemInfo("person.name"));
        evi.getSelector().add(new SelectorItemInfo("person.number"));
        PositionMemberCollection pmColl = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(evi);
        if (pmColl != null && pmColl.size() != 0) {
            personInfo = pmColl.get(0).getPerson();
        }
        return personInfo;
    }

    public static String getStartDate2EndDateString(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(startDate);
        sb.append("\u2014\u2014");
        sb.append(endDate);
        return sb.toString();
    }

    public static void initCourseHourUnit(KDComboBox comboCourseHourUnit) {
        comboCourseHourUnit.removeAllItems();
        comboCourseHourUnit.addItems(CourseHourUnitEnum.getEnumList().toArray());
        if (comboCourseHourUnit.getItemCount() > 0) {
            comboCourseHourUnit.setSelectedIndex(0);
        }
    }

    public static void auditTrainActivity(String trainActivityId) throws Exception {
        if (trainActivityId == null) {
            return;
        }
        TrainActivityFacadeFactory.getRemoteInstance().auditTrainActivity(trainActivityId);
    }

    public static void startTrainActivity(String trainActivityId) throws Exception {
        if (trainActivityId == null) {
            return;
        }
        TrainActivityFacadeFactory.getRemoteInstance().startTrainActivity(trainActivityId);
    }

    public static void finishTrainActivity(String trainActivityId) throws Exception {
        if (trainActivityId == null) {
            return;
        }
        TrainActivityFacadeFactory.getRemoteInstance().finishTrainActivity(trainActivityId);
    }

    public static void setTrainActivityStatus(String trainActivityId, TrainActStateEnum status) throws Exception {
        if (trainActivityId == null || status == null) {
            return;
        }
        TrainActivityFacadeFactory.getRemoteInstance().setTrainActivityStatus(trainActivityId, status);
    }

    public static Map getPublishMessageMap(String trainActivityId) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("trainStartDate"));
        sic.add(new SelectorItemInfo("trainEndDate"));
        sic.add(new SelectorItemInfo("trainAddress"));
        TrainActivityInfo activityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityId));
        String title = EASResource.getString((String)resourcePath, (String)"TrainActivityMessageTitle");
        title = title.replaceAll("#0", activityInfo.getName());
        String body = EASResource.getString((String)resourcePath, (String)"TrainActivityMessageBody");
        body = body.replaceAll("#0", activityInfo.getName() == null ? "" : activityInfo.getName());
        body = body.replaceAll("#1", activityInfo.getTrainStartDate() == null ? "" : activityInfo.getTrainStartDate().toString());
        body = body.replaceAll("#2", activityInfo.getTrainAddress() == null ? "" : activityInfo.getTrainAddress());
        HashMap<String, String> messageMap = new HashMap<String, String>();
        messageMap.put("title", title);
        messageMap.put("body", body);
        return messageMap;
    }

    public static List getPublishPersonIdList(String trainActivityId) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("Person.id"));
        TrainActParticipantScopeCollection coll = TrainActParticipantScopeFactory.getRemoteInstance().getTrainActParticipantScopeCollection(evi);
        if (coll != null) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                idList.add(coll.get(i).getPerson().getId().toString());
            }
        }
        return idList;
    }

    public static TrainActStateEnum getTrainActivityStatus(String trainActivityId) throws Exception {
        if (trainActivityId == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("trainActState"));
        return TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityId), sic).getTrainActState();
    }

    public static void initOrgUnit(KDBizPromptBox prmtOrgUnit, boolean isMultiSelected) throws Exception {
        AdminByCurrentHROF7WithOrgRangeFilter adminF7 = new AdminByCurrentHROF7WithOrgRangeFilter();
        adminF7.setMultiSelect(isMultiSelected);
        prmtOrgUnit.setSelector((KDPromptSelector)adminF7);
    }

    public static void initOrgUnit(KDBizPromptBox prmtOrgUnit, boolean isMultiSelected, IUIObject owner) throws Exception {
        AdminByCurrentHROF7WithOrgRangeFilter adminF7 = new AdminByCurrentHROF7WithOrgRangeFilter(owner);
        adminF7.setMultiSelect(isMultiSelected);
        prmtOrgUnit.setSelector((KDPromptSelector)adminF7);
    }

    public static void initTrainItemTree(KDBizPromptBox prmtTrainItemTree, IUIObject owner) throws Exception {
        TrainItemTreePromptBox box = new TrainItemTreePromptBox(owner);
        prmtTrainItemTree.setSelector((KDPromptSelector)box);
    }

    public static void initTrainCourse(KDBizPromptBox prmtTrainCourse, boolean isMultiSelected, IUIObject owner) throws Exception {
        TrainCourseForReportPromptBox box = new TrainCourseForReportPromptBox(owner);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
        box.setFilterInfo(fi);
        box.setSingleSelect(!isMultiSelected);
        prmtTrainCourse.setSelector((KDPromptSelector)box);
        prmtTrainCourse.setEditable(false);
    }

    public static void initTrainCourseByActivity(KDBizPromptBox prmtTrainCourse, String trainActivityID) throws Exception {
        prmtTrainCourse.setSelector(null);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
        fi.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)trainActivityID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(fi);
        prmtTrainCourse.setEntityViewInfo(viewInfo);
        prmtTrainCourse.setQueryInfo("com.kingdee.eas.hr.train.app.TrainCourseByActivityQuery");
        prmtTrainCourse.setCommitFormat("$number$");
        prmtTrainCourse.setDisplayFormat("$name$");
        prmtTrainCourse.setEditFormat("$number$");
        prmtTrainCourse.setEditable(true);
    }

    public static void initTrainCourseByActivity_END_AND_STAR(KDBizPromptBox prmtTrainCourse, String trainActivityID) throws Exception {
        prmtTrainCourse.setSelector(null);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)trainActivityID));
        fi.getFilterItems().add(new FilterItemInfo("trainActCourse.CourseState", (Object)10));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("courseTarget"));
        sic.add(new SelectorItemInfo("courseCost"));
        sic.add(new SelectorItemInfo("CourseHour"));
        sic.add(new SelectorItemInfo("CourseHourUnit"));
        sic.add(new SelectorItemInfo("treeid.id"));
        sic.add(new SelectorItemInfo("treeid.name"));
        sic.add(new SelectorItemInfo("courseKind.id"));
        sic.add(new SelectorItemInfo("courseKind.name"));
        sic.add(new SelectorItemInfo("trainActCourse.CourseState"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(fi);
        prmtTrainCourse.setEntityViewInfo(viewInfo);
        prmtTrainCourse.setSelectorCollection(sic);
        prmtTrainCourse.setQueryInfo("com.kingdee.eas.hr.train.app.TrainCourseByActivityQuery");
        prmtTrainCourse.setCommitFormat("$number$");
        prmtTrainCourse.setDisplayFormat("$name$");
        prmtTrainCourse.setEditFormat("$number$");
        prmtTrainCourse.setEditable(true);
    }

    public static void initTrainActivity(KDBizPromptBox prmtTrainActivity) throws Exception {
        TrainActivityHelper.initTrainActivity(prmtTrainActivity, null);
    }

    public static void initTrainActivity(KDBizPromptBox prmtTrainActivity, SelectorItemCollection sic) throws Exception {
        prmtTrainActivity.setQueryInfo("com.kingdee.eas.hr.train.app.TrainActivityQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)50));
        filterInfo.mergeFilter(TrainUtils.getHRAndAdminRangeFilterInfo("HrOrgUnit.id", "belongOrgUnit.id"), "AND");
        viewInfo.setFilter(filterInfo);
        prmtTrainActivity.setEntityViewInfo(viewInfo);
        if (sic != null) {
            prmtTrainActivity.setSelectorCollection(sic);
        }
    }

    public static void initTrainActivity_By_End_Star(KDBizPromptBox prmtTrainActivity) throws Exception {
        TrainActivityHelper.initTrainActivity_By_End_Star(prmtTrainActivity, null);
    }

    public static void initTrainActivity_By_End_Star(KDBizPromptBox prmtTrainActivity, SelectorItemCollection sic) throws Exception {
        prmtTrainActivity.setQueryInfo("com.kingdee.eas.hr.train.app.TrainActivityQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)50));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)40));
        filterInfo.setMaskString("(#0 or #1)");
        filterInfo.mergeFilter(TrainUtils.getHRAndAdminRangeFilterInfo("HrOrgUnit.id", "belongOrgUnit.id"), "AND");
        viewInfo.setFilter(filterInfo);
        prmtTrainActivity.setEntityViewInfo(viewInfo);
        if (sic != null) {
            prmtTrainActivity.setSelectorCollection(sic);
        }
    }

    public static void initTrainActivityForSelf(KDBizPromptBox prmtTrainActivity, SelectorItemCollection sic) throws Exception {
        prmtTrainActivity.setQueryInfo("com.kingdee.eas.hr.train.app.TrainActivitySelfQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)10, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)30, CompareType.NOTEQUALS));
        filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"HrOrgUnit.id", (String)"belongOrgUnit.id"), "AND");
        viewInfo.setFilter(filterInfo);
        prmtTrainActivity.setEntityViewInfo(viewInfo);
        if (sic != null) {
            prmtTrainActivity.setSelectorCollection(sic);
        }
    }

    public static void initTrainActivityByContact(KDBizPromptBox prmtTrainActivity, SelectorItemCollection sic) throws Exception {
        prmtTrainActivity.setQueryInfo("com.kingdee.eas.hr.train.app.TrainActivityQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("needContract", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)10, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)30, CompareType.NOTEQUALS));
        filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"HrOrgUnit.id", (String)"belongOrgUnit.id"), "AND");
        viewInfo.setFilter(filterInfo);
        prmtTrainActivity.setEntityViewInfo(viewInfo);
        if (sic != null) {
            prmtTrainActivity.setSelectorCollection(sic);
        }
    }

    public static void initPerson(KDBizPromptBox prmtPerson, boolean isMultiSelected) throws Exception {
        if (isMultiSelected) {
            PersonMultiPromptBox personF7 = new PersonMultiPromptBox();
            personF7.setIsSingleSelect(!isMultiSelected);
            prmtPerson.setSelector((KDPromptSelector)personF7);
            prmtPerson.setEnabledMultiSelection(true);
        } else {
            PersonMultiPromptBox personF7 = new PersonMultiPromptBox();
            prmtPerson.setSelector((KDPromptSelector)personF7);
        }
    }

    public static void initTrainItem(KDBizPromptBox prmtTrainItem, boolean isMultiSelected, IUIObject owner) throws Exception {
        TreeBasePromptBox trainItemF7 = new TreeBasePromptBox(owner, TrainItemF7UI.class.getName());
        trainItemF7.setSingleSelect(!isMultiSelected);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("isEnable", (Object)1));
        trainItemF7.setFilterInfo(fi);
        prmtTrainItem.setSelector((KDPromptSelector)trainItemF7);
        prmtTrainItem.setEditable(false);
    }

    public static BigDecimal getChargeItemsTotalCost(String trainActCourseId) throws Exception {
        return TrainActivityFacadeFactory.getRemoteInstance().getChargeItemsTotalCost(trainActCourseId);
    }

    public static AdminOrgUnitInfo getAdminOrgUnit(String personId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        try {
            IPositionMember iPM = PositionMemberFactory.getRemoteInstance();
            PositionMemberCollection pmColl = iPM.getPositionMemberCollection(viewInfo);
            if (pmColl != null && pmColl.size() > 0) {
                return pmColl.get(0).getPosition().getAdminOrgUnit();
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static PositionInfo getPosition(String personId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        try {
            IPositionMember iPM = PositionMemberFactory.getRemoteInstance();
            PositionMemberCollection pmColl = iPM.getPositionMemberCollection(viewInfo);
            if (pmColl != null && pmColl.size() > 0) {
                return pmColl.get(0).getPosition();
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static PositionInfo getPositionAndAdminOrgUnit(String personId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        try {
            IPositionMember iPM = PositionMemberFactory.getRemoteInstance();
            PositionMemberCollection pmColl = iPM.getPositionMemberCollection(viewInfo);
            if (pmColl != null && pmColl.size() > 0) {
                return pmColl.get(0).getPosition();
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static void initSpinnerYear(KDSpinner spnYear) {
        Calendar instance = Calendar.getInstance();
        int thisYear = instance.get(1);
        SpinnerNumberModel yModel = new SpinnerNumberModel(thisYear, thisYear - 100, thisYear + 100, 1);
        spnYear.setModel((SpinnerModel)yModel);
    }

    public static void initSpinnerYear(KDSpinner spnBeginYear, KDSpinner spnBeginMonthOrQuarter, KDSpinner spnEndYear, KDSpinner spnEndMonthOrQuarter, TrainPlanCategoryEnum categoryEnum) {
        Calendar instance = Calendar.getInstance();
        int thisYear = instance.get(1);
        SpinnerNumberModel yModel = new SpinnerNumberModel(thisYear, thisYear - 100, thisYear + 100, 1);
        spnBeginYear.setModel((SpinnerModel)yModel);
        SpinnerNumberModel yModel1 = new SpinnerNumberModel(thisYear, thisYear - 100, thisYear + 100, 1);
        spnEndYear.setModel((SpinnerModel)yModel1);
        if (categoryEnum.equals((Object)TrainPlanCategoryEnum.QUARTER)) {
            int thisQuarter = TrainActivityHelper.getQuarter(instance.get(2) + 1);
            SpinnerNumberModel mModel = new SpinnerNumberModel(thisQuarter, 1, 4, 1);
            spnBeginMonthOrQuarter.setModel((SpinnerModel)mModel);
            SpinnerNumberModel mModel1 = new SpinnerNumberModel(thisQuarter, 1, 4, 1);
            spnEndMonthOrQuarter.setModel((SpinnerModel)mModel1);
        } else {
            int thisMonth = instance.get(2) + 1;
            SpinnerNumberModel mModel = new SpinnerNumberModel(thisMonth, 1, 12, 1);
            spnBeginMonthOrQuarter.setModel((SpinnerModel)mModel);
            SpinnerNumberModel mModel1 = new SpinnerNumberModel(thisMonth, 1, 12, 1);
            spnEndMonthOrQuarter.setModel((SpinnerModel)mModel1);
        }
    }

    public static int getQuarter(int i) {
        if (i == 1 || i == 2 || i == 3) {
            return 1;
        }
        if (i == 4 || i == 5 || i == 6) {
            return 2;
        }
        if (i == 7 || i == 8 || i == 9) {
            return 3;
        }
        return 4;
    }

    public static TrainCourseRecordInfo setRecordDefaultCourseInfo(TrainCourseRecordInfo recordInfo, TrainCourseInfo courseInfo) throws BOSException {
        TrainCourseRecordExtendsInfo extendsInfo;
        recordInfo.setTrainCourse(courseInfo);
        TrainCourseRecordCollection records = TrainActivityHelper.getCourseRecords(recordInfo.getEmployee().getId().toString(), recordInfo.getTrainActivity().getId().toString());
        if (records != null && records.size() > 0) {
            recordInfo = records.get(0);
            recordInfo.setId(null);
            extendsInfo = recordInfo.getRecordExtends();
            extendsInfo.setId(null);
            recordInfo.setTrainCourse(courseInfo);
        } else {
            records = TrainActivityHelper.getCourseRecords(recordInfo.getTrainActivity().getId().toString());
            if (records != null && records.size() > 0) {
                recordInfo = records.get(0);
                recordInfo.setId(null);
                if (recordInfo.getRecordExtends() == null) {
                    recordInfo.setRecordExtends(new TrainCourseRecordExtendsInfo());
                } else {
                    extendsInfo = recordInfo.getRecordExtends();
                    extendsInfo.setId(null);
                }
                recordInfo.setTrainCourse(courseInfo);
            } else {
                TrainActivityHelper.setRecordDefaultActInfo(recordInfo, recordInfo.getTrainActivity());
            }
        }
        if (recordInfo.getTrainActivity() != null && !TrainCommonUtils.isEmpty((CoreBaseInfo)courseInfo)) {
            TrainActCourseInfo actCourseInfo = TrainActivityHelper.getTrainActCourse(recordInfo.getTrainActivity().getId().toString(), courseInfo.getId().toString());
            Date startDate = null;
            Date endDate = null;
            if (actCourseInfo != null) {
                startDate = actCourseInfo.getStartDate();
                endDate = actCourseInfo.getEndDate();
            } else {
                startDate = recordInfo.getActBeginDate();
                endDate = recordInfo.getActEndDate();
            }
            if (startDate != null) {
                recordInfo.setBeginDateTime(new Timestamp(startDate.getTime()));
            }
            if (endDate != null) {
                recordInfo.setEndDateTime(new Timestamp(endDate.getTime()));
            }
            if (recordInfo.getCourseCost() == null) {
                recordInfo.setCourseCost(actCourseInfo.getTotalCost());
            }
        }
        if (recordInfo.getTrainType() == null) {
            recordInfo.setTrainType(TrainTypeEnum.INNERTRAINTYPE);
        }
        if (recordInfo.getActTrainType() == null) {
            recordInfo.setActTrainType(TrainTypeEnum.INNERTRAINTYPE);
        }
        return recordInfo;
    }

    public static TrainCourseRecordInfo setRecordDefaultCourseInfo(TrainCourseRecordInfo recordInfo, TrainActCourseInfo trainActCourseInfo) throws BOSException {
        recordInfo.setTrainCourse(trainActCourseInfo.getTrainCourse());
        recordInfo.setCourseHour(trainActCourseInfo.getCourseHour());
        if (trainActCourseInfo.getCourseHourUnit() != null) {
            recordInfo.setCourseHourUnit(trainActCourseInfo.getCourseHourUnit());
        }
        if (trainActCourseInfo.getStartDate() != null) {
            recordInfo.setBeginDateTime(new Timestamp(trainActCourseInfo.getStartDate().getTime()));
        }
        if (trainActCourseInfo.getEndDate() != null) {
            recordInfo.setEndDateTime(new Timestamp(trainActCourseInfo.getEndDate().getTime()));
        }
        recordInfo.setNeedExam(trainActCourseInfo.isNeedExam());
        if (trainActCourseInfo.isNeedExam()) {
            recordInfo.setAssessMethod(trainActCourseInfo.getAssessMethod());
        }
        recordInfo.setTrainMethod(trainActCourseInfo.getTrainingMethod());
        return recordInfo;
    }

    public static TrainCourseRecordInfo setRecordDefaultActInfo(TrainCourseRecordInfo recordInfo) throws BOSException {
        String trainActivityId;
        String employeeId = TrainCommonUtils.isEmpty((CoreBaseInfo)recordInfo.getEmployee()) ? null : recordInfo.getEmployee().getId().toString();
        TrainCourseRecordCollection records = TrainActivityHelper.getCourseRecords(employeeId, trainActivityId = TrainCommonUtils.isEmpty((CoreBaseInfo)recordInfo.getTrainActivity()) ? null : recordInfo.getTrainActivity().getId().toString());
        if (records != null && records.size() > 0) {
            recordInfo = records.get(0);
            recordInfo.setId(null);
            TrainCourseRecordExtendsInfo extendsInfo = recordInfo.getRecordExtends();
            extendsInfo.setId(null);
        } else {
            records = TrainActivityHelper.getCourseRecords(trainActivityId);
            if (records != null && records.size() > 0) {
                PersonInfo employeeInfo = recordInfo.getEmployee();
                recordInfo = records.get(0);
                recordInfo.setId(null);
                recordInfo.setEmployee(employeeInfo);
                TrainCourseRecordExtendsInfo extendsInfo = recordInfo.getRecordExtends();
                extendsInfo.setId(null);
            } else {
                TrainActivityHelper.setRecordDefaultActInfo(recordInfo, recordInfo.getTrainActivity());
            }
        }
        return recordInfo;
    }

    public static TrainCourseRecordCollection getCourseRecords(String employeeId, String trainActivityId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("Employee.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainActivity.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainMethod.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAssessMethod.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("trainItem.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainCategory.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainingCategory.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainType"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainAddress"));
        viewInfo.getSelector().add(new SelectorItemInfo("actNeedExam"));
        viewInfo.getSelector().add(new SelectorItemInfo("actHour"));
        viewInfo.getSelector().add(new SelectorItemInfo("actHourUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCost"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAssessScore"));
        viewInfo.getSelector().add(new SelectorItemInfo("actIsPassed"));
        viewInfo.getSelector().add(new SelectorItemInfo("actBeginDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("actEndDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("actPassStandard"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAttendAll"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAbsentHour"));
        viewInfo.getSelector().add(new SelectorItemInfo("actShouldAttend"));
        viewInfo.getSelector().add(new SelectorItemInfo("actActualAttend"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAbsHourUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAbsent"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAbsentType"));
        viewInfo.getSelector().add(new SelectorItemInfo("actDescription"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.actAssessValue"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)employeeId));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", null, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        return TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(viewInfo);
    }

    public static TrainCourseRecordCollection getCourseRecords(String trainActivityId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("TrainActivity.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainMethod.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAssessMethod.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("trainItem.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainCategory.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainingCategory.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainType"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainAddress"));
        viewInfo.getSelector().add(new SelectorItemInfo("actNeedExam"));
        viewInfo.getSelector().add(new SelectorItemInfo("actHour"));
        viewInfo.getSelector().add(new SelectorItemInfo("actHourUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("actBeginDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("actEndDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("actPassStandard"));
        viewInfo.getSelector().add(new SelectorItemInfo("actShouldAttend"));
        viewInfo.getSelector().add(new SelectorItemInfo("actDescription"));
        viewInfo.getSelector().add(new SelectorItemInfo("actDescription"));
        viewInfo.getSelector().add(new SelectorItemInfo("Employee.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", null, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        return TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(viewInfo);
    }

    public static TrainCourseRecordInfo setRecordDefaultActInfo(TrainCourseRecordInfo recordInfo, TrainActivityInfo activityInfo) {
        recordInfo.setTrainActivity(activityInfo);
        recordInfo.setTrainItem(activityInfo.getTrainItem());
        recordInfo.setActBeginDate(activityInfo.getTrainStartDate());
        recordInfo.setActEndDate(activityInfo.getTrainEndDate());
        recordInfo.setActCost(activityInfo.getBudgetCost());
        recordInfo.setActTrainAddress(activityInfo.getTrainAddress());
        recordInfo.setActDescription(activityInfo.getDescription());
        recordInfo.setActNeedExam(activityInfo.isNeedExam());
        recordInfo.setActPassStandard(activityInfo.getPassStand());
        recordInfo.setActTrainMethod(activityInfo.getTrainMethod());
        recordInfo.setActTrainType(activityInfo.getTrainType());
        recordInfo.setActTrainingCategory(activityInfo.getTrainingCategor());
        recordInfo.setActTrainCategory(activityInfo.getTrainCatagory());
        recordInfo.setTrainChannel(activityInfo.getTrainChanne());
        recordInfo.setOrgUnit(activityInfo.getOrgUnit());
        if (activityInfo.isNeedAssess()) {
            recordInfo.setActAssessMethod(activityInfo.getAssessMethod());
        }
        recordInfo.setActIsPassed(TrainRecordIsPassedEnum.PASSED);
        recordInfo.setIsPassed(TrainRecordIsPassedEnum.PASSED);
        if (recordInfo.getTrainType() == null) {
            recordInfo.setTrainType(TrainTypeEnum.INNERTRAINTYPE);
        }
        return recordInfo;
    }

    public static SelectorItemCollection getActSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("trainItem.id"));
        sic.add(new SelectorItemInfo("trainItem.number"));
        sic.add(new SelectorItemInfo("trainItem.name"));
        sic.add(new SelectorItemInfo("trainStartDate"));
        sic.add(new SelectorItemInfo("trainEndDate"));
        sic.add(new SelectorItemInfo("BudgetCost"));
        sic.add(new SelectorItemInfo("orgPerson.id"));
        sic.add(new SelectorItemInfo("orgPerson.number"));
        sic.add(new SelectorItemInfo("orgPerson.name"));
        sic.add(new SelectorItemInfo("trainAddress"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("needAssess"));
        sic.add(new SelectorItemInfo("passStand"));
        sic.add(new SelectorItemInfo("assessMethod.id"));
        sic.add(new SelectorItemInfo("assessMethod.name"));
        sic.add(new SelectorItemInfo("trainMethod.id"));
        sic.add(new SelectorItemInfo("trainType"));
        sic.add(new SelectorItemInfo("trainCatagory.id"));
        sic.add(new SelectorItemInfo("trainingCategor.id"));
        sic.add(new SelectorItemInfo("trainChanne.id"));
        sic.add(new SelectorItemInfo("trainChanne.name"));
        sic.add(new SelectorItemInfo("trainActState"));
        return sic;
    }

    public static String getDateRang(Date startDate, Date endDate, String split) {
        StringBuffer str = new StringBuffer();
        if (startDate != null || endDate != null) {
            str.append(startDate);
            str.append(split);
            str.append(endDate);
        }
        return str.toString();
    }

    public static List getActCourseIds(String activityId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)activityId));
        viewInfo.setFilter(filterInfo);
        TrainActCourseCollection courses = TrainActCourseFactory.getRemoteInstance().getTrainActCourseCollection(viewInfo);
        ArrayList<String> courseIds = null;
        if (courses != null && courses.size() > 0) {
            courseIds = new ArrayList<String>();
            for (int i = 0; i < courses.size(); ++i) {
                courseIds.add(courses.get(i).getTrainCourse().getId().toString());
            }
        }
        return courseIds;
    }

    public static void setAddAndEndPersonState(KDBizPromptBox prmtTrainActivity, KDBizPromptBox prmtTrainCourse, JButton btnAddRuleNew, JButton btnDelRuleNew, KDTable tblMain) throws BOSException {
        if (prmtTrainActivity.getValue() != null && prmtTrainCourse.getValue() == null) {
            TrainActivityInfo info = (TrainActivityInfo)prmtTrainActivity.getValue();
            if (!TrainActStateEnum.CLOSED.equals((Object)info.getTrainActState())) {
                btnAddRuleNew.setEnabled(false);
                btnDelRuleNew.setEnabled(false);
                TrainActivityHelper.clearTable(tblMain);
            }
        } else {
            btnAddRuleNew.setEnabled(true);
            btnAddRuleNew.setEnabled(true);
        }
    }

    public static void clearTable(KDTable tblMain) {
        tblMain.checkParsed();
        tblMain.removeRows();
    }

    public static TrainCourseRecordCollection getRecordCollection(Set personIdSet, KDBizPromptBox prmtTrainActivity, KDBizPromptBox prmtTrainCourse) throws Exception {
        if (personIdSet == null || personIdSet.size() == 0) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)personIdSet, CompareType.INCLUDE));
        filterInfo.mergeFilter(TrainActivityHelper.getFilterInfo(prmtTrainActivity, prmtTrainCourse), "AND");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.isApproved"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.actIsApproved"));
        TrainCourseRecordCollection col = TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(viewInfo);
        if (prmtTrainActivity.getValue() == null && prmtTrainCourse.getValue() != null) {
            if (col == null || col.size() == 0) {
                return null;
            }
            TrainCourseRecordCollection col_tmp = new TrainCourseRecordCollection();
            for (int i = 0; i < col.size(); ++i) {
                TrainCourseRecordInfo info = col.get(i);
                String trainDate = TrainClientUtil.assembleDate(info.getBeginDateTime(), info.getEndDateTime(), "yyyy-MM-dd HH:mm:ss");
                info.put("trainDate", trainDate);
                col_tmp.add(info);
            }
            return col_tmp;
        }
        return col;
    }

    public static Set getPersonIdSet(KDBizPromptBox prmtTrainActivity, KDBizPromptBox prmtTrainCourse) throws Exception {
        HashSet<String> personIdSet = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        String userID = null;
        userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        TrainActivityInfo trainActivityInfo = (TrainActivityInfo)prmtTrainActivity.getValue();
        TrainCourseInfo trainCourseInfo = (TrainCourseInfo)prmtTrainCourse.getValue();
        if (prmtTrainActivity.getValue() != null && prmtTrainCourse.getValue() != null) {
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityInfo.getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)trainCourseInfo.getId().toString()));
        } else if (prmtTrainActivity.getValue() != null && prmtTrainCourse.getValue() == null) {
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityInfo.getId().toString()));
        } else if (prmtTrainActivity.getValue() == null && prmtTrainCourse.getValue() != null) {
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", null, CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)trainCourseInfo.getId().toString()));
        }
        fi.getFilterItems().add(new FilterItemInfo("recordExtends.isApproved", (Object)Boolean.FALSE));
        fi.getFilterItems().add(new FilterItemInfo("recordExtends.actIsApproved", (Object)Boolean.FALSE));
        fi.getFilterItems().add(TrainCommonUtils.getAdminRangeFilterItemInfo(userID, "recordExtends.OrgStudent.id"));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("Employee.id"));
        TrainCourseRecordCollection recordCol = TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(evi);
        if (recordCol == null || recordCol.size() == 0) {
            return null;
        }
        for (int i = 0; i < recordCol.size(); ++i) {
            TrainCourseRecordInfo recordInfo = recordCol.get(i);
            personIdSet.add(recordInfo.getEmployee().getId().toString());
        }
        return personIdSet;
    }

    public static FilterInfo getFilterInfo(KDBizPromptBox prmtTrainActivity, KDBizPromptBox prmtTrainCourse) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        if (prmtTrainCourse.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)((TrainCourseInfo)prmtTrainCourse.getValue()).getId().toString()));
        }
        if (prmtTrainActivity.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((TrainActivityInfo)prmtTrainActivity.getValue()).getId().toString()));
        } else if (prmtTrainCourse.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", null));
        }
        if (filterInfo.getFilterItems().size() == 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)BOSUuid.create((BOSObjectType)new TrainCourseRecordInfo().getBOSType()).toString()));
        }
        filterInfo.mergeFilter(TrainUtils.getHRAndAdminRangePersonFilterInfo_All("hrOrgUnit.id", "employee.id"), "AND");
        return filterInfo;
    }

    public static Set getTableIdSet(KDTable tblMain) {
        if (tblMain.getRowCount() == 0) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            IRow row = tblMain.getRow(i);
            idSet.add(row.getCell("id").getValue().toString());
        }
        return idSet;
    }

    public static void deleteRows(KDTable tblMain) {
        int[] row = KDTableUtil.getSelectedRows((KDTable)tblMain);
        for (int i = row.length - 1; i >= 0; --i) {
            IRow r = tblMain.getRow(row[i]);
            if (r == null) continue;
            tblMain.removeRow(row[i]);
        }
    }

    public static void columnCopy(KDTable tblMain) {
        if (tblMain.getRowCount() == 0) {
            return;
        }
        int size = tblMain.getSelectManager().size();
        if (size > 0) {
            KDTSelectBlock sb = tblMain.getSelectManager().get(0);
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = tblMain.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            Object value = tblMain.getCell(row, column).getValue();
            int length = tblMain.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (i == row) continue;
                tblMain.getCell(i, column).setValue(value);
            }
        }
    }

    public static TrainCourseRecordCollection getRecordCollection(FilterInfo filterInfo, SelectorItemCollection itemCollection) throws Exception {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("recordExtends.isApproved", (Object)Boolean.FALSE));
        fi.mergeFilter(filterInfo, "AND");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(fi);
        if (itemCollection != null && itemCollection.size() > 0) {
            int n = itemCollection.size();
            for (int i = 0; i < n; ++i) {
                viewInfo.getSelector().add(itemCollection.get(i));
            }
        }
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.isApproved"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.actIsApproved"));
        return TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(viewInfo);
    }

    public static TrainCourseRecordCollection filterRecord(TrainCourseRecordCollection courseRecordCollection, boolean isActivity, boolean justCourse) {
        TrainCourseRecordCollection col = new TrainCourseRecordCollection();
        String trainDate = null;
        HashSet<String> tmp_Set = new HashSet<String>();
        if (courseRecordCollection == null || courseRecordCollection.size() == 0) {
            return null;
        }
        if (isActivity) {
            tmp_Set.clear();
            for (int i = 0; i < courseRecordCollection.size(); ++i) {
                TrainCourseRecordInfo recordInfo = courseRecordCollection.get(i);
                if (recordInfo.getRecordExtends().isActIsApproved() || tmp_Set.contains(recordInfo.getEmployee().getId().toString())) continue;
                col.add(recordInfo);
                tmp_Set.add(recordInfo.getEmployee().getId().toString());
            }
        } else {
            tmp_Set.clear();
            for (int i = 0; i < courseRecordCollection.size(); ++i) {
                TrainCourseRecordInfo recordInfo = courseRecordCollection.get(i);
                if (recordInfo.getRecordExtends().isIsApproved() || tmp_Set.contains(recordInfo.getId().toString())) continue;
                col.add(recordInfo);
                tmp_Set.add(recordInfo.getId().toString());
                trainDate = TrainClientUtil.assembleDate(recordInfo.getBeginDateTime(), recordInfo.getEndDateTime(), "yyyy-MM-dd HH:mm:ss");
                if (!justCourse) continue;
                recordInfo.put("trainDate", trainDate);
            }
        }
        return col;
    }

    public static Set getTableSet(KDTable tblMain, String columnName) {
        HashSet<Object> rowIdSet = new HashSet<Object>();
        if (tblMain == null || tblMain.getRowCount() == 0) {
            return rowIdSet;
        }
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            IRow row = tblMain.getRow(i);
            rowIdSet.add(row.getCell(columnName).getValue());
        }
        return rowIdSet;
    }

    public static TrainCourseRecordCollection filterRecord(TrainCourseRecordCollection courseRecordCollection, boolean justCourse) {
        if (justCourse) {
            for (int i = 0; i < courseRecordCollection.size(); ++i) {
                TrainCourseRecordInfo info = courseRecordCollection.get(i);
                String trainDate = TrainClientUtil.assembleDate(info.getBeginDateTime(), info.getEndDateTime(), "yyyy-MM-dd HH:mm:ss");
                info.put("trainDate", trainDate);
            }
        }
        return courseRecordCollection;
    }

    public static HashMap getPropertyForRecordPerson(Set persons) throws Exception {
        HashMap personMap = new HashMap();
        if (persons == null || persons.size() == 0) {
            return personMap;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)persons, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainCourseRecordForBatchQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        while (rowSet.next()) {
            HashMap<String, String> personRef = new HashMap<String, String>();
            personRef.put("name", rowSet.getString("name"));
            personRef.put("number", rowSet.getString("number"));
            personRef.put("orgUnit", rowSet.getString("adminOrgUnit.displayName"));
            personRef.put("jobGrade", rowSet.getString("JobGrade.name"));
            personRef.put("position", rowSet.getString("position.name"));
            personRef.put("id", rowSet.getString("id"));
            personMap.put(rowSet.getString("id"), personRef);
        }
        return personMap;
    }
}

