/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.train.ParticipatorRoleFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainActivityOrganigerCollection;
import com.kingdee.eas.hr.train.TrainActivityOrganigerFactory;
import com.kingdee.eas.hr.train.TrainActivityOrganigerInfo;
import com.kingdee.eas.hr.train.TrainException;
import com.kingdee.eas.hr.train.client.AbstractTrainActivityOrganigerEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.ComboBoxModel;
import org.apache.log4j.Logger;

public class TrainActivityOrganigerEditUI
extends AbstractTrainActivityOrganigerEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActivityOrganigerEditUI.class);
    private String trainActivityId;
    private ItemAction[] actions = null;

    public void onLoad() throws Exception {
        this.kdtEntries.checkParsed();
        this.trainActivityId = (String)this.getUIContext().get("TrainActivityID");
        this.actions = TrainUtils.addButtonsToMutilTable(this.contOrganizer, this.kdtEntries);
        EmployeeMultiF7PromptBox promptBox = new EmployeeMultiF7PromptBox((IUIObject)this);
        promptBox.setUserOrgRangeFilter(true);
        TrainUtils.setTableCellEditorByF7Selector(this.kdtEntries, (KDPromptSelector)promptBox, "organiger");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(TrainUtils.getCUFilterForQuery());
        TrainUtils.setTableCellEditorByF7Query(this.kdtEntries, "com.kingdee.eas.hr.train.app.ParticipatorRoleQuery", "role", evi);
        this.kdtEntries.getColumn("workPhone").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("mobilePhone").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("number").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("email").getStyleAttributes().setLocked(true);
        this.initWorkButton();
        this.setDataObject(this.getTrainActivityOrganizerInfo());
        this.loadFields();
        TrainUtils.setTableCellEditorByTextField(this.kdtEntries, "responsibility", 100);
        TrainUtils.setTableCellEditorByTextField(this.kdtEntries, "remark", 100);
        this.kdtEntries.getColumn("number").getStyleAttributes().setBackground(TrainActivityHelper.DISABLE_COLOR);
        this.kdtEntries.getColumn("workPhone").getStyleAttributes().setBackground(TrainActivityHelper.DISABLE_COLOR);
        this.kdtEntries.getColumn("mobilePhone").getStyleAttributes().setBackground(TrainActivityHelper.DISABLE_COLOR);
        this.kdtEntries.getColumn("email").getStyleAttributes().setBackground(TrainActivityHelper.DISABLE_COLOR);
        KDComboBox cboRole = new KDComboBox();
        cboRole.setModel((ComboBoxModel)TrainUtils.getComboModel(ParticipatorRoleFactory.getRemoteInstance(), TrainUtils.getCurrentHRFilter("hrOrgUnit.id")));
        TrainUtils.setTableCellEditorByComboBox(this.kdtEntries, cboRole, "role");
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.kdtEntries.getStyleAttributes().setLocked(true);
            for (int i = 0; i < this.actions.length; ++i) {
                this.actions[i].setEnabled(false);
            }
        }
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
    }

    private IObjectValue getTrainActivityOrganizerInfo() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)this.trainActivityId));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        TrainActivityOrganigerCollection trainActivityOrganigerCollection = TrainActivityOrganigerFactory.getRemoteInstance().getTrainActivityOrganigerCollection(evi);
        if (trainActivityOrganigerCollection != null && trainActivityOrganigerCollection.size() > 0) {
            return trainActivityOrganigerCollection.get(0);
        }
        return this.createNewData();
    }

    protected String getEditUIName() {
        return TrainActivityOrganigerEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainActivityOrganigerFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainActivityOrganigerInfo objectValue = new TrainActivityOrganigerInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        TrainActivityInfo trainActivityInfo = new TrainActivityInfo();
        trainActivityInfo.setId(BOSUuid.read((String)this.trainActivityId));
        objectValue.setTrainActivity(trainActivityInfo);
        return objectValue;
    }

    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        super.kdtEntries_editStopped(e);
        int colIndex = e.getColIndex();
        IRow row = this.kdtEntries.getRow(e.getRowIndex());
        if (colIndex == this.kdtEntries.getColumn("organiger").getColumnIndex() && e.getValue() != null) {
            PersonInfo personInfo = (PersonInfo)e.getValue();
            String id = personInfo.getId().toString();
            personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(id));
            row.getCell("number").setValue((Object)personInfo.getNumber());
            row.getCell("workPhone").setValue((Object)personInfo.getOfficePhone());
            row.getCell("mobilePhone").setValue((Object)personInfo.getCell());
            row.getCell("email").setValue((Object)personInfo.getEmail());
            row.getCell("id").setValue((Object)id);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtEntries, "organiger");
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtEntries, "role");
        if (TrainUtils.isRepeatRowInTable(this.kdtEntries, "organiger")) {
            String name = this.contOrganizer.getTitle();
            throw new TrainException(TrainException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void kdtEntries_editStarting(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtEntries.getColumn("role").getColumnIndex()) {
            int rowIndex = e.getRowIndex();
            KDComboBox comboBox = (KDComboBox)this.kdtEntries.getEditManager().getEditor().getComponent();
            TrainUtils.setComboBoxSelected(comboBox, this.kdtEntries, rowIndex, colIndex);
        }
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)((String)this.getUIContext().get("TrainActivityID"))));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        request.put("viewInfo", (Object)evi);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public boolean isPrepareInit() {
        return true;
    }
}

