/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.train.AbsentTypeEnum;
import com.kingdee.eas.hr.train.AssessMethodInfo;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainAssistant;
import com.kingdee.eas.hr.train.TrainCategoryFactory;
import com.kingdee.eas.hr.train.TrainCategoryInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseRecordCollection;
import com.kingdee.eas.hr.train.TrainCourseRecordExtendsInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.TrainFacadeFactory;
import com.kingdee.eas.hr.train.TrainRecordIsPassedEnum;
import com.kingdee.eas.hr.train.TrainTypeEnum;
import com.kingdee.eas.hr.train.TrainingCategoryFactory;
import com.kingdee.eas.hr.train.TrainingCategoryInfo;
import com.kingdee.eas.hr.train.TrainingMethodInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainActivityRecordEditUI;
import com.kingdee.eas.hr.train.client.PersonCheckUpEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainContractEditUI;
import com.kingdee.eas.hr.train.client.TrainRewardsEditUI;
import com.kingdee.eas.hr.train.client.TrainThoughtEditUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.event.ChangeEvent;

public class TrainActivityRecordEditUI
extends AbstractTrainActivityRecordEditUI {
    public static String RES = "com.kingdee.eas.hr.train.client.TrainChanneResource";
    private String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";
    private String notEnterInfo = EASResource.getString((String)this.resourcePath, (String)"HAVENOTENTERINFO");
    private HashMap hmUIState = new HashMap();
    private boolean isTrainActivityRecord = true;
    private boolean isLoadField = false;
    BOSUuid posiID;
    BOSUuid orgID;

    public void onLoad() throws Exception {
        this.btnAttachment.setVisible(true);
        this.txtActivityPassStandard.setPrecision(2);
        this.MenuItemAttachment.setVisible(true);
        this.MenuItemAttachment.setEnabled(true);
        if (this.getUIContext().get("IsTrainActivityRecord") != null) {
            this.isTrainActivityRecord = (Boolean)this.getUIContext().get("IsTrainActivityRecord");
        }
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmt.setIsSingleSelect(true);
        pmt.setUserOrgRangeFilter(true);
        HashSet hroSet = TrainActivityFacadeFactory.getRemoteInstance().getHRRange();
        pmt.setHROFilter(hroSet);
        pmt.setModal(true);
        pmt.setReturnPositionAndUnit(false);
        this.prmtEmployee.setSelector((KDPromptSelector)pmt);
        this.prmtEmployee.setEditable(false);
        this.initPrmtTrainActivity();
        this.initTrainChannel();
        TrainActivityHelper.initTrainItem(this.prmtTrainItem, false, (IUIObject)this);
        TrainUtils.initOrgUnit(this.prmtOrgUnit, false, (IUIObject)this);
        TrainActivityHelper.initPerson(this.prmtResponser, false);
        this.prmpTrainChannel.setEditable(false);
        this.setComboBox();
        this.setUIStatus();
        super.onLoad();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.chkEnterPersonInfo.setSelected(true);
            this.comboActivityIsPassed.setSelectedItem((Object)TrainRecordIsPassedEnum.PASSED);
            this.ckActivityAttendAll.setSelected(true);
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            TrainClientUtil.lockUI((CoreUI)this, this.hmUIState);
        }
        this.initFormattedTextRange();
        this.prmtTrainActivity.setRequired(this.isTrainActivityRecord);
        this.prmpTrainCategory.setEntityViewInfo(TrainUtils.getCurrentCUEntityViewInfo());
        this.prmpTrainingCategory.setEntityViewInfo(TrainUtils.getCurrentHREntityViewInfo());
        if (this.chkActivityNeedExam.isSelected()) {
            this.setComponentStateByNeedExam(true);
        } else {
            this.setComponentStateByNeedExam(false);
        }
    }

    private void initTrainChannel() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)TrainUtils.getCurrentHROrgUnit().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("IsEnabled", (Object)0));
        evi.setFilter(fi);
        this.prmpTrainChannel.setEntityViewInfo(evi);
    }

    private void setComboBox() throws BOSException, EASBizException {
        HashMap parameters = new HashMap();
        HashMap<String, Object> trainMethodMap = new HashMap<String, Object>();
        trainMethodMap.put("bosType", new TrainingMethodInfo().getBOSType());
        trainMethodMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("trainMethod", trainMethodMap);
        HashMap<String, Object> assessMethodMap = new HashMap<String, Object>();
        assessMethodMap.put("bosType", new AssessMethodInfo().getBOSType());
        assessMethodMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("assessMethod", assessMethodMap);
        Map result = TrainFacadeFactory.getRemoteInstance().batchGetCollection(parameters);
        this.cboTrainMethod.setModel((ComboBoxModel)TrainUtils.getComboBoxModel((IObjectCollection)result.get("trainMethod")));
        this.cboAssessMethod.setModel((ComboBoxModel)TrainUtils.getComboBoxModel((IObjectCollection)result.get("assessMethod")));
    }

    private void initFormattedTextRange() {
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtActivityCost);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtActivityHour);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtActivityPassStandard);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtAssessScore);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtActivityShouldAttendTimes);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtActivityRealAttendTimes);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtActivityAbsentTimes);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtActivityAbsentHour);
    }

    private void initPrmtTrainActivity() throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("trainItem.id"));
        sic.add(new SelectorItemInfo("trainItem.number"));
        sic.add(new SelectorItemInfo("trainItem.name"));
        sic.add(new SelectorItemInfo("trainStartDate"));
        sic.add(new SelectorItemInfo("trainEndDate"));
        sic.add(new SelectorItemInfo("BudgetCost"));
        sic.add(new SelectorItemInfo("orgPerson.id"));
        sic.add(new SelectorItemInfo("orgPerson.number"));
        sic.add(new SelectorItemInfo("orgPerson.name"));
        sic.add(new SelectorItemInfo("trainAddress"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("needAssess"));
        sic.add(new SelectorItemInfo("passStand"));
        sic.add(new SelectorItemInfo("assessMethod.id"));
        sic.add(new SelectorItemInfo("assessMethod.name"));
        sic.add(new SelectorItemInfo("trainMethod.id"));
        sic.add(new SelectorItemInfo("trainMethod.name"));
        sic.add(new SelectorItemInfo("needCertifcate"));
        sic.add(new SelectorItemInfo("trainChanne.id"));
        sic.add(new SelectorItemInfo("trainChanne.name"));
        sic.add(new SelectorItemInfo("trainContent"));
        TrainActivityHelper.initTrainActivity(this.prmtTrainActivity, sic);
    }

    private void setUIStatus() {
        boolean enable = !this.getOprtState().equals(OprtState.ADDNEW);
        this.actionContract.setEnabled(enable);
        this.actionReward.setEnabled(enable);
        this.actionThought.setEnabled(enable);
        this.actionAttachment.setEnabled(enable);
        this.actionPersonCheckUp.setEnabled(enable);
        this.actionAttachment.setEnabled(enable);
        if (!enable) {
            this.ckActivityAttendAll.setSelected(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnContract.setIcon(EASResource.getIcon((String)"imgTbtn_pactletter"));
        this.btnReward.setIcon(EASResource.getIcon((String)"imgTbtn_hortationamerce"));
        this.btnThought.setIcon(EASResource.getIcon((String)"imgTbtn_learned"));
        this.btnPersonCheckUp.setIcon(EASResource.getIcon((String)"imgTbtn_recostallot"));
        this.menuItemContract.setIcon(EASResource.getIcon((String)"imgTbtn_pactletter"));
        this.menuItemReward.setIcon(EASResource.getIcon((String)"imgTbtn_hortationamerce"));
        this.menuItemThought.setIcon(EASResource.getIcon((String)"imgTbtn_learned"));
        this.menuItemPersonCheckUp.setIcon(EASResource.getIcon((String)"imgTbtn_recostallot"));
    }

    public void loadFields() {
        this.isLoadField = true;
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            try {
                this.setDataObject(this.getValue(null));
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
        super.loadFields();
        if (this.editData.getRecordExtends() != null && this.editData.getRecordExtends().size() > 0) {
            this.txtAssessValue.setText(this.editData.getRecordExtends().getActAssessValue());
        } else {
            this.txtAssessValue.setText(null);
        }
        if (this.editData.getActAssessMethod() != null) {
            TrainUtils.setComboBoxSelected(this.cboAssessMethod, this.editData.getActAssessMethod().getId().toString());
        } else {
            this.cboAssessMethod.setSelectedIndex(-1);
        }
        if (this.editData.getActTrainMethod() != null) {
            TrainUtils.setComboBoxSelected(this.cboTrainMethod, this.editData.getActTrainMethod().getId().toString());
        } else {
            this.cboTrainMethod.setSelectedIndex(-1);
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.setPrmtTrainActivityState();
        }
        this.isLoadField = false;
    }

    private void setPrmtTrainActivityState() {
        if (!this.isTrainActivityRecord) {
            return;
        }
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)this.editData.getTrainCourse())) {
            this.prmtTrainActivity.setEnabled(false);
            return;
        }
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)this.editData.getTrainActivity())) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)this.editData.getEmployee().getId().toString()));
            String trainActivityId = this.editData.getTrainActivity().getId().toString();
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", null, CompareType.NOTEQUALS));
            viewInfo.setFilter(filterInfo);
            try {
                TrainCourseRecordCollection collection = TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(viewInfo);
                if (collection != null && collection.size() > 0) {
                    this.prmtTrainActivity.setEnabled(false);
                }
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        pk = this.getUIContext().get("ID") != null ? new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("ID").toString())) : null;
        return this.getBizInterface().getValue(pk, this.getSelectors());
    }

    public void actionContract_actionPerformed(ActionEvent e) throws Exception {
        this.showNewWindow(TrainContractEditUI.class.getName());
    }

    public void actionReward_actionPerformed(ActionEvent e) throws Exception {
        this.showNewWindow(TrainRewardsEditUI.class.getName());
    }

    public void actionThought_actionPerformed(ActionEvent e) throws Exception {
        this.showNewWindow(TrainThoughtEditUI.class.getName());
    }

    private void showNewWindow(String uiName) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.editData.getId().toString());
        uiContext.put((Object)"come_from", (Object)TrainActivityRecordEditUI.class.getName());
        uiContext.put((Object)"TrainRecordFlag", (Object)"TrainCourseRecord");
        String state = this.getOprtState();
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, state);
        window.show();
    }

    protected void chkActivityNeedExam_stateChanged(ChangeEvent e) throws Exception {
        super.chkActivityNeedExam_stateChanged(e);
        if (this.chkActivityNeedExam.isSelected()) {
            this.setComponentStateByNeedExam(true);
        } else {
            this.txtActivityPassStandard.setValue(null);
            this.txtAssessScore.setValue(null);
            this.cboAssessMethod.setSelectedItem(null);
            this.setComponentStateByNeedExam(false);
        }
    }

    private void setComponentStateByNeedExam(boolean flag) {
        int authority = this.cboAssessMethod.getAccessAuthority();
        this.txtActivityPassStandard.setAccessAuthority(0);
        this.txtAssessScore.setAccessAuthority(0);
        this.txtActivityPassStandard.setEnabled(flag);
        this.cboAssessMethod.setEnabled(flag);
        this.txtAssessScore.setEnabled(flag);
        this.txtAssessValue.setEnabled(flag);
        this.txtActivityPassStandard.setAccessAuthority(authority);
        this.txtAssessScore.setAccessAuthority(authority);
    }

    protected void ckActivityAttendAll_stateChanged(ChangeEvent e) throws Exception {
        if (this.ckActivityAttendAll.isSelected()) {
            this.setComponentStateByAttendAll(false);
            this.comboActivityAbsentType.setSelectedIndex(-1);
            this.txtActivityAbsentHour.setValue(null);
        } else {
            this.setComponentStateByAttendAll(true);
        }
        this.setAbsent();
    }

    private void setComponentStateByAttendAll(boolean flag) {
        int authority = this.comboActivityAbsentType.getAccessAuthority();
        this.comboActivityAbsentType.setAccessAuthority(0);
        this.txtActivityRealAttendTimes.setAccessAuthority(0);
        this.txtActivityAbsentHour.setAccessAuthority(0);
        this.comboActivityAbsentHourUnit.setAccessAuthority(0);
        this.comboActivityAbsentType.setEnabled(flag);
        this.txtActivityRealAttendTimes.setEnabled(flag);
        this.txtActivityAbsentHour.setEnabled(flag);
        this.comboActivityAbsentHourUnit.setEnabled(flag);
        this.comboActivityAbsentType.setAccessAuthority(authority);
        this.txtActivityRealAttendTimes.setAccessAuthority(authority);
        this.txtActivityAbsentHour.setAccessAuthority(authority);
        this.comboActivityAbsentHourUnit.setAccessAuthority(authority);
    }

    protected void prmtEmployee_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtEmployee_dataChanged(e);
        if (this.prmtEmployee.getData() == null) {
            return;
        }
        PersonInfo personInfo = (PersonInfo)this.prmtEmployee.getData();
        if (!OprtState.EDIT.equals(this.getOprtState()) && !OprtState.VIEW.equals(this.getOprtState())) {
            this.txtEmpPosition.setText(personInfo.get("primaryPosition").toString());
            PositionInfo posiInfo = (PositionInfo)personInfo.get("primaryPosition");
            this.posiID = posiInfo.getId();
            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)personInfo.get("primaryadminorg");
            this.orgID = adminOrgUnitInfo.getId();
            this.txtEmpUnit.setText(personInfo.get("primaryadminorg").toString());
        }
        if (TrainCommonUtils.isEmpty((CoreBaseInfo)personInfo)) {
            this.txtEmpNumber.setText(null);
            this.txtEmpSex.setText(null);
            this.txtEmpDiploma.setText(null);
            this.txtEmpPost.setText(null);
            this.txtEmpJob.setText(null);
            this.txtEmpUnit.setText(null);
            this.txtEmpPosition.setText(null);
        } else {
            Map employeeInfos = TrainFacadeFactory.getRemoteInstance().getEmployeeRelationInfo(personInfo.getId().toString());
            this.txtEmpNumber.setText((String)employeeInfos.get("number"));
            this.txtEmpSex.setText((String)employeeInfos.get("sex"));
            this.txtEmpDiploma.setText((String)employeeInfos.get("diploma"));
            this.txtEmpPost.setText((String)employeeInfos.get("technicalPost"));
            this.txtEmpJob.setText((String)employeeInfos.get("job"));
            if (employeeInfos.get("adminOrgUnit") != null) {
                this.txtEmpUnit.setText(((AdminOrgUnitInfo)employeeInfos.get("adminOrgUnit")).getName());
            }
        }
    }

    protected void prmtTrainActivity_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtTrainActivity_dataChanged(e);
        if (this.prmtTrainActivity.getData() == null) {
            this.pkActivityBeginDate.setRequired(false);
            this.pkActivityEndDate.setRequired(false);
            return;
        }
        if (this.isLoadField) {
            return;
        }
        TrainActivityInfo trainActivityInfo = (TrainActivityInfo)this.prmtTrainActivity.getData();
        this.txtTrainActivityNumber.setText(trainActivityInfo.getNumber());
        this.prmtTrainItem.setData((Object)trainActivityInfo.getTrainItem());
        this.pkActivityBeginDate.setValue((Object)trainActivityInfo.getTrainStartDate());
        this.pkActivityEndDate.setValue((Object)trainActivityInfo.getTrainEndDate());
        this.prmtResponser.setData((Object)trainActivityInfo.getOrgPerson());
        this.txtActivityCost.setNumberValue((Number)trainActivityInfo.getBudgetCost());
        this.txtActivityTrainAddress.setText(trainActivityInfo.getTrainAddress());
        this.txtActivityDescription.setText(trainActivityInfo.getDescription());
        this.chkActivityNeedExam.setSelected(trainActivityInfo.isNeedAssess());
        this.txtActivityPassStandard.setValue((Object)trainActivityInfo.getPassStand());
        this.prmtOrgUnit.setData((Object)trainActivityInfo.getOrgUnit());
        if (trainActivityInfo.getTrainContent() != null) {
            this.txtTrainContent.setText(trainActivityInfo.getTrainContent().toString());
        }
        if (trainActivityInfo.getTrainChanne() != null) {
            this.prmpTrainChannel.setData((Object)trainActivityInfo.getTrainChanne());
        }
        this.chkActGiveCertificate.setSelected(trainActivityInfo.isNeedCertifcate());
        if (trainActivityInfo.getAssessMethod() != null && trainActivityInfo.getAssessMethod().getId() != null) {
            TrainUtils.setComboBoxSelected(this.cboAssessMethod, trainActivityInfo.getAssessMethod().getId().toString());
        } else {
            this.cboAssessMethod.setSelectedIndex(-1);
        }
        if (trainActivityInfo.getTrainMethod() != null && trainActivityInfo.getTrainMethod().getId() != null) {
            TrainUtils.setComboBoxSelected(this.cboTrainMethod, trainActivityInfo.getTrainMethod().getId().toString());
        } else {
            this.cboTrainMethod.setSelectedIndex(-1);
        }
        if (trainActivityInfo.getTrainContent() != null) {
            this.txtTrainContent.setText(trainActivityInfo.getTrainContent());
        }
        this.pkActivityBeginDate.setRequired(true);
        this.pkActivityEndDate.setRequired(true);
        trainActivityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityInfo.getId().toString()));
        if (trainActivityInfo.getTrainType() != null) {
            if (TrainTypeEnum.INNERTRAINTYPE.equals((Object)trainActivityInfo.getTrainType())) {
                this.combTrainType.setSelectedItem((Object)TrainTypeEnum.INNERTRAINTYPE);
            } else {
                this.combTrainType.setSelectedItem((Object)TrainTypeEnum.OUTTRAINTYPE);
            }
        }
        TrainCategoryInfo trainCatagoryinfo = null;
        if (trainActivityInfo.getTrainCatagory() != null && trainActivityInfo.getTrainCatagory().getId() != null) {
            trainCatagoryinfo = TrainCategoryFactory.getRemoteInstance().getTrainCategoryInfo((IObjectPK)new ObjectUuidPK(trainActivityInfo.getTrainCatagory().getId().toString()));
        }
        this.prmpTrainCategory.setData(trainCatagoryinfo);
        TrainingCategoryInfo trainingCategoryInfo = null;
        if (trainActivityInfo.getTrainingCategor() != null && trainActivityInfo.getTrainingCategor().getId() != null) {
            trainingCategoryInfo = TrainingCategoryFactory.getRemoteInstance().getTrainingCategoryInfo((IObjectPK)new ObjectUuidPK(trainActivityInfo.getTrainingCategor().getId().toString()));
        }
        this.prmpTrainingCategory.setData(trainingCategoryInfo);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.setUIStatus();
    }

    public void storeFields() {
        super.storeFields();
        if (this.posiID != null) {
            this.editData.getRecordExtends().getPosiStudent().setId(this.posiID);
        } else if (this.editData.getRecordExtends().getPosiStudent() != null) {
            this.editData.getRecordExtends().getPosiStudent().setId(this.editData.getRecordExtends().getPosiStudent().getId());
        } else {
            this.editData.getRecordExtends().getPosiStudent().setId(null);
        }
        if (this.orgID != null) {
            this.editData.getRecordExtends().getOrgStudent().setId(this.orgID);
        } else if (this.editData.getRecordExtends().getPosiStudent() != null) {
            this.editData.getRecordExtends().getOrgStudent().setId(this.editData.getRecordExtends().getOrgStudent().getId());
        } else {
            this.editData.getRecordExtends().getOrgStudent().setId(null);
        }
        if (!TrainCommonUtils.isEmpty(this.txtTrainContent.getText())) {
            TrainCourseRecordExtendsInfo eInfo = null;
            if (this.editData.getRecordExtends() == null) {
                eInfo = new TrainCourseRecordExtendsInfo();
                this.editData.setRecordExtends(eInfo);
            } else {
                eInfo = this.editData.getRecordExtends();
            }
            eInfo.setTrainContent(this.txtTrainContent.getText());
        }
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK pk = TrainCourseRecordFactory.getRemoteInstance().submitTrainActivityRecord(this.editData, this.isTrainActivityRecord);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.getUIContext().put("ID", pk.toString());
        return pk;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtEmployee);
        if (this.isTrainActivityRecord) {
            TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtTrainActivity);
        }
        TrainVerifyUtils.verifyDateBigOrSmallOrEqual((CoreUIObject)this, this.pkActivityBeginDate, this.pkActivityEndDate, null);
        if (this.prmtTrainActivity.getValue() != null) {
            TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkActivityBeginDate);
            TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkActivityEndDate);
        }
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.comboActivityIsPassed);
        TrainVerifyUtils.verifyNumberBig((CoreUIObject)this, this.txtActivityShouldAttendTimes, this.txtActivityRealAttendTimes);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainCourseRecordFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainCourseRecordInfo objectValue = new TrainCourseRecordInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setHrOrgUnit(TrainUtils.getCurrentHROrgUnit());
        if (objectValue.getRecordExtends() == null) {
            TrainCourseRecordExtendsInfo eInfo = new TrainCourseRecordExtendsInfo();
            eInfo.setActAssessValue(this.txtAssessValue.getText());
            PositionInfo position = new PositionInfo();
            position.setName(this.txtEmpPosition.getText());
            eInfo.setPosiStudent(position);
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setName(this.txtEmpUnit.getText());
            eInfo.setOrgStudent(adminOrgUnitInfo);
            eInfo.setActIsApproved(false);
            eInfo.setIsApproved(false);
            objectValue.put("recordExtends", eInfo);
        } else {
            TrainCourseRecordExtendsInfo eInfo = objectValue.getRecordExtends();
            eInfo.setActAssessValue(this.txtAssessValue.getText());
        }
        return objectValue;
    }

    protected void txtAssessScore_dataChanged(DataChangeEvent e) throws Exception {
        super.txtAssessScore_dataChanged(e);
        Number assessScore = this.txtAssessScore.getNumberValue();
        Number passStand = this.txtActivityPassStandard.getNumberValue();
        if (assessScore != null && passStand != null) {
            if (assessScore.doubleValue() >= passStand.doubleValue()) {
                this.comboActivityIsPassed.setSelectedItem((Object)TrainRecordIsPassedEnum.PASSED);
            } else {
                this.comboActivityIsPassed.setSelectedItem((Object)TrainRecordIsPassedEnum.NOT_PASSED);
            }
        }
    }

    protected void txtActivityShouldAttendTimes_dataChanged(DataChangeEvent e) throws Exception {
        this.setAbsent();
    }

    protected void txtActivityRealAttendTimes_dataChanged(DataChangeEvent e) throws Exception {
        this.setAbsent();
    }

    private void setAbsent() {
        if (this.ckActivityAttendAll.isSelected()) {
            this.txtActivityRealAttendTimes.setValue((Object)this.txtActivityShouldAttendTimes.getNumberValue());
        }
        if (this.txtActivityShouldAttendTimes.getNumberValue() != null) {
            int shouldAttend = this.txtActivityShouldAttendTimes.getNumberValue().intValue();
            int actualAttend = this.txtActivityRealAttendTimes.getNumberValue() == null ? 0 : this.txtActivityRealAttendTimes.getNumberValue().intValue();
            this.txtActivityAbsentTimes.setValue((Object)(shouldAttend - actualAttend));
        }
        if (("EDIT".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) && this.editData.getActAbsent() == null) {
            this.txtActivityAbsentTimes.setValue(null);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("TrainCourse.id"));
        sic.add(new SelectorItemInfo("TrainCourse.TrainActivity.belongOrgUnit.id"));
        sic.add(new SelectorItemInfo("TrainActivity.orgPerson.name"));
        sic.add(new SelectorItemInfo("TrainActivity.planActivity.trainItem.id"));
        sic.add(new SelectorItemInfo("TrainActivity.planActivity.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("recordExtends.id"));
        sic.add(new SelectorItemInfo("recordExtends.PosiStudent.id"));
        sic.add(new SelectorItemInfo("recordExtends.OrgStudent.id"));
        return sic;
    }

    protected void comboActivityAbsentType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.ckActivityAttendAll.isSelected()) {
            return;
        }
        if (AbsentTypeEnum.ABSENT.equals(this.comboActivityAbsentType.getSelectedItem())) {
            this.txtActivityRealAttendTimes.setValue((Object)new BigDecimal("0.00"));
            this.txtActivityRealAttendTimes.setEnabled(false);
        } else {
            this.txtActivityRealAttendTimes.setEnabled(true);
        }
    }

    public void setTrainActivityEnabled(boolean enabled) {
        this.prmtTrainActivity.setEnabled(enabled);
    }

    public void actionPersonCheckUp_actionPerformed(ActionEvent e) throws Exception {
        String state = null;
        UIContext uiContext = new UIContext((Object)this);
        TrainCourseRecordInfo info = TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordInfo((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
        if (info.getActPersonCheckUp() != null) {
            uiContext.put((Object)"ID", (Object)info.getActPersonCheckUp().getId().toString());
            state = this.getOprtState();
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            TrainClientUtil.showMessageAndAbort(this.resourcePath, "HAVENOTENTERINFO", (CoreUI)this);
        } else {
            state = OprtState.ADDNEW;
        }
        uiContext.put((Object)"recordId", (Object)this.editData.getId().toString());
        uiContext.put((Object)"PersonID", (Object)this.editData.getEmployee().getId().toString());
        uiContext.put((Object)"editUI", (Object)"TrainActivityRecordEditUI");
        uiContext.put((Object)"hideToolBar", (Object)"true");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PersonCheckUpEditUI.class.getName(), (Map)uiContext, null, state);
        uiWindow.show();
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        HashMap parameters = new HashMap();
        HashMap<String, Object> trainMethodMap = new HashMap<String, Object>();
        trainMethodMap.put("bosType", new TrainingMethodInfo().getBOSType());
        trainMethodMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("trainMethod", trainMethodMap);
        HashMap<String, Object> assessMethodMap = new HashMap<String, Object>();
        assessMethodMap.put("bosType", new AssessMethodInfo().getBOSType());
        assessMethodMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("assessMethod", assessMethodMap);
        request.put("comboParams", parameters);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public RequestContext prepareActionReward(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionReward(itemAction);
        if (request == null) {
            request = new RequestContext();
        }
        request.put("viewInfo", (Object)TrainAssistant.getEntityViewInfo("trainActRecord.id", this.editData.getId().toString()));
        return request;
    }

    public RequestContext prepareActionThought(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionThought(itemAction);
        if (request == null) {
            request = new RequestContext();
        }
        request.put("viewInfo", (Object)TrainAssistant.getEntityViewInfo("trainActRecord.id", this.editData.getId().toString()));
        return request;
    }

    public RequestContext prepareActionContract(IItemAction itemAction) throws Exception {
        return super.prepareActionContract(itemAction);
    }

    public RequestContext prepareActionPersonCheckUp(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionPersonCheckUp(itemAction);
        if (request == null) {
            request = new RequestContext();
        }
        request.put("trainRecordId", (Object)this.editData.getId().toString());
        return request;
    }

    public RequestContext prepareActionSubmit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionSubmit(itemAction);
        if (request == null) {
            request = new RequestContext();
        }
        request.put("isTrainActivityRecord", (Object)this.isTrainActivityRecord);
        return request;
    }

    public boolean isPrepareActionContract() {
        return true;
    }

    public boolean isPrepareActionPersonCheckUp() {
        return true;
    }

    public boolean isPrepareActionReward() {
        return true;
    }

    public boolean isPrepareActionSubmit() {
        return false;
    }

    public boolean isPrepareActionThought() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }
}

