/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCategoryInfo;
import com.kingdee.eas.hr.train.TrainTypeForFilterEnum;
import com.kingdee.eas.hr.train.TrainingCategoryInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainActivityReportFilterUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;

public class TrainActivityReportFilterUI
extends AbstractTrainActivityReportFilterUI {
    public TrainActivityReportFilterUI() throws Exception {
        Calendar now = Calendar.getInstance();
        this.pkEndDate.setValue((Object)new Date(now.getTimeInMillis()));
        now.set(5, 1);
        this.pkStartDate.setValue((Object)new Date(now.getTimeInMillis()));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.combTrainType.setSelectedIndex(2);
        HashSet hroSet = TrainActivityFacadeFactory.getRemoteInstance().getHRRange();
        AdminByOrgRangePromptBox adminByOrgRangePromptBox = new AdminByOrgRangePromptBox((IUIObject)this);
        adminByOrgRangePromptBox.setHROFilter(hroSet);
        adminByOrgRangePromptBox.setIsSingleSelect(false);
        this.prmtAdminOrg.setEditable(false);
        this.prmtAdminOrg.setQueryInfo(null);
        this.prmtAdminOrg.setEnabledMultiSelection(true);
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminByOrgRangePromptBox);
        TrainActivityHelper.initTrainActivity(this.prmtTrainActivity);
        this.prmtTrainCategory.setEntityViewInfo(TrainUtils.getCurrentCUEntityViewInfo());
        this.prmpTrainingCategory.setEntityViewInfo(TrainUtils.getCurrentHREntityViewInfo());
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        Object[] orgUnits = (Object[])this.prmtAdminOrg.getValue();
        if (orgUnits != null && orgUnits.length > 0) {
            HashSet<String> orgIds = new HashSet<String>();
            for (int i = 0; i < orgUnits.length; ++i) {
                orgIds.add(((OrgUnitInfo)orgUnits[i]).getId().toString());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("belongOrgUnit.id", orgIds, CompareType.INCLUDE));
        }
        Date startDate = (Date)this.pkStartDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        filterInfo.getFilterItems().add(new FilterItemInfo("actInfo.actEndDate", (Object)DateTimeUtils.truncateDate((Date)startDate), CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("actInfo.actEndDate", (Object)TrainUtils.getDateMaxTime(endDate), CompareType.LESS_EQUALS));
        TrainActivityInfo trainActivity = (TrainActivityInfo)this.prmtTrainActivity.getValue();
        if (trainActivity != null && trainActivity.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)trainActivity.getId().toString()));
        }
        if (this.combTrainType.getSelectedIndex() != -1) {
            String type = this.combTrainType.getSelectedItem().toString();
            if (type.equals(TrainTypeForFilterEnum.INNERTRAINTYPE.toString())) {
                String inner = "10";
                filterInfo.getFilterItems().add(new FilterItemInfo("trainType", (Object)inner, CompareType.EQUALS));
            } else if (type.equals(TrainTypeForFilterEnum.OUTTRAINTYPE.toString())) {
                String outer = "20";
                filterInfo.getFilterItems().add(new FilterItemInfo("trainType", (Object)outer, CompareType.EQUALS));
            }
        }
        if (this.prmtTrainCategory.getData() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trainCatagory.id", (Object)((TrainCategoryInfo)this.prmtTrainCategory.getData()).getId().toString()));
        }
        if (this.prmpTrainingCategory.getData() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainingCategor.id", (Object)((TrainingCategoryInfo)this.prmpTrainingCategory.getData()).getId().toString()));
        }
        return filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtAdminOrg);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkStartDate);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkEndDate);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtTrainActivity);
        CustomerQueryUtil.storeToCustomerParams(cp, this.combTrainType);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtTrainCategory);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmpTrainingCategory);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtAdminOrg, AdminOrgUnitInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkStartDate);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkEndDate);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtTrainActivity, TrainActivityInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmpTrainingCategory, TrainingCategoryInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtTrainCategory, TrainCategoryInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.combTrainType);
    }

    public boolean verify() {
        if (this.verifyEmpty(this.pkStartDate) || this.verifyEmpty(this.pkEndDate)) {
            return false;
        }
        TrainVerifyUtils.verifyDateBigOrSmallOrEqual((CoreUIObject)this, this.pkStartDate, this.pkEndDate, null);
        return true;
    }

    private boolean verifyEmpty(KDDatePicker datePicker) {
        String content = datePicker.getText();
        if (StringUtils.isEmpty((String)content)) {
            MsgBox.showInfo((Component)((Object)this), (String)TrainVerifyUtils.getMessage((Component)datePicker));
            datePicker.requestFocus(true);
            return true;
        }
        return false;
    }

    public void clear() {
        this.prmtAdminOrg.setValue(null);
        this.prmtTrainActivity.setValue(null);
        this.pkStartDate.setValue(null);
        this.pkEndDate.setValue(null);
        this.prmtTrainCategory.setData(null);
        this.prmpTrainingCategory.setData(null);
        this.combTrainType.setSelectedIndex(-1);
    }
}

