/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainConstants;
import com.kingdee.eas.hr.train.client.AbstractTrainActivityReportListUI;
import com.kingdee.eas.hr.train.client.TrainActivityReportFilterUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TrainActivityReportListUI
extends AbstractTrainActivityReportListUI {
    private Set trainActivityIds = new HashSet();
    private boolean isFirstDefaultQuery = true;
    private CommonQueryDialog queryDlg = null;
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainReportResource";

    public TrainActivityReportListUI() throws Exception {
        this.txtTitle.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        super.onLoad();
        this.isFirstDefaultQuery = false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(TrainUtils.getUserAdminRangeFilter("belongOrgUnit.id"));
            filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)50));
            return filterInfo;
        }
        catch (Exception e) {
            this.handleException(e);
            return super.getDefaultFilterForQuery();
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            this.trainActivityIds.clear();
            rowSet.beforeFirst();
            while (rowSet.next()) {
                this.trainActivityIds.add(rowSet.getString("id"));
            }
            Map studentCounts = null;
            if (this.trainActivityIds.size() > 0) {
                studentCounts = TrainActivityFacadeFactory.getRemoteInstance().getActStudentCount(this.trainActivityIds);
            }
            Map mainUnits = TrainUtils.getMainUnitMap();
            CourseHourUnitEnum mainUnitType = null;
            if (mainUnits != null) {
                mainUnitType = TrainUtils.getMainUnitType(mainUnits);
            }
            DecimalFormat df = TrainConstants.NUMBER_FORMAT;
            String split = EASResource.getString((String)RESOURCE, (String)"to");
            BigDecimal rate = null;
            String dateString = null;
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (studentCounts != null) {
                    String activityId = rowSet.getString("id");
                    rowSet.updateString("studentCount", (String)studentCounts.get(activityId));
                }
                dateString = TrainClientUtil.assembleDate(rowSet.getDate("actInfo.actBeginDate"), rowSet.getDate("actInfo.actEndDate"), "yyyy-MM-dd", split);
                rowSet.updateString("trainDate", dateString);
                BigDecimal hour = rowSet.getBigDecimal("actInfo.actHour");
                int hourUnit = rowSet.getInt("actInfo.actHourUnit");
                if (hour != null && hourUnit > 0) {
                    if (mainUnitType != null) {
                        rate = (BigDecimal)mainUnits.get((Object)CourseHourUnitEnum.getEnum(hourUnit));
                        if (rate != null) {
                            rowSet.updateString("actHour", df.format(hour.multiply(rate)) + mainUnitType.toString());
                            continue;
                        }
                        rowSet.updateString("actHour", df.format(hour) + CourseHourUnitEnum.getEnum(hourUnit).toString());
                        continue;
                    }
                    rowSet.updateString("actHour", df.format(hour) + CourseHourUnitEnum.getEnum(hourUnit).toString());
                    continue;
                }
                rowSet.updateString("actHour", null);
            }
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int colIndex;
        if (e.getClickCount() == 2) {
            return;
        }
        if (e.getType() == 0 && ((colIndex = e.getColIndex()) == this.tblMain.getColumnIndex("actHour") || colIndex == this.tblMain.getColumnIndex("trainDate") || colIndex == this.tblMain.getColumnIndex("studentCount"))) {
            return;
        }
        super.tblMain_tableClicked(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.queryDlg != null && this.getUIContext() != null && "report".equals(this.getUIContext().get("UIClassParam"))) {
            this.queryDlg.changeOwner((Component)((Object)this));
        }
        this.showFilterDialog(e);
        this.isFirstDefaultQuery = false;
        this.setTxtTitle();
    }

    private void setTxtTitle() {
        StringBuffer title = new StringBuffer();
        String startDate = null;
        String endDate = null;
        FilterItemCollection filters = this.mainQuery.getFilter().getFilterItems();
        for (int i = 0; i < filters.size(); ++i) {
            FilterItemInfo filterItemInfo = filters.get(i);
            if (!"actInfo.actEndDate".equals(filterItemInfo.getPropertyName())) continue;
            if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                startDate = DateTimeUtils.formatDate((Date)((Date)filterItemInfo.getCompareValue()));
            }
            if (!CompareType.LESS_EQUALS.equals((Object)filterItemInfo.getCompareType())) continue;
            endDate = DateTimeUtils.formatDate((Date)((Date)filterItemInfo.getCompareValue()));
        }
        title.append(startDate);
        title.append(" ");
        title.append(EASResource.getString((String)RESOURCE, (String)"to"));
        title.append(" ");
        title.append(endDate);
        title.append(" ");
        title.append(this.getUITitle());
        this.txtTitle.setText(title.toString());
    }

    private void showFilterDialog(ActionEvent e) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = TrainActivityReportListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            EntityViewInfo defaultView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            if (defaultView == null || !FilterUtility.hasFilterItem((FilterInfo)defaultView.getFilter())) {
                this.shwQueryDialog();
            } else {
                if (this.getPreference() == null) {
                    this.doDefaultSolution(iQuery, queryName);
                    this.applyPreference();
                }
                this.mainQuery = this.getEntityViewInfo(defaultView);
                this.execQuery();
            }
        } else {
            this.shwQueryDialog();
        }
    }

    private void shwQueryDialog() throws BOSException, Exception {
        if (this.queryDlg == null) {
            this.queryDlg = this.initCommonQueryDialog();
        }
        if (this.queryDlg.show()) {
            this.doQuery(this.queryDlg);
            this.mainQuery.getSorter().clear();
            this.mainQuery = this.getEntityViewInfo(this.queryDlg.getEntityViewInfoResult());
            if (this.mainQuery.getSorter() != null && this.mainQuery.getSorter().size() > 0) {
                this.setIsIgnoreOrder(true);
            } else {
                this.setIsIgnoreOrder(false);
            }
            this.prepareQuery(null).callHandler();
            this.refreshList();
        } else {
            SysUtil.abort();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dlg = super.initCommonQueryDialog();
        TrainActivityReportFilterUI filterUI = null;
        try {
            filterUI = new TrainActivityReportFilterUI();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        dlg.addUserPanel((KDPanel)filterUI);
        return dlg;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    public IUIActionPostman prepareInit() {
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), this, this.mainQueryPK);
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

