/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.TrainApplyInfo;
import com.kingdee.eas.hr.train.TrainApplyTypeEnum;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainPlanInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainApplyFilterUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Logger;

public class TrainApplyFilterUI
extends AbstractTrainApplyFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainApplyFilterUI.class);
    private final PersonInfo loginPerson;
    private PersonInfo currentPerson;

    public TrainApplyFilterUI() throws Exception {
        this.currentPerson = this.loginPerson = SysContext.getSysContext().getCurrentUserInfo().getPerson();
    }

    private void executeQueryApply() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("applyerID", (Object)this.currentPerson.getId().toString()));
        evi.setFilter(fi);
        this.setDataObject((IObjectValue)evi);
        this.prtTrainApplyName.setEntityViewInfo(evi);
        this.prtTrainApplyNumber.setEntityViewInfo(evi);
    }

    public void onLoad() throws Exception {
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmt.setIsSingleSelect(true);
        pmt.setModal(true);
        this.prtTrainApplyAuditor.setSelector((KDPromptSelector)pmt);
        this.prtTrainApplyAuditor.setEnabledMultiSelection(false);
        this.combTrainApplyState.setSelectedIndex(-1);
        this.combTrainApplyType.setSelectedIndex(-1);
        this.pkApplyDate.setValue(null);
        this.executeQueryApply();
        super.onLoad();
        this.prtTrainApplyName.setEditable(false);
        this.prtTrainApplyNumber.setEditable(false);
        this.prtTrainApplyAuditor.setEditable(false);
        EntityViewInfo viewPlanInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)50));
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)40));
        filterInfo.setMaskString("#0 or #1");
        filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"hrOrgUnit.id", (String)"OrgUnit.id"), "AND");
        viewPlanInfo.setFilter(filterInfo);
        this.prmpTrainPlan.setEntityViewInfo(viewPlanInfo);
    }

    public FilterInfo getFilterInfo() {
        Object type;
        FilterInfo fi = new FilterInfo();
        if (this.prtTrainApplyName.getData() != null) {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)((TrainApplyInfo)this.prtTrainApplyName.getData()).getId().toString()));
        }
        if (this.prtTrainApplyNumber.getData() != null) {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)((TrainApplyInfo)this.prtTrainApplyNumber.getData()).getId().toString()));
        }
        if (this.combTrainApplyType.getSelectedIndex() != -1) {
            type = this.combTrainApplyType.getSelectedItem();
            if (type.equals((Object)TrainApplyTypeEnum.INNERTRAINAPPLY)) {
                String inApplyType = "3E2F3C4A";
                fi.getFilterItems().add(new FilterItemInfo("applyType", (Object)inApplyType, CompareType.EQUALS));
            } else if (type.equals((Object)TrainApplyTypeEnum.OUTERTRAINAPPLY)) {
                String outApplyType = "1D76642F";
                fi.getFilterItems().add(new FilterItemInfo("applyType", (Object)outApplyType, CompareType.EQUALS));
            }
        }
        if (this.pkApplyDate.getValue() != null && !"".equals(this.pkApplyDate.getValue())) {
            String applyDate = this.pkApplyDate.getTimestamp().toString();
            DateFormat sdfInput = DateFormat.getDateInstance();
            Date d = null;
            try {
                d = sdfInput.parse(applyDate);
            }
            catch (ParseException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            fi.getFilterItems().add(new FilterItemInfo("ApplyDate", (Object)d));
        }
        if (this.prmpTrainPlan.getData() != null) {
            fi.getFilterItems().add(new FilterItemInfo("planName", (Object)((TrainPlanInfo)this.prmpTrainPlan.getData()).getName()));
        }
        if (this.combTrainApplyState.getSelectedIndex() != -1) {
            type = this.combTrainApplyState.getSelectedItem().toString();
            if (((String)type).equals(TrainAuditStateEnum.UNSUBMIT.toString())) {
                String unSubmint = String.valueOf(10);
                fi.getFilterItems().add(new FilterItemInfo("AuditState", (Object)unSubmint, CompareType.EQUALS));
            } else if (((String)type).equals(TrainAuditStateEnum.AUDITING.toString())) {
                String auditing = String.valueOf(20);
                fi.getFilterItems().add(new FilterItemInfo("AuditState", (Object)auditing, CompareType.EQUALS));
            } else if (((String)type).equals(TrainAuditStateEnum.UNPASS.toString())) {
                String unPass = String.valueOf(30);
                fi.getFilterItems().add(new FilterItemInfo("AuditState", (Object)unPass, CompareType.EQUALS));
            } else if (((String)type).equals(TrainAuditStateEnum.PASS.toString())) {
                String pass = String.valueOf(40);
                fi.getFilterItems().add(new FilterItemInfo("AuditState", (Object)pass, CompareType.EQUALS));
            } else if (((String)type).equals(TrainAuditStateEnum.AUDITED.toString())) {
                String audited = String.valueOf(50);
                fi.getFilterItems().add(new FilterItemInfo("AuditState", (Object)audited, CompareType.EQUALS));
            } else if (((String)type).equals(TrainAuditStateEnum.UNAUDITED.toString())) {
                String unAdudited = String.valueOf(60);
                fi.getFilterItems().add(new FilterItemInfo("AuditState", (Object)unAdudited, CompareType.EQUALS));
            }
        }
        if (this.prtTrainApplyAuditor.getData() != null) {
            fi.getFilterItems().add(new FilterItemInfo("personName", (Object)((PersonInfo)this.prtTrainApplyAuditor.getData()).getName()));
        }
        return fi;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prtTrainApplyName.getData() != null) {
            CustomerQueryUtil.storeToCustomerParams(cp, this.prtTrainApplyName);
        }
        if (this.prtTrainApplyNumber.getData() != null) {
            CustomerQueryUtil.storeToCustomerParams(cp, this.prtTrainApplyNumber);
        }
        if (this.combTrainApplyType.getSelectedItem() != null) {
            CustomerQueryUtil.storeToCustomerParams(cp, this.combTrainApplyType);
        }
        if (this.pkApplyDate.getValue() != null) {
            CustomerQueryUtil.storeToCustomerParams(cp, this.pkApplyDate);
        }
        if (this.combTrainApplyState.getSelectedItem() != null) {
            CustomerQueryUtil.storeToCustomerParams(cp, this.combTrainApplyState);
        }
        if (this.prtTrainApplyAuditor.getData() != null && ((PersonInfo)this.prtTrainApplyAuditor.getData()).getName() != null) {
            cp.addCustomerParam("prtTrainApplyAuditor", ((PersonInfo)this.prtTrainApplyAuditor.getData()).getName().toString());
        }
        if (this.prmpTrainPlan.getData() != null) {
            CustomerQueryUtil.storeToCustomerParams(cp, this.prmpTrainPlan);
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prtTrainApplyName, TrainApplyInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prtTrainApplyNumber, TrainApplyInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.combTrainApplyType);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkApplyDate);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.combTrainApplyState);
        if (cp != null) {
            String name = cp.getCustomerParam("prtTrainApplyAuditor");
            PersonInfo info = new PersonInfo();
            info.setName(name);
            this.prtTrainApplyAuditor.setData((Object)info);
        } else {
            this.prtTrainApplyAuditor.setValue(null);
        }
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmpTrainPlan, TrainPlanInfo.class.getName());
    }

    public void clear() {
        super.clear();
        this.prtTrainApplyName.setData(null);
        this.prtTrainApplyNumber.setData(null);
        this.combTrainApplyState.setSelectedItem(null);
        this.combTrainApplyType.setSelectedItem(null);
        this.pkApplyDate.setValue(null);
        this.prtTrainApplyAuditor.setData(null);
        this.prmpTrainPlan.setData(null);
    }

    protected void combTrainApplyType_actionPerformed(ActionEvent e) throws Exception {
        super.combTrainApplyType_actionPerformed(e);
    }

    protected void combTrainApplyState_actionPerformed(ActionEvent e) throws Exception {
        super.combTrainApplyState_actionPerformed(e);
    }
}

