/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.train.TrainPlanFacadeFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainBudgetUseUI;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainBudgetUseUI
extends AbstractTrainBudgetUseUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainBudgetUseUI.class);

    public void onLoad() throws Exception {
        this.tblBudgetUse.checkParsed();
        super.onLoad();
        int years = (Integer)this.getUIContext().get("years");
        String orgUnitID = (String)this.getUIContext().get("orgUnitID");
        String orgUnitDisplayName = (String)this.getUIContext().get("orgUnitDisplayName");
        Set BudgetSet = TrainPlanFacadeFactory.getRemoteInstance().getBudget(years, orgUnitID);
        this.putDataToTable(years, orgUnitDisplayName, BudgetSet);
    }

    private void putDataToTable(int year, String orgUnitDisplayName, Set BudgetSet) throws SQLException {
        IRow row = null;
        row = this.tblBudgetUse.addRow();
        BigDecimal[] budgetArray2 = null;
        row.getCell("years").setValue(this.getUIContext().get("years"));
        row.getCell("orgUnit").setValue((Object)orgUnitDisplayName);
        for (BigDecimal[] budgetArray2 : BudgetSet) {
            row.getCell("balance").setValue((Object)budgetArray2[0]);
            row.getCell("budgetYear").setValue((Object)budgetArray2[1]);
            row.getCell("budgetHasUse").setValue((Object)budgetArray2[1].subtract(budgetArray2[0]));
        }
    }
}

