/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.basedata.assistant.CityCollection;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.ChannelCoursE1Collection;
import com.kingdee.eas.hr.train.ChannelCoursE1Factory;
import com.kingdee.eas.hr.train.CodingRuleHelper;
import com.kingdee.eas.hr.train.TrainChanneCategoryInfo;
import com.kingdee.eas.hr.train.TrainChanneFactory;
import com.kingdee.eas.hr.train.TrainChanneInfo;
import com.kingdee.eas.hr.train.TrainEvaluLevelInfo;
import com.kingdee.eas.hr.train.TrainFacadeFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainChanneEditUI;
import com.kingdee.eas.hr.train.client.ChannelCoursEditUI;
import com.kingdee.eas.hr.train.client.ComBoxInfo;
import com.kingdee.eas.hr.train.client.TrainChanneEquipmentListUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainRecordHistorListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainChanneEditUI
extends AbstractTrainChanneEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainChanneEditUI.class);
    static String RES = "com.kingdee.eas.hr.train.client.TrainChanneResource";
    int oldIndex = -1;
    boolean isEnabled = false;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAttach.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.btnChanneCourse.setIcon(EASResource.getIcon((String)"imgTbtn_maincourse"));
        this.btnSchoolHistory.setIcon(EASResource.getIcon((String)"imgTbtn_schoolhistory"));
        this.btnTrainEquipment.setIcon(EASResource.getIcon((String)"imgTbtn_establishment"));
        this.menuCourse.setIcon(EASResource.getIcon((String)"imgTbtn_maincourse"));
        this.menuHistory.setIcon(EASResource.getIcon((String)"imgTbtn_schoolhistory"));
        this.menuEquipment.setIcon(EASResource.getIcon((String)"imgTbtn_establishment"));
        this.menuItemAttach.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.setButtonDefaultStyl(this.btnAttach);
    }

    public void loadFields() {
        CodingRuleHelper.setAutoNumber(this, (CoreBaseInfo)this.editData, this.txtNumber, this.getOprtState());
        super.loadFields();
        this.loadProvince();
        this.loadCity();
        this.loadTrainEvaluLevel();
        this.isEnabled = this.editData.isIsEnabled();
        this.initWorkButtonState();
        if (this.editData.getNumber() != null && this.editData.getNumber().trim().length() > 0) {
            this.txtNumber.setEnabled(false);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            if (this.editData != null && this.editData.isIsEnabled()) {
                this.actionRemove.setEnabled(false);
                this.actionEdit.setEnabled(false);
            } else {
                this.actionRemove.setEnabled(true);
                this.actionEdit.setEnabled(true);
            }
        }
    }

    private void initWorkButtonState() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.actionAttach.setEnabled(false);
            this.actionChanneCourse.setEnabled(false);
            this.actionSchoolHistory.setEnabled(false);
            this.actionTrainEquipment.setEnabled(false);
        } else {
            this.actionAttach.setEnabled(true);
            this.actionChanneCourse.setEnabled(true);
            this.actionSchoolHistory.setEnabled(true);
            this.actionTrainEquipment.setEnabled(true);
        }
    }

    private void loadTrainEvaluLevel() {
        if (!TrainClientUtil.objectIsNull(this.editData.getTrainEvaluLevel())) {
            String id = this.editData.getTrainEvaluLevel().getId().toString();
            for (int j = this.comboTrainEvaluLevel.getItemCount() - 1; j > -1; --j) {
                TrainEvaluLevelInfo trainEvaluLevelinfo = (TrainEvaluLevelInfo)((ComBoxInfo)this.comboTrainEvaluLevel.getItemAt(j)).getobjInfo();
                if (!id.equals(trainEvaluLevelinfo.getId().toString())) continue;
                this.comboTrainEvaluLevel.setSelectedIndex(j);
            }
        } else {
            this.comboTrainEvaluLevel.setSelectedItem(null);
        }
    }

    private void loadCity() {
        if (!TrainClientUtil.objectIsNull(this.editData.getCity())) {
            String id = this.editData.getCity().getId().toString();
            for (int j = this.comboCity.getItemCount() - 1; j > -1; --j) {
                CityInfo info = (CityInfo)((ComBoxInfo)this.comboCity.getItemAt(j)).getobjInfo();
                if (!id.equals(info.getId().toString())) continue;
                this.comboCity.setSelectedIndex(j);
            }
        } else {
            this.comboCity.setSelectedItem(null);
        }
    }

    private void loadProvince() {
        if (!TrainClientUtil.objectIsNull(this.editData.getProvince())) {
            String id = this.editData.getProvince().getId().toString();
            for (int j = this.comboProvince.getItemCount() - 1; j > -1; --j) {
                ProvinceInfo info = (ProvinceInfo)((ComBoxInfo)this.comboProvince.getItemAt(j)).getobjInfo();
                if (!id.equals(info.getId().toString())) continue;
                this.comboProvince.setSelectedIndex(j);
            }
        } else {
            this.comboProvince.setSelectedItem(null);
        }
    }

    public void storeFields() {
        super.storeFields();
        this.storeProvince();
        this.storeCity();
        this.storeTrainEvaluLevel();
        this.editData.setIsEnabled(this.isEnabled);
    }

    private void storeTrainEvaluLevel() {
        if (!TrainClientUtil.objectIsNull(this.comboTrainEvaluLevel.getSelectedItem())) {
            this.editData.setTrainEvaluLevel((TrainEvaluLevelInfo)((ComBoxInfo)this.comboTrainEvaluLevel.getSelectedItem()).getobjInfo());
        }
    }

    private void storeCity() {
        if (!TrainClientUtil.objectIsNull(this.comboCity.getSelectedItem())) {
            this.editData.setCity((CityInfo)((ComBoxInfo)this.comboCity.getSelectedItem()).getobjInfo());
        }
    }

    private void storeProvince() {
        if (!TrainClientUtil.objectIsNull(this.comboProvince.getSelectedItem())) {
            this.editData.setProvince((ProvinceInfo)((ComBoxInfo)this.comboProvince.getSelectedItem()).getobjInfo());
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("Province.id"));
        sic.add(new SelectorItemInfo("Province.name"));
        sic.add(new SelectorItemInfo("Province.number"));
        sic.add(new SelectorItemInfo("City.id"));
        sic.add(new SelectorItemInfo("City.name"));
        sic.add(new SelectorItemInfo("City.number"));
        sic.add(new SelectorItemInfo("TrainEvaluLevel.id"));
        sic.add(new SelectorItemInfo("TrainEvaluLevel.name"));
        sic.add(new SelectorItemInfo("TrainEvaluLevel.number"));
        sic.add(new SelectorItemInfo("HrOrgUnit.id"));
        sic.add(new SelectorItemInfo("IsEnabled"));
        return sic;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected String getEditUIName() {
        return TrainChanneEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainChanneFactory.getRemoteInstance();
    }

    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState()) && this.getUIContext().get("ParentNode") != null && this.getUIContext().get("ParentNode") instanceof TrainChanneCategoryInfo) {
            this.editData.put("treeId", (TrainChanneCategoryInfo)this.getUIContext().get("ParentNode"));
        }
    }

    protected IObjectValue createNewData() {
        TrainChanneInfo objectValue = new TrainChanneInfo();
        objectValue.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return objectValue;
    }

    public void onLoad() throws Exception {
        TrainClientUtil.checkValidHRO((CoreUI)this);
        this.setComboBox();
        FilterInfo fi = TrainUtils.getCurrentHRFilter("hrOrgUnit.id");
        fi.getFilterItems().add(new FilterItemInfo("property", (Object)10));
        fi.setMaskString("#0 or #1");
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(fi);
        this.prmChanneCategory.setEntityViewInfo(ev);
        super.onLoad();
    }

    private void setComboBox() throws BOSException, EASBizException {
        int i;
        HashMap parameters = new HashMap();
        HashMap<String, BOSObjectType> provinceMap = new HashMap<String, BOSObjectType>();
        provinceMap.put("bosType", new ProvinceInfo().getBOSType());
        parameters.put("province", provinceMap);
        HashMap<String, Object> evaluLevelMap = new HashMap<String, Object>();
        evaluLevelMap.put("bosType", new TrainEvaluLevelInfo().getBOSType());
        evaluLevelMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("evaluLevel", evaluLevelMap);
        Map result = TrainFacadeFactory.getRemoteInstance().batchGetCollection(parameters);
        IObjectCollection collection = (IObjectCollection)result.get("province");
        Object[] comboxInfos = new ComBoxInfo[collection.size()];
        int n = collection.size();
        for (i = 0; i < n; ++i) {
            comboxInfos[i] = new ComBoxInfo(collection.getObject(i));
        }
        this.comboProvince.setActionCommand("INIT");
        this.comboProvince.removeAllItems();
        this.comboProvince.addItems(comboxInfos);
        this.comboProvince.setActionCommand(null);
        collection = (IObjectCollection)result.get("evaluLevel");
        comboxInfos = new ComBoxInfo[collection.size()];
        n = collection.size();
        for (i = 0; i < n; ++i) {
            comboxInfos[i] = new ComBoxInfo(collection.getObject(i));
        }
        this.comboTrainEvaluLevel.setActionCommand("INIT");
        this.comboTrainEvaluLevel.removeAllItems();
        this.comboTrainEvaluLevel.addItems(comboxInfos);
        this.comboTrainEvaluLevel.setActionCommand(null);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        if (TrainClientUtil.objectIsNull(this.prmChanneCategory.getText())) {
            this.prmChanneCategory.requestFocus(true);
            TrainClientUtil.showErrorMessage(RES, "supplierTypeNotNull", (CoreUI)this);
        }
        if (!TrainClientUtil.objectIsNull(this.txtPostCode.getText())) {
            String postCode = this.txtPostCode.getText();
            if (postCode.trim().length() != 6) {
                this.txtPostCode.requestFocus();
                TrainClientUtil.showErrorMessage(RES, "postCodeMustNumber", (CoreUI)this);
            }
            int n = postCode.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isDigit(postCode.charAt(i))) continue;
                this.txtPostCode.requestFocus();
                TrainClientUtil.showErrorMessage(RES, "postCodeMustNumber", (CoreUI)this);
            }
        }
    }

    private void initComboCity() throws Exception {
        if (!TrainClientUtil.objectIsNull(this.comboProvince.getSelectedItem())) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("province.id", (Object)((ProvinceInfo)((ComBoxInfo)this.comboProvince.getSelectedItem()).getobjInfo()).getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            CityCollection collection = CityFactory.getRemoteInstance().getCityCollection(viewInfo);
            Object[] comboxInfos = new ComBoxInfo[collection.size()];
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                comboxInfos[i] = new ComBoxInfo((IObjectValue)collection.get(i));
            }
            this.comboCity.removeAllItems();
            this.comboCity.addItems(comboxInfos);
        } else {
            this.comboCity.removeAllItems();
        }
    }

    public void actionAttach_actionPerformed(ActionEvent e) throws Exception {
        if (TrainClientUtil.objectIsNull(this.editData.getId())) {
            TrainClientUtil.showErrorMessage(RES, "mustSaveCanAttachment", (CoreUI)this);
        }
        AttachmentClientManager am = AttachmentManagerFactory.getClientManager();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            am.showAttachmentListUIByBoID(this.editData.getId().toString(), (Object)this, false);
        } else {
            am.showAttachmentListUIByBoID(this.editData.getId().toString(), (Object)this, true);
        }
    }

    public void actionChanneCourse_actionPerformed(ActionEvent e) throws Exception {
        super.actionChanneCourse_actionPerformed(e);
        if (TrainClientUtil.objectIsNull(this.editData.getId())) {
            TrainClientUtil.showErrorMessage(RES, "mustSaveCanChanneCourse", (CoreUI)this);
        }
        UIContext uiContext = new UIContext((Object)this);
        String oprt = OprtState.VIEW;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainChannel.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("trainChannel.id"));
        ChannelCoursE1Collection e1Collection = ChannelCoursE1Factory.getRemoteInstance().getChannelCoursE1Collection(viewInfo);
        if (e1Collection != null && e1Collection.size() > 0) {
            uiContext.put((Object)"ID", (Object)e1Collection.get(0).getId().toString());
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            oprt = e1Collection != null && e1Collection.size() > 0 ? OprtState.EDIT : OprtState.ADDNEW;
        } else if (OprtState.VIEW.equals(this.getOprtState()) && (e1Collection == null || e1Collection.size() == 0)) {
            TrainClientUtil.showErrorMessage(RES, "noResponseChanneCourse", (CoreUI)this);
        }
        uiContext.put((Object)"trainChannel", (Object)this.editData);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ChannelCoursEditUI.class.getName(), (Map)uiContext, null, oprt);
        uiWindow.show();
    }

    public void actionSchoolHistory_actionPerformed(ActionEvent e) throws Exception {
        super.actionSchoolHistory_actionPerformed(e);
        if (TrainClientUtil.objectIsNull(this.editData.getId())) {
            TrainClientUtil.showErrorMessage(RES, "mustSaveCanSchoolHistory", (CoreUI)this);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"trainChannel", (Object)this.editData.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainRecordHistorListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionTrainEquipment_actionPerformed(ActionEvent e) throws Exception {
        super.actionTrainEquipment_actionPerformed(e);
        if (TrainClientUtil.objectIsNull(this.editData.getId())) {
            TrainClientUtil.showErrorMessage(RES, "mustSaveCanChanneEquipment", (CoreUI)this);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"trainChannel", (Object)this.editData);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainChanneEquipmentListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void comboProvince_actionPerformed(ActionEvent e) throws Exception {
        super.comboProvince_actionPerformed(e);
        if ("INIT".equals(this.comboProvince.getActionCommand())) {
            return;
        }
        if (this.comboProvince.getSelectedIndex() != this.oldIndex) {
            this.oldIndex = this.comboProvince.getSelectedIndex();
            this.comboProvince.setSelectedItem(this.comboProvince.getItemAt(this.oldIndex));
            this.initComboCity();
        }
    }

    private boolean checkCanModifyDelete() {
        return !this.editData.isIsEnabled();
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        HashMap parameters = new HashMap();
        HashMap<String, BOSObjectType> provinceMap = new HashMap<String, BOSObjectType>();
        provinceMap.put("bosType", new ProvinceInfo().getBOSType());
        parameters.put("province", provinceMap);
        HashMap<String, Object> evaluLevelMap = new HashMap<String, Object>();
        evaluLevelMap.put("bosType", new TrainEvaluLevelInfo().getBOSType());
        evaluLevelMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("evaluLevel", evaluLevelMap);
        request.put("comboParams", parameters);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public RequestContext prepareActionChanneCourse(IItemAction itemAction) throws Exception {
        return super.prepareActionChanneCourse(null);
    }

    public boolean isPrepareActionChanneCourse() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }
}

