/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.PersonPhotoCollection;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.client.HidedMenuItem;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainAssistantUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TrainClientUtil {
    private static Logger logger = Logger.getLogger(TrainClientUtil.class);
    static Color disableColor = Color.decode("#F5F5E6");
    static Color requiredColor = Color.decode("#FCFBDF");
    static Color normalColor = Color.decode("#FFFFFF");
    static String AND = "AND";
    static String OR = "OR";
    static int PRECISION = 2;
    static Float maxPrecision = new Float("99999999.99");
    static Float minPrecision = new Float("0.00");
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainResource";

    public static boolean objectIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)obj.toString());
        }
        return false;
    }

    public static String getResource(String RES, String message) {
        return EASResource.getString((String)RES, (String)message);
    }

    public static String getResource(String RES, String message, Object[] params) {
        String str = TrainClientUtil.getResource(RES, message);
        return MessageFormat.format(str, params);
    }

    public static void showErrorMessage(String RES, String message, CoreUI uiObject) {
        MsgBox.showInfo((Component)uiObject, (String)TrainClientUtil.getResource(RES, message));
        uiObject.setCursorOfDefault();
        SysUtil.abort();
    }

    public static void showErrorMessage(String resource, String message, Object[] arguments, CoreUI ui) {
        String str = EASResource.getString((String)resource, (String)message);
        MessageFormat format = new MessageFormat(str);
        MsgBox.showError((Component)ui, (String)format.format(arguments));
        ui.setCursorOfDefault();
        SysUtil.abort();
    }

    public static void showMessage(String RES, String message, CoreUI uiObject) {
        MsgBox.showInfo((Component)uiObject, (String)TrainClientUtil.getResource(RES, message));
    }

    public static void showMessageAndAbort(String RES, String message, CoreUI uiObject) {
        MsgBox.showInfo((Component)uiObject, (String)TrainClientUtil.getResource(RES, message));
        SysUtil.abort();
    }

    public static void showMessageAndAbort(String RES, String message, Object[] params, CoreUI uiObject) {
        MsgBox.showInfo((Component)uiObject, (String)TrainClientUtil.getResource(RES, message, params));
        SysUtil.abort();
    }

    public static boolean showConfirmMessge(String RES, String message, CoreUI uiObject) {
        int result = MsgBox.showConfirm2((Component)uiObject, (String)TrainClientUtil.getResource(RES, message));
        if (result == 0) {
            return true;
        }
        if (result == 2) {
            return false;
        }
        return false;
    }

    public static boolean showConfirmMessge(CoreUI uiObject, String RES, String message, Object[] params) {
        int result = MsgBox.showConfirm2((Component)uiObject, (String)TrainClientUtil.getResource(RES, message, params));
        if (result == 0) {
            return true;
        }
        if (result == 2) {
            return false;
        }
        return false;
    }

    public static String formatBigDecimal(BigDecimal value, int precicion) {
        if (TrainClientUtil.objectIsNull(value)) {
            return "";
        }
        String str = ZERO.compareTo(value) == 0 ? "0.00000000000000000000000" : value.toString();
        if (str.lastIndexOf(".") == -1) {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(str);
            strBuffer.append(".");
            for (int i = 0; i < precicion; ++i) {
                strBuffer.append("0");
            }
            return strBuffer.toString();
        }
        if (str.lastIndexOf(".") == str.length() - 2) {
            return str + "0";
        }
        int len = str.lastIndexOf(".") + 1 + precicion;
        return str.substring(0, len);
    }

    public static IRow getSelectedRow(KDTable tblMain) {
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = tblMain.getRow(rowIndex);
            return row;
        }
        return null;
    }

    public static FilterInfo getCurrentHROFilter() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    public static void checkValidHRO(CoreUI uiObject) {
        if (TrainClientUtil.objectIsNull(SysContext.getSysContext().getCurrentHRUnit())) {
            TrainClientUtil.showErrorMessage("com.kingdee.eas.hr.train.TrainResource", "currentUserNoHRO", uiObject);
        }
    }

    public static void checkValidPerson(CoreUI uiObject) {
        if (TrainClientUtil.objectIsNull(SysContext.getSysContext().getCurrentUserInfo().getPerson())) {
            TrainClientUtil.showErrorMessage("com.kingdee.eas.hr.train.client.TrainApplyResource", "userNoPerson", uiObject);
        }
    }

    public static void setBimBuildEntryWorkButtonState(KDTable table, boolean state) {
        HashSet<String> set = new HashSet<String>();
        set.add("btnAddnewLine");
        set.add("btnInsertLine");
        set.add("btnRemoveLines");
        Component[] components = ((DetailPanel)table.getParent().getParent()).getComponents();
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            if (!"controlPanel".equals(components[i].getName().toString()) || !(components[i] instanceof KDPanel)) continue;
            Component[] components2 = ((KDPanel)components[i]).getComponents();
            int m = components2.length;
            for (int j = 0; j < m; ++j) {
                if (!set.contains(components2[j].getName().toString()) || !(components2[j] instanceof KDWorkButton)) continue;
                ((KDWorkButton)components2[j]).setEnabled(state);
            }
        }
    }

    public static String getStartDate2EndDateString(Date startDate, Date endDate, String seperate) {
        if (startDate == null || endDate == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(startDate);
        sb.append(seperate);
        sb.append(endDate);
        return sb.toString();
    }

    public static String getHourUnitString(Object courseHour, Object unit) {
        if (courseHour == null || unit == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(TrainClientUtil.formatBigDecimal((BigDecimal)courseHour, 2));
        if (unit instanceof Integer) {
            sb.append(CourseHourUnitEnum.getEnum((Integer)unit).toString());
        } else if (unit instanceof BizEnumInfo) {
            sb.append(CourseHourUnitEnum.getEnum(((BizEnumValueInfo)unit).getInt()).toString());
        } else {
            sb.append(unit.toString());
        }
        return sb.toString();
    }

    public static boolean isOrgResponser() throws Exception {
        AdminOrgUnitCollection adminColl = HROrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollectionWithOrgRangeFilter(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
        return adminColl.size() > 0;
    }

    public static HashSet getOrgRangeWithHROandAdminRange() throws Exception {
        AdminOrgUnitCollection adminColl = HROrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollectionWithOrgRangeFilter(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
        HashSet<String> orgSet = new HashSet<String>();
        int n = adminColl.size();
        for (int i = 0; i < n; ++i) {
            orgSet.add(adminColl.get(i).getId().toString());
        }
        return orgSet;
    }

    public static void makeMaskString(StringBuffer maskString, int index, String logicWord) {
        if (index == 0) {
            maskString.append("#" + index);
        } else {
            maskString.append(logicWord + "#" + index);
        }
    }

    public static int getIntValue(Object obj) {
        if (obj == null) {
            return 0;
        }
        String str = obj.toString();
        if (str.indexOf(".") > 0) {
            str = str.substring(0, str.indexOf("."));
        }
        return Integer.parseInt(str);
    }

    public static boolean objectArrayIsNull(Object obj) {
        if (TrainClientUtil.objectIsNull(obj)) {
            return true;
        }
        if (((Object[])obj).length == 0) {
            return true;
        }
        return TrainClientUtil.objectIsNull(((Object[])obj)[0]);
    }

    public static HashSet getObjectArrayIds(Object obj) {
        HashSet<String> set = new HashSet<String>();
        Object[] objs = (Object[])obj;
        int n = objs.length;
        for (int i = 0; i < n; ++i) {
            set.add(((CoreBaseInfo)objs[i]).getId().toString());
        }
        return set;
    }

    public static String getObjectID(Object obj) {
        return ((CoreBaseInfo)obj).getId().toString();
    }

    public static BigDecimal objToBigDecimal(Object obj) {
        if (TrainClientUtil.objectIsNull(obj)) {
            return new BigDecimal("0.0");
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        try {
            return new BigDecimal(obj.toString().trim());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setBigDecimalDisplayFormatter(KDFormattedTextField formattedTextField, int prec) {
        formattedTextField.setRemoveingZeroInDispaly(false);
        formattedTextField.setRemoveingZeroInEdit(false);
        formattedTextField.setPrecision(prec);
    }

    public static void setPercentageDisplayFormatter(KDFormattedTextField formattedTextField, int prec) {
        formattedTextField.setPrecision(prec);
        formattedTextField.setRemoveingZeroInDispaly(false);
        formattedTextField.setRemoveingZeroInEdit(false);
        formattedTextField.setPercentDisplay(true);
    }

    public static void setFormattedTextFieldMaxMinValue(KDFormattedTextField formattedTextField, Float min, Float max) {
        formattedTextField.setMaximumValue((Comparable)max);
        formattedTextField.setMinimumValue((Comparable)min);
    }

    public static void setFormattedTextFieldMaxMinValue(KDFormattedTextField formattedTextField) {
        TrainClientUtil.setFormattedTextFieldMaxMinValue(formattedTextField, minPrecision, maxPrecision);
    }

    public static CtrlUnitInfo getGroupOrg() {
        try {
            return SysContext.getSysContext().getCurrentCtrlUnit();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static void orgUnitLongNumberToFullName(IRowSet rowSet, String numberColumnName) {
        try {
            Set numbers = TrainClientUtil.parseOrgUnitLongNumber(rowSet, numberColumnName);
            AdminOrgUnitCollection names = TrainClientUtil.getOrgUnitNames(numbers);
            Map nameMap = TrainClientUtil.assembleNameMap((IObjectCollection)names);
            TrainClientUtil.replaceNumberToName(rowSet, numberColumnName, nameMap);
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static Map assembleNameMap(IObjectCollection collection) {
        HashMap<Object, Object> nameMap = new HashMap<Object, Object>();
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                IObjectValue object = collection.getObject(i);
                nameMap.put(object.get("number"), object.get("name"));
            }
        }
        return nameMap;
    }

    private static void replaceNumberToName(IRowSet rowSet, String numberColumnName, Map nameMap) throws SQLException {
        if (nameMap == null || nameMap.size() == 0) {
            return;
        }
        rowSet.beforeFirst();
        StringBuffer nameBuffer = new StringBuffer();
        while (rowSet.next()) {
            String longNumber = rowSet.getString(numberColumnName);
            if (TrainCommonUtils.isEmpty(longNumber)) continue;
            StringTokenizer parser = new StringTokenizer(longNumber, "!");
            int i = 0;
            while (parser.hasMoreTokens()) {
                if (i != 0) {
                    nameBuffer.append("/");
                }
                String number = parser.nextToken();
                nameBuffer.append(nameMap.get(number));
                ++i;
            }
            rowSet.updateString(numberColumnName, nameBuffer.toString());
            nameBuffer.delete(0, nameBuffer.length());
        }
    }

    private static AdminOrgUnitCollection getOrgUnitNames(Set numbers) throws BOSException {
        AdminOrgUnitCollection names = null;
        if (numbers != null && numbers.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            FilterInfo filterInfo = TrainUtils.getCurrentCUFilter();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", new HashSet(numbers), CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            names = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(viewInfo);
        }
        return names;
    }

    private static Set parseOrgUnitLongNumber(IRowSet rowSet, String numberColumnName) throws SQLException {
        TreeSet<String> numbers = new TreeSet<String>();
        rowSet.beforeFirst();
        while (rowSet.next()) {
            String longNumber = rowSet.getString(numberColumnName);
            if (TrainCommonUtils.isEmpty(longNumber)) continue;
            StringTokenizer parser = new StringTokenizer(longNumber, "!");
            while (parser.hasMoreTokens()) {
                numbers.add(parser.nextToken());
            }
        }
        return numbers;
    }

    public static void lockUI(CoreUI coreUI, Map hmUIState) {
        if (hmUIState.size() > 0) {
            return;
        }
        Component[] comps = coreUI.getComponents();
        TrainClientUtil.lockComponents(comps, hmUIState);
    }

    public static void lockComponents(Component[] comps, Map hmUIState) {
        if (comps != null && comps.length > 0) {
            for (int i = 0; i < comps.length; ++i) {
                int authority;
                IKDTextComponent comp;
                if (comps[i] instanceof KDPanel || comps[i] instanceof KDScrollPane || comps[i] instanceof KDSplitPane || comps[i] instanceof KDTabbedPane || comps[i] instanceof KDLabelContainer || comps[i] instanceof KDContainer || comps[i] instanceof KDPanel || comps[i] instanceof JViewport) {
                    TrainClientUtil.lockComponents(((Container)comps[i]).getComponents(), hmUIState);
                    continue;
                }
                if (comps[i] instanceof IKDTextComponent) {
                    comp = (IKDTextComponent)comps[i];
                    authority = comp.getAccessAuthority();
                    comp.setAccessAuthority(0);
                    hmUIState.put(comps[i], comp.isEnabled());
                    comp.setEnabled(false);
                    comp.setAccessAuthority(authority);
                    continue;
                }
                if (!(comps[i] instanceof KDCheckBox)) continue;
                comp = (KDCheckBox)comps[i];
                authority = comp.getAccessAuthority();
                comp.setAccessAuthority(0);
                hmUIState.put(comps[i], comp.isEnabled());
                comp.setEnabled(false);
                comp.setAccessAuthority(authority);
            }
        }
    }

    public static void unLockUI(Map hmUIState) {
        if (hmUIState == null || hmUIState.size() == 0) {
            return;
        }
        Component comp = null;
        for (Map.Entry entry : hmUIState.entrySet()) {
            int authority;
            comp = (Component)entry.getKey();
            Boolean state = (Boolean)hmUIState.get(comp);
            if (state == null) continue;
            if (comp instanceof IKDTextComponent) {
                authority = ((IKDTextComponent)comp).getAccessAuthority();
                ((IKDTextComponent)comp).setAccessAuthority(0);
                comp.setEnabled(state);
                ((IKDTextComponent)comp).setAccessAuthority(authority);
                continue;
            }
            if (!(comp instanceof KDCheckBox)) continue;
            authority = ((KDCheckBox)comp).getAccessAuthority();
            ((KDCheckBox)comp).setAccessAuthority(0);
            comp.setEnabled(state);
            ((KDCheckBox)comp).setAccessAuthority(authority);
        }
        hmUIState.clear();
    }

    public static void setComponentEnable(IKDTextComponent component, boolean flag) {
        int authority = component.getAccessAuthority();
        component.setAccessAuthority(0);
        component.setEnabled(flag);
        component.setAccessAuthority(authority);
    }

    public static void setComponentEditable(IKDTextComponent component, boolean flag) {
        int authority = component.getAccessAuthority();
        component.setAccessAuthority(0);
        component.setEditable(flag);
        component.setAccessAuthority(authority);
    }

    public static void setDisableColor(KDTable table) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            IColumn column = table.getColumn(i);
            if (!column.getStyleAttributes().isLocked()) continue;
            column.getStyleAttributes().setBackground(TrainActivityHelper.DISABLE_COLOR);
        }
    }

    public static AdminOrgUnitInfo getCurrentAdminOrgUnit() {
        HROrgUnitInfo hrOrgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
        try {
            AdminOrgUnitCollection adminOrgUnits = HROrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollectionWithOrgRangeFilter(hrOrgUnitInfo.getId().toString());
            AdminOrgUnitInfo adminOrgUnitInfo = SysContext.getSysContext().getCurrentAdminUnit();
            String id = adminOrgUnitInfo.getId().toString();
            if (id != null && adminOrgUnits != null && adminOrgUnits.size() > 0) {
                int size = adminOrgUnits.size();
                for (int i = 0; i < size; ++i) {
                    if (!id.equals(adminOrgUnits.get(i).getId().toString())) continue;
                    return adminOrgUnitInfo;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public static String setCommonQueryTitle(CoreUI ui, CommonQueryDialog dialog) {
        StringBuffer sb = new StringBuffer();
        sb.append(ui.getUITitle());
        sb.append(" - ");
        sb.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        dialog.setTitle(sb.toString());
        return sb.toString();
    }

    public static boolean setFirstRow(KDTable table) {
        boolean result = false;
        if (table.getRowCount() > 0) {
            table.getSelectManager().select(0, 0, 0, table.getColumnCount() - 1);
            result = true;
        }
        return result;
    }

    public static BufferedImage getPersonPhoto(PersonInfo personInfo) {
        BufferedImage bfg = null;
        try {
            IPersonPhoto iPhoto;
            PersonPhotoCollection ppColl;
            if (personInfo.getId() != null && (ppColl = (iPhoto = PersonPhotoFactory.getRemoteInstance()).getPersonPhotoCollection(" select imageData where person='" + personInfo.getId() + "'")) != null && ppColl.size() > 0 && ppColl.get(0).getImageData() != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(ppColl.get(0).getImageData());
                bfg = ImageIO.read(bais);
                bais.close();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return bfg;
    }

    public static String assembleDate(Date startDate, Date endDate, String format) {
        return TrainClientUtil.assembleDate(startDate, endDate, format, " -- ");
    }

    public static String assembleDate(Date startDate, Date endDate, String format, String split) {
        StringBuffer sb = new StringBuffer();
        if (startDate == null && endDate == null) {
            return sb.toString();
        }
        if (startDate != null) {
            sb.append(DateTimeUtils.format((Date)startDate, (String)format));
        }
        sb.append(split);
        if (endDate != null) {
            sb.append(DateTimeUtils.format((Date)endDate, (String)format));
        }
        return sb.toString();
    }

    public static void viewEditUI(CoreUI coreUI, String uiName, KDTable table, String columnName, String message) throws UIException {
        if (table.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)coreUI, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int curIndex = TrainUtils.getCurrentRowIndex(table);
        Object value = table.getRow(curIndex).getCell(columnName).getValue();
        String courseId = null;
        if (value instanceof CoreBaseInfo) {
            courseId = ((CoreBaseInfo)value).getId().toString();
        } else if (value != null) {
            courseId = value.toString();
        }
        if (TrainCommonUtils.isEmpty(courseId)) {
            if (TrainCommonUtils.isEmpty(message)) {
                message = EASResource.getString((String)RESOURCE, (String)"DataIsNull");
            }
            MsgBox.showInfo((Component)coreUI, (String)message);
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)coreUI);
        uiContext.put((Object)"ID", (Object)courseId);
        uiContext.put((Object)"viewOnly", (Object)Boolean.TRUE);
        String state = OprtState.VIEW;
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, state);
        EditUI editUI = (EditUI)uiWindow.getUIObject();
        if (editUI.getUIMenuBar() != null) {
            editUI.getUIMenuBar().setVisible(false);
        }
        uiWindow.show();
    }

    public static void addSqlMenu(CoreUIObject uiObject, KDMenu menu) {
        TrainClientUtil.addHideMnum(uiObject, menu, "com.kingdee.eas.fm.common.client.FMIsqlUI", "ctrl shift alt Q", "com.kingdee.eas.base.uiframe.client.UINewTabFactory");
    }

    public static void addAssistantMenu(CoreUIObject uiObject, KDMenu menu) {
        TrainClientUtil.addHideMnum(uiObject, menu, TrainAssistantUI.class.getName(), "ctrl shift alt A", "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
    }

    private static void addHideMnum(final CoreUIObject uiObject, KDMenu menu, final String uiName, String key, final String modelName) {
        menu.add((JMenuItem)((Object)new HidedMenuItem(key){

            public void action_actionPerformed() {
                try {
                    IUIFactory factory = null;
                    factory = modelName != null ? UIFactory.createUIFactory((String)modelName) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    UIContext uiContext = new UIContext((Object)uiObject);
                    IUIWindow window = factory.create(uiName, (Map)uiContext);
                    window.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        }));
    }

    public static void executeWithProcess(CoreUI uiObject, IProgTask prog) {
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)uiObject);
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        } else {
            return;
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    public static DetailPanel getTableDetailPanel(Component component) {
        if (component != null) {
            if ((component = component.getParent()) instanceof DetailPanel) {
                return (DetailPanel)component;
            }
            return TrainClientUtil.getTableDetailPanel(component);
        }
        return null;
    }

    public static boolean setTableTitle(KDTable table, String title) {
        DetailPanel detailPanel = TrainClientUtil.getTableDetailPanel((Component)table);
        if (detailPanel != null) {
            detailPanel.setTitle(title);
            return true;
        }
        return false;
    }

    public static void removeNonWorkFlowState(KDComboBox comboBox) {
        if (comboBox == null) {
            return;
        }
        Object item = null;
        for (int i = comboBox.getItemCount() - 1; i >= 0; --i) {
            item = comboBox.getItemAt(i);
            if (!TrainAuditStateEnum.AUDITED.equals(item) && !TrainAuditStateEnum.UNAUDITED.equals(item)) continue;
            comboBox.removeItem(item);
        }
    }

    public static IUIActionPostman prepareDefaultSolutionParam(IUIActionPostman handler, ListUI listUI, IMetaDataPK mainQueryPK) {
        RequestContext request = new RequestContext();
        request.put("uiClassName", (Object)listUI.getMetaDataPK().getFullName());
        request.put("mainQueryPK", (Object)mainQueryPK);
        handler.setRequestContext((Serializable)request);
        return handler;
    }
}

