/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.hr.base.EmployeeClassifyInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.client.BatchContractEditUI;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordCollection;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainStudentCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseFactory;
import com.kingdee.eas.hr.train.TrainStudentFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainContractBatchMgrUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListModel;
import org.apache.log4j.Logger;

public class TrainContractBatchMgrUI
extends AbstractTrainContractBatchMgrUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainContractBatchMgrUI.class);
    String RES = "com.kingdee.eas.hr.train.client.TrainRecordResource";
    private static final String RESOURCE = "com.kingdee.eas.hr.train.TrainActivityResource";
    HashMap recordMap;
    boolean isActivity = false;
    HashMap currentMap;
    boolean courseFlag = false;
    boolean activityFlag = false;
    private boolean isStrideHRO = false;
    Map person_Map = new HashMap();

    public void onLoad() throws Exception {
        super.onLoad();
        this.isStrideHRO = HRParamUtil.getParamOfHR(null, (String)"IS_CONTRACT_ALLHR", null);
        this.prmtHRO.setValue((Object)SysContext.getSysContext().getCurrentHRUnit());
        this.prmtHRO.setEnabled(false);
        this.btnInsertEmployee.setEnabled(false);
        TrainActivityHelper.initTrainActivityByContact(this.promptTrainActivity, null);
        TrainActivityHelper.initTrainCourse(this.promptTrainCourse, false, (IUIObject)this);
    }

    protected void promptTrainActivity_dataChanged(DataChangeEvent e) throws Exception {
        super.promptTrainActivity_dataChanged(e);
        if (this.activityFlag) {
            this.activityFlag = false;
            return;
        }
        this.isActivity = e.getNewValue() != null ? this.promptTrainActivity.getValue() != null : false;
        if (this.promptTrainActivity.getValue() != null) {
            if (this.promptTrainCourse.getValue() != null) {
                this.courseFlag = true;
                this.promptTrainCourse.setValue(null);
            }
            TrainActivityHelper.initTrainCourseByActivity(this.promptTrainCourse, ((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString());
            this.isActivity = true;
        } else {
            TrainActivityHelper.initTrainCourse(this.promptTrainCourse, false, (IUIObject)this);
            this.courseFlag = true;
            this.promptTrainCourse.setValue(null);
        }
        this.loadData();
        this.btnInsertEmployee.setEnabled(this.promptTrainActivity.getValue() != null);
    }

    protected void promptTrainCourse_dataChanged(DataChangeEvent e) throws Exception {
        super.promptTrainCourse_dataChanged(e);
        if (this.courseFlag) {
            this.courseFlag = false;
            return;
        }
        this.isActivity = e.getNewValue() == null;
        this.loadData();
    }

    private void loadData() throws Exception {
        this.removeAllEmployee();
        FilterInfo filterInfo = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (this.promptTrainActivity.getValue() != null) {
            if (this.promptTrainCourse.getValue() != null) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainCourse.id", (Object)((TrainCourseInfo)this.promptTrainCourse.getValue()).getId().toString()));
                String sql = TrainUtils.getHRAndAdminRangePersonSQL();
                filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)sql, CompareType.INNER));
                entityViewInfo.setFilter(filterInfo);
                TrainStudentCourseCollection studentCourseCollection = TrainStudentCourseFactory.getRemoteInstance().getTrainStudentCourseCollection(entityViewInfo);
                PersonInfo[] obj = new PersonInfo[studentCourseCollection.size()];
                int n = studentCourseCollection.size();
                for (int i = 0; i < n; ++i) {
                    obj[i] = studentCourseCollection.get(i).getPerson();
                }
                this.addEmployee(obj);
            } else {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("needDivide", (Object)1));
                if (TrainActivityFactory.getRemoteInstance().exists(filterInfo)) {
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
                    String sql = TrainUtils.getHRAndAdminRangePersonSQL();
                    filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)sql, CompareType.INNER));
                    entityViewInfo.setFilter(filterInfo);
                    TrainStudentCollection studentCollection = TrainStudentFactory.getRemoteInstance().getTrainStudentCollection(entityViewInfo);
                    PersonInfo[] obj = new PersonInfo[studentCollection.size()];
                    int n = studentCollection.size();
                    for (int i = 0; i < n; ++i) {
                        obj[i] = studentCollection.get(i).getPerson();
                    }
                    this.addEmployee(obj);
                } else {
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
                    String sql = TrainUtils.getHRAndAdminRangePersonSQL();
                    filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)sql, CompareType.INNER));
                    entityViewInfo.setFilter(filterInfo);
                    TrainStudentCourseCollection studentCourseCollection = TrainStudentCourseFactory.getRemoteInstance().getTrainStudentCourseCollection(entityViewInfo);
                    PersonInfo[] obj = new PersonInfo[studentCourseCollection.size()];
                    int n = studentCourseCollection.size();
                    for (int i = 0; i < n; ++i) {
                        obj[i] = studentCourseCollection.get(i).getPerson();
                    }
                    this.addEmployee(obj);
                }
            }
        } else if (this.promptTrainCourse.getValue() != null) {
            filterInfo = TrainUtils.getHROrgUnitFilter("hrOrgUnit.id");
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", null));
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)((TrainCourseInfo)this.promptTrainCourse.getValue()).getId().toString()));
            String sql = TrainUtils.getHRAndAdminRangePersonSQL();
            filterInfo.getFilterItems().add(new FilterItemInfo("employee.id", (Object)sql, CompareType.INNER));
            entityViewInfo.setFilter(filterInfo);
            TrainCourseRecordCollection collection = TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(entityViewInfo);
            if (collection != null && collection.size() > 0) {
                int size = collection.size();
                PersonInfo[] objs = new PersonInfo[size];
                for (int i = 0; i < size; ++i) {
                    objs[i] = collection.get(i).getEmployee();
                }
                Map persons = this.assembleEmployees(objs);
                PersonInfo personInfo = null;
                PersonInfo info = null;
                String split = EASResource.getString((String)RESOURCE, (String)"to");
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    personInfo = collection.get(i).getEmployee();
                    if (TrainCommonUtils.isEmpty((CoreBaseInfo)personInfo)) continue;
                    info = (PersonInfo)persons.get(personInfo.getId().toString());
                    personInfo = (PersonInfo)info.clone();
                    str.delete(0, str.length());
                    str.append(personInfo.getName());
                    str.append("(");
                    str.append(TrainClientUtil.assembleDate(collection.get(i).getBeginDateTime(), collection.get(i).getEndDateTime(), "yyyy-MM-dd", split));
                    str.append(")");
                    personInfo.setName(str.toString());
                    personInfo.put("TrainCourseRecord.id", (Object)collection.get(i).getId().toString());
                    ((DefaultListModel)this.listEmployee.getModel()).addElement(personInfo);
                }
            }
        }
    }

    private void addEmployee(PersonInfo[] obj) throws Exception {
        if (obj == null || obj.length == 0) {
            return;
        }
        Map persons = this.assembleEmployees(obj);
        if (persons != null && persons.size() > 0) {
            Iterator it = persons.values().iterator();
            PersonInfo personInfo = null;
            while (it.hasNext()) {
                personInfo = (PersonInfo)it.next();
                this.person_Map.put(personInfo.getId().toString(), personInfo);
                if (this.checkIsExistInListEmployee(personInfo)) continue;
                ((DefaultListModel)this.listEmployee.getModel()).addElement(personInfo);
            }
        }
    }

    public void actionInsertEmployee_actionPerformed(ActionEvent e) {
        EmployeeMultiF7PromptBox person = new EmployeeMultiF7PromptBox((IUIObject)this);
        HROrgUnitInfo hrOrgUnitInfo = this.getCurrentHRO();
        HashSet<String> set = null;
        Object[] obj = null;
        if (hrOrgUnitInfo != null) {
            set = new HashSet<String>();
            set.add(hrOrgUnitInfo.getId().toString());
        }
        person.setIsSingleSelect(false);
        person.setReturnPositionAndUnit(false);
        if (this.isZTCustomer) {
            person.setIsShowAllAdmin(true);
        } else if (this.isStrideHRO) {
            person.setIsShowAllAdmin(true);
        } else {
            person.setHROFilter(set);
        }
        person.show();
        if (!person.isCanceled() && person.getData() != null) {
            obj = (Object[])person.getData();
            for (int i = 0; i < obj.length; ++i) {
                if (this.checkIsExistInListEmployee((PersonInfo)obj[i])) continue;
                ((DefaultListModel)this.listEmployee.getModel()).addElement((PersonInfo)obj[i]);
                PersonInfo personInfo = (PersonInfo)obj[i];
                this.person_Map.put(personInfo.getId().toString(), personInfo);
            }
        }
        if (obj == null || obj.length == 0) {
            return;
        }
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.getMainOrgContext() == null) {
            return SysContext.getSysContext().getCurrentHRUnit();
        }
        if (FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.ControlUnit) != null) {
            return (HROrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.HRO);
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    private Map assembleEmployees(PersonInfo[] obj) throws BOSException, SQLException, Exception {
        HashSet<String> hashSet = new HashSet<String>();
        int n = obj.length;
        for (int i = 0; i < n; ++i) {
            hashSet.add(obj[i].getId().toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", hashSet, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "EmployeeF7SelectQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        PersonInfo personInfo = null;
        HashMap<String, PersonInfo> result = new HashMap<String, PersonInfo>();
        while (rowSet.next()) {
            personInfo = new PersonInfo();
            if (rowSet.getString("employeeClassify.id") != null) {
                EmployeeClassifyInfo employeeClassifyInfo = new EmployeeClassifyInfo();
                employeeClassifyInfo.setId(BOSUuid.read((String)rowSet.getString("employeeClassify.id")));
                employeeClassifyInfo.setName(rowSet.getString("employeeClassify.name"));
                employeeClassifyInfo.setDisplayName(rowSet.getString("employeeClassify.displayName"));
                personInfo.setEmployeeClassify(employeeClassifyInfo);
            }
            personInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
            personInfo.setNumber(rowSet.getString("number"));
            personInfo.setName(rowSet.getString("name"));
            personInfo.setIdCardNO(rowSet.getString("idCardNO"));
            personInfo.setPassportNO(rowSet.getString("passportNO"));
            personInfo.setGender(Genders.getEnum((int)rowSet.getInt("gender")));
            personInfo.setEmail(rowSet.getString("email"));
            if (rowSet.getBoolean("PositionMember.isPrimary")) {
                personInfo.put("primaryAdminOrg", (Object)this.getAdminOrgUnitInfo(rowSet));
                personInfo.put("primaryPosition", (Object)this.getPositionInfo(rowSet));
            }
            result.put(rowSet.getString("id"), personInfo);
        }
        return result;
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfo(IRowSet rows) throws Exception {
        AdminOrgUnitInfo adminInfo = null;
        if (rows.getString("AdminOrgUnit.id") != null) {
            adminInfo = new AdminOrgUnitInfo();
            adminInfo.setId(BOSUuid.read((String)rows.getString("AdminOrgUnit.id")));
            adminInfo.setNumber(rows.getString("AdminOrgUnit.number"));
            adminInfo.setName(rows.getString("AdminOrgUnit.name"));
            adminInfo.setLevel(rows.getInt("AdminOrgUnit.level"));
            adminInfo.setLongNumber(rows.getString("AdminOrgUnit.longNumber"));
            adminInfo.setDisplayName(rows.getString("AdminOrgUnit.displayName"));
        }
        return adminInfo;
    }

    private PositionInfo getPositionInfo(IRowSet rows) throws Exception {
        PositionInfo posiInfo = new PositionInfo();
        if (rows.getString("Position.id") != null) {
            posiInfo = new PositionInfo();
            posiInfo.setId(BOSUuid.read((String)rows.getString("Position.id")));
            posiInfo.setNumber(rows.getString("Position.number"));
            posiInfo.setName(rows.getString("Position.name"));
        }
        return posiInfo;
    }

    private void removeAllEmployee() {
        for (int i = this.listEmployee.getElementCount() - 1; i >= 0; --i) {
            this.listEmployee.removeElementAt(i);
        }
    }

    public void actionYes_actionPerformed(ActionEvent e) throws Exception {
        this.checkInput();
        this.handleEmployee();
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BatchContractEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        this.getUIWindow().close();
        uiWindow.show();
        Vector pks = ((BatchContractEditUI)uiWindow.getUIObject()).pks;
        this.operateBatchSaveContacht(pks);
    }

    private void operateBatchSaveContacht(Vector pks) throws Exception {
        if (pks == null || pks.size() == 0) {
            return;
        }
        ObjectUuidPK[] contractIds = new ObjectUuidPK[pks.size()];
        int size = pks.size();
        for (int i = 0; i < size; ++i) {
            contractIds[i] = (IObjectPK)pks.get(i);
        }
        String activityID = null;
        String courseID = null;
        if (this.promptTrainActivity.getValue() != null) {
            activityID = ((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString();
        }
        if (this.promptTrainCourse.getValue() != null) {
            if (this.promptTrainActivity.getValue() == null) {
                DefaultListModel model = (DefaultListModel)this.listEmployee.getModel();
                HashSet<String> trainCourseRecordIds = new HashSet<String>();
                PersonInfo personInfo = null;
                for (int i = 0; i < model.size(); ++i) {
                    personInfo = (PersonInfo)model.getElementAt(i);
                    trainCourseRecordIds.add(personInfo.getString("TrainCourseRecord.id"));
                }
                TrainCourseRecordFactory.getRemoteInstance().submitContactBatch(trainCourseRecordIds, (IObjectPK[])contractIds);
                return;
            }
            courseID = ((TrainCourseInfo)this.promptTrainCourse.getValue()).getId().toString();
        }
        TrainCourseRecordFactory.getRemoteInstance().submitContactBatch(activityID, courseID, (IObjectPK[])contractIds, this.person_Map);
    }

    public void checkInput() throws EmployeeException {
        if (this.promptTrainActivity.getValue() == null && this.promptTrainCourse.getValue() == null) {
            TrainClientUtil.showErrorMessage(this.RES, "activityAndCourseNotNull", this);
        }
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtToUnit, this.kDLabel7.getText() + EASResource.getString((String)"com.kingdee.eas.hr.train.TrainVerifyResource", (String)"CanNotBeNull"));
        if (this.promptTrainActivity.getValue() == null) {
            DefaultListModel model = (DefaultListModel)this.listEmployee.getModel();
            PersonInfo personInfo = null;
            for (int i = 0; i < model.size(); ++i) {
                personInfo = (PersonInfo)model.getElementAt(i);
                for (int j = 0; j < model.size(); ++j) {
                    if (i == j || !personInfo.getId().toString().equals(((PersonInfo)model.getElementAt(j)).getId().toString())) continue;
                    String name = personInfo.getName();
                    name = name.substring(0, name.indexOf("("));
                    TrainClientUtil.showErrorMessage(this.RES, "employeeRepeat", new Object[]{name}, this);
                }
            }
        }
        super.checkInput();
    }

    private void handleEmployee() {
        if (this.promptTrainActivity.getValue() == null && this.promptTrainCourse.getValue() != null) {
            DefaultListModel model = (DefaultListModel)this.listEmployee.getModel();
            PersonInfo personInfo = null;
            for (int i = 0; i < model.size(); ++i) {
                personInfo = (PersonInfo)model.getElementAt(i);
                String name = personInfo.getName();
                name = name.substring(0, name.indexOf("("));
                personInfo.setName(name);
            }
        }
    }

    protected boolean isPersonF7ShowAllAdmin() {
        return false;
    }
}

